/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.WebAuthenticationCB;
import jp.sf.fess.db.cbean.cq.WebAuthenticationCQ;
import jp.sf.fess.db.cbean.cq.WebCrawlingConfigCQ;
import jp.sf.fess.db.cbean.cq.ciq.WebAuthenticationCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;

/**
 * The base condition-query of WEB_AUTHENTICATION.
 * @author DBFlute(AutoGenerator)
 */
public class BsWebAuthenticationCQ extends AbstractBsWebAuthenticationCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected WebAuthenticationCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsWebAuthenticationCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare inline query. <br />
     * {select ... from ... left outer join (select * from WEB_AUTHENTICATION) where abc = [abc] ...}
     * @return Inline query. (NotNull)
     */
    public WebAuthenticationCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = new WebAuthenticationCIQ(getChildQuery(),
                    getSqlClause(), getAliasName(), getNestLevel(), this);
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    /**
     * Prepare on-clause query. <br />
     * {select ... from ... left outer join WEB_AUTHENTICATION on ... and abc = [abc] ...}
     * @return On-clause query. (NotNull)
     */
    public WebAuthenticationCIQ on() {
        if (isBaseQuery(this)) {
            throw new UnsupportedOperationException(
                    "Unsupported on-clause for local table!");
        }
        WebAuthenticationCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    public BsWebAuthenticationCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    public BsWebAuthenticationCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _urlPattern;

    public ConditionValue getUrlPattern() {
        if (_urlPattern == null) {
            _urlPattern = nCV();
        }
        return _urlPattern;
    }

    protected ConditionValue getCValueUrlPattern() {
        return getUrlPattern();
    }

    public BsWebAuthenticationCQ addOrderBy_UrlPattern_Asc() {
        regOBA("URL_PATTERN");
        return this;
    }

    public BsWebAuthenticationCQ addOrderBy_UrlPattern_Desc() {
        regOBD("URL_PATTERN");
        return this;
    }

    protected ConditionValue _username;

    public ConditionValue getUsername() {
        if (_username == null) {
            _username = nCV();
        }
        return _username;
    }

    protected ConditionValue getCValueUsername() {
        return getUsername();
    }

    public BsWebAuthenticationCQ addOrderBy_Username_Asc() {
        regOBA("USERNAME");
        return this;
    }

    public BsWebAuthenticationCQ addOrderBy_Username_Desc() {
        regOBD("USERNAME");
        return this;
    }

    protected ConditionValue _password;

    public ConditionValue getPassword() {
        if (_password == null) {
            _password = nCV();
        }
        return _password;
    }

    protected ConditionValue getCValuePassword() {
        return getPassword();
    }

    public BsWebAuthenticationCQ addOrderBy_Password_Asc() {
        regOBA("PASSWORD");
        return this;
    }

    public BsWebAuthenticationCQ addOrderBy_Password_Desc() {
        regOBD("PASSWORD");
        return this;
    }

    protected ConditionValue _webCrawlingConfigId;

    public ConditionValue getWebCrawlingConfigId() {
        if (_webCrawlingConfigId == null) {
            _webCrawlingConfigId = nCV();
        }
        return _webCrawlingConfigId;
    }

    protected ConditionValue getCValueWebCrawlingConfigId() {
        return getWebCrawlingConfigId();
    }

    protected Map<String, WebCrawlingConfigCQ> _webCrawlingConfigId_InScopeSubQuery_WebCrawlingConfigMap;

    public Map<String, WebCrawlingConfigCQ> getWebCrawlingConfigId_InScopeSubQuery_WebCrawlingConfig() {
        return _webCrawlingConfigId_InScopeSubQuery_WebCrawlingConfigMap;
    }

    public String keepWebCrawlingConfigId_InScopeSubQuery_WebCrawlingConfig(
            WebCrawlingConfigCQ subQuery) {
        if (_webCrawlingConfigId_InScopeSubQuery_WebCrawlingConfigMap == null) {
            _webCrawlingConfigId_InScopeSubQuery_WebCrawlingConfigMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_webCrawlingConfigId_InScopeSubQuery_WebCrawlingConfigMap
                        .size() + 1);
        _webCrawlingConfigId_InScopeSubQuery_WebCrawlingConfigMap.put(key,
                subQuery);
        return "webCrawlingConfigId_InScopeSubQuery_WebCrawlingConfig." + key;
    }

    public BsWebAuthenticationCQ addOrderBy_WebCrawlingConfigId_Asc() {
        regOBA("WEB_CRAWLING_CONFIG_ID");
        return this;
    }

    public BsWebAuthenticationCQ addOrderBy_WebCrawlingConfigId_Desc() {
        regOBD("WEB_CRAWLING_CONFIG_ID");
        return this;
    }

    protected ConditionValue _createdBy;

    public ConditionValue getCreatedBy() {
        if (_createdBy == null) {
            _createdBy = nCV();
        }
        return _createdBy;
    }

    protected ConditionValue getCValueCreatedBy() {
        return getCreatedBy();
    }

    public BsWebAuthenticationCQ addOrderBy_CreatedBy_Asc() {
        regOBA("CREATED_BY");
        return this;
    }

    public BsWebAuthenticationCQ addOrderBy_CreatedBy_Desc() {
        regOBD("CREATED_BY");
        return this;
    }

    protected ConditionValue _createdTime;

    public ConditionValue getCreatedTime() {
        if (_createdTime == null) {
            _createdTime = nCV();
        }
        return _createdTime;
    }

    protected ConditionValue getCValueCreatedTime() {
        return getCreatedTime();
    }

    public BsWebAuthenticationCQ addOrderBy_CreatedTime_Asc() {
        regOBA("CREATED_TIME");
        return this;
    }

    public BsWebAuthenticationCQ addOrderBy_CreatedTime_Desc() {
        regOBD("CREATED_TIME");
        return this;
    }

    protected ConditionValue _updatedBy;

    public ConditionValue getUpdatedBy() {
        if (_updatedBy == null) {
            _updatedBy = nCV();
        }
        return _updatedBy;
    }

    protected ConditionValue getCValueUpdatedBy() {
        return getUpdatedBy();
    }

    public BsWebAuthenticationCQ addOrderBy_UpdatedBy_Asc() {
        regOBA("UPDATED_BY");
        return this;
    }

    public BsWebAuthenticationCQ addOrderBy_UpdatedBy_Desc() {
        regOBD("UPDATED_BY");
        return this;
    }

    protected ConditionValue _updatedTime;

    public ConditionValue getUpdatedTime() {
        if (_updatedTime == null) {
            _updatedTime = nCV();
        }
        return _updatedTime;
    }

    protected ConditionValue getCValueUpdatedTime() {
        return getUpdatedTime();
    }

    public BsWebAuthenticationCQ addOrderBy_UpdatedTime_Asc() {
        regOBA("UPDATED_TIME");
        return this;
    }

    public BsWebAuthenticationCQ addOrderBy_UpdatedTime_Desc() {
        regOBD("UPDATED_TIME");
        return this;
    }

    protected ConditionValue _deletedBy;

    public ConditionValue getDeletedBy() {
        if (_deletedBy == null) {
            _deletedBy = nCV();
        }
        return _deletedBy;
    }

    protected ConditionValue getCValueDeletedBy() {
        return getDeletedBy();
    }

    public BsWebAuthenticationCQ addOrderBy_DeletedBy_Asc() {
        regOBA("DELETED_BY");
        return this;
    }

    public BsWebAuthenticationCQ addOrderBy_DeletedBy_Desc() {
        regOBD("DELETED_BY");
        return this;
    }

    protected ConditionValue _deletedTime;

    public ConditionValue getDeletedTime() {
        if (_deletedTime == null) {
            _deletedTime = nCV();
        }
        return _deletedTime;
    }

    protected ConditionValue getCValueDeletedTime() {
        return getDeletedTime();
    }

    public BsWebAuthenticationCQ addOrderBy_DeletedTime_Asc() {
        regOBA("DELETED_TIME");
        return this;
    }

    public BsWebAuthenticationCQ addOrderBy_DeletedTime_Desc() {
        regOBD("DELETED_TIME");
        return this;
    }

    protected ConditionValue _versionNo;

    public ConditionValue getVersionNo() {
        if (_versionNo == null) {
            _versionNo = nCV();
        }
        return _versionNo;
    }

    protected ConditionValue getCValueVersionNo() {
        return getVersionNo();
    }

    public BsWebAuthenticationCQ addOrderBy_VersionNo_Asc() {
        regOBA("VERSION_NO");
        return this;
    }

    public BsWebAuthenticationCQ addOrderBy_VersionNo_Desc() {
        regOBD("VERSION_NO");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    public BsWebAuthenticationCQ addSpecifiedDerivedOrderBy_Asc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    public BsWebAuthenticationCQ addSpecifiedDerivedOrderBy_Desc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
        WebAuthenticationCQ baseQuery = (WebAuthenticationCQ) baseQueryAsSuper;
        WebAuthenticationCQ unionQuery = (WebAuthenticationCQ) unionQueryAsSuper;
        if (baseQuery.hasConditionQueryWebCrawlingConfig()) {
            unionQuery.queryWebCrawlingConfig().reflectRelationOnUnionQuery(
                    baseQuery.queryWebCrawlingConfig(),
                    unionQuery.queryWebCrawlingConfig());
        }
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    public WebCrawlingConfigCQ queryWebCrawlingConfig() {
        return getConditionQueryWebCrawlingConfig();
    }

    protected WebCrawlingConfigCQ _conditionQueryWebCrawlingConfig;

    public WebCrawlingConfigCQ getConditionQueryWebCrawlingConfig() {
        if (_conditionQueryWebCrawlingConfig == null) {
            _conditionQueryWebCrawlingConfig = xcreateQueryWebCrawlingConfig();
            xsetupOuterJoinWebCrawlingConfig();
        }
        return _conditionQueryWebCrawlingConfig;
    }

    protected WebCrawlingConfigCQ xcreateQueryWebCrawlingConfig() {
        String nrp = resolveNextRelationPath("WEB_AUTHENTICATION",
                "webCrawlingConfig");
        String jan = resolveJoinAliasName(nrp, getNextNestLevel());
        WebCrawlingConfigCQ cq = new WebCrawlingConfigCQ(this, getSqlClause(),
                jan, getNextNestLevel());
        cq.xsetForeignPropertyName("webCrawlingConfig");
        cq.xsetRelationPath(nrp);
        return cq;
    }

    protected void xsetupOuterJoinWebCrawlingConfig() {
        WebCrawlingConfigCQ cq = getConditionQueryWebCrawlingConfig();
        Map<String, String> joinOnMap = newLinkedHashMap();
        joinOnMap.put(getRealColumnName("WEB_CRAWLING_CONFIG_ID"), cq
                .getRealColumnName("ID"));
        registerOuterJoin(cq, joinOnMap);
    }

    public boolean hasConditionQueryWebCrawlingConfig() {
        return _conditionQueryWebCrawlingConfig != null;
    }

    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, WebAuthenticationCQ> _scalarSubQueryMap;

    public Map<String, WebAuthenticationCQ> getScalarSubQuery() {
        return _scalarSubQueryMap;
    }

    public String keepScalarSubQuery(WebAuthenticationCQ subQuery) {
        if (_scalarSubQueryMap == null) {
            _scalarSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarSubQueryMap.size() + 1);
        _scalarSubQueryMap.put(key, subQuery);
        return "scalarSubQuery." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, WebAuthenticationCQ> _myselfInScopeSubQueryMap;

    public Map<String, WebAuthenticationCQ> getMyselfInScopeSubQuery() {
        return _myselfInScopeSubQueryMap;
    }

    public String keepMyselfInScopeSubQuery(WebAuthenticationCQ subQuery) {
        if (_myselfInScopeSubQueryMap == null) {
            _myselfInScopeSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeSubQueryMap.size() + 1);
        _myselfInScopeSubQueryMap.put(key, subQuery);
        return "myselfInScopeSubQuery." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return WebAuthenticationCB.class.getName();
    }

    String xCQ() {
        return WebAuthenticationCQ.class.getName();
    }

    String xMap() {
        return Map.class.getName();
    }
}
