/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.ciq;

import jp.sf.fess.db.cbean.LabelTypeCB;
import jp.sf.fess.db.cbean.cq.DataConfigToLabelTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.FileConfigToLabelTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.LabelTypeCQ;
import jp.sf.fess.db.cbean.cq.WebConfigToLabelTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.bs.AbstractBsLabelTypeCQ;
import jp.sf.fess.db.cbean.cq.bs.BsLabelTypeCQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;

/**
 * The condition-inline-query of LABEL_TYPE.
 * @author DBFlute(AutoGenerator)
 */
public class LabelTypeCIQ extends AbstractBsLabelTypeCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected BsLabelTypeCQ _myCQ;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public LabelTypeCIQ(ConditionQuery childQuery, SqlClause sqlClause,
            String aliasName, int nestLevel, BsLabelTypeCQ myCQ) {
        super(childQuery, sqlClause, aliasName, nestLevel);
        _myCQ = myCQ;
        _foreignPropertyName = _myCQ.getForeignPropertyName();// Accept foreign property name.
        _relationPath = _myCQ.getRelationPath();// Accept relation path.
    }

    // ===================================================================================
    //                                                             Override about Register
    //                                                             =======================
    @Override
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
        throw new UnsupportedOperationException(
                "InlineQuery must not need UNION method: " + baseQueryAsSuper
                        + " : " + unionQueryAsSuper);
    }

    @Override
    protected void setupConditionValueAndRegisterWhereClause(ConditionKey k,
            Object v, ConditionValue cv, String col) {
        regIQ(k, v, cv, col);
    }

    @Override
    protected void setupConditionValueAndRegisterWhereClause(ConditionKey k,
            Object v, ConditionValue cv, String col, ConditionOption op) {
        regIQ(k, v, cv, col, op);
    }

    @Override
    protected void registerWhereClause(String whereClause) {
        registerInlineWhereClause(whereClause);
    }

    @Override
    protected String getInScopeSubQueryRealColumnName(String columnName) {
        if (_onClauseInline) {
            throw new UnsupportedOperationException(
                    "InScopeSubQuery of on-clause is unsupported");
        }
        return _onClauseInline ? getRealAliasName() + "." + columnName
                : columnName;
    }

    @Override
    protected void registerExistsSubQuery(ConditionQuery subQuery,
            String columnName, String relatedColumnName, String propertyName) {
        throw new UnsupportedOperationException(
                "Sorry! ExistsSubQuery at inline view is unsupported. So please use InScopeSubQyery.");
    }

    // ===================================================================================
    //                                                                Override about Query
    //                                                                ====================
    protected ConditionValue getCValueId() {
        return _myCQ.getId();
    }

    public String keepId_InScopeSubQuery_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        return _myCQ
                .keepId_InScopeSubQuery_DataConfigToLabelTypeMappingList(subQuery);
    }

    public String keepId_InScopeSubQuery_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ subQuery) {
        return _myCQ
                .keepId_InScopeSubQuery_FileConfigToLabelTypeMappingList(subQuery);
    }

    public String keepId_InScopeSubQuery_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        return _myCQ
                .keepId_InScopeSubQuery_WebConfigToLabelTypeMappingList(subQuery);
    }

    public String keepId_NotInScopeSubQuery_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        return _myCQ
                .keepId_NotInScopeSubQuery_DataConfigToLabelTypeMappingList(subQuery);
    }

    public String keepId_NotInScopeSubQuery_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ subQuery) {
        return _myCQ
                .keepId_NotInScopeSubQuery_FileConfigToLabelTypeMappingList(subQuery);
    }

    public String keepId_NotInScopeSubQuery_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        return _myCQ
                .keepId_NotInScopeSubQuery_WebConfigToLabelTypeMappingList(subQuery);
    }

    public String keepId_ExistsSubQuery_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        throw new UnsupportedOperationException(
                "ExistsSubQuery at inline() is unsupported! Sorry!");
    }

    public String keepId_ExistsSubQuery_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ subQuery) {
        throw new UnsupportedOperationException(
                "ExistsSubQuery at inline() is unsupported! Sorry!");
    }

    public String keepId_ExistsSubQuery_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        throw new UnsupportedOperationException(
                "ExistsSubQuery at inline() is unsupported! Sorry!");
    }

    public String keepId_NotExistsSubQuery_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        throw new UnsupportedOperationException(
                "NotExistsSubQuery at inline() is unsupported! Sorry!");
    }

    public String keepId_NotExistsSubQuery_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ subQuery) {
        throw new UnsupportedOperationException(
                "NotExistsSubQuery at inline() is unsupported! Sorry!");
    }

    public String keepId_NotExistsSubQuery_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        throw new UnsupportedOperationException(
                "NotExistsSubQuery at inline() is unsupported! Sorry!");
    }

    public String keepId_SpecifyDerivedReferrer_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        throw new UnsupportedOperationException(
                "(Specify)DerivedReferrer at inline() is unsupported! Sorry!");
    }

    public String keepId_SpecifyDerivedReferrer_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ subQuery) {
        throw new UnsupportedOperationException(
                "(Specify)DerivedReferrer at inline() is unsupported! Sorry!");
    }

    public String keepId_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        throw new UnsupportedOperationException(
                "(Specify)DerivedReferrer at inline() is unsupported! Sorry!");
    }

    public String keepId_QueryDerivedReferrer_DataConfigToLabelTypeMappingList(
            DataConfigToLabelTypeMappingCQ subQuery) {
        throw new UnsupportedOperationException(
                "(Query)DerivedReferrer at inline() is unsupported! Sorry!");
    }

    public String keepId_QueryDerivedReferrer_DataConfigToLabelTypeMappingListParameter(
            Object parameterValue) {
        throw new UnsupportedOperationException(
                "(Query)DerivedReferrer at inline() is unsupported! Sorry!");
    }

    public String keepId_QueryDerivedReferrer_FileConfigToLabelTypeMappingList(
            FileConfigToLabelTypeMappingCQ subQuery) {
        throw new UnsupportedOperationException(
                "(Query)DerivedReferrer at inline() is unsupported! Sorry!");
    }

    public String keepId_QueryDerivedReferrer_FileConfigToLabelTypeMappingListParameter(
            Object parameterValue) {
        throw new UnsupportedOperationException(
                "(Query)DerivedReferrer at inline() is unsupported! Sorry!");
    }

    public String keepId_QueryDerivedReferrer_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        throw new UnsupportedOperationException(
                "(Query)DerivedReferrer at inline() is unsupported! Sorry!");
    }

    public String keepId_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameter(
            Object parameterValue) {
        throw new UnsupportedOperationException(
                "(Query)DerivedReferrer at inline() is unsupported! Sorry!");
    }

    protected ConditionValue getCValueName() {
        return _myCQ.getName();
    }

    protected ConditionValue getCValueValue() {
        return _myCQ.getValue();
    }

    protected ConditionValue getCValueSortOrder() {
        return _myCQ.getSortOrder();
    }

    protected ConditionValue getCValueCreatedBy() {
        return _myCQ.getCreatedBy();
    }

    protected ConditionValue getCValueCreatedTime() {
        return _myCQ.getCreatedTime();
    }

    protected ConditionValue getCValueUpdatedBy() {
        return _myCQ.getUpdatedBy();
    }

    protected ConditionValue getCValueUpdatedTime() {
        return _myCQ.getUpdatedTime();
    }

    protected ConditionValue getCValueDeletedBy() {
        return _myCQ.getDeletedBy();
    }

    protected ConditionValue getCValueDeletedTime() {
        return _myCQ.getDeletedTime();
    }

    protected ConditionValue getCValueVersionNo() {
        return _myCQ.getVersionNo();
    }

    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    public String keepScalarSubQuery(LabelTypeCQ subQuery) {
        throw new UnsupportedOperationException(
                "ScalarSubQuery at inline() is unsupported! Sorry!");
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    public String keepMyselfInScopeSubQuery(LabelTypeCQ subQuery) {
        throw new UnsupportedOperationException(
                "MyselfInScopeSubQuery at inline() is unsupported! Sorry!");
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xiCB() {
        return LabelTypeCB.class.getName();
    }

    String xiCQ() {
        return LabelTypeCQ.class.getName();
    }
}
