/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

import javax.annotation.Resource;

import jp.sf.fess.Constants;
import jp.sf.fess.db.cbean.SearchLogCB;
import jp.sf.fess.db.exbhv.ClickLogBhv;
import jp.sf.fess.db.exbhv.SearchLogBhv;
import jp.sf.fess.db.exentity.ClickLog;
import jp.sf.fess.db.exentity.SearchLog;
import jp.sf.fess.util.FessProperties;

import org.seasar.framework.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchLogHelper {
    private static final Logger logger = LoggerFactory // NOPMD
            .getLogger(SearchLogHelper.class);

    @Resource
    protected SearchLogBhv searchLogBhv;

    @Resource
    protected ClickLogBhv clickLogBhv;

    @Resource
    protected FessProperties crawlerProperties;

    private volatile Queue<SearchLog> searchLogQueue = new ConcurrentLinkedQueue<SearchLog>();

    private volatile Queue<ClickLog> clickLogQueue = new ConcurrentLinkedQueue<ClickLog>();

    public void addSearchLog(SearchLog searchLog) {
        searchLogQueue.add(searchLog);
    }

    public void addClickLog(ClickLog clickLog) {
        clickLogQueue.add(clickLog);
    }

    public void storeSearchLog() {
        if (!searchLogQueue.isEmpty()) {
            Queue<SearchLog> queue = searchLogQueue;
            searchLogQueue = new ConcurrentLinkedQueue<SearchLog>();
            List<SearchLog> searchLogList = new ArrayList<SearchLog>();
            String value = crawlerProperties.getProperty(
                    Constants.PURGE_BY_BOTS_PROPERTY, Constants.EMPTY_STRING);
            String[] botNames;
            if (StringUtil.isBlank(value)) {
                botNames = new String[0];
            } else {
                botNames = value.split(",");
            }
            for (SearchLog searchLog : queue) {
                boolean add = true;
                for (String botName : botNames) {
                    if (searchLog.getUserAgent().indexOf(botName) >= 0) {
                        add = false;
                        break;
                    }
                }
                if (add) {
                    searchLogList.add(searchLog);
                }
            }
            searchLogBhv.batchInsert(searchLogList);
            queue = null;
        }

        if (!clickLogQueue.isEmpty()) {
            Queue<ClickLog> queue = clickLogQueue;
            clickLogQueue = new ConcurrentLinkedQueue<ClickLog>();
            List<ClickLog> clickLogList = new ArrayList<ClickLog>();
            for (ClickLog clickLog : queue) {
                SearchLogCB cb = new SearchLogCB();
                cb.query().setRequestedTime_Equal(
                        clickLog.getQueryRequestedTime());
                cb.query().setUserSessionId_Equal(clickLog.getUserSessionId());
                SearchLog entity = searchLogBhv.selectEntity(cb);
                if (entity != null) {
                    clickLog.setSearchId(entity.getId());
                    clickLogList.add(clickLog);
                } else {
                    logger.warn("Not Found[ClickLog]: " + clickLog);
                }
            }
            if (!clickLogList.isEmpty()) {
                clickLogBhv.batchInsert(clickLogList);
            }
            queue = null;
        }
    }
}
