/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.WebConfigToBrowserTypeMappingDbm;
import jp.sf.fess.db.cbean.WebConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.exentity.BrowserType;
import jp.sf.fess.db.exentity.WebConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of WEB_CONFIG_TO_BROWSER_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, WEB_CONFIG_ID, BROWSER_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     BROWSER_TYPE, WEB_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     browserType, webCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsWebConfigToBrowserTypeMappingBhv extends
        AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "WEB_CONFIG_TO_BROWSER_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return WebConfigToBrowserTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public WebConfigToBrowserTypeMappingDbm getMyDBMeta() {
        return WebConfigToBrowserTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public WebConfigToBrowserTypeMapping newMyEntity() {
        return new WebConfigToBrowserTypeMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public WebConfigToBrowserTypeMappingCB newMyConditionBean() {
        return new WebConfigToBrowserTypeMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * int count = webConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of WebConfigToBrowserTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(WebConfigToBrowserTypeMappingCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(WebConfigToBrowserTypeMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;WebConfigToBrowserTypeMapping&gt;() {
     *     public void handle(WebConfigToBrowserTypeMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of WebConfigToBrowserTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of WebConfigToBrowserTypeMapping. (NotNull)
     */
    public void selectCursor(WebConfigToBrowserTypeMappingCB cb,
            EntityRowHandler<WebConfigToBrowserTypeMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler,
                WebConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToBrowserTypeMapping> void doSelectCursor(
            WebConfigToBrowserTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<WebConfigToBrowserTypeMapping>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping = webConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (webConfigToBrowserTypeMapping != null) {
     *     ... = webConfigToBrowserTypeMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToBrowserTypeMapping. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToBrowserTypeMapping selectEntity(
            WebConfigToBrowserTypeMappingCB cb) {
        return doSelectEntity(cb, WebConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToBrowserTypeMapping> ENTITY doSelectEntity(
            final WebConfigToBrowserTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, WebConfigToBrowserTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebConfigToBrowserTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping = webConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = webConfigToBrowserTypeMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of WebConfigToBrowserTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToBrowserTypeMapping selectEntityWithDeletedCheck(
            WebConfigToBrowserTypeMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb,
                WebConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToBrowserTypeMapping> ENTITY doSelectEntityWithDeletedCheck(
            final WebConfigToBrowserTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, WebConfigToBrowserTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebConfigToBrowserTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToBrowserTypeMapping selectByPKValue(Long id) {
        return doSelectByPKValue(id, WebConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToBrowserTypeMapping> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToBrowserTypeMapping selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id,
                WebConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToBrowserTypeMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private WebConfigToBrowserTypeMappingCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        WebConfigToBrowserTypeMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;WebConfigToBrowserTypeMapping&gt; webConfigToBrowserTypeMappingList = webConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping : webConfigToBrowserTypeMappingList) {
     *     ... = webConfigToBrowserTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToBrowserTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<WebConfigToBrowserTypeMapping> selectList(
            WebConfigToBrowserTypeMappingCB cb) {
        return doSelectList(cb, WebConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToBrowserTypeMapping> ListResultBean<ENTITY> doSelectList(
            WebConfigToBrowserTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, WebConfigToBrowserTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebConfigToBrowserTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;WebConfigToBrowserTypeMapping&gt; page = webConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping : page) {
     *     ... = webConfigToBrowserTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToBrowserTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<WebConfigToBrowserTypeMapping> selectPage(
            WebConfigToBrowserTypeMappingCB cb) {
        return doSelectPage(cb, WebConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToBrowserTypeMapping> PagingResultBean<ENTITY> doSelectPage(
            WebConfigToBrowserTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, WebConfigToBrowserTypeMappingCB>() {
                    public int callbackSelectCount(
                            WebConfigToBrowserTypeMappingCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            WebConfigToBrowserTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * webConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(WebConfigToBrowserTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<WebConfigToBrowserTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends WebConfigToBrowserTypeMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'BrowserType'.
     * @param webConfigToBrowserTypeMappingList The list of webConfigToBrowserTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<BrowserType> pulloutBrowserType(
            List<WebConfigToBrowserTypeMapping> webConfigToBrowserTypeMappingList) {
        return helpPulloutInternally(
                webConfigToBrowserTypeMappingList,
                new InternalPulloutCallback<WebConfigToBrowserTypeMapping, BrowserType>() {
                    public BrowserType getFr(WebConfigToBrowserTypeMapping e) {
                        return e.getBrowserType();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(BrowserType e,
                            List<WebConfigToBrowserTypeMapping> ls) {
                        e.setWebConfigToBrowserTypeMappingList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'WebCrawlingConfig'.
     * @param webConfigToBrowserTypeMappingList The list of webConfigToBrowserTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<WebCrawlingConfig> pulloutWebCrawlingConfig(
            List<WebConfigToBrowserTypeMapping> webConfigToBrowserTypeMappingList) {
        return helpPulloutInternally(
                webConfigToBrowserTypeMappingList,
                new InternalPulloutCallback<WebConfigToBrowserTypeMapping, WebCrawlingConfig>() {
                    public WebCrawlingConfig getFr(
                            WebConfigToBrowserTypeMapping e) {
                        return e.getWebCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<WebConfigToBrowserTypeMapping> ls) {
                        e.setWebConfigToBrowserTypeMappingList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping = new WebConfigToBrowserTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * webConfigToBrowserTypeMapping.setFoo...(value);
     * webConfigToBrowserTypeMapping.setBar...(value);
     * webConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">insert</span>(webConfigToBrowserTypeMapping);
     * ... = webConfigToBrowserTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param webConfigToBrowserTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(
            WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping) {
        assertEntityNotNull(webConfigToBrowserTypeMapping);
        delegateInsert(webConfigToBrowserTypeMapping);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping = new WebConfigToBrowserTypeMapping();
     * webConfigToBrowserTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webConfigToBrowserTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToBrowserTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">update</span>(webConfigToBrowserTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webConfigToBrowserTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping) {
        helpUpdateInternally(webConfigToBrowserTypeMapping,
                new InternalUpdateCallback<WebConfigToBrowserTypeMapping>() {
                    public int callbackDelegateUpdate(
                            WebConfigToBrowserTypeMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param webConfigToBrowserTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping) {
        helpInsertOrUpdateInternally(
                webConfigToBrowserTypeMapping,
                new InternalInsertOrUpdateCallback<WebConfigToBrowserTypeMapping, WebConfigToBrowserTypeMappingCB>() {
                    public void callbackInsert(
                            WebConfigToBrowserTypeMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(
                            WebConfigToBrowserTypeMapping entity) {
                        update(entity);
                    }

                    public WebConfigToBrowserTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            WebConfigToBrowserTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping = new WebConfigToBrowserTypeMapping();
     * webConfigToBrowserTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToBrowserTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">delete</span>(webConfigToBrowserTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webConfigToBrowserTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(
            WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping) {
        helpDeleteInternally(webConfigToBrowserTypeMapping,
                new InternalDeleteCallback<WebConfigToBrowserTypeMapping>() {
                    public int callbackDelegateDelete(
                            WebConfigToBrowserTypeMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webConfigToBrowserTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<WebConfigToBrowserTypeMapping> webConfigToBrowserTypeMappingList) {
        assertObjectNotNull("webConfigToBrowserTypeMappingList",
                webConfigToBrowserTypeMappingList);
        return delegateInsertList(webConfigToBrowserTypeMappingList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webConfigToBrowserTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<WebConfigToBrowserTypeMapping> webConfigToBrowserTypeMappingList) {
        assertObjectNotNull("webConfigToBrowserTypeMappingList",
                webConfigToBrowserTypeMappingList);
        return delegateUpdateList(webConfigToBrowserTypeMappingList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webConfigToBrowserTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<WebConfigToBrowserTypeMapping> webConfigToBrowserTypeMappingList) {
        assertObjectNotNull("webConfigToBrowserTypeMappingList",
                webConfigToBrowserTypeMappingList);
        return delegateDeleteList(webConfigToBrowserTypeMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping = new WebConfigToBrowserTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webConfigToBrowserTypeMapping.setPK...(value);</span>
     * webConfigToBrowserTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webConfigToBrowserTypeMapping.setVersionNo(value);</span>
     * WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">queryUpdate</span>(webConfigToBrowserTypeMapping, cb);
     * </pre>
     * @param webConfigToBrowserTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of WebConfigToBrowserTypeMapping. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(
            WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping,
            WebConfigToBrowserTypeMappingCB cb) {
        return delegateQueryUpdate(webConfigToBrowserTypeMapping, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">queryDelete</span>(webConfigToBrowserTypeMapping, cb);
     * </pre>
     * @param cb The condition-bean of WebConfigToBrowserTypeMapping. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(WebConfigToBrowserTypeMappingCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping = new WebConfigToBrowserTypeMapping();
     * webConfigToBrowserTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webConfigToBrowserTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToBrowserTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;WebConfigToBrowserTypeMappingCB&gt; option = new UpdateOption&lt;WebConfigToBrowserTypeMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;WebConfigToBrowserTypeMappingCB&gt;() {
     *         public void specify(WebConfigToBrowserTypeMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     webConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(webConfigToBrowserTypeMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param webConfigToBrowserTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(
            WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping,
            final UpdateOption<WebConfigToBrowserTypeMappingCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(webConfigToBrowserTypeMapping,
                new InternalUpdateCallback<WebConfigToBrowserTypeMapping>() {
                    public int callbackDelegateUpdate(
                            WebConfigToBrowserTypeMapping entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping = new WebConfigToBrowserTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webConfigToBrowserTypeMapping.setPK...(value);</span>
     * webConfigToBrowserTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webConfigToBrowserTypeMapping.setVersionNo(value);</span>
     * WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;WebConfigToBrowserTypeMappingCB&gt; option = new UpdateOption&lt;WebConfigToBrowserTypeMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;WebConfigToBrowserTypeMappingCB&gt;() {
     *     public void specify(WebConfigToBrowserTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * webConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(webConfigToBrowserTypeMapping, cb, option);
     * </pre>
     * @param webConfigToBrowserTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of WebConfigToBrowserTypeMapping. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(
            WebConfigToBrowserTypeMapping webConfigToBrowserTypeMapping,
            WebConfigToBrowserTypeMappingCB cb,
            final UpdateOption<WebConfigToBrowserTypeMappingCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(webConfigToBrowserTypeMapping, cb,
                option);
    }

    protected void processVaryingUpdate(
            UpdateOption<WebConfigToBrowserTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        WebConfigToBrowserTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(WebConfigToBrowserTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends WebConfigToBrowserTypeMapping> void delegateSelectCursor(
            WebConfigToBrowserTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends WebConfigToBrowserTypeMapping> List<ENTITY> delegateSelectList(
            WebConfigToBrowserTypeMappingCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(WebConfigToBrowserTypeMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(WebConfigToBrowserTypeMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(WebConfigToBrowserTypeMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<WebConfigToBrowserTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<WebConfigToBrowserTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<WebConfigToBrowserTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int delegateQueryUpdate(WebConfigToBrowserTypeMapping e,
            WebConfigToBrowserTypeMappingCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(WebConfigToBrowserTypeMappingCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(WebConfigToBrowserTypeMapping e,
            UpdateOption<WebConfigToBrowserTypeMappingCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(WebConfigToBrowserTypeMapping e,
            WebConfigToBrowserTypeMappingCB cb,
            UpdateOption<WebConfigToBrowserTypeMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected WebConfigToBrowserTypeMapping downcast(Entity entity) {
        return helpEntityDowncastInternally(entity,
                WebConfigToBrowserTypeMapping.class);
    }

    protected WebConfigToBrowserTypeMappingCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                WebConfigToBrowserTypeMappingCB.class);
    }
}
