/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.CrawlingSessionInfoCB;
import jp.sf.fess.db.cbean.cq.CrawlingSessionCQ;
import jp.sf.fess.db.cbean.cq.CrawlingSessionInfoCQ;
import jp.sf.fess.db.cbean.cq.ciq.CrawlingSessionInfoCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;

/**
 * The base condition-query of CRAWLING_SESSION_INFO.
 * @author DBFlute(AutoGenerator)
 */
public class BsCrawlingSessionInfoCQ extends AbstractBsCrawlingSessionInfoCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected CrawlingSessionInfoCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsCrawlingSessionInfoCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare InlineView query. <br />
     * {select ... from ... left outer join (select * from CRAWLING_SESSION_INFO) where FOO = [value] ...}
     * <pre>
     * cb.query().queryMemberStatus().<span style="color: #FD4747">inline()</span>.setFoo...;
     * </pre>
     * @return The condition-query for InlineView query. (NotNull)
     */
    public CrawlingSessionInfoCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = createInlineQuery();
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    protected CrawlingSessionInfoCIQ createInlineQuery() {
        return new CrawlingSessionInfoCIQ(getReferrerQuery(), getSqlClause(),
                getAliasName(), getNestLevel(), this);
    }

    /**
     * Prepare OnClause query. <br />
     * {select ... from ... left outer join CRAWLING_SESSION_INFO on ... and FOO = [value] ...}
     * <pre>
     * cb.query().queryMemberStatus().<span style="color: #FD4747">on()</span>.setFoo...;
     * </pre>
     * @return The condition-query for OnClause query. (NotNull)
     * @throws IllegalConditionBeanOperationException When this condition-query is base query.
     */
    public CrawlingSessionInfoCIQ on() {
        if (isBaseQuery()) {
            throw new IllegalConditionBeanOperationException(
                    "OnClause for local table is unavailable!");
        }
        CrawlingSessionInfoCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionInfoCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionInfoCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _crawlingSessionId;

    public ConditionValue getCrawlingSessionId() {
        if (_crawlingSessionId == null) {
            _crawlingSessionId = nCV();
        }
        return _crawlingSessionId;
    }

    protected ConditionValue getCValueCrawlingSessionId() {
        return getCrawlingSessionId();
    }

    protected Map<String, CrawlingSessionCQ> _crawlingSessionId_InScopeRelation_CrawlingSessionMap;

    public Map<String, CrawlingSessionCQ> getCrawlingSessionId_InScopeRelation_CrawlingSession() {
        return _crawlingSessionId_InScopeRelation_CrawlingSessionMap;
    }

    public String keepCrawlingSessionId_InScopeRelation_CrawlingSession(
            CrawlingSessionCQ subQuery) {
        if (_crawlingSessionId_InScopeRelation_CrawlingSessionMap == null) {
            _crawlingSessionId_InScopeRelation_CrawlingSessionMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_crawlingSessionId_InScopeRelation_CrawlingSessionMap.size() + 1);
        _crawlingSessionId_InScopeRelation_CrawlingSessionMap
                .put(key, subQuery);
        return "crawlingSessionId_InScopeRelation_CrawlingSession." + key;
    }

    protected Map<String, CrawlingSessionCQ> _crawlingSessionId_NotInScopeRelation_CrawlingSessionMap;

    public Map<String, CrawlingSessionCQ> getCrawlingSessionId_NotInScopeRelation_CrawlingSession() {
        return _crawlingSessionId_NotInScopeRelation_CrawlingSessionMap;
    }

    public String keepCrawlingSessionId_NotInScopeRelation_CrawlingSession(
            CrawlingSessionCQ subQuery) {
        if (_crawlingSessionId_NotInScopeRelation_CrawlingSessionMap == null) {
            _crawlingSessionId_NotInScopeRelation_CrawlingSessionMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_crawlingSessionId_NotInScopeRelation_CrawlingSessionMap
                        .size() + 1);
        _crawlingSessionId_NotInScopeRelation_CrawlingSessionMap.put(key,
                subQuery);
        return "crawlingSessionId_NotInScopeRelation_CrawlingSession." + key;
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionInfoCQ addOrderBy_CrawlingSessionId_Asc() {
        regOBA("CRAWLING_SESSION_ID");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionInfoCQ addOrderBy_CrawlingSessionId_Desc() {
        regOBD("CRAWLING_SESSION_ID");
        return this;
    }

    protected ConditionValue _key;

    public ConditionValue getKey() {
        if (_key == null) {
            _key = nCV();
        }
        return _key;
    }

    protected ConditionValue getCValueKey() {
        return getKey();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionInfoCQ addOrderBy_Key_Asc() {
        regOBA("KEY");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionInfoCQ addOrderBy_Key_Desc() {
        regOBD("KEY");
        return this;
    }

    protected ConditionValue _value;

    public ConditionValue getValue() {
        if (_value == null) {
            _value = nCV();
        }
        return _value;
    }

    protected ConditionValue getCValueValue() {
        return getValue();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionInfoCQ addOrderBy_Value_Asc() {
        regOBA("VALUE");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionInfoCQ addOrderBy_Value_Desc() {
        regOBD("VALUE");
        return this;
    }

    protected ConditionValue _createdTime;

    public ConditionValue getCreatedTime() {
        if (_createdTime == null) {
            _createdTime = nCV();
        }
        return _createdTime;
    }

    protected ConditionValue getCValueCreatedTime() {
        return getCreatedTime();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionInfoCQ addOrderBy_CreatedTime_Asc() {
        regOBA("CREATED_TIME");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsCrawlingSessionInfoCQ addOrderBy_CreatedTime_Desc() {
        regOBD("CREATED_TIME");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    /**
     * Add order-by for specified derived column as ascend.
     * <pre>
     * cb.specify().derivedPurchaseList().max(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.specify().columnPurchaseDatetime();
     *     }
     * }, <span style="color: #FD4747">aliasName</span>);
     * <span style="color: #3F7E5E">// order by [alias-name] asc</span>
     * cb.<span style="color: #FD4747">addSpecifiedDerivedOrderBy_Asc</span>(<span style="color: #FD4747">aliasName</span>);
     * </pre>
     * @param aliasName The alias name specified at (Specify)DerivedReferrer. (NotNull)
     * @return this. (NotNull)
     */
    public BsCrawlingSessionInfoCQ addSpecifiedDerivedOrderBy_Asc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    /**
     * Add order-by for specified derived column as descend.
     * <pre>
     * cb.specify().derivedPurchaseList().max(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.specify().columnPurchaseDatetime();
     *     }
     * }, <span style="color: #FD4747">aliasName</span>);
     * <span style="color: #3F7E5E">// order by [alias-name] desc</span>
     * cb.<span style="color: #FD4747">addSpecifiedDerivedOrderBy_Desc</span>(<span style="color: #FD4747">aliasName</span>);
     * </pre>
     * @param aliasName The alias name specified at (Specify)DerivedReferrer. (NotNull)
     * @return this. (NotNull)
     */
    public BsCrawlingSessionInfoCQ addSpecifiedDerivedOrderBy_Desc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
        CrawlingSessionInfoCQ baseQuery = (CrawlingSessionInfoCQ) baseQueryAsSuper;
        CrawlingSessionInfoCQ unionQuery = (CrawlingSessionInfoCQ) unionQueryAsSuper;
        if (baseQuery.hasConditionQueryCrawlingSession()) {
            unionQuery.queryCrawlingSession().reflectRelationOnUnionQuery(
                    baseQuery.queryCrawlingSession(),
                    unionQuery.queryCrawlingSession());
        }
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    /**
     * Get the condition-query for relation table. <br />
     * CRAWLING_SESSION as 'crawlingSession'.
     * @return The instance of condition-query. (NotNull)
     */
    public CrawlingSessionCQ queryCrawlingSession() {
        return getConditionQueryCrawlingSession();
    }

    protected CrawlingSessionCQ _conditionQueryCrawlingSession;

    public CrawlingSessionCQ getConditionQueryCrawlingSession() {
        if (_conditionQueryCrawlingSession == null) {
            _conditionQueryCrawlingSession = xcreateQueryCrawlingSession();
            xsetupOuterJoinCrawlingSession();
        }
        return _conditionQueryCrawlingSession;
    }

    protected CrawlingSessionCQ xcreateQueryCrawlingSession() {
        String nrp = resolveNextRelationPath("CRAWLING_SESSION_INFO",
                "crawlingSession");
        String jan = resolveJoinAliasName(nrp, getNextNestLevel());
        CrawlingSessionCQ cq = new CrawlingSessionCQ(this, getSqlClause(), jan,
                getNextNestLevel());
        cq.xsetForeignPropertyName("crawlingSession");
        cq.xsetRelationPath(nrp);
        return cq;
    }

    protected void xsetupOuterJoinCrawlingSession() {
        CrawlingSessionCQ cq = getConditionQueryCrawlingSession();
        Map<String, String> joinOnMap = newLinkedHashMap();
        joinOnMap.put("CRAWLING_SESSION_ID", "ID");
        registerOuterJoin(cq, joinOnMap);
    }

    public boolean hasConditionQueryCrawlingSession() {
        return _conditionQueryCrawlingSession != null;
    }

    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, CrawlingSessionInfoCQ> _scalarConditionMap;

    public Map<String, CrawlingSessionInfoCQ> getScalarCondition() {
        return _scalarConditionMap;
    }

    public String keepScalarCondition(CrawlingSessionInfoCQ subQuery) {
        if (_scalarConditionMap == null) {
            _scalarConditionMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarConditionMap.size() + 1);
        _scalarConditionMap.put(key, subQuery);
        return "scalarCondition." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, CrawlingSessionInfoCQ> _myselfInScopeRelationMap;

    public Map<String, CrawlingSessionInfoCQ> getMyselfInScopeRelation() {
        return _myselfInScopeRelationMap;
    }

    public String keepMyselfInScopeRelation(CrawlingSessionInfoCQ subQuery) {
        if (_myselfInScopeRelationMap == null) {
            _myselfInScopeRelationMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeRelationMap.size() + 1);
        _myselfInScopeRelationMap.put(key, subQuery);
        return "myselfInScopeRelation." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // very internal (for suppressing warn about 'Not Use Import')
    protected String xCB() {
        return CrawlingSessionInfoCB.class.getName();
    }

    protected String xCQ() {
        return CrawlingSessionInfoCQ.class.getName();
    }

    protected String xMap() {
        return Map.class.getName();
    }
}
