/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.helper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

import jp.sf.fess.db.allcommon.CDef;
import jp.sf.fess.db.cbean.PathMappingCB;
import jp.sf.fess.db.exbhv.PathMappingBhv;
import jp.sf.fess.db.exentity.PathMapping;

import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.annotation.tiger.InitMethod;

public class PathMappingHelper implements Serializable {

    private static final long serialVersionUID = 1L;

    private Map<String, List<PathMapping>> pathMappingMap = new HashMap<String, List<PathMapping>>();

    private List<PathMapping> cachedPathMappingList = null;

    @InitMethod
    public void init() {
        List<CDef.ProcessType> ptList = new ArrayList<CDef.ProcessType>();
        ptList.add(CDef.ProcessType.Displaying);
        ptList.add(CDef.ProcessType.Both);

        PathMappingCB cb = new PathMappingCB();

        cb.query().setDeletedBy_IsNull();
        cb.query().addOrderBy_SortOrder_Asc();
        cb.query().setProcessType_InScope_AsProcessType(ptList);

        cachedPathMappingList = SingletonS2Container.getComponent(
                PathMappingBhv.class).selectList(cb);
    }

    public void setPathMappingList(String sessionId,
            List<PathMapping> pathMappingList) {
        if (sessionId != null) {
            if (pathMappingList != null) {
                pathMappingMap.put(sessionId, pathMappingList);
            } else {
                removePathMappingList(sessionId);
            }
        }
    }

    public void removePathMappingList(String sessionId) {
        pathMappingMap.remove(sessionId);
    }

    public List<PathMapping> getPathMappingList(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        return pathMappingMap.get(sessionId);
    }

    public String replaceUrl(String sessionId, String url) {
        List<PathMapping> pathMappingList = getPathMappingList(sessionId);
        if (pathMappingList == null) {
            return url;
        }
        return replaceUrl(pathMappingList, url);
    }

    public String replaceUrl(String url) {
        return replaceUrl(cachedPathMappingList, url);
    }

    private String replaceUrl(List<PathMapping> pathMappingList, String url) {
        for (PathMapping pathMapping : pathMappingList) {
            Matcher matcher = pathMapping.getMatcher(url);
            if (matcher.find()) {
                url = matcher.replaceAll(pathMapping.getReplacement());
            }
        }
        return url;
    }
}
