/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.BrowserTypeDbm;
import jp.sf.fess.db.cbean.BrowserTypeCB;
import jp.sf.fess.db.cbean.DataConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.WebConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.exbhv.BrowserTypeBhv;
import jp.sf.fess.db.exbhv.DataConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exentity.BrowserType;
import jp.sf.fess.db.exentity.DataConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToBrowserTypeMapping;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of BROWSER_TYPE as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     DATA_CONFIG_TO_BROWSER_TYPE_MAPPING, FILE_CONFIG_TO_BROWSER_TYPE_MAPPING, WEB_CONFIG_TO_BROWSER_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     dataConfigToBrowserTypeMappingList, fileConfigToBrowserTypeMappingList, webConfigToBrowserTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsBrowserTypeBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "BROWSER_TYPE";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return BrowserTypeDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public BrowserTypeDbm getMyDBMeta() {
        return BrowserTypeDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public BrowserType newMyEntity() {
        return new BrowserType();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public BrowserTypeCB newMyConditionBean() {
        return new BrowserTypeCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * int count = browserTypeBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The selected count.
     */
    public int selectCount(BrowserTypeCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(BrowserTypeCB cb) { // called by selectCount(cb) 
        assertCBNotNull(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(BrowserTypeCB cb) { // called by selectPage(cb)
        assertCBNotNull(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * browserTypeBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;BrowserType&gt;() {
     *     public void handle(BrowserType entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @param entityRowHandler The handler of entity row of BrowserType. (NotNull)
     */
    public void selectCursor(BrowserTypeCB cb,
            EntityRowHandler<BrowserType> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> void doSelectCursor(
            BrowserTypeCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<BrowserType>", entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * BrowserType browserType = browserTypeBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (browserType != null) {
     *     ... = browserType.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public BrowserType selectEntity(BrowserTypeCB cb) {
        return doSelectEntity(cb, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ENTITY doSelectEntity(
            final BrowserTypeCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, BrowserTypeCB>() {
                    public List<ENTITY> callbackSelectList(BrowserTypeCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * BrowserType browserType = browserTypeBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = browserType.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public BrowserType selectEntityWithDeletedCheck(BrowserTypeCB cb) {
        return doSelectEntityWithDeletedCheck(cb, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ENTITY doSelectEntityWithDeletedCheck(
            final BrowserTypeCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, BrowserTypeCB>() {
                    public List<ENTITY> callbackSelectList(BrowserTypeCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public BrowserType selectByPKValue(Long id) {
        return doSelectByPKValue(id, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ENTITY doSelectByPKValue(Long id,
            Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public BrowserType selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private BrowserTypeCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        BrowserTypeCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;BrowserType&gt; browserTypeList = browserTypeBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (BrowserType browserType : browserTypeList) {
     *     ... = browserType.get...();
     * }
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<BrowserType> selectList(BrowserTypeCB cb) {
        return doSelectList(cb, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ListResultBean<ENTITY> doSelectList(
            BrowserTypeCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, BrowserTypeCB>() {
                    public List<ENTITY> callbackSelectList(BrowserTypeCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;BrowserType&gt; page = browserTypeBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (BrowserType browserType : page) {
     *     ... = browserType.get...();
     * }
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<BrowserType> selectPage(BrowserTypeCB cb) {
        return doSelectPage(cb, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> PagingResultBean<ENTITY> doSelectPage(
            BrowserTypeCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, BrowserTypeCB>() {
                    public int callbackSelectCount(BrowserTypeCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    public List<ENTITY> callbackSelectList(BrowserTypeCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * browserTypeBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(BrowserTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<BrowserTypeCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends BrowserTypeCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            BrowserType browserType,
            ConditionBeanSetupper<DataConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserType, conditionBeanSetupper);
        loadDataConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToBrowserTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * browserTypeBhv.<span style="color: #FD4747">loadDataConfigToBrowserTypeMappingList</span>(browserTypeList, new ConditionBeanSetupper&lt;DataConfigToBrowserTypeMappingCB&gt;() {
     *     public void setup(DataConfigToBrowserTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (BrowserType browserType : browserTypeList) {
     *     ... = browserType.<span style="color: #FD4747">getDataConfigToBrowserTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setBrowserTypeId_InScope(pkList);
     * cb.query().addOrderBy_BrowserTypeId_Asc();
     * </pre>
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            List<BrowserType> browserTypeList,
            ConditionBeanSetupper<DataConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserTypeList, conditionBeanSetupper);
        loadDataConfigToBrowserTypeMappingList(
                browserTypeList,
                new LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            BrowserType browserType,
            LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserType, loadReferrerOption);
        loadDataConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            List<BrowserType> browserTypeList,
            LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserTypeList, loadReferrerOption);
        if (browserTypeList.isEmpty()) {
            return;
        }
        final DataConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(DataConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                browserTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<BrowserType, Long, DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping>() {
                    public Long getPKVal(BrowserType e) {
                        return e.getId();
                    }

                    public void setRfLs(BrowserType e,
                            List<DataConfigToBrowserTypeMapping> ls) {
                        e.setDataConfigToBrowserTypeMappingList(ls);
                    }

                    public DataConfigToBrowserTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(DataConfigToBrowserTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setBrowserTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(DataConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_BrowserTypeId_Asc();
                    }

                    public void spFKCol(DataConfigToBrowserTypeMappingCB cb) {
                        cb.specify().columnBrowserTypeId();
                    }

                    public List<DataConfigToBrowserTypeMapping> selRfLs(
                            DataConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(DataConfigToBrowserTypeMapping e) {
                        return e.getBrowserTypeId();
                    }

                    public void setlcEt(DataConfigToBrowserTypeMapping re,
                            BrowserType le) {
                        re.setBrowserType(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            BrowserType browserType,
            ConditionBeanSetupper<FileConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserType, conditionBeanSetupper);
        loadFileConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of fileConfigToBrowserTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * browserTypeBhv.<span style="color: #FD4747">loadFileConfigToBrowserTypeMappingList</span>(browserTypeList, new ConditionBeanSetupper&lt;FileConfigToBrowserTypeMappingCB&gt;() {
     *     public void setup(FileConfigToBrowserTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (BrowserType browserType : browserTypeList) {
     *     ... = browserType.<span style="color: #FD4747">getFileConfigToBrowserTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setBrowserTypeId_InScope(pkList);
     * cb.query().addOrderBy_BrowserTypeId_Asc();
     * </pre>
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            List<BrowserType> browserTypeList,
            ConditionBeanSetupper<FileConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserTypeList, conditionBeanSetupper);
        loadFileConfigToBrowserTypeMappingList(
                browserTypeList,
                new LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            BrowserType browserType,
            LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserType, loadReferrerOption);
        loadFileConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            List<BrowserType> browserTypeList,
            LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserTypeList, loadReferrerOption);
        if (browserTypeList.isEmpty()) {
            return;
        }
        final FileConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(FileConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                browserTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<BrowserType, Long, FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping>() {
                    public Long getPKVal(BrowserType e) {
                        return e.getId();
                    }

                    public void setRfLs(BrowserType e,
                            List<FileConfigToBrowserTypeMapping> ls) {
                        e.setFileConfigToBrowserTypeMappingList(ls);
                    }

                    public FileConfigToBrowserTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(FileConfigToBrowserTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setBrowserTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(FileConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_BrowserTypeId_Asc();
                    }

                    public void spFKCol(FileConfigToBrowserTypeMappingCB cb) {
                        cb.specify().columnBrowserTypeId();
                    }

                    public List<FileConfigToBrowserTypeMapping> selRfLs(
                            FileConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(FileConfigToBrowserTypeMapping e) {
                        return e.getBrowserTypeId();
                    }

                    public void setlcEt(FileConfigToBrowserTypeMapping re,
                            BrowserType le) {
                        re.setBrowserType(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            BrowserType browserType,
            ConditionBeanSetupper<WebConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserType, conditionBeanSetupper);
        loadWebConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToBrowserTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * browserTypeBhv.<span style="color: #FD4747">loadWebConfigToBrowserTypeMappingList</span>(browserTypeList, new ConditionBeanSetupper&lt;WebConfigToBrowserTypeMappingCB&gt;() {
     *     public void setup(WebConfigToBrowserTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (BrowserType browserType : browserTypeList) {
     *     ... = browserType.<span style="color: #FD4747">getWebConfigToBrowserTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setBrowserTypeId_InScope(pkList);
     * cb.query().addOrderBy_BrowserTypeId_Asc();
     * </pre>
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            List<BrowserType> browserTypeList,
            ConditionBeanSetupper<WebConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserTypeList, conditionBeanSetupper);
        loadWebConfigToBrowserTypeMappingList(
                browserTypeList,
                new LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            BrowserType browserType,
            LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserType, loadReferrerOption);
        loadWebConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            List<BrowserType> browserTypeList,
            LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserTypeList, loadReferrerOption);
        if (browserTypeList.isEmpty()) {
            return;
        }
        final WebConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(WebConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                browserTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<BrowserType, Long, WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping>() {
                    public Long getPKVal(BrowserType e) {
                        return e.getId();
                    }

                    public void setRfLs(BrowserType e,
                            List<WebConfigToBrowserTypeMapping> ls) {
                        e.setWebConfigToBrowserTypeMappingList(ls);
                    }

                    public WebConfigToBrowserTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(WebConfigToBrowserTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setBrowserTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(WebConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_BrowserTypeId_Asc();
                    }

                    public void spFKCol(WebConfigToBrowserTypeMappingCB cb) {
                        cb.specify().columnBrowserTypeId();
                    }

                    public List<WebConfigToBrowserTypeMapping> selRfLs(
                            WebConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(WebConfigToBrowserTypeMapping e) {
                        return e.getBrowserTypeId();
                    }

                    public void setlcEt(WebConfigToBrowserTypeMapping re,
                            BrowserType le) {
                        re.setBrowserType(le);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * BrowserType browserType = new BrowserType();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * browserType.setFoo...(value);
     * browserType.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//browserType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//browserType.set...;</span>
     * browserTypeBhv.<span style="color: #FD4747">insert</span>(browserType);
     * ... = browserType.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param browserType The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(BrowserType browserType) {
        doInsert(browserType, null);
    }

    protected void doInsert(BrowserType browserType,
            InsertOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserType", browserType);
        prepareInsertOption(option);
        delegateInsert(browserType, option);
    }

    protected void prepareInsertOption(InsertOption<BrowserTypeCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreate(Entity entity,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), (InsertOption) option);
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * browserType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//browserType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//browserType.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * browserType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     browserTypeBhv.<span style="color: #FD4747">update</span>(browserType);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param browserType The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final BrowserType browserType) {
        doUpdate(browserType, null);
    }

    protected void doUpdate(BrowserType browserType,
            final UpdateOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserType", browserType);
        prepareUpdateOption(option);
        helpUpdateInternally(browserType,
                new InternalUpdateCallback<BrowserType>() {
                    public int callbackDelegateUpdate(BrowserType entity) {
                        return delegateUpdate(entity, option);
                    }
                });
    }

    protected void prepareUpdateOption(UpdateOption<BrowserTypeCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected BrowserTypeCB createCBForVaryingUpdate() {
        BrowserTypeCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected BrowserTypeCB createCBForSpecifiedUpdate() {
        BrowserTypeCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModify(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * browserType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//browserType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//browserType.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * browserTypeBhv.<span style="color: #FD4747">updateNonstrict</span>(browserType);
     * </pre>
     * @param browserType The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final BrowserType browserType) {
        doUpdateNonstrict(browserType, null);
    }

    protected void doUpdateNonstrict(BrowserType browserType,
            final UpdateOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserType", browserType);
        prepareUpdateOption(option);
        helpUpdateNonstrictInternally(browserType,
                new InternalUpdateNonstrictCallback<BrowserType>() {
                    public int callbackDelegateUpdateNonstrict(
                            BrowserType entity) {
                        return delegateUpdateNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModifyNonstrict(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            updateNonstrict(downcast(entity));
        } else {
            varyingUpdateNonstrict(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param browserType The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(BrowserType browserType) {
        doInesrtOrUpdate(browserType, null, null);
    }

    protected void doInesrtOrUpdate(BrowserType browserType,
            final InsertOption<BrowserTypeCB> insertOption,
            final UpdateOption<BrowserTypeCB> updateOption) {
        helpInsertOrUpdateInternally(
                browserType,
                new InternalInsertOrUpdateCallback<BrowserType, BrowserTypeCB>() {
                    public void callbackInsert(BrowserType entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdate(BrowserType entity) {
                        doUpdate(entity, updateOption);
                    }

                    public BrowserTypeCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(BrowserTypeCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModify(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param browserType The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(BrowserType browserType) {
        doInesrtOrUpdateNonstrict(browserType, null, null);
    }

    protected void doInesrtOrUpdateNonstrict(BrowserType browserType,
            final InsertOption<BrowserTypeCB> insertOption,
            final UpdateOption<BrowserTypeCB> updateOption) {
        helpInsertOrUpdateInternally(browserType,
                new InternalInsertOrUpdateNonstrictCallback<BrowserType>() {
                    public void callbackInsert(BrowserType entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdateNonstrict(BrowserType entity) {
                        doUpdateNonstrict(entity, updateOption);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModifyNonstrict(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdateNonstrict(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdateNonstrict(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * browserType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     browserTypeBhv.<span style="color: #FD4747">delete</span>(browserType);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param browserType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(BrowserType browserType) {
        doDelete(browserType, null);
    }

    protected void doDelete(BrowserType browserType,
            final DeleteOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserType", browserType);
        prepareDeleteOption(option);
        helpDeleteInternally(browserType,
                new InternalDeleteCallback<BrowserType>() {
                    public int callbackDelegateDelete(BrowserType entity) {
                        return delegateDelete(entity, option);
                    }
                });
    }

    protected void prepareDeleteOption(DeleteOption<BrowserTypeCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemove(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), (DeleteOption) option);
        }
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * browserTypeBhv.<span style="color: #FD4747">deleteNonstrict</span>(browserType);
     * </pre>
     * @param browserType The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(BrowserType browserType) {
        doDeleteNonstrict(browserType, null);
    }

    protected void doDeleteNonstrict(BrowserType browserType,
            final DeleteOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserType", browserType);
        prepareDeleteOption(option);
        helpDeleteNonstrictInternally(browserType,
                new InternalDeleteNonstrictCallback<BrowserType>() {
                    public int callbackDelegateDeleteNonstrict(
                            BrowserType entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * browserTypeBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(browserType);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param browserType The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(BrowserType browserType) {
        doDeleteNonstrictIgnoreDeleted(browserType, null);
    }

    protected void doDeleteNonstrictIgnoreDeleted(BrowserType browserType,
            final DeleteOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserType", browserType);
        prepareDeleteOption(option);
        helpDeleteNonstrictIgnoreDeletedInternally(
                browserType,
                new InternalDeleteNonstrictIgnoreDeletedCallback<BrowserType>() {
                    public int callbackDelegateDeleteNonstrict(
                            BrowserType entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemoveNonstrict(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            deleteNonstrict(downcast(entity));
        } else {
            varyingDeleteNonstrict(downcast(entity), (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<BrowserType> browserTypeList) {
        return doBatchInsert(browserTypeList, null);
    }

    protected int[] doBatchInsert(List<BrowserType> browserTypeList,
            InsertOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        prepareInsertOption(option);
        return delegateBatchInsert(browserTypeList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpCreate(List<Entity> ls,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert((List) ls);
        } else {
            return varyingBatchInsert((List) ls, (InsertOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<BrowserType> browserTypeList) {
        return doBatchUpdate(browserTypeList, null);
    }

    protected int[] doBatchUpdate(List<BrowserType> browserTypeList,
            UpdateOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(browserTypeList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModify(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate((List) ls);
        } else {
            return varyingBatchUpdate((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param browserTypeList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<BrowserType> browserTypeList,
            SpecifyQuery<BrowserTypeCB> updateColumnSpec) {
        return doBatchUpdate(browserTypeList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(List<BrowserType> browserTypeList) {
        return doBatchUpdateNonstrict(browserTypeList, null);
    }

    protected int[] doBatchUpdateNonstrict(List<BrowserType> browserTypeList,
            UpdateOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        prepareUpdateOption(option);
        return delegateBatchUpdateNonstrict(browserTypeList, option);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param browserTypeList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(List<BrowserType> browserTypeList,
            SpecifyQuery<BrowserTypeCB> updateColumnSpec) {
        return doBatchUpdateNonstrict(browserTypeList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModifyNonstrict(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdateNonstrict((List) ls);
        } else {
            return varyingBatchUpdateNonstrict((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<BrowserType> browserTypeList) {
        return doBatchDelete(browserTypeList, null);
    }

    protected int[] doBatchDelete(List<BrowserType> browserTypeList,
            DeleteOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        prepareDeleteOption(option);
        return delegateBatchDelete(browserTypeList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemove(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete((List) ls);
        } else {
            return varyingBatchDelete((List) ls, (DeleteOption) option);
        }
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(List<BrowserType> browserTypeList) {
        return doBatchDeleteNonstrict(browserTypeList, null);
    }

    protected int[] doBatchDeleteNonstrict(List<BrowserType> browserTypeList,
            DeleteOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        prepareDeleteOption(option);
        return delegateBatchDeleteNonstrict(browserTypeList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemoveNonstrict(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDeleteNonstrict((List) ls);
        } else {
            return varyingBatchDeleteNonstrict((List) ls, (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * browserTypeBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;browserType, BrowserTypeCB&gt;() {
     *     public ConditionBean setup(browserType entity, BrowserTypeCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(
            QueryInsertSetupper<BrowserType, BrowserTypeCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            QueryInsertSetupper<BrowserType, BrowserTypeCB> setupper,
            InsertOption<BrowserTypeCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        BrowserType entity = new BrowserType();
        BrowserTypeCB intoCB = createCBForQueryInsert();
        ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected BrowserTypeCB createCBForQueryInsert() {
        BrowserTypeCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeCreate(
            QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert((QueryInsertSetupper) setupper);
        } else {
            return varyingQueryInsert((QueryInsertSetupper) setupper,
                    (InsertOption) option);
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//browserType.setPK...(value);</span>
     * browserType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//browserType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//browserType.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * browserTypeBhv.<span style="color: #FD4747">queryUpdate</span>(browserType, cb);
     * </pre>
     * @param browserType The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(BrowserType browserType, BrowserTypeCB cb) {
        return doQueryUpdate(browserType, cb, null);
    }

    protected int doQueryUpdate(BrowserType browserType, BrowserTypeCB cb,
            UpdateOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserType", browserType);
        assertCBNotNull(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(browserType, cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeModify(Entity entity, ConditionBean cb,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity), (BrowserTypeCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity), (BrowserTypeCB) cb,
                    (UpdateOption) option);
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * browserTypeBhv.<span style="color: #FD4747">queryDelete</span>(browserType, cb);
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(BrowserTypeCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(BrowserTypeCB cb,
            DeleteOption<BrowserTypeCB> option) {
        assertCBNotNull(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeRemove(ConditionBean cb,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((BrowserTypeCB) cb);
        } else {
            return varyingQueryDelete((BrowserTypeCB) cb, (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * BrowserType browserType = new BrowserType();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * browserType.setFoo...(value);
     * browserType.setBar...(value);
     * InsertOption<BrowserTypeCB> option = new InsertOption<BrowserTypeCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * browserTypeBhv.<span style="color: #FD4747">varyingInsert</span>(browserType, option);
     * ... = browserType.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param browserType The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(BrowserType browserType,
            InsertOption<BrowserTypeCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(browserType, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * browserType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * browserType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;BrowserTypeCB&gt; option = new UpdateOption&lt;BrowserTypeCB&gt;();
     *     option.self(new SpecifyQuery&lt;BrowserTypeCB&gt;() {
     *         public void specify(BrowserTypeCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     browserTypeBhv.<span style="color: #FD4747">varyingUpdate</span>(browserType, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param browserType The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(BrowserType browserType,
            UpdateOption<BrowserTypeCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(browserType, option);
    }

    /**
     * Update the entity with varying requests non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as updateNonstrict(entity).
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * browserType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * UpdateOption&lt;BrowserTypeCB&gt; option = new UpdateOption&lt;BrowserTypeCB&gt;();
     * option.self(new SpecifyQuery&lt;BrowserTypeCB&gt;() {
     *     public void specify(BrowserTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * browserTypeBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(browserType, option);
     * </pre>
     * @param browserType The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(BrowserType browserType,
            UpdateOption<BrowserTypeCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdateNonstrict(browserType, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param browserType The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(BrowserType browserType,
            InsertOption<BrowserTypeCB> insertOption,
            UpdateOption<BrowserTypeCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(browserType, insertOption, updateOption);
    }

    /**
     * Insert or update the entity with varying requests non-strictly. {NonExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdateNonstrict(entity).
     * @param browserType The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdateNonstrict(BrowserType browserType,
            InsertOption<BrowserTypeCB> insertOption,
            UpdateOption<BrowserTypeCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdateNonstrict(browserType, insertOption, updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param browserType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(BrowserType browserType,
            DeleteOption<BrowserTypeCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(browserType, option);
    }

    /**
     * Delete the entity with varying requests non-strictly. {UpdateCountZeroException, NonExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as deleteNonstrict(entity).
     * @param browserType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDeleteNonstrict(BrowserType browserType,
            DeleteOption<BrowserTypeCB> option) {
        assertDeleteOptionNotNull(option);
        doDeleteNonstrict(browserType, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param browserTypeList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(List<BrowserType> browserTypeList,
            InsertOption<BrowserTypeCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(browserTypeList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param browserTypeList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(List<BrowserType> browserTypeList,
            UpdateOption<BrowserTypeCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(browserTypeList, option);
    }

    /**
     * Batch-update the list with varying requests non-strictly. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param browserTypeList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdateNonstrict(List<BrowserType> browserTypeList,
            UpdateOption<BrowserTypeCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdateNonstrict(browserTypeList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param browserTypeList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(List<BrowserType> browserTypeList,
            DeleteOption<BrowserTypeCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(browserTypeList, option);
    }

    /**
     * Batch-delete the list with varying requests non-strictly. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDeleteNonstrict(entityList).
     * @param browserTypeList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDeleteNonstrict(List<BrowserType> browserTypeList,
            DeleteOption<BrowserTypeCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDeleteNonstrict(browserTypeList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            QueryInsertSetupper<BrowserType, BrowserTypeCB> setupper,
            InsertOption<BrowserTypeCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * BrowserType browserType = new BrowserType();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//browserType.setPK...(value);</span>
     * browserType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;BrowserTypeCB&gt; option = new UpdateOption&lt;BrowserTypeCB&gt;();
     * option.self(new SpecifyQuery&lt;BrowserTypeCB&gt;() {
     *     public void specify(BrowserTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * browserTypeBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(browserType, cb, option);
     * </pre>
     * @param browserType The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(BrowserType browserType, BrowserTypeCB cb,
            UpdateOption<BrowserTypeCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(browserType, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(BrowserTypeCB cb,
            DeleteOption<BrowserTypeCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<BrowserTypeBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(BrowserTypeCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(BrowserTypeCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends BrowserType> void delegateSelectCursor(
            BrowserTypeCB cb, EntityRowHandler<ENTITY> erh, Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends BrowserType> List<ENTITY> delegateSelectList(
            BrowserTypeCB cb, Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(BrowserType e, InsertOption<BrowserTypeCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(BrowserType e, UpdateOption<BrowserTypeCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateEntityCommand(e, op));
    }

    protected int delegateUpdateNonstrict(BrowserType e,
            UpdateOption<BrowserTypeCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(BrowserType e, DeleteOption<BrowserTypeCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteEntityCommand(e, op));
    }

    protected int delegateDeleteNonstrict(BrowserType e,
            DeleteOption<BrowserTypeCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(List<BrowserType> ls,
            InsertOption<BrowserTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(List<BrowserType> ls,
            UpdateOption<BrowserTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchUpdateNonstrict(List<BrowserType> ls,
            UpdateOption<BrowserTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(List<BrowserType> ls,
            DeleteOption<BrowserTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchDeleteNonstrict(List<BrowserType> ls,
            DeleteOption<BrowserTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(BrowserType e, BrowserTypeCB inCB,
            ConditionBean resCB, InsertOption<BrowserTypeCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(BrowserType e, BrowserTypeCB cb,
            UpdateOption<BrowserTypeCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(BrowserTypeCB cb,
            DeleteOption<BrowserTypeCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected BrowserType downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, BrowserType.class);
    }

    protected BrowserTypeCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, BrowserTypeCB.class);
    }
}
