/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.RoleTypeDbm;
import jp.sf.fess.db.cbean.DataConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.LabelTypeToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.RoleTypeCB;
import jp.sf.fess.db.cbean.WebConfigToRoleTypeMappingCB;
import jp.sf.fess.db.exbhv.DataConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exbhv.LabelTypeToRoleTypeMappingBhv;
import jp.sf.fess.db.exbhv.RoleTypeBhv;
import jp.sf.fess.db.exbhv.WebConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exentity.DataConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.LabelTypeToRoleTypeMapping;
import jp.sf.fess.db.exentity.RoleType;
import jp.sf.fess.db.exentity.WebConfigToRoleTypeMapping;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of ROLE_TYPE as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     DATA_CONFIG_TO_ROLE_TYPE_MAPPING, FILE_CONFIG_TO_ROLE_TYPE_MAPPING, LABEL_TYPE_TO_ROLE_TYPE_MAPPING, WEB_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     dataConfigToRoleTypeMappingList, fileConfigToRoleTypeMappingList, labelTypeToRoleTypeMappingList, webConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsRoleTypeBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "ROLE_TYPE";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return RoleTypeDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public RoleTypeDbm getMyDBMeta() {
        return RoleTypeDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public RoleType newMyEntity() {
        return new RoleType();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public RoleTypeCB newMyConditionBean() {
        return new RoleTypeCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * int count = roleTypeBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of RoleType. (NotNull)
     * @return The selected count.
     */
    public int selectCount(RoleTypeCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(RoleTypeCB cb) { // called by selectCount(cb) 
        assertCBNotNull(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(RoleTypeCB cb) { // called by selectPage(cb)
        assertCBNotNull(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * roleTypeBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;RoleType&gt;() {
     *     public void handle(RoleType entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of RoleType. (NotNull)
     * @param entityRowHandler The handler of entity row of RoleType. (NotNull)
     */
    public void selectCursor(RoleTypeCB cb,
            EntityRowHandler<RoleType> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, RoleType.class);
    }

    protected <ENTITY extends RoleType> void doSelectCursor(RoleTypeCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<RoleType>", entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * RoleType roleType = roleTypeBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (roleType != null) {
     *     ... = roleType.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of RoleType. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public RoleType selectEntity(RoleTypeCB cb) {
        return doSelectEntity(cb, RoleType.class);
    }

    protected <ENTITY extends RoleType> ENTITY doSelectEntity(
            final RoleTypeCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, RoleTypeCB>() {
                    public List<ENTITY> callbackSelectList(RoleTypeCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * RoleType roleType = roleTypeBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = roleType.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of RoleType. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public RoleType selectEntityWithDeletedCheck(RoleTypeCB cb) {
        return doSelectEntityWithDeletedCheck(cb, RoleType.class);
    }

    protected <ENTITY extends RoleType> ENTITY doSelectEntityWithDeletedCheck(
            final RoleTypeCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, RoleTypeCB>() {
                    public List<ENTITY> callbackSelectList(RoleTypeCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public RoleType selectByPKValue(Long id) {
        return doSelectByPKValue(id, RoleType.class);
    }

    protected <ENTITY extends RoleType> ENTITY doSelectByPKValue(Long id,
            Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public RoleType selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, RoleType.class);
    }

    protected <ENTITY extends RoleType> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private RoleTypeCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        RoleTypeCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;RoleType&gt; roleTypeList = roleTypeBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (RoleType roleType : roleTypeList) {
     *     ... = roleType.get...();
     * }
     * </pre>
     * @param cb The condition-bean of RoleType. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<RoleType> selectList(RoleTypeCB cb) {
        return doSelectList(cb, RoleType.class);
    }

    protected <ENTITY extends RoleType> ListResultBean<ENTITY> doSelectList(
            RoleTypeCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, RoleTypeCB>() {
                    public List<ENTITY> callbackSelectList(RoleTypeCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;RoleType&gt; page = roleTypeBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (RoleType roleType : page) {
     *     ... = roleType.get...();
     * }
     * </pre>
     * @param cb The condition-bean of RoleType. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<RoleType> selectPage(RoleTypeCB cb) {
        return doSelectPage(cb, RoleType.class);
    }

    protected <ENTITY extends RoleType> PagingResultBean<ENTITY> doSelectPage(
            RoleTypeCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, RoleTypeCB>() {
                    public int callbackSelectCount(RoleTypeCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    public List<ENTITY> callbackSelectList(RoleTypeCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * roleTypeBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(RoleTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<RoleTypeCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends RoleTypeCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            RoleType roleType,
            ConditionBeanSetupper<DataConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleType, conditionBeanSetupper);
        loadDataConfigToRoleTypeMappingList(xnewLRLs(roleType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToRoleTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * roleTypeBhv.<span style="color: #FD4747">loadDataConfigToRoleTypeMappingList</span>(roleTypeList, new ConditionBeanSetupper&lt;DataConfigToRoleTypeMappingCB&gt;() {
     *     public void setup(DataConfigToRoleTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (RoleType roleType : roleTypeList) {
     *     ... = roleType.<span style="color: #FD4747">getDataConfigToRoleTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setRoleTypeId_InScope(pkList);
     * cb.query().addOrderBy_RoleTypeId_Asc();
     * </pre>
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            ConditionBeanSetupper<DataConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleTypeList, conditionBeanSetupper);
        loadDataConfigToRoleTypeMappingList(
                roleTypeList,
                new LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            RoleType roleType,
            LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleType, loadReferrerOption);
        loadDataConfigToRoleTypeMappingList(xnewLRLs(roleType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleTypeList, loadReferrerOption);
        if (roleTypeList.isEmpty()) {
            return;
        }
        final DataConfigToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                DataConfigToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                roleTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<RoleType, Long, DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping>() {
                    public Long getPKVal(RoleType e) {
                        return e.getId();
                    }

                    public void setRfLs(RoleType e,
                            List<DataConfigToRoleTypeMapping> ls) {
                        e.setDataConfigToRoleTypeMappingList(ls);
                    }

                    public DataConfigToRoleTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(DataConfigToRoleTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setRoleTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(DataConfigToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_RoleTypeId_Asc();
                    }

                    public void spFKCol(DataConfigToRoleTypeMappingCB cb) {
                        cb.specify().columnRoleTypeId();
                    }

                    public List<DataConfigToRoleTypeMapping> selRfLs(
                            DataConfigToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(DataConfigToRoleTypeMapping e) {
                        return e.getRoleTypeId();
                    }

                    public void setlcEt(DataConfigToRoleTypeMapping re,
                            RoleType le) {
                        re.setRoleType(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            RoleType roleType,
            ConditionBeanSetupper<FileConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleType, conditionBeanSetupper);
        loadFileConfigToRoleTypeMappingList(xnewLRLs(roleType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of fileConfigToRoleTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * roleTypeBhv.<span style="color: #FD4747">loadFileConfigToRoleTypeMappingList</span>(roleTypeList, new ConditionBeanSetupper&lt;FileConfigToRoleTypeMappingCB&gt;() {
     *     public void setup(FileConfigToRoleTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (RoleType roleType : roleTypeList) {
     *     ... = roleType.<span style="color: #FD4747">getFileConfigToRoleTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setRoleTypeId_InScope(pkList);
     * cb.query().addOrderBy_RoleTypeId_Asc();
     * </pre>
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            ConditionBeanSetupper<FileConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleTypeList, conditionBeanSetupper);
        loadFileConfigToRoleTypeMappingList(
                roleTypeList,
                new LoadReferrerOption<FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            RoleType roleType,
            LoadReferrerOption<FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleType, loadReferrerOption);
        loadFileConfigToRoleTypeMappingList(xnewLRLs(roleType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            LoadReferrerOption<FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleTypeList, loadReferrerOption);
        if (roleTypeList.isEmpty()) {
            return;
        }
        final FileConfigToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                FileConfigToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                roleTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<RoleType, Long, FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping>() {
                    public Long getPKVal(RoleType e) {
                        return e.getId();
                    }

                    public void setRfLs(RoleType e,
                            List<FileConfigToRoleTypeMapping> ls) {
                        e.setFileConfigToRoleTypeMappingList(ls);
                    }

                    public FileConfigToRoleTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(FileConfigToRoleTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setRoleTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(FileConfigToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_RoleTypeId_Asc();
                    }

                    public void spFKCol(FileConfigToRoleTypeMappingCB cb) {
                        cb.specify().columnRoleTypeId();
                    }

                    public List<FileConfigToRoleTypeMapping> selRfLs(
                            FileConfigToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(FileConfigToRoleTypeMapping e) {
                        return e.getRoleTypeId();
                    }

                    public void setlcEt(FileConfigToRoleTypeMapping re,
                            RoleType le) {
                        re.setRoleType(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadLabelTypeToRoleTypeMappingList(
            RoleType roleType,
            ConditionBeanSetupper<LabelTypeToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleType, conditionBeanSetupper);
        loadLabelTypeToRoleTypeMappingList(xnewLRLs(roleType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of labelTypeToRoleTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * roleTypeBhv.<span style="color: #FD4747">loadLabelTypeToRoleTypeMappingList</span>(roleTypeList, new ConditionBeanSetupper&lt;LabelTypeToRoleTypeMappingCB&gt;() {
     *     public void setup(LabelTypeToRoleTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (RoleType roleType : roleTypeList) {
     *     ... = roleType.<span style="color: #FD4747">getLabelTypeToRoleTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setRoleTypeId_InScope(pkList);
     * cb.query().addOrderBy_RoleTypeId_Asc();
     * </pre>
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadLabelTypeToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            ConditionBeanSetupper<LabelTypeToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleTypeList, conditionBeanSetupper);
        loadLabelTypeToRoleTypeMappingList(
                roleTypeList,
                new LoadReferrerOption<LabelTypeToRoleTypeMappingCB, LabelTypeToRoleTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadLabelTypeToRoleTypeMappingList(
            RoleType roleType,
            LoadReferrerOption<LabelTypeToRoleTypeMappingCB, LabelTypeToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleType, loadReferrerOption);
        loadLabelTypeToRoleTypeMappingList(xnewLRLs(roleType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadLabelTypeToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            LoadReferrerOption<LabelTypeToRoleTypeMappingCB, LabelTypeToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleTypeList, loadReferrerOption);
        if (roleTypeList.isEmpty()) {
            return;
        }
        final LabelTypeToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                LabelTypeToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                roleTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<RoleType, Long, LabelTypeToRoleTypeMappingCB, LabelTypeToRoleTypeMapping>() {
                    public Long getPKVal(RoleType e) {
                        return e.getId();
                    }

                    public void setRfLs(RoleType e,
                            List<LabelTypeToRoleTypeMapping> ls) {
                        e.setLabelTypeToRoleTypeMappingList(ls);
                    }

                    public LabelTypeToRoleTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(LabelTypeToRoleTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setRoleTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(LabelTypeToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_RoleTypeId_Asc();
                    }

                    public void spFKCol(LabelTypeToRoleTypeMappingCB cb) {
                        cb.specify().columnRoleTypeId();
                    }

                    public List<LabelTypeToRoleTypeMapping> selRfLs(
                            LabelTypeToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(LabelTypeToRoleTypeMapping e) {
                        return e.getRoleTypeId();
                    }

                    public void setlcEt(LabelTypeToRoleTypeMapping re,
                            RoleType le) {
                        re.setRoleType(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            RoleType roleType,
            ConditionBeanSetupper<WebConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleType, conditionBeanSetupper);
        loadWebConfigToRoleTypeMappingList(xnewLRLs(roleType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToRoleTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * roleTypeBhv.<span style="color: #FD4747">loadWebConfigToRoleTypeMappingList</span>(roleTypeList, new ConditionBeanSetupper&lt;WebConfigToRoleTypeMappingCB&gt;() {
     *     public void setup(WebConfigToRoleTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (RoleType roleType : roleTypeList) {
     *     ... = roleType.<span style="color: #FD4747">getWebConfigToRoleTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setRoleTypeId_InScope(pkList);
     * cb.query().addOrderBy_RoleTypeId_Asc();
     * </pre>
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            ConditionBeanSetupper<WebConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleTypeList, conditionBeanSetupper);
        loadWebConfigToRoleTypeMappingList(
                roleTypeList,
                new LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            RoleType roleType,
            LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleType, loadReferrerOption);
        loadWebConfigToRoleTypeMappingList(xnewLRLs(roleType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleTypeList, loadReferrerOption);
        if (roleTypeList.isEmpty()) {
            return;
        }
        final WebConfigToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                WebConfigToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                roleTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<RoleType, Long, WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping>() {
                    public Long getPKVal(RoleType e) {
                        return e.getId();
                    }

                    public void setRfLs(RoleType e,
                            List<WebConfigToRoleTypeMapping> ls) {
                        e.setWebConfigToRoleTypeMappingList(ls);
                    }

                    public WebConfigToRoleTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(WebConfigToRoleTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setRoleTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(WebConfigToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_RoleTypeId_Asc();
                    }

                    public void spFKCol(WebConfigToRoleTypeMappingCB cb) {
                        cb.specify().columnRoleTypeId();
                    }

                    public List<WebConfigToRoleTypeMapping> selRfLs(
                            WebConfigToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(WebConfigToRoleTypeMapping e) {
                        return e.getRoleTypeId();
                    }

                    public void setlcEt(WebConfigToRoleTypeMapping re,
                            RoleType le) {
                        re.setRoleType(le);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * RoleType roleType = new RoleType();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * roleType.setFoo...(value);
     * roleType.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//roleType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//roleType.set...;</span>
     * roleTypeBhv.<span style="color: #FD4747">insert</span>(roleType);
     * ... = roleType.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param roleType The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(RoleType roleType) {
        doInsert(roleType, null);
    }

    protected void doInsert(RoleType roleType, InsertOption<RoleTypeCB> option) {
        assertObjectNotNull("roleType", roleType);
        prepareInsertOption(option);
        delegateInsert(roleType, option);
    }

    protected void prepareInsertOption(InsertOption<RoleTypeCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreate(Entity entity,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), (InsertOption) option);
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * roleType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * roleType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//roleType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//roleType.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * roleType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     roleTypeBhv.<span style="color: #FD4747">update</span>(roleType);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param roleType The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final RoleType roleType) {
        doUpdate(roleType, null);
    }

    protected void doUpdate(RoleType roleType,
            final UpdateOption<RoleTypeCB> option) {
        assertObjectNotNull("roleType", roleType);
        prepareUpdateOption(option);
        helpUpdateInternally(roleType, new InternalUpdateCallback<RoleType>() {
            public int callbackDelegateUpdate(RoleType entity) {
                return delegateUpdate(entity, option);
            }
        });
    }

    protected void prepareUpdateOption(UpdateOption<RoleTypeCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected RoleTypeCB createCBForVaryingUpdate() {
        RoleTypeCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected RoleTypeCB createCBForSpecifiedUpdate() {
        RoleTypeCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModify(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * roleType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * roleType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//roleType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//roleType.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//roleType.setVersionNo(value);</span>
     * roleTypeBhv.<span style="color: #FD4747">updateNonstrict</span>(roleType);
     * </pre>
     * @param roleType The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final RoleType roleType) {
        doUpdateNonstrict(roleType, null);
    }

    protected void doUpdateNonstrict(RoleType roleType,
            final UpdateOption<RoleTypeCB> option) {
        assertObjectNotNull("roleType", roleType);
        prepareUpdateOption(option);
        helpUpdateNonstrictInternally(roleType,
                new InternalUpdateNonstrictCallback<RoleType>() {
                    public int callbackDelegateUpdateNonstrict(RoleType entity) {
                        return delegateUpdateNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModifyNonstrict(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            updateNonstrict(downcast(entity));
        } else {
            varyingUpdateNonstrict(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param roleType The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(RoleType roleType) {
        doInesrtOrUpdate(roleType, null, null);
    }

    protected void doInesrtOrUpdate(RoleType roleType,
            final InsertOption<RoleTypeCB> insertOption,
            final UpdateOption<RoleTypeCB> updateOption) {
        helpInsertOrUpdateInternally(roleType,
                new InternalInsertOrUpdateCallback<RoleType, RoleTypeCB>() {
                    public void callbackInsert(RoleType entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdate(RoleType entity) {
                        doUpdate(entity, updateOption);
                    }

                    public RoleTypeCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(RoleTypeCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModify(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param roleType The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(RoleType roleType) {
        doInesrtOrUpdateNonstrict(roleType, null, null);
    }

    protected void doInesrtOrUpdateNonstrict(RoleType roleType,
            final InsertOption<RoleTypeCB> insertOption,
            final UpdateOption<RoleTypeCB> updateOption) {
        helpInsertOrUpdateInternally(roleType,
                new InternalInsertOrUpdateNonstrictCallback<RoleType>() {
                    public void callbackInsert(RoleType entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdateNonstrict(RoleType entity) {
                        doUpdateNonstrict(entity, updateOption);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModifyNonstrict(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdateNonstrict(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdateNonstrict(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * roleType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * roleType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     roleTypeBhv.<span style="color: #FD4747">delete</span>(roleType);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param roleType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(RoleType roleType) {
        doDelete(roleType, null);
    }

    protected void doDelete(RoleType roleType,
            final DeleteOption<RoleTypeCB> option) {
        assertObjectNotNull("roleType", roleType);
        prepareDeleteOption(option);
        helpDeleteInternally(roleType, new InternalDeleteCallback<RoleType>() {
            public int callbackDelegateDelete(RoleType entity) {
                return delegateDelete(entity, option);
            }
        });
    }

    protected void prepareDeleteOption(DeleteOption<RoleTypeCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemove(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), (DeleteOption) option);
        }
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * roleType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//roleType.setVersionNo(value);</span>
     * roleTypeBhv.<span style="color: #FD4747">deleteNonstrict</span>(roleType);
     * </pre>
     * @param roleType The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(RoleType roleType) {
        doDeleteNonstrict(roleType, null);
    }

    protected void doDeleteNonstrict(RoleType roleType,
            final DeleteOption<RoleTypeCB> option) {
        assertObjectNotNull("roleType", roleType);
        prepareDeleteOption(option);
        helpDeleteNonstrictInternally(roleType,
                new InternalDeleteNonstrictCallback<RoleType>() {
                    public int callbackDelegateDeleteNonstrict(RoleType entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * roleType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//roleType.setVersionNo(value);</span>
     * roleTypeBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(roleType);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param roleType The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(RoleType roleType) {
        doDeleteNonstrictIgnoreDeleted(roleType, null);
    }

    protected void doDeleteNonstrictIgnoreDeleted(RoleType roleType,
            final DeleteOption<RoleTypeCB> option) {
        assertObjectNotNull("roleType", roleType);
        prepareDeleteOption(option);
        helpDeleteNonstrictIgnoreDeletedInternally(roleType,
                new InternalDeleteNonstrictIgnoreDeletedCallback<RoleType>() {
                    public int callbackDelegateDeleteNonstrict(RoleType entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemoveNonstrict(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            deleteNonstrict(downcast(entity));
        } else {
            varyingDeleteNonstrict(downcast(entity), (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param roleTypeList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<RoleType> roleTypeList) {
        return doBatchInsert(roleTypeList, null);
    }

    protected int[] doBatchInsert(List<RoleType> roleTypeList,
            InsertOption<RoleTypeCB> option) {
        assertObjectNotNull("roleTypeList", roleTypeList);
        prepareInsertOption(option);
        return delegateBatchInsert(roleTypeList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpCreate(List<Entity> ls,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert((List) ls);
        } else {
            return varyingBatchInsert((List) ls, (InsertOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param roleTypeList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<RoleType> roleTypeList) {
        return doBatchUpdate(roleTypeList, null);
    }

    protected int[] doBatchUpdate(List<RoleType> roleTypeList,
            UpdateOption<RoleTypeCB> option) {
        assertObjectNotNull("roleTypeList", roleTypeList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(roleTypeList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModify(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate((List) ls);
        } else {
            return varyingBatchUpdate((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param roleTypeList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<RoleType> roleTypeList,
            SpecifyQuery<RoleTypeCB> updateColumnSpec) {
        return doBatchUpdate(roleTypeList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param roleTypeList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(List<RoleType> roleTypeList) {
        return doBatchUpdateNonstrict(roleTypeList, null);
    }

    protected int[] doBatchUpdateNonstrict(List<RoleType> roleTypeList,
            UpdateOption<RoleTypeCB> option) {
        assertObjectNotNull("roleTypeList", roleTypeList);
        prepareUpdateOption(option);
        return delegateBatchUpdateNonstrict(roleTypeList, option);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param roleTypeList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(List<RoleType> roleTypeList,
            SpecifyQuery<RoleTypeCB> updateColumnSpec) {
        return doBatchUpdateNonstrict(roleTypeList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModifyNonstrict(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdateNonstrict((List) ls);
        } else {
            return varyingBatchUpdateNonstrict((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param roleTypeList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<RoleType> roleTypeList) {
        return doBatchDelete(roleTypeList, null);
    }

    protected int[] doBatchDelete(List<RoleType> roleTypeList,
            DeleteOption<RoleTypeCB> option) {
        assertObjectNotNull("roleTypeList", roleTypeList);
        prepareDeleteOption(option);
        return delegateBatchDelete(roleTypeList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemove(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete((List) ls);
        } else {
            return varyingBatchDelete((List) ls, (DeleteOption) option);
        }
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param roleTypeList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(List<RoleType> roleTypeList) {
        return doBatchDeleteNonstrict(roleTypeList, null);
    }

    protected int[] doBatchDeleteNonstrict(List<RoleType> roleTypeList,
            DeleteOption<RoleTypeCB> option) {
        assertObjectNotNull("roleTypeList", roleTypeList);
        prepareDeleteOption(option);
        return delegateBatchDeleteNonstrict(roleTypeList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemoveNonstrict(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDeleteNonstrict((List) ls);
        } else {
            return varyingBatchDeleteNonstrict((List) ls, (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * roleTypeBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;roleType, RoleTypeCB&gt;() {
     *     public ConditionBean setup(roleType entity, RoleTypeCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(QueryInsertSetupper<RoleType, RoleTypeCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            QueryInsertSetupper<RoleType, RoleTypeCB> setupper,
            InsertOption<RoleTypeCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        RoleType entity = new RoleType();
        RoleTypeCB intoCB = createCBForQueryInsert();
        ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected RoleTypeCB createCBForQueryInsert() {
        RoleTypeCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeCreate(
            QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert((QueryInsertSetupper) setupper);
        } else {
            return varyingQueryInsert((QueryInsertSetupper) setupper,
                    (InsertOption) option);
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//roleType.setPK...(value);</span>
     * roleType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//roleType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//roleType.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//roleType.setVersionNo(value);</span>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * roleTypeBhv.<span style="color: #FD4747">queryUpdate</span>(roleType, cb);
     * </pre>
     * @param roleType The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of RoleType. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(RoleType roleType, RoleTypeCB cb) {
        return doQueryUpdate(roleType, cb, null);
    }

    protected int doQueryUpdate(RoleType roleType, RoleTypeCB cb,
            UpdateOption<RoleTypeCB> option) {
        assertObjectNotNull("roleType", roleType);
        assertCBNotNull(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(roleType, cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeModify(Entity entity, ConditionBean cb,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity), (RoleTypeCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity), (RoleTypeCB) cb,
                    (UpdateOption) option);
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * roleTypeBhv.<span style="color: #FD4747">queryDelete</span>(roleType, cb);
     * </pre>
     * @param cb The condition-bean of RoleType. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(RoleTypeCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(RoleTypeCB cb, DeleteOption<RoleTypeCB> option) {
        assertCBNotNull(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeRemove(ConditionBean cb,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((RoleTypeCB) cb);
        } else {
            return varyingQueryDelete((RoleTypeCB) cb, (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * RoleType roleType = new RoleType();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * roleType.setFoo...(value);
     * roleType.setBar...(value);
     * InsertOption<RoleTypeCB> option = new InsertOption<RoleTypeCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * roleTypeBhv.<span style="color: #FD4747">varyingInsert</span>(roleType, option);
     * ... = roleType.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param roleType The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(RoleType roleType, InsertOption<RoleTypeCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(roleType, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * RoleType roleType = new RoleType();
     * roleType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * roleType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * roleType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;RoleTypeCB&gt; option = new UpdateOption&lt;RoleTypeCB&gt;();
     *     option.self(new SpecifyQuery&lt;RoleTypeCB&gt;() {
     *         public void specify(RoleTypeCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     roleTypeBhv.<span style="color: #FD4747">varyingUpdate</span>(roleType, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param roleType The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(RoleType roleType, UpdateOption<RoleTypeCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(roleType, option);
    }

    /**
     * Update the entity with varying requests non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as updateNonstrict(entity).
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * RoleType roleType = new RoleType();
     * roleType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * roleType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//roleType.setVersionNo(value);</span>
     * UpdateOption&lt;RoleTypeCB&gt; option = new UpdateOption&lt;RoleTypeCB&gt;();
     * option.self(new SpecifyQuery&lt;RoleTypeCB&gt;() {
     *     public void specify(RoleTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * roleTypeBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(roleType, option);
     * </pre>
     * @param roleType The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(RoleType roleType,
            UpdateOption<RoleTypeCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdateNonstrict(roleType, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param roleType The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(RoleType roleType,
            InsertOption<RoleTypeCB> insertOption,
            UpdateOption<RoleTypeCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(roleType, insertOption, updateOption);
    }

    /**
     * Insert or update the entity with varying requests non-strictly. {NonExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdateNonstrict(entity).
     * @param roleType The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdateNonstrict(RoleType roleType,
            InsertOption<RoleTypeCB> insertOption,
            UpdateOption<RoleTypeCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdateNonstrict(roleType, insertOption, updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param roleType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(RoleType roleType, DeleteOption<RoleTypeCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(roleType, option);
    }

    /**
     * Delete the entity with varying requests non-strictly. {UpdateCountZeroException, NonExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as deleteNonstrict(entity).
     * @param roleType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDeleteNonstrict(RoleType roleType,
            DeleteOption<RoleTypeCB> option) {
        assertDeleteOptionNotNull(option);
        doDeleteNonstrict(roleType, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param roleTypeList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(List<RoleType> roleTypeList,
            InsertOption<RoleTypeCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(roleTypeList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param roleTypeList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(List<RoleType> roleTypeList,
            UpdateOption<RoleTypeCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(roleTypeList, option);
    }

    /**
     * Batch-update the list with varying requests non-strictly. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param roleTypeList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdateNonstrict(List<RoleType> roleTypeList,
            UpdateOption<RoleTypeCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdateNonstrict(roleTypeList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param roleTypeList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(List<RoleType> roleTypeList,
            DeleteOption<RoleTypeCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(roleTypeList, option);
    }

    /**
     * Batch-delete the list with varying requests non-strictly. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDeleteNonstrict(entityList).
     * @param roleTypeList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDeleteNonstrict(List<RoleType> roleTypeList,
            DeleteOption<RoleTypeCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDeleteNonstrict(roleTypeList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            QueryInsertSetupper<RoleType, RoleTypeCB> setupper,
            InsertOption<RoleTypeCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * RoleType roleType = new RoleType();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//roleType.setPK...(value);</span>
     * roleType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//roleType.setVersionNo(value);</span>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;RoleTypeCB&gt; option = new UpdateOption&lt;RoleTypeCB&gt;();
     * option.self(new SpecifyQuery&lt;RoleTypeCB&gt;() {
     *     public void specify(RoleTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * roleTypeBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(roleType, cb, option);
     * </pre>
     * @param roleType The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of RoleType. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(RoleType roleType, RoleTypeCB cb,
            UpdateOption<RoleTypeCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(roleType, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of RoleType. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(RoleTypeCB cb, DeleteOption<RoleTypeCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<RoleTypeBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(RoleTypeCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(RoleTypeCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends RoleType> void delegateSelectCursor(
            RoleTypeCB cb, EntityRowHandler<ENTITY> erh, Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends RoleType> List<ENTITY> delegateSelectList(
            RoleTypeCB cb, Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(RoleType e, InsertOption<RoleTypeCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(RoleType e, UpdateOption<RoleTypeCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateEntityCommand(e, op));
    }

    protected int delegateUpdateNonstrict(RoleType e,
            UpdateOption<RoleTypeCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(RoleType e, DeleteOption<RoleTypeCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteEntityCommand(e, op));
    }

    protected int delegateDeleteNonstrict(RoleType e,
            DeleteOption<RoleTypeCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(List<RoleType> ls,
            InsertOption<RoleTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(List<RoleType> ls,
            UpdateOption<RoleTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchUpdateNonstrict(List<RoleType> ls,
            UpdateOption<RoleTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(List<RoleType> ls,
            DeleteOption<RoleTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchDeleteNonstrict(List<RoleType> ls,
            DeleteOption<RoleTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(RoleType e, RoleTypeCB inCB,
            ConditionBean resCB, InsertOption<RoleTypeCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(RoleType e, RoleTypeCB cb,
            UpdateOption<RoleTypeCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(RoleTypeCB cb, DeleteOption<RoleTypeCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected RoleType downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, RoleType.class);
    }

    protected RoleTypeCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, RoleTypeCB.class);
    }
}
