/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.service;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.sf.fess.crud.service.BsBrowserTypeService;
import jp.sf.fess.db.cbean.BrowserTypeCB;
import jp.sf.fess.db.exentity.BrowserType;
import jp.sf.fess.pager.BrowserTypePager;

public class BrowserTypeService extends BsBrowserTypeService implements
        Serializable {

    private static final long serialVersionUID = 1L;

    protected void setupListCondition(BrowserTypeCB cb,
            BrowserTypePager browserTypePager) {
        super.setupListCondition(cb, browserTypePager);

        // setup condition
        cb.query().setDeletedBy_IsNull();
        cb.query().addOrderBy_SortOrder_Asc();
        cb.query().addOrderBy_Name_Asc();
        // search

    }

    protected void setupEntityCondition(BrowserTypeCB cb,
            Map<String, String> keys) {
        super.setupEntityCondition(cb, keys);

        // setup condition
        cb.query().setDeletedBy_IsNull();

    }

    protected void setupStoreCondition(BrowserType browserType) {
        super.setupStoreCondition(browserType);

        // setup condition

    }

    protected void setupDeleteCondition(BrowserType browserType) {
        super.setupDeleteCondition(browserType);

        // setup condition

    }

    public List<BrowserType> getBrowserTypeList() {
        BrowserTypeCB cb = new BrowserTypeCB();
        cb.query().setDeletedBy_IsNull();
        cb.query().addOrderBy_SortOrder_Asc();
        cb.query().addOrderBy_Name_Asc();
        return browserTypeBhv.selectList(cb);
    }

}
