/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.exentity.LabelType;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ReferrerInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.dbmeta.name.TableSqlName;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of LABEL_TYPE. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class LabelTypeDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final LabelTypeDbm _instance = new LabelTypeDbm();

    private LabelTypeDbm() {
    }

    public static LabelTypeDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    public DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    protected final String _tableDbName = "LABEL_TYPE";

    protected final String _tablePropertyName = "labelType";

    protected final TableSqlName _tableSqlName = new TableSqlName("LABEL_TYPE",
            _tableDbName);
    {
        _tableSqlName.xacceptFilter(DBFluteConfig.getInstance()
                .getTableSqlNameFilter());
    }

    @Override
    public String getTableDbName() {
        return _tableDbName;
    }

    @Override
    public String getTablePropertyName() {
        return _tablePropertyName;
    }

    @Override
    public TableSqlName getTableSqlName() {
        return _tableSqlName;
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected final ColumnInfo _columnId = cci(
            "ID",
            "ID",
            null,
            null,
            true,
            "id",
            Long.class,
            true,
            true,
            "BIGINT",
            19,
            0,
            false,
            null,
            null,
            null,
            "dataConfigToLabelTypeMappingList,fileConfigToLabelTypeMappingList,labelTypeToRoleTypeMappingList,webConfigToLabelTypeMappingList",
            null);

    protected final ColumnInfo _columnName = cci("NAME", "NAME", null, null,
            true, "name", String.class, false, false, "VARCHAR", 100, 0, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnValue = cci("VALUE", "VALUE", null, null,
            true, "value", String.class, false, false, "VARCHAR", 20, 0, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnSortOrder = cci("SORT_ORDER",
            "SORT_ORDER", null, null, true, "sortOrder", Integer.class, false,
            false, "INTEGER", 10, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnCreatedBy = cci("CREATED_BY",
            "CREATED_BY", null, null, true, "createdBy", String.class, false,
            false, "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnCreatedTime = cci("CREATED_TIME",
            "CREATED_TIME", null, null, true, "createdTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnUpdatedBy = cci("UPDATED_BY",
            "UPDATED_BY", null, null, false, "updatedBy", String.class, false,
            false, "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnUpdatedTime = cci("UPDATED_TIME",
            "UPDATED_TIME", null, null, false, "updatedTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnDeletedBy = cci("DELETED_BY",
            "DELETED_BY", null, null, false, "deletedBy", String.class, false,
            false, "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnDeletedTime = cci("DELETED_TIME",
            "DELETED_TIME", null, null, false, "deletedTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnVersionNo = cci("VERSION_NO",
            "VERSION_NO", null, null, true, "versionNo", Integer.class, false,
            false, "INTEGER", 10, 0, false, OptimisticLockType.VERSION_NO,
            null, null, null, null);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnName() {
        return _columnName;
    }

    public ColumnInfo columnValue() {
        return _columnValue;
    }

    public ColumnInfo columnSortOrder() {
        return _columnSortOrder;
    }

    public ColumnInfo columnCreatedBy() {
        return _columnCreatedBy;
    }

    public ColumnInfo columnCreatedTime() {
        return _columnCreatedTime;
    }

    public ColumnInfo columnUpdatedBy() {
        return _columnUpdatedBy;
    }

    public ColumnInfo columnUpdatedTime() {
        return _columnUpdatedTime;
    }

    public ColumnInfo columnDeletedBy() {
        return _columnDeletedBy;
    }

    public ColumnInfo columnDeletedTime() {
        return _columnDeletedTime;
    }

    public ColumnInfo columnVersionNo() {
        return _columnVersionNo;
    }

    @Override
    protected List<ColumnInfo> ccil() {
        final List<ColumnInfo> ls = newArrayList();
        ls.add(columnId());
        ls.add(columnName());
        ls.add(columnValue());
        ls.add(columnSortOrder());
        ls.add(columnCreatedBy());
        ls.add(columnCreatedTime());
        ls.add(columnUpdatedBy());
        ls.add(columnUpdatedTime());
        ls.add(columnDeletedBy());
        ls.add(columnDeletedTime());
        ls.add(columnVersionNo());
        return ls;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    @Override
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    @Override
    public boolean hasPrimaryKey() {
        return true;
    }

    @Override
    public boolean hasCompoundPrimaryKey() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------
    public ReferrerInfo referrerDataConfigToLabelTypeMappingList() {
        final Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                DataConfigToLabelTypeMappingDbm.getInstance()
                        .columnLabelTypeId());
        return cri("dataConfigToLabelTypeMappingList", this,
                DataConfigToLabelTypeMappingDbm.getInstance(), map, false);
    }

    public ReferrerInfo referrerFileConfigToLabelTypeMappingList() {
        final Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                FileConfigToLabelTypeMappingDbm.getInstance()
                        .columnLabelTypeId());
        return cri("fileConfigToLabelTypeMappingList", this,
                FileConfigToLabelTypeMappingDbm.getInstance(), map, false);
    }

    public ReferrerInfo referrerLabelTypeToRoleTypeMappingList() {
        final Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                LabelTypeToRoleTypeMappingDbm.getInstance().columnLabelTypeId());
        return cri("labelTypeToRoleTypeMappingList", this,
                LabelTypeToRoleTypeMappingDbm.getInstance(), map, false);
    }

    public ReferrerInfo referrerWebConfigToLabelTypeMappingList() {
        final Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                WebConfigToLabelTypeMappingDbm.getInstance()
                        .columnLabelTypeId());
        return cri("webConfigToLabelTypeMappingList", this,
                WebConfigToLabelTypeMappingDbm.getInstance(), map, false);
    }

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    @Override
    public boolean hasIdentity() {
        return true;
    }

    @Override
    public boolean hasVersionNo() {
        return true;
    }

    @Override
    public ColumnInfo getVersionNoColumnInfo() {
        return _columnVersionNo;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    @Override
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.LabelType";
    }

    @Override
    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.LabelTypeCB";
    }

    @Override
    public String getDaoTypeName() {
        return "${glPackageExtendedDao}.LabelTypeDao";
    }

    @Override
    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.LabelTypeBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    @Override
    public Class<LabelType> getEntityType() {
        return LabelType.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    @Override
    public Entity newEntity() {
        return newMyEntity();
    }

    public LabelType newMyEntity() {
        return new LabelType();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    @Override
    public void acceptPrimaryKeyMap(final Entity e,
            final Map<String, ? extends Object> m) {
        doAcceptPrimaryKeyMap((LabelType) e, m, _epsMap);
    }

    @Override
    public Map<String, Object> extractPrimaryKeyMap(final Entity e) {
        return doExtractPrimaryKeyMap(e);
    }

    @Override
    public Map<String, Object> extractAllColumnMap(final Entity e) {
        return doExtractAllColumnMap(e);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<LabelType>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsName(), columnName());
        setupEps(_epsMap, new EpsValue(), columnValue());
        setupEps(_epsMap, new EpsSortOrder(), columnSortOrder());
        setupEps(_epsMap, new EpsCreatedBy(), columnCreatedBy());
        setupEps(_epsMap, new EpsCreatedTime(), columnCreatedTime());
        setupEps(_epsMap, new EpsUpdatedBy(), columnUpdatedBy());
        setupEps(_epsMap, new EpsUpdatedTime(), columnUpdatedTime());
        setupEps(_epsMap, new EpsDeletedBy(), columnDeletedBy());
        setupEps(_epsMap, new EpsDeletedTime(), columnDeletedTime());
        setupEps(_epsMap, new EpsVersionNo(), columnVersionNo());
    }

    @Override
    public boolean hasEntityPropertySetupper(final String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    @Override
    public void setupEntityProperty(final String propertyName,
            final Object entity, final Object value) {
        findEps(_epsMap, propertyName).setup((LabelType) entity, value);
    }

    public class EpsId implements Eps<LabelType> {
        @Override
        public void setup(final LabelType e, final Object v) {
            e.setId(ctl(v));
        }
    }

    public static class EpsName implements Eps<LabelType> {
        @Override
        public void setup(final LabelType e, final Object v) {
            e.setName((String) v);
        }
    }

    public static class EpsValue implements Eps<LabelType> {
        @Override
        public void setup(final LabelType e, final Object v) {
            e.setValue((String) v);
        }
    }

    public class EpsSortOrder implements Eps<LabelType> {
        @Override
        public void setup(final LabelType e, final Object v) {
            e.setSortOrder(cti(v));
        }
    }

    public static class EpsCreatedBy implements Eps<LabelType> {
        @Override
        public void setup(final LabelType e, final Object v) {
            e.setCreatedBy((String) v);
        }
    }

    public static class EpsCreatedTime implements Eps<LabelType> {
        @Override
        public void setup(final LabelType e, final Object v) {
            e.setCreatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsUpdatedBy implements Eps<LabelType> {
        @Override
        public void setup(final LabelType e, final Object v) {
            e.setUpdatedBy((String) v);
        }
    }

    public static class EpsUpdatedTime implements Eps<LabelType> {
        @Override
        public void setup(final LabelType e, final Object v) {
            e.setUpdatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsDeletedBy implements Eps<LabelType> {
        @Override
        public void setup(final LabelType e, final Object v) {
            e.setDeletedBy((String) v);
        }
    }

    public static class EpsDeletedTime implements Eps<LabelType> {
        @Override
        public void setup(final LabelType e, final Object v) {
            e.setDeletedTime((java.sql.Timestamp) v);
        }
    }

    public class EpsVersionNo implements Eps<LabelType> {
        @Override
        public void setup(final LabelType e, final Object v) {
            e.setVersionNo(cti(v));
        }
    }
}
