DROP SEQUENCE WEB_CRAWLING_CONFIG_SEQ;
DROP SEQUENCE BROWSER_TYPE_SEQ;
DROP SEQUENCE FILE_CRAWLING_CONFIG_SEQ;
DROP SEQUENCE WEB_CONFIG_TO_B_TYPE_SEQ;
DROP SEQUENCE FILE_CONFIG_TO_B_TYPE_SEQ;
DROP SEQUENCE PATH_MAPPING_SEQ;
DROP SEQUENCE CRAWLING_SESSION_SEQ;
DROP SEQUENCE OVERLAPPING_HOST_SEQ;
DROP SEQUENCE REQUEST_HEADER_SEQ;
DROP SEQUENCE WEB_AUTHENTICATION_SEQ;
DROP SEQUENCE CRAWLING_SESSION_INFO_SEQ;
DROP SEQUENCE LABEL_TYPE_SEQ;
DROP SEQUENCE FILE_CONFIG_TO_LABEL_TYPE_SEQ;
DROP SEQUENCE WEB_CONFIG_TO_LABEL_TYPE_SEQ;
DROP SEQUENCE ROLE_TYPE_SEQ;
DROP SEQUENCE FILE_CONFIG_TO_ROLE_TYPE_SEQ;
DROP SEQUENCE WEB_CONFIG_TO_ROLE_TYPE_SEQ;
DROP SEQUENCE DATA_CRAWLING_CONFIG_SEQ;
DROP SEQUENCE DATA_CONFIG_TO_ROLE_TYPE_SEQ;
DROP SEQUENCE DATA_CONFIG_TO_LABEL_TYPE_SEQ;
DROP SEQUENCE DATA_CONFIG_TO_B_TYPE_SEQ;
DROP SEQUENCE SEARCH_LOG_SEQ;
DROP SEQUENCE LABEL_TYPE_TO_ROLE_TYPE_SEQ;
DROP SEQUENCE CLICK_LOG_SEQ;
DROP SEQUENCE FAILURE_URL_SEQ;
DROP SEQUENCE FILE_AUTHENTICATION_SEQ;

DROP TABLE "FILE_AUTHENTICATION";
DROP TABLE "FAILURE_URL";
DROP TABLE "CLICK_LOG";
DROP TABLE "LABEL_TYPE_TO_ROLE_TYPE";
DROP TABLE "SEARCH_LOG";
DROP TABLE "DATA_CONFIG_TO_B_TYPE";
DROP TABLE "DATA_CONFIG_TO_LABEL_TYPE";
DROP TABLE "DATA_CONFIG_TO_ROLE_TYPE";
DROP TABLE "DATA_CRAWLING_CONFIG";
DROP TABLE "WEB_CONFIG_TO_ROLE_TYPE";
DROP TABLE "FILE_CONFIG_TO_ROLE_TYPE";
DROP TABLE "ROLE_TYPE";
DROP TABLE "WEB_CONFIG_TO_LABEL_TYPE";
DROP TABLE "FILE_CONFIG_TO_LABEL_TYPE";
DROP TABLE "LABEL_TYPE";
DROP TABLE "CRAWLING_SESSION_INFO";
DROP TABLE "WEB_AUTHENTICATION";
DROP TABLE "REQUEST_HEADER";
DROP TABLE "OVERLAPPING_HOST";
DROP TABLE "CRAWLING_SESSION";
DROP TABLE "PATH_MAPPING";
DROP TABLE "FILE_CONFIG_TO_B_TYPE";
DROP TABLE "WEB_CONFIG_TO_B_TYPE";
DROP TABLE "FILE_CRAWLING_CONFIG";
DROP TABLE "BROWSER_TYPE";
DROP TABLE "WEB_CRAWLING_CONFIG";

CREATE TABLE "WEB_CRAWLING_CONFIG"(
  "ID" NUMBER(18,0) NOT NULL,
  "NAME" VARCHAR2(200) NOT NULL,
  "URLS" VARCHAR2(4000) NOT NULL,
  "INCLUDED_URLS" VARCHAR2(4000),
  "EXCLUDED_URLS" VARCHAR2(4000),
  "INCLUDED_DOC_URLS" VARCHAR2(4000),
  "EXCLUDED_DOC_URLS" VARCHAR2(4000),
  "DEPTH" NUMBER(7,0),
  "MAX_ACCESS_COUNT" NUMBER(18,0),
  "USER_AGENT" VARCHAR2(200) NOT NULL,
  "NUM_OF_THREAD" NUMBER(9,0) NOT NULL,
  "INTERVAL_TIME" NUMBER(9,0) NOT NULL,
  "BOOST" FLOAT NOT NULL,
  "AVAILABLE" VARCHAR2(1) NOT NULL,
  "SORT_ORDER" NUMBER(9,0) NOT NULL,
  "CREATED_BY" VARCHAR2(255) NOT NULL,
  "CREATED_TIME" TIMESTAMP NOT NULL,
  "UPDATED_BY" VARCHAR2(255),
  "UPDATED_TIME" TIMESTAMP,
  "DELETED_BY" VARCHAR2(255),
  "DELETED_TIME" TIMESTAMP,
  "VERSION_NO" NUMBER(9,0) NOT NULL,

  CONSTRAINT "WEB_CRAWLING_CONFIG_PK" PRIMARY KEY ("ID") ENABLE
);

CREATE TABLE "BROWSER_TYPE"(
  "ID" NUMBER(18,0) NOT NULL,
  "NAME" VARCHAR2(100) NOT NULL,
  "VALUE" VARCHAR2(20) NOT NULL,
  "SORT_ORDER" NUMBER(9,0) NOT NULL,
  "CREATED_BY" VARCHAR2(255) NOT NULL,
  "CREATED_TIME" TIMESTAMP NOT NULL,
  "UPDATED_BY" VARCHAR2(255),
  "UPDATED_TIME" TIMESTAMP,
  "DELETED_BY" VARCHAR2(255),
  "DELETED_TIME" TIMESTAMP,
  "VERSION_NO" NUMBER(9,0) NOT NULL,

  CONSTRAINT "BROWSER_TYPE_PK" PRIMARY KEY ("ID") ENABLE
);

CREATE TABLE "FILE_CRAWLING_CONFIG"(
  "ID" NUMBER(18,0) NOT NULL,
  "NAME" VARCHAR2(200) NOT NULL,
  "PATHS" VARCHAR2(4000) NOT NULL,
  "INCLUDED_PATHS" VARCHAR2(4000),
  "EXCLUDED_PATHS" VARCHAR2(4000),
  "INCLUDED_DOC_PATHS" VARCHAR2(4000),
  "EXCLUDED_DOC_PATHS" VARCHAR2(4000),
  "DEPTH" NUMBER(9,0),
  "MAX_ACCESS_COUNT" NUMBER(18,0),
  "NUM_OF_THREAD" NUMBER(9,0) NOT NULL,
  "INTERVAL_TIME" NUMBER(9,0) NOT NULL,
  "BOOST" FLOAT NOT NULL,
  "AVAILABLE" VARCHAR2(1) NOT NULL,
  "SORT_ORDER" NUMBER(9,0) NOT NULL,
  "CREATED_BY" VARCHAR2(255) NOT NULL,
  "CREATED_TIME" TIMESTAMP NOT NULL,
  "UPDATED_BY" VARCHAR2(255),
  "UPDATED_TIME" TIMESTAMP,
  "DELETED_BY" VARCHAR2(255),
  "DELETED_TIME" TIMESTAMP,
  "VERSION_NO" NUMBER(9,0) NOT NULL,

  CONSTRAINT "FILE_CRAWLING_CONFIG_PK" PRIMARY KEY ("ID") ENABLE
);

CREATE TABLE "WEB_CONFIG_TO_B_TYPE"(
  "ID" NUMBER(18,0) NOT NULL,
  "WEB_CONFIG_ID" NUMBER(18,0) NOT NULL,
  "BROWSER_TYPE_ID" NUMBER(18,0) NOT NULL,

  CONSTRAINT "WEB_CONFIG_TO_B_TYPE_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (WEB_CONFIG_ID) REFERENCES WEB_CRAWLING_CONFIG (ID),
  FOREIGN KEY (BROWSER_TYPE_ID) REFERENCES BROWSER_TYPE (ID)
);

CREATE TABLE "FILE_CONFIG_TO_B_TYPE"(
  "ID" NUMBER(18,0) NOT NULL,
  "FILE_CONFIG_ID" NUMBER(18,0) NOT NULL,
  "BROWSER_TYPE_ID" NUMBER(18,0) NOT NULL,

  CONSTRAINT "FILE_CONFIG_TO_B_TYPE_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (FILE_CONFIG_ID) REFERENCES FILE_CRAWLING_CONFIG (ID),
  FOREIGN KEY (BROWSER_TYPE_ID) REFERENCES BROWSER_TYPE (ID)
);

CREATE TABLE "PATH_MAPPING"(
  "ID" NUMBER(18,0) NOT NULL,
  "REGEX" VARCHAR2(1000) NOT NULL,
  "REPLACEMENT" VARCHAR2(1000) NOT NULL,
  "PROCESS_TYPE" VARCHAR2(1) NOT NULL,
  "SORT_ORDER" NUMBER(9,0) NOT NULL,
  "CREATED_BY" VARCHAR2(255) NOT NULL,
  "CREATED_TIME" TIMESTAMP NOT NULL,
  "UPDATED_BY" VARCHAR2(255),
  "UPDATED_TIME" TIMESTAMP,
  "DELETED_BY" VARCHAR2(255),
  "DELETED_TIME" TIMESTAMP,
  "VERSION_NO" NUMBER(9,0) NOT NULL,

  CONSTRAINT "PATH_MAPPING_PK" PRIMARY KEY ("ID") ENABLE
);

CREATE TABLE "CRAWLING_SESSION"(
  "ID" NUMBER(18,0) NOT NULL,
  "SESSION_ID" VARCHAR2(20) NOT NULL,
  "CREATED_TIME" TIMESTAMP NOT NULL,

  CONSTRAINT "CRAWLING_SESSION_PK" PRIMARY KEY ("ID") ENABLE
);

CREATE TABLE "OVERLAPPING_HOST"(
  "ID" NUMBER(18,0) NOT NULL,
  "REGULAR_NAME" VARCHAR2(1000) NOT NULL,
  "OVERLAPPING_NAME" VARCHAR2(1000) NOT NULL,
  "SORT_ORDER" NUMBER(9,0) NOT NULL,
  "CREATED_BY" VARCHAR2(255) NOT NULL,
  "CREATED_TIME" TIMESTAMP NOT NULL,
  "UPDATED_BY" VARCHAR2(255),
  "UPDATED_TIME" TIMESTAMP,
  "DELETED_BY" VARCHAR2(255),
  "DELETED_TIME" TIMESTAMP,
  "VERSION_NO" NUMBER(9,0) NOT NULL,

  CONSTRAINT "OVERLAPPING_HOST_PK" PRIMARY KEY ("ID") ENABLE
);

CREATE TABLE "REQUEST_HEADER"(
  "ID" NUMBER(18,0) NOT NULL,
  "NAME" VARCHAR2(100) NOT NULL,
  "VALUE" VARCHAR2(1000) NOT NULL,
  "WEB_CRAWLING_CONFIG_ID" NUMBER(18,0) NOT NULL,
  "CREATED_BY" VARCHAR2(255) NOT NULL,
  "CREATED_TIME" TIMESTAMP NOT NULL,
  "UPDATED_BY" VARCHAR2(255),
  "UPDATED_TIME" TIMESTAMP,
  "DELETED_BY" VARCHAR2(255),
  "DELETED_TIME" TIMESTAMP,
  "VERSION_NO" NUMBER(9,0) NOT NULL,

  CONSTRAINT "REQUEST_HEADER_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (WEB_CRAWLING_CONFIG_ID) REFERENCES WEB_CRAWLING_CONFIG (ID)
);

CREATE TABLE "WEB_AUTHENTICATION"(
  "ID" NUMBER(18,0) NOT NULL,
  "HOSTNAME" VARCHAR2(100),
  "PORT" NUMBER(9,0) NOT NULL,
  "AUTH_REALM" VARCHAR2(100),
  "PROTOCOL_SCHEME" VARCHAR2(10),
  "USERNAME" VARCHAR2(100) NOT NULL,
  "PASSWORD" VARCHAR2(100),
  "PARAMETERS" VARCHAR2(1000),
  "WEB_CRAWLING_CONFIG_ID" NUMBER(18,0) NOT NULL,
  "CREATED_BY" VARCHAR2(255) NOT NULL,
  "CREATED_TIME" TIMESTAMP NOT NULL,
  "UPDATED_BY" VARCHAR2(255),
  "UPDATED_TIME" TIMESTAMP,
  "DELETED_BY" VARCHAR2(255),
  "DELETED_TIME" TIMESTAMP,
  "VERSION_NO" NUMBER(9,0) NOT NULL,

  CONSTRAINT "WEB_AUTHENTICATION_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (WEB_CRAWLING_CONFIG_ID) REFERENCES WEB_CRAWLING_CONFIG (ID)
);

CREATE TABLE "CRAWLING_SESSION_INFO"(
  "ID" NUMBER(18,0) NOT NULL,
  "CRAWLING_SESSION_ID" NUMBER(18,0) NOT NULL,
  "KEY" VARCHAR2(20) NOT NULL,
  "VALUE" VARCHAR2(100) NOT NULL,
  "CREATED_TIME" TIMESTAMP NOT NULL,

  CONSTRAINT "CRAWLING_SESSION_INFO_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (CRAWLING_SESSION_ID) REFERENCES CRAWLING_SESSION (ID)
);

CREATE TABLE "LABEL_TYPE"(
  "ID" NUMBER(18,0) NOT NULL,
  "NAME" VARCHAR2(100) NOT NULL,
  "VALUE" VARCHAR2(20) NOT NULL,
  "SORT_ORDER" NUMBER(9,0) NOT NULL,
  "CREATED_BY" VARCHAR2(255) NOT NULL,
  "CREATED_TIME" TIMESTAMP NOT NULL,
  "UPDATED_BY" VARCHAR2(255),
  "UPDATED_TIME" TIMESTAMP,
  "DELETED_BY" VARCHAR2(255),
  "DELETED_TIME" TIMESTAMP,
  "VERSION_NO" NUMBER(9,0) NOT NULL,

  CONSTRAINT "LABEL_TYPE_PK" PRIMARY KEY ("ID") ENABLE
);

CREATE TABLE "FILE_CONFIG_TO_LABEL_TYPE"(
  "ID" NUMBER(18,0) NOT NULL,
  "FILE_CONFIG_ID" NUMBER(18,0) NOT NULL,
  "LABEL_TYPE_ID" NUMBER(18,0) NOT NULL,

  CONSTRAINT "FILE_CONFIG_TO_LABEL_TYPE_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (LABEL_TYPE_ID) REFERENCES LABEL_TYPE (ID),
  FOREIGN KEY (FILE_CONFIG_ID) REFERENCES FILE_CRAWLING_CONFIG (ID)
);

CREATE TABLE "WEB_CONFIG_TO_LABEL_TYPE"(
  "ID" NUMBER(18,0) NOT NULL,
  "WEB_CONFIG_ID" NUMBER(18,0) NOT NULL,
  "LABEL_TYPE_ID" NUMBER(18,0) NOT NULL,

  CONSTRAINT "WEB_CONFIG_TO_LABEL_TYPE_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (LABEL_TYPE_ID) REFERENCES LABEL_TYPE (ID),
  FOREIGN KEY (WEB_CONFIG_ID) REFERENCES WEB_CRAWLING_CONFIG (ID)
);

CREATE TABLE "ROLE_TYPE"(
  "ID" NUMBER(18,0) NOT NULL,
  "NAME" VARCHAR2(100) NOT NULL,
  "VALUE" VARCHAR2(20) NOT NULL,
  "SORT_ORDER" NUMBER(9,0) NOT NULL,
  "CREATED_BY" VARCHAR2(255) NOT NULL,
  "CREATED_TIME" TIMESTAMP NOT NULL,
  "UPDATED_BY" VARCHAR2(255),
  "UPDATED_TIME" TIMESTAMP,
  "DELETED_BY" VARCHAR2(255),
  "DELETED_TIME" TIMESTAMP,
  "VERSION_NO" NUMBER(9,0) NOT NULL,

  CONSTRAINT "ROLE_TYPE_PK" PRIMARY KEY ("ID") ENABLE
);

CREATE TABLE "FILE_CONFIG_TO_ROLE_TYPE"(
  "ID" NUMBER(18,0) NOT NULL,
  "FILE_CONFIG_ID" NUMBER(18,0) NOT NULL,
  "ROLE_TYPE_ID" NUMBER(18,0) NOT NULL,

  CONSTRAINT "FILE_CONFIG_TO_ROLE_TYPE_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (FILE_CONFIG_ID) REFERENCES FILE_CRAWLING_CONFIG (ID),
  FOREIGN KEY (ROLE_TYPE_ID) REFERENCES ROLE_TYPE (ID)
);

CREATE TABLE "WEB_CONFIG_TO_ROLE_TYPE"(
  "ID" NUMBER(18,0) NOT NULL,
  "WEB_CONFIG_ID" NUMBER(18,0) NOT NULL,
  "ROLE_TYPE_ID" NUMBER(18,0) NOT NULL,

  CONSTRAINT "WEB_CONFIG_TO_ROLE_TYPE_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (WEB_CONFIG_ID) REFERENCES WEB_CRAWLING_CONFIG (ID),
  FOREIGN KEY (ROLE_TYPE_ID) REFERENCES ROLE_TYPE (ID)
);

CREATE TABLE "DATA_CRAWLING_CONFIG"(
  "ID" NUMBER(18,0) NOT NULL,
  "NAME" VARCHAR2(200) NOT NULL,
  "HANDLER_NAME" VARCHAR2(200) NOT NULL,
  "HANDLER_PARAMETER" VARCHAR2(4000),
  "HANDLER_SCRIPT" VARCHAR2(4000),
  "BOOST" FLOAT NOT NULL,
  "AVAILABLE" VARCHAR2(1) NOT NULL,
  "SORT_ORDER" NUMBER(9,0) NOT NULL,
  "CREATED_BY" VARCHAR2(255) NOT NULL,
  "CREATED_TIME" TIMESTAMP NOT NULL,
  "UPDATED_BY" VARCHAR2(255),
  "UPDATED_TIME" TIMESTAMP,
  "DELETED_BY" VARCHAR2(255),
  "DELETED_TIME" TIMESTAMP,
  "VERSION_NO" NUMBER(9,0) NOT NULL,

  CONSTRAINT "DATA_CRAWLING_CONFIG_PK" PRIMARY KEY ("ID") ENABLE
);

CREATE TABLE "DATA_CONFIG_TO_ROLE_TYPE"(
  "ID" NUMBER(18,0) NOT NULL,
  "DATA_CONFIG_ID" NUMBER(18,0) NOT NULL,
  "ROLE_TYPE_ID" NUMBER(18,0) NOT NULL,

  CONSTRAINT "DATA_CONFIG_TO_ROLE_TYPE_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (DATA_CONFIG_ID) REFERENCES DATA_CRAWLING_CONFIG (ID),
  FOREIGN KEY (ROLE_TYPE_ID) REFERENCES ROLE_TYPE (ID)
);

CREATE TABLE "DATA_CONFIG_TO_LABEL_TYPE"(
  "ID" NUMBER(18,0) NOT NULL,
  "DATA_CONFIG_ID" NUMBER(18,0) NOT NULL,
  "LABEL_TYPE_ID" NUMBER(18,0) NOT NULL,

  CONSTRAINT "DATA_CONFIG_TO_LABEL_TYPE_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (DATA_CONFIG_ID) REFERENCES DATA_CRAWLING_CONFIG (ID),
  FOREIGN KEY (LABEL_TYPE_ID) REFERENCES LABEL_TYPE (ID)
);

CREATE TABLE "DATA_CONFIG_TO_B_TYPE"(
  "ID" NUMBER(18,0) NOT NULL,
  "DATA_CONFIG_ID" NUMBER(18,0) NOT NULL,
  "BROWSER_TYPE_ID" NUMBER(18,0) NOT NULL,

  CONSTRAINT "DATA_CONFIG_TO_B_TYPE_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (DATA_CONFIG_ID) REFERENCES DATA_CRAWLING_CONFIG (ID),
  FOREIGN KEY (BROWSER_TYPE_ID) REFERENCES BROWSER_TYPE (ID)
);

CREATE TABLE "SEARCH_LOG"(
  "ID" NUMBER(18,0) NOT NULL,
  "SEARCH_WORD" VARCHAR2(1000),
  "SEARCH_QUERY" VARCHAR2(1000),
  "SOLR_QUERY" VARCHAR2(1000),
  "REQUESTED_TIME" TIMESTAMP NOT NULL,
  "RESPONSE_TIME" NUMBER(9,0) NOT NULL,
  "HIT_COUNT" NUMBER(18,0) NOT NULL,
  "QUERY_OFFSET" NUMBER(9,0) NOT NULL,
  "QUERY_PAGE_SIZE" NUMBER(9,0) NOT NULL,
  "USER_AGENT" VARCHAR2(255),
  "REFERER" VARCHAR2(1000),
  "CLIENT_IP" VARCHAR2(50),
  "USER_SESSION_ID" VARCHAR2(100),
  "ACCESS_TYPE" VARCHAR2(1) NOT NULL,

  CONSTRAINT "SEARCH_LOG_PK" PRIMARY KEY ("ID") ENABLE
);

CREATE TABLE "LABEL_TYPE_TO_ROLE_TYPE"(
  "ID" NUMBER(18,0) NOT NULL,
  "LABEL_TYPE_ID" NUMBER(18,0) NOT NULL,
  "ROLE_TYPE_ID" NUMBER(18,0) NOT NULL,

  CONSTRAINT "LABEL_TYPE_TO_ROLE_TYPE_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (LABEL_TYPE_ID) REFERENCES LABEL_TYPE (ID),
  FOREIGN KEY (ROLE_TYPE_ID) REFERENCES ROLE_TYPE (ID)
);

CREATE TABLE "CLICK_LOG"(
  "ID" NUMBER(18,0) NOT NULL,
  "SEARCH_ID" NUMBER(18,0) NOT NULL,
  "URL" VARCHAR2(4000) NOT NULL,
  "REQUESTED_TIME" TIMESTAMP NOT NULL,

  CONSTRAINT "CLICK_LOG_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (SEARCH_ID) REFERENCES SEARCH_LOG (ID)
);

CREATE TABLE "FAILURE_URL"(
  "ID" NUMBER(18,0) NOT NULL,
  "URL" VARCHAR2(4000) NOT NULL,
  "THREAD_NAME" VARCHAR2(30) NOT NULL,
  "ERROR_NAME" VARCHAR2(255),
  "ERROR_LOG" VARCHAR2(4000),
  "ERROR_COUNT" NUMBER(9,0) NOT NULL,
  "LAST_ACCESS_TIME" TIMESTAMP NOT NULL,
  "WEB_CONFIG_ID" NUMBER(18,0),
  "FILE_CONFIG_ID" NUMBER(18,0),

  CONSTRAINT "FAILURE_URL_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (FILE_CONFIG_ID) REFERENCES FILE_CRAWLING_CONFIG (ID),
  FOREIGN KEY (WEB_CONFIG_ID) REFERENCES WEB_CRAWLING_CONFIG (ID)
);

CREATE TABLE "FILE_AUTHENTICATION"(
  "ID" NUMBER(18,0) NOT NULL,
  "HOSTNAME" VARCHAR2(255),
  "PORT" NUMBER(9,0) NOT NULL,
  "PROTOCOL_SCHEME" VARCHAR2(10),
  "USERNAME" VARCHAR2(100) NOT NULL,
  "PASSWORD" VARCHAR2(100),
  "PARAMETERS" VARCHAR2(1000),
  "FILE_CRAWLING_CONFIG_ID" NUMBER(18,0) NOT NULL,
  "CREATED_BY" VARCHAR2(255) NOT NULL,
  "CREATED_TIME" TIMESTAMP NOT NULL,
  "UPDATED_BY" VARCHAR2(255),
  "UPDATED_TIME" TIMESTAMP,
  "DELETED_BY" VARCHAR2(255),
  "DELETED_TIME" TIMESTAMP,
  "VERSION_NO" NUMBER(9,0) NOT NULL,

  CONSTRAINT "FILE_AUTHENTICATION_PK" PRIMARY KEY ("ID") ENABLE,
  FOREIGN KEY (FILE_CRAWLING_CONFIG_ID) REFERENCES FILE_CRAWLING_CONFIG (ID)
);


CREATE INDEX IDX_W_C_TO_B_T_FOR_W_C ON WEB_CONFIG_TO_B_TYPE (WEB_CONFIG_ID);

CREATE INDEX IDX_F_C_TO_B_T_FOR_F_C ON FILE_CONFIG_TO_B_TYPE (FILE_CONFIG_ID);

CREATE INDEX IDX_O_H_BY_R_N_AND_S_O ON OVERLAPPING_HOST (REGULAR_NAME, SORT_ORDER);

CREATE INDEX IDX_F_C_TO_L_T_FOR_F_C ON FILE_CONFIG_TO_LABEL_TYPE (FILE_CONFIG_ID);

CREATE INDEX IDX_W_C_TO_L_T_FOR_W_C ON WEB_CONFIG_TO_LABEL_TYPE (WEB_CONFIG_ID);

CREATE INDEX IDX_F_C_TO_R_T_FOR_F_C ON FILE_CONFIG_TO_ROLE_TYPE (FILE_CONFIG_ID);

CREATE INDEX IDX_W_C_TO_R_T_FOR_W_C ON WEB_CONFIG_TO_ROLE_TYPE (WEB_CONFIG_ID);

CREATE INDEX IDX_D_C_TO_R_T_FOR_D_C ON DATA_CONFIG_TO_ROLE_TYPE (DATA_CONFIG_ID);

CREATE INDEX IDX_D_C_TO_L_T_FOR_D_C ON DATA_CONFIG_TO_LABEL_TYPE (DATA_CONFIG_ID);

CREATE INDEX IDX_D_C_TO_B_T_FOR_D_C ON DATA_CONFIG_TO_B_TYPE (DATA_CONFIG_ID);

CREATE INDEX IDX_S_L_BY_H_C ON SEARCH_LOG (HIT_COUNT);
CREATE INDEX IDX_S_L_BY_R_T ON SEARCH_LOG (RESPONSE_TIME);
CREATE INDEX IDX_S_L_BY_RT ON SEARCH_LOG (REQUESTED_TIME);
CREATE INDEX IDX_S_L_BY_S_W ON SEARCH_LOG (SEARCH_WORD);
CREATE INDEX IDX_S_L_BY_RT_USID ON SEARCH_LOG (REQUESTED_TIME, USER_SESSION_ID);

CREATE INDEX IDX_F_U_FOR_L ON FAILURE_URL (URL, LAST_ACCESS_TIME, ERROR_NAME, ERROR_COUNT);
CREATE INDEX IDX_F_U_BY_W_C_ID ON FAILURE_URL (WEB_CONFIG_ID);
CREATE INDEX IDX_F_U_BY_F_C_ID ON FAILURE_URL (FILE_CONFIG_ID);

CREATE SEQUENCE WEB_CRAWLING_CONFIG_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE BROWSER_TYPE_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE FILE_CRAWLING_CONFIG_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE WEB_CONFIG_TO_B_TYPE_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE FILE_CONFIG_TO_B_TYPE_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE PATH_MAPPING_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE CRAWLING_SESSION_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE OVERLAPPING_HOST_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE REQUEST_HEADER_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE WEB_AUTHENTICATION_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE CRAWLING_SESSION_INFO_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE LABEL_TYPE_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE FILE_CONFIG_TO_LABEL_TYPE_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE WEB_CONFIG_TO_LABEL_TYPE_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE ROLE_TYPE_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE FILE_CONFIG_TO_ROLE_TYPE_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE WEB_CONFIG_TO_ROLE_TYPE_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE DATA_CRAWLING_CONFIG_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE DATA_CONFIG_TO_ROLE_TYPE_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE DATA_CONFIG_TO_LABEL_TYPE_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE DATA_CONFIG_TO_B_TYPE_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE SEARCH_LOG_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE LABEL_TYPE_TO_ROLE_TYPE_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE CLICK_LOG_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE FAILURE_URL_SEQ START WITH 1 INCREMENT BY 50;
CREATE SEQUENCE FILE_AUTHENTICATION_SEQ START WITH 1 INCREMENT BY 50;

INSERT INTO BROWSER_TYPE (ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, VERSION_NO) VALUES (1, 'PC', 'pc', 1, 'admin', '2000-01-01 00:00:00', 1);
INSERT INTO BROWSER_TYPE (ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, VERSION_NO) VALUES (2, 'DoCoMo', 'docomo', 2, 'admin', '2000-01-01 00:00:00', 1);
INSERT INTO BROWSER_TYPE (ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, VERSION_NO) VALUES (3, 'au', 'au', 3, 'admin', '2000-01-01 00:00:00', 1);
INSERT INTO BROWSER_TYPE (ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, VERSION_NO) VALUES (4, 'Softbank', 'softbank', 4, 'admin', '2000-01-01 00:00:00', 1);


