/*
 * Copyright 2009-2012 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.exentity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

import jp.sf.fess.Constants;
import jp.sf.fess.db.bsentity.BsWebCrawlingConfig;

import org.seasar.framework.util.StringUtil;

/**
 * The entity of WEB_CRAWLING_CONFIG.
 * <p>
 * You can implement your original methods here.
 * This class remains when re-generating.
 * </p>
 * @author DBFlute(AutoGenerator)
 */
public class WebCrawlingConfig extends BsWebCrawlingConfig implements
        CrawlingConfig {

    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    private String[] browserTypeIds;

    private String[] labelTypeIds;

    private String[] roleTypeIds;

    protected Pattern[] includedDocUrlPatterns;

    protected Pattern[] excludedDocUrlPatterns;

    public WebCrawlingConfig() {
        super();
        setBoost(BigDecimal.ONE);
    }

    /* (non-Javadoc)
     * @see jp.sf.fess.db.exentity.CrawlingConfig#getBrowserTypeIds()
     */
    public String[] getBrowserTypeIds() {
        return browserTypeIds;
    }

    public void setBrowserTypeIds(final String[] browserTypeIds) {
        this.browserTypeIds = browserTypeIds;
    }

    @Override
    public String[] getBrowserTypeValues() {
        final List<String> values = new ArrayList<String>();
        final List<WebConfigToBrowserTypeMapping> list = getWebConfigToBrowserTypeMappingList();
        if (list != null && !list.isEmpty()) {
            for (final WebConfigToBrowserTypeMapping mapping : list) {
                values.add(mapping.getBrowserType().getValue());
            }
        }
        return values.toArray(new String[values.size()]);
    }

    /* (non-Javadoc)
     * @see jp.sf.fess.db.exentity.CrawlingConfig#getLabelTypeIds()
     */
    public String[] getLabelTypeIds() {
        return labelTypeIds;
    }

    public void setLabelTypeIds(final String[] labelTypeIds) {
        this.labelTypeIds = labelTypeIds;
    }

    @Override
    public String[] getLabelTypeValues() {
        final List<String> values = new ArrayList<String>();
        final List<WebConfigToLabelTypeMapping> list = getWebConfigToLabelTypeMappingList();
        if (list != null && !list.isEmpty()) {
            for (final WebConfigToLabelTypeMapping mapping : list) {
                values.add(mapping.getLabelType().getValue());
            }
        }
        return values.toArray(new String[values.size()]);
    }

    /* (non-Javadoc)
     * @see jp.sf.fess.db.exentity.CrawlingConfig#getRoleTypeIds()
     */
    public String[] getRoleTypeIds() {
        return roleTypeIds;
    }

    public void setRoleTypeIds(final String[] roleTypeIds) {
        this.roleTypeIds = roleTypeIds;
    }

    @Override
    public String[] getRoleTypeValues() {
        final List<String> values = new ArrayList<String>();
        final List<WebConfigToRoleTypeMapping> list = getWebConfigToRoleTypeMappingList();
        if (list != null && !list.isEmpty()) {
            for (final WebConfigToRoleTypeMapping mapping : list) {
                values.add(mapping.getRoleType().getValue());
            }
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    public String getDocumentBoost() {
        return Float.valueOf(getBoost().floatValue()).toString();
    }

    @Override
    public String getIndexingTarget(final String input) {
        if (includedDocUrlPatterns == null) {
            initDocUrlPattern();
        }

        for (final Pattern pattern : includedDocUrlPatterns) {
            if (pattern.matcher(input).matches()) {
                return Constants.TRUE;
            }
        }

        for (final Pattern pattern : excludedDocUrlPatterns) {
            if (pattern.matcher(input).matches()) {
                return Constants.FALSE;
            }
        }

        return Constants.TRUE;
    }

    protected void initDocUrlPattern() {
        if (StringUtil.isNotBlank(getIncludedDocUrls())) {
            final List<Pattern> urlPatterList = new ArrayList<Pattern>();
            final String[] urls = getIncludedDocUrls().split("[\r\n]");
            for (final String u : urls) {
                if (StringUtil.isNotBlank(u) && !u.trim().startsWith("#")) {
                    urlPatterList.add(Pattern.compile(u.trim()));
                }
            }
            includedDocUrlPatterns = urlPatterList
                    .toArray(new Pattern[urlPatterList.size()]);
        } else {
            includedDocUrlPatterns = new Pattern[0];
        }

        if (StringUtil.isNotBlank(getExcludedDocUrls())) {
            final List<Pattern> urlPatterList = new ArrayList<Pattern>();
            final String[] urls = getExcludedDocUrls().split("[\r\n]");
            for (final String u : urls) {
                if (StringUtil.isNotBlank(u) && !u.trim().startsWith("#")) {
                    urlPatterList.add(Pattern.compile(u.trim()));
                }
            }
            excludedDocUrlPatterns = urlPatterList
                    .toArray(new Pattern[urlPatterList.size()]);
        } else {
            excludedDocUrlPatterns = new Pattern[0];
        }
    }

    public String getBoostValue() {
        if (_boost != null) {
            return Integer.toString(_boost.intValue());
        }
        return null;
    }

    public void setBoostValue(final String value) {
        if (value != null) {
            try {
                _boost = new BigDecimal(value);
            } catch (final Exception e) {
            }
        }
    }

}
