/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.FileConfigToRoleTypeMappingDbm;
import jp.sf.fess.db.cbean.FileConfigToRoleTypeMappingCB;
import jp.sf.fess.db.exentity.FileConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.FileCrawlingConfig;
import jp.sf.fess.db.exentity.RoleType;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of FILE_CONFIG_TO_ROLE_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, FILE_CONFIG_ID, ROLE_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     FILE_CRAWLING_CONFIG, ROLE_TYPE
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     fileCrawlingConfig, roleType
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsFileConfigToRoleTypeMappingBhv extends
        AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "FILE_CONFIG_TO_ROLE_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return FileConfigToRoleTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public FileConfigToRoleTypeMappingDbm getMyDBMeta() {
        return FileConfigToRoleTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public FileConfigToRoleTypeMapping newMyEntity() {
        return new FileConfigToRoleTypeMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public FileConfigToRoleTypeMappingCB newMyConditionBean() {
        return new FileConfigToRoleTypeMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * FileConfigToRoleTypeMappingCB cb = new FileConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * int count = fileConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(FileConfigToRoleTypeMappingCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(FileConfigToRoleTypeMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * FileConfigToRoleTypeMappingCB cb = new FileConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * fileConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;FileConfigToRoleTypeMapping&gt;() {
     *     public void handle(FileConfigToRoleTypeMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of FileConfigToRoleTypeMapping. (NotNull)
     */
    public void selectCursor(FileConfigToRoleTypeMappingCB cb,
            EntityRowHandler<FileConfigToRoleTypeMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, FileConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToRoleTypeMapping> void doSelectCursor(
            FileConfigToRoleTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<FileConfigToRoleTypeMapping>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * FileConfigToRoleTypeMappingCB cb = new FileConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping = fileConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (fileConfigToRoleTypeMapping != null) {
     *     ... = fileConfigToRoleTypeMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileConfigToRoleTypeMapping selectEntity(
            FileConfigToRoleTypeMappingCB cb) {
        return doSelectEntity(cb, FileConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToRoleTypeMapping> ENTITY doSelectEntity(
            final FileConfigToRoleTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, FileConfigToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileConfigToRoleTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * FileConfigToRoleTypeMappingCB cb = new FileConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping = fileConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = fileConfigToRoleTypeMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileConfigToRoleTypeMapping selectEntityWithDeletedCheck(
            FileConfigToRoleTypeMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb,
                FileConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToRoleTypeMapping> ENTITY doSelectEntityWithDeletedCheck(
            final FileConfigToRoleTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, FileConfigToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileConfigToRoleTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileConfigToRoleTypeMapping selectByPKValue(Long id) {
        return doSelectByPKValue(id, FileConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToRoleTypeMapping> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileConfigToRoleTypeMapping selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id,
                FileConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToRoleTypeMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private FileConfigToRoleTypeMappingCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        FileConfigToRoleTypeMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * FileConfigToRoleTypeMappingCB cb = new FileConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;FileConfigToRoleTypeMapping&gt; fileConfigToRoleTypeMappingList = fileConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping : fileConfigToRoleTypeMappingList) {
     *     ... = fileConfigToRoleTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<FileConfigToRoleTypeMapping> selectList(
            FileConfigToRoleTypeMappingCB cb) {
        return doSelectList(cb, FileConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToRoleTypeMapping> ListResultBean<ENTITY> doSelectList(
            FileConfigToRoleTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, FileConfigToRoleTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileConfigToRoleTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * FileConfigToRoleTypeMappingCB cb = new FileConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;FileConfigToRoleTypeMapping&gt; page = fileConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping : page) {
     *     ... = fileConfigToRoleTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<FileConfigToRoleTypeMapping> selectPage(
            FileConfigToRoleTypeMappingCB cb) {
        return doSelectPage(cb, FileConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToRoleTypeMapping> PagingResultBean<ENTITY> doSelectPage(
            FileConfigToRoleTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, FileConfigToRoleTypeMappingCB>() {
                    public int callbackSelectCount(
                            FileConfigToRoleTypeMappingCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            FileConfigToRoleTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * fileConfigToRoleTypeMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(FileConfigToRoleTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<FileConfigToRoleTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends FileConfigToRoleTypeMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'FileCrawlingConfig'.
     * @param fileConfigToRoleTypeMappingList The list of fileConfigToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<FileCrawlingConfig> pulloutFileCrawlingConfig(
            List<FileConfigToRoleTypeMapping> fileConfigToRoleTypeMappingList) {
        return helpPulloutInternally(
                fileConfigToRoleTypeMappingList,
                new InternalPulloutCallback<FileConfigToRoleTypeMapping, FileCrawlingConfig>() {
                    public FileCrawlingConfig getFr(
                            FileConfigToRoleTypeMapping e) {
                        return e.getFileCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(FileCrawlingConfig e,
                            List<FileConfigToRoleTypeMapping> ls) {
                        e.setFileConfigToRoleTypeMappingList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'RoleType'.
     * @param fileConfigToRoleTypeMappingList The list of fileConfigToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<RoleType> pulloutRoleType(
            List<FileConfigToRoleTypeMapping> fileConfigToRoleTypeMappingList) {
        return helpPulloutInternally(
                fileConfigToRoleTypeMappingList,
                new InternalPulloutCallback<FileConfigToRoleTypeMapping, RoleType>() {
                    public RoleType getFr(FileConfigToRoleTypeMapping e) {
                        return e.getRoleType();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(RoleType e,
                            List<FileConfigToRoleTypeMapping> ls) {
                        e.setFileConfigToRoleTypeMappingList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping = new FileConfigToRoleTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * fileConfigToRoleTypeMapping.setFoo...(value);
     * fileConfigToRoleTypeMapping.setBar...(value);
     * fileConfigToRoleTypeMappingBhv.<span style="color: #FD4747">insert</span>(fileConfigToRoleTypeMapping);
     * ... = fileConfigToRoleTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param fileConfigToRoleTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping) {
        assertEntityNotNull(fileConfigToRoleTypeMapping);
        delegateInsert(fileConfigToRoleTypeMapping);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping = new FileConfigToRoleTypeMapping();
     * fileConfigToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileConfigToRoleTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileConfigToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     fileConfigToRoleTypeMappingBhv.<span style="color: #FD4747">update</span>(fileConfigToRoleTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param fileConfigToRoleTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping) {
        helpUpdateInternally(fileConfigToRoleTypeMapping,
                new InternalUpdateCallback<FileConfigToRoleTypeMapping>() {
                    public int callbackDelegateUpdate(
                            FileConfigToRoleTypeMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param fileConfigToRoleTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping) {
        helpInsertOrUpdateInternally(
                fileConfigToRoleTypeMapping,
                new InternalInsertOrUpdateCallback<FileConfigToRoleTypeMapping, FileConfigToRoleTypeMappingCB>() {
                    public void callbackInsert(
                            FileConfigToRoleTypeMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(
                            FileConfigToRoleTypeMapping entity) {
                        update(entity);
                    }

                    public FileConfigToRoleTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            FileConfigToRoleTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping = new FileConfigToRoleTypeMapping();
     * fileConfigToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileConfigToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     fileConfigToRoleTypeMappingBhv.<span style="color: #FD4747">delete</span>(fileConfigToRoleTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param fileConfigToRoleTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping) {
        helpDeleteInternally(fileConfigToRoleTypeMapping,
                new InternalDeleteCallback<FileConfigToRoleTypeMapping>() {
                    public int callbackDelegateDelete(
                            FileConfigToRoleTypeMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<FileConfigToRoleTypeMapping> fileConfigToRoleTypeMappingList) {
        assertObjectNotNull("fileConfigToRoleTypeMappingList",
                fileConfigToRoleTypeMappingList);
        return delegateInsertList(fileConfigToRoleTypeMappingList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<FileConfigToRoleTypeMapping> fileConfigToRoleTypeMappingList) {
        assertObjectNotNull("fileConfigToRoleTypeMappingList",
                fileConfigToRoleTypeMappingList);
        return delegateUpdateList(fileConfigToRoleTypeMappingList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<FileConfigToRoleTypeMapping> fileConfigToRoleTypeMappingList) {
        assertObjectNotNull("fileConfigToRoleTypeMappingList",
                fileConfigToRoleTypeMappingList);
        return delegateDeleteList(fileConfigToRoleTypeMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping = new FileConfigToRoleTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//fileConfigToRoleTypeMapping.setPK...(value);</span>
     * fileConfigToRoleTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileConfigToRoleTypeMapping.setVersionNo(value);</span>
     * FileConfigToRoleTypeMappingCB cb = new FileConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * fileConfigToRoleTypeMappingBhv.<span style="color: #FD4747">queryUpdate</span>(fileConfigToRoleTypeMapping, cb);
     * </pre>
     * @param fileConfigToRoleTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(
            FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping,
            FileConfigToRoleTypeMappingCB cb) {
        return delegateQueryUpdate(fileConfigToRoleTypeMapping, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * FileConfigToRoleTypeMappingCB cb = new FileConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * fileConfigToRoleTypeMappingBhv.<span style="color: #FD4747">queryDelete</span>(fileConfigToRoleTypeMapping, cb);
     * </pre>
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(FileConfigToRoleTypeMappingCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping = new FileConfigToRoleTypeMapping();
     * fileConfigToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileConfigToRoleTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileConfigToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;FileConfigToRoleTypeMappingCB&gt; option = new UpdateOption&lt;FileConfigToRoleTypeMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;FileConfigToRoleTypeMappingCB&gt;() {
     *         public void specify(FileConfigToRoleTypeMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     fileConfigToRoleTypeMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(fileConfigToRoleTypeMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param fileConfigToRoleTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(
            FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping,
            final UpdateOption<FileConfigToRoleTypeMappingCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(fileConfigToRoleTypeMapping,
                new InternalUpdateCallback<FileConfigToRoleTypeMapping>() {
                    public int callbackDelegateUpdate(
                            FileConfigToRoleTypeMapping entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping = new FileConfigToRoleTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//fileConfigToRoleTypeMapping.setPK...(value);</span>
     * fileConfigToRoleTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileConfigToRoleTypeMapping.setVersionNo(value);</span>
     * FileConfigToRoleTypeMappingCB cb = new FileConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;FileConfigToRoleTypeMappingCB&gt; option = new UpdateOption&lt;FileConfigToRoleTypeMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;FileConfigToRoleTypeMappingCB&gt;() {
     *     public void specify(FileConfigToRoleTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * fileConfigToRoleTypeMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(fileConfigToRoleTypeMapping, cb, option);
     * </pre>
     * @param fileConfigToRoleTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(
            FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping,
            FileConfigToRoleTypeMappingCB cb,
            final UpdateOption<FileConfigToRoleTypeMappingCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(fileConfigToRoleTypeMapping, cb,
                option);
    }

    protected void processVaryingUpdate(
            UpdateOption<FileConfigToRoleTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        FileConfigToRoleTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(FileConfigToRoleTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends FileConfigToRoleTypeMapping> void delegateSelectCursor(
            FileConfigToRoleTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends FileConfigToRoleTypeMapping> List<ENTITY> delegateSelectList(
            FileConfigToRoleTypeMappingCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(FileConfigToRoleTypeMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(FileConfigToRoleTypeMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(FileConfigToRoleTypeMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<FileConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<FileConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<FileConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int delegateQueryUpdate(FileConfigToRoleTypeMapping e,
            FileConfigToRoleTypeMappingCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(FileConfigToRoleTypeMappingCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(FileConfigToRoleTypeMapping e,
            UpdateOption<FileConfigToRoleTypeMappingCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(FileConfigToRoleTypeMapping e,
            FileConfigToRoleTypeMappingCB cb,
            UpdateOption<FileConfigToRoleTypeMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected FileConfigToRoleTypeMapping downcast(Entity entity) {
        return helpEntityDowncastInternally(entity,
                FileConfigToRoleTypeMapping.class);
    }

    protected FileConfigToRoleTypeMappingCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                FileConfigToRoleTypeMappingCB.class);
    }
}
