/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

import javax.annotation.Resource;

import jp.sf.fess.db.exbhv.SearchLogBhv;
import jp.sf.fess.db.exbhv.pmbean.HotSearchWordPmb;
import jp.sf.fess.db.exentity.customize.HotSearchWord;

import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.framework.container.annotation.tiger.InitMethod;

public class HotSearchWordHelper {

    @Resource
    protected SearchLogBhv searchLogBhv;

    protected Map<Range, List<String>> cacheMap = new HashMap<HotSearchWordHelper.Range, List<String>>();

    public int size = 10;

    public Pattern excludedWordPattern;

    @InitMethod
    public void init() {
        long now = System.currentTimeMillis();
        cacheMap.put(Range.ONE_DAY, getHotSearchWordListByFromDate(new Date(now
                - Range.ONE_DAY.getTime())));
        cacheMap.put(Range.ONE_WEEK, getHotSearchWordListByFromDate(new Date(
                now - Range.ONE_WEEK.getTime())));
        cacheMap.put(Range.ONE_MONTH, getHotSearchWordListByFromDate(new Date(
                now - Range.ONE_MONTH.getTime())));
        cacheMap.put(Range.ONE_YEAR, getHotSearchWordListByFromDate(new Date(
                now - Range.ONE_YEAR.getTime())));
        cacheMap.put(Range.ENTIRE, getHotSearchWordListByFromDate(null));
    }

    protected List<String> getHotSearchWordListByFromDate(Date fromDate) {
        HotSearchWordPmb pmb = new HotSearchWordPmb();

        pmb.fetchFirst(size);
        pmb.fetchPage(0);

        if (fromDate != null) {
            pmb.setFromRequestedTime_FromDate(fromDate);
        }

        String path = SearchLogBhv.PATH_selectHotSearchWord;
        PagingResultBean<HotSearchWord> statsList = searchLogBhv.outsideSql()
                .autoPaging().selectPage(path, pmb, HotSearchWord.class);

        List<String> wordList = new ArrayList<String>();
        if (statsList.isEmpty()) {
            return wordList;
        }

        for (HotSearchWord hotSearchWord : statsList) {
            if (excludedWordPattern != null) {
                if (!excludedWordPattern.matcher(hotSearchWord.getName())
                        .matches()) {
                    wordList.add(hotSearchWord.getName());
                }
            } else {
                wordList.add(hotSearchWord.getName());
            }
        }
        return wordList;
    }

    public void reload() {
        init();
    }

    public List<String> getHotSearchWordList(Range range) {
        return cacheMap.get(range);
    }

    public enum Range {
        ONE_DAY(1), ONE_WEEK(7), ONE_MONTH(30), ONE_YEAR(365), ENTIRE(0);
        private long time;

        private Range(long t) {
            time = t * 24L * 60L * 60L * 1000L;
        }

        public long getTime() {
            return time;
        }
    }
}
