/*
 * Copyright 2009-2012 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.exentity.FailureUrl;
import jp.sf.fess.db.exentity.RequestHeader;
import jp.sf.fess.db.exentity.WebAuthentication;
import jp.sf.fess.db.exentity.WebConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToRoleTypeMapping;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The entity of WEB_CRAWLING_CONFIG as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, URLS, INCLUDED_URLS, EXCLUDED_URLS, INCLUDED_DOC_URLS, EXCLUDED_DOC_URLS, DEPTH, MAX_ACCESS_COUNT, USER_AGENT, NUM_OF_THREAD, INTERVAL_TIME, BOOST, AVAILABLE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     FAILURE_URL, REQUEST_HEADER, WEB_AUTHENTICATION, WEB_CONFIG_TO_BROWSER_TYPE_MAPPING, WEB_CONFIG_TO_LABEL_TYPE_MAPPING, WEB_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     failureUrlList, requestHeaderList, webAuthenticationList, webConfigToBrowserTypeMappingList, webConfigToLabelTypeMappingList, webConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsWebCrawlingConfig implements Entity, Serializable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    // -----------------------------------------------------
    //                                                Column
    //                                                ------
    /** ID: {PK, ID, NotNull, BIGINT(19)} */
    protected Long _id;

    /** NAME: {NotNull, VARCHAR(200)} */
    protected String _name;

    /** URLS: {NotNull, VARCHAR(4000)} */
    protected String _urls;

    /** INCLUDED_URLS: {VARCHAR(4000)} */
    protected String _includedUrls;

    /** EXCLUDED_URLS: {VARCHAR(4000)} */
    protected String _excludedUrls;

    /** INCLUDED_DOC_URLS: {VARCHAR(4000)} */
    protected String _includedDocUrls;

    /** EXCLUDED_DOC_URLS: {VARCHAR(4000)} */
    protected String _excludedDocUrls;

    /** DEPTH: {INTEGER(10)} */
    protected Integer _depth;

    /** MAX_ACCESS_COUNT: {BIGINT(19)} */
    protected Long _maxAccessCount;

    /** USER_AGENT: {NotNull, VARCHAR(200)} */
    protected String _userAgent;

    /** NUM_OF_THREAD: {NotNull, INTEGER(10)} */
    protected Integer _numOfThread;

    /** INTERVAL_TIME: {NotNull, INTEGER(10)} */
    protected Integer _intervalTime;

    /** BOOST: {NotNull, DOUBLE(17)} */
    protected java.math.BigDecimal _boost;

    /** AVAILABLE: {NotNull, VARCHAR(1)} */
    protected String _available;

    /** SORT_ORDER: {NotNull, INTEGER(10)} */
    protected Integer _sortOrder;

    /** CREATED_BY: {NotNull, VARCHAR(255)} */
    protected String _createdBy;

    /** CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _createdTime;

    /** UPDATED_BY: {VARCHAR(255)} */
    protected String _updatedBy;

    /** UPDATED_TIME: {TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _updatedTime;

    /** DELETED_BY: {VARCHAR(255)} */
    protected String _deletedBy;

    /** DELETED_TIME: {TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _deletedTime;

    /** VERSION_NO: {NotNull, INTEGER(10)} */
    protected Integer _versionNo;

    // -----------------------------------------------------
    //                                              Internal
    //                                              --------
    /** The modified properties for this entity. */
    protected final EntityModifiedProperties __modifiedProperties = newModifiedProperties();

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    /**
     * {@inheritDoc}
     */
    @Override
    public String getTableDbName() {
        return "WEB_CRAWLING_CONFIG";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getTablePropertyName() { // according to Java Beans rule
        return "webCrawlingConfig";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /**
     * {@inheritDoc}
     */
    @Override
    public DBMeta getDBMeta() {
        return DBMetaInstanceHandler.findDBMeta(getTableDbName());
    }

    // ===================================================================================
    //                                                                         Primary Key
    //                                                                         ===========
    /**
     * {@inheritDoc}
     */
    @Override
    public boolean hasPrimaryKeyValue() {
        if (getId() == null) {
            return false;
        }
        return true;
    }

    // ===================================================================================
    //                                                                    Foreign Property
    //                                                                    ================
    // ===================================================================================
    //                                                                   Referrer Property
    //                                                                   =================
    /** FAILURE_URL as 'failureUrlList'. */
    protected List<FailureUrl> _failureUrlList;

    /**
     * FAILURE_URL as 'failureUrlList'.
     * @return The entity list of referrer property 'failureUrlList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FailureUrl> getFailureUrlList() {
        if (_failureUrlList == null) {
            _failureUrlList = new ArrayList<FailureUrl>();
        }
        return _failureUrlList;
    }

    /**
     * FAILURE_URL as 'failureUrlList'.
     * @param failureUrlList The entity list of referrer property 'failureUrlList'. (NullAllowed)
     */
    public void setFailureUrlList(final List<FailureUrl> failureUrlList) {
        _failureUrlList = failureUrlList;
    }

    /** REQUEST_HEADER as 'requestHeaderList'. */
    protected List<RequestHeader> _requestHeaderList;

    /**
     * REQUEST_HEADER as 'requestHeaderList'.
     * @return The entity list of referrer property 'requestHeaderList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<RequestHeader> getRequestHeaderList() {
        if (_requestHeaderList == null) {
            _requestHeaderList = new ArrayList<RequestHeader>();
        }
        return _requestHeaderList;
    }

    /**
     * REQUEST_HEADER as 'requestHeaderList'.
     * @param requestHeaderList The entity list of referrer property 'requestHeaderList'. (NullAllowed)
     */
    public void setRequestHeaderList(final List<RequestHeader> requestHeaderList) {
        _requestHeaderList = requestHeaderList;
    }

    /** WEB_AUTHENTICATION as 'webAuthenticationList'. */
    protected List<WebAuthentication> _webAuthenticationList;

    /**
     * WEB_AUTHENTICATION as 'webAuthenticationList'.
     * @return The entity list of referrer property 'webAuthenticationList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<WebAuthentication> getWebAuthenticationList() {
        if (_webAuthenticationList == null) {
            _webAuthenticationList = new ArrayList<WebAuthentication>();
        }
        return _webAuthenticationList;
    }

    /**
     * WEB_AUTHENTICATION as 'webAuthenticationList'.
     * @param webAuthenticationList The entity list of referrer property 'webAuthenticationList'. (NullAllowed)
     */
    public void setWebAuthenticationList(
            final List<WebAuthentication> webAuthenticationList) {
        _webAuthenticationList = webAuthenticationList;
    }

    /** WEB_CONFIG_TO_BROWSER_TYPE_MAPPING as 'webConfigToBrowserTypeMappingList'. */
    protected List<WebConfigToBrowserTypeMapping> _webConfigToBrowserTypeMappingList;

    /**
     * WEB_CONFIG_TO_BROWSER_TYPE_MAPPING as 'webConfigToBrowserTypeMappingList'.
     * @return The entity list of referrer property 'webConfigToBrowserTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<WebConfigToBrowserTypeMapping> getWebConfigToBrowserTypeMappingList() {
        if (_webConfigToBrowserTypeMappingList == null) {
            _webConfigToBrowserTypeMappingList = new ArrayList<WebConfigToBrowserTypeMapping>();
        }
        return _webConfigToBrowserTypeMappingList;
    }

    /**
     * WEB_CONFIG_TO_BROWSER_TYPE_MAPPING as 'webConfigToBrowserTypeMappingList'.
     * @param webConfigToBrowserTypeMappingList The entity list of referrer property 'webConfigToBrowserTypeMappingList'. (NullAllowed)
     */
    public void setWebConfigToBrowserTypeMappingList(
            final List<WebConfigToBrowserTypeMapping> webConfigToBrowserTypeMappingList) {
        _webConfigToBrowserTypeMappingList = webConfigToBrowserTypeMappingList;
    }

    /** WEB_CONFIG_TO_LABEL_TYPE_MAPPING as 'webConfigToLabelTypeMappingList'. */
    protected List<WebConfigToLabelTypeMapping> _webConfigToLabelTypeMappingList;

    /**
     * WEB_CONFIG_TO_LABEL_TYPE_MAPPING as 'webConfigToLabelTypeMappingList'.
     * @return The entity list of referrer property 'webConfigToLabelTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<WebConfigToLabelTypeMapping> getWebConfigToLabelTypeMappingList() {
        if (_webConfigToLabelTypeMappingList == null) {
            _webConfigToLabelTypeMappingList = new ArrayList<WebConfigToLabelTypeMapping>();
        }
        return _webConfigToLabelTypeMappingList;
    }

    /**
     * WEB_CONFIG_TO_LABEL_TYPE_MAPPING as 'webConfigToLabelTypeMappingList'.
     * @param webConfigToLabelTypeMappingList The entity list of referrer property 'webConfigToLabelTypeMappingList'. (NullAllowed)
     */
    public void setWebConfigToLabelTypeMappingList(
            final List<WebConfigToLabelTypeMapping> webConfigToLabelTypeMappingList) {
        _webConfigToLabelTypeMappingList = webConfigToLabelTypeMappingList;
    }

    /** WEB_CONFIG_TO_ROLE_TYPE_MAPPING as 'webConfigToRoleTypeMappingList'. */
    protected List<WebConfigToRoleTypeMapping> _webConfigToRoleTypeMappingList;

    /**
     * WEB_CONFIG_TO_ROLE_TYPE_MAPPING as 'webConfigToRoleTypeMappingList'.
     * @return The entity list of referrer property 'webConfigToRoleTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<WebConfigToRoleTypeMapping> getWebConfigToRoleTypeMappingList() {
        if (_webConfigToRoleTypeMappingList == null) {
            _webConfigToRoleTypeMappingList = new ArrayList<WebConfigToRoleTypeMapping>();
        }
        return _webConfigToRoleTypeMappingList;
    }

    /**
     * WEB_CONFIG_TO_ROLE_TYPE_MAPPING as 'webConfigToRoleTypeMappingList'.
     * @param webConfigToRoleTypeMappingList The entity list of referrer property 'webConfigToRoleTypeMappingList'. (NullAllowed)
     */
    public void setWebConfigToRoleTypeMappingList(
            final List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList) {
        _webConfigToRoleTypeMappingList = webConfigToRoleTypeMappingList;
    }

    // ===================================================================================
    //                                                                 Modified Properties
    //                                                                 ===================
    /**
     * {@inheritDoc}
     */
    @Override
    public Set<String> modifiedProperties() {
        return __modifiedProperties.getPropertyNames();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void clearModifiedInfo() {
        __modifiedProperties.clear();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean hasModification() {
        return !__modifiedProperties.isEmpty();
    }

    protected EntityModifiedProperties newModifiedProperties() {
        return new EntityModifiedProperties();
    }

    // ===================================================================================
    //                                                                      Basic Override
    //                                                                      ==============
    /**
     * If primary-keys or columns of the other are same as this one, returns true.
     * @param other The other entity. (NullAllowed)
     * @return Comparing result.
     */
    @Override
    public boolean equals(final Object other) {
        if (other == null || !(other instanceof BsWebCrawlingConfig)) {
            return false;
        }
        final BsWebCrawlingConfig otherEntity = (BsWebCrawlingConfig) other;
        if (!xSV(getId(), otherEntity.getId())) {
            return false;
        }
        return true;
    }

    protected boolean xSV(final Object value1, final Object value2) { // isSameValue()
        return InternalUtil.isSameValue(value1, value2);
    }

    /**
     * Calculates the hash-code from primary-keys or columns.
     * @return The hash-code from primary-key or columns.
     */
    @Override
    public int hashCode() {
        int result = 17;
        result = xCH(result, getTableDbName());
        result = xCH(result, getId());
        return result;
    }

    protected int xCH(final int result, final Object value) { // calculateHashcode()
        return InternalUtil.calculateHashcode(result, value);
    }

    /**
     * @return The display string of all columns and relation existences. (NotNull)
     */
    @Override
    public String toString() {
        return buildDisplayString(InternalUtil.toClassTitle(this), true, true);
    }

    /**
     * @return The display string of basic informations with one-nested relation values. (NotNull)
     */
    @Override
    public String toStringWithRelation() {
        final StringBuilder sb = new StringBuilder();
        sb.append(toString());
        final String l = "\n  ";
        if (_failureUrlList != null) {
            for (final Entity e : _failureUrlList) {
                if (e != null) {
                    sb.append(l).append(xbRDS(e, "failureUrlList"));
                }
            }
        }
        if (_requestHeaderList != null) {
            for (final Entity e : _requestHeaderList) {
                if (e != null) {
                    sb.append(l).append(xbRDS(e, "requestHeaderList"));
                }
            }
        }
        if (_webAuthenticationList != null) {
            for (final Entity e : _webAuthenticationList) {
                if (e != null) {
                    sb.append(l).append(xbRDS(e, "webAuthenticationList"));
                }
            }
        }
        if (_webConfigToBrowserTypeMappingList != null) {
            for (final Entity e : _webConfigToBrowserTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "webConfigToBrowserTypeMappingList"));
                }
            }
        }
        if (_webConfigToLabelTypeMappingList != null) {
            for (final Entity e : _webConfigToLabelTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "webConfigToLabelTypeMappingList"));
                }
            }
        }
        if (_webConfigToRoleTypeMappingList != null) {
            for (final Entity e : _webConfigToRoleTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "webConfigToRoleTypeMappingList"));
                }
            }
        }
        return sb.toString();
    }

    protected String xbRDS(final Entity e, final String name) { // buildRelationDisplayString()
        return e.buildDisplayString(name, true, true);
    }

    /**
     * @param name The name for display. (NullAllowed: If it's null, it does not have a name)
     * @param column Does it contains column values or not?
     * @param relation Does it contains relation existences or not?
     * @return The display string for this entity. (NotNull)
     */
    @Override
    public String buildDisplayString(final String name, final boolean column,
            final boolean relation) {
        final StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append(name).append(column || relation ? ":" : "");
        }
        if (column) {
            sb.append(buildColumnString());
        }
        if (relation) {
            sb.append(buildRelationString());
        }
        sb.append("@").append(Integer.toHexString(hashCode()));
        return sb.toString();
    }

    protected String buildColumnString() {
        final String c = ", ";
        final StringBuilder sb = new StringBuilder();
        sb.append(c).append(getId());
        sb.append(c).append(getName());
        sb.append(c).append(getUrls());
        sb.append(c).append(getIncludedUrls());
        sb.append(c).append(getExcludedUrls());
        sb.append(c).append(getIncludedDocUrls());
        sb.append(c).append(getExcludedDocUrls());
        sb.append(c).append(getDepth());
        sb.append(c).append(getMaxAccessCount());
        sb.append(c).append(getUserAgent());
        sb.append(c).append(getNumOfThread());
        sb.append(c).append(getIntervalTime());
        sb.append(c).append(getBoost());
        sb.append(c).append(getAvailable());
        sb.append(c).append(getSortOrder());
        sb.append(c).append(getCreatedBy());
        sb.append(c).append(getCreatedTime());
        sb.append(c).append(getUpdatedBy());
        sb.append(c).append(getUpdatedTime());
        sb.append(c).append(getDeletedBy());
        sb.append(c).append(getDeletedTime());
        sb.append(c).append(getVersionNo());
        if (sb.length() > 0) {
            sb.delete(0, c.length());
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    protected String buildRelationString() {
        final StringBuilder sb = new StringBuilder();
        final String c = ",";
        if (_failureUrlList != null && !_failureUrlList.isEmpty()) {
            sb.append(c).append("failureUrlList");
        }
        if (_requestHeaderList != null && !_requestHeaderList.isEmpty()) {
            sb.append(c).append("requestHeaderList");
        }
        if (_webAuthenticationList != null && !_webAuthenticationList.isEmpty()) {
            sb.append(c).append("webAuthenticationList");
        }
        if (_webConfigToBrowserTypeMappingList != null
                && !_webConfigToBrowserTypeMappingList.isEmpty()) {
            sb.append(c).append("webConfigToBrowserTypeMappingList");
        }
        if (_webConfigToLabelTypeMappingList != null
                && !_webConfigToLabelTypeMappingList.isEmpty()) {
            sb.append(c).append("webConfigToLabelTypeMappingList");
        }
        if (_webConfigToRoleTypeMappingList != null
                && !_webConfigToRoleTypeMappingList.isEmpty()) {
            sb.append(c).append("webConfigToRoleTypeMappingList");
        }
        if (sb.length() > 0) {
            sb.delete(0, c.length()).insert(0, "(").append(")");
        }
        return sb.toString();
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    /**
     * [get] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @return The value of the column 'ID'. (NullAllowed)
     */
    public Long getId() {
        return _id;
    }

    /**
     * [set] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @param id The value of the column 'ID'. (NullAllowed)
     */
    public void setId(final Long id) {
        __modifiedProperties.addPropertyName("id");
        _id = id;
    }

    /**
     * [get] NAME: {NotNull, VARCHAR(200)} <br />
     * @return The value of the column 'NAME'. (NullAllowed)
     */
    public String getName() {
        return _name;
    }

    /**
     * [set] NAME: {NotNull, VARCHAR(200)} <br />
     * @param name The value of the column 'NAME'. (NullAllowed)
     */
    public void setName(final String name) {
        __modifiedProperties.addPropertyName("name");
        _name = name;
    }

    /**
     * [get] URLS: {NotNull, VARCHAR(4000)} <br />
     * @return The value of the column 'URLS'. (NullAllowed)
     */
    public String getUrls() {
        return _urls;
    }

    /**
     * [set] URLS: {NotNull, VARCHAR(4000)} <br />
     * @param urls The value of the column 'URLS'. (NullAllowed)
     */
    public void setUrls(final String urls) {
        __modifiedProperties.addPropertyName("urls");
        _urls = urls;
    }

    /**
     * [get] INCLUDED_URLS: {VARCHAR(4000)} <br />
     * @return The value of the column 'INCLUDED_URLS'. (NullAllowed)
     */
    public String getIncludedUrls() {
        return _includedUrls;
    }

    /**
     * [set] INCLUDED_URLS: {VARCHAR(4000)} <br />
     * @param includedUrls The value of the column 'INCLUDED_URLS'. (NullAllowed)
     */
    public void setIncludedUrls(final String includedUrls) {
        __modifiedProperties.addPropertyName("includedUrls");
        _includedUrls = includedUrls;
    }

    /**
     * [get] EXCLUDED_URLS: {VARCHAR(4000)} <br />
     * @return The value of the column 'EXCLUDED_URLS'. (NullAllowed)
     */
    public String getExcludedUrls() {
        return _excludedUrls;
    }

    /**
     * [set] EXCLUDED_URLS: {VARCHAR(4000)} <br />
     * @param excludedUrls The value of the column 'EXCLUDED_URLS'. (NullAllowed)
     */
    public void setExcludedUrls(final String excludedUrls) {
        __modifiedProperties.addPropertyName("excludedUrls");
        _excludedUrls = excludedUrls;
    }

    /**
     * [get] INCLUDED_DOC_URLS: {VARCHAR(4000)} <br />
     * @return The value of the column 'INCLUDED_DOC_URLS'. (NullAllowed)
     */
    public String getIncludedDocUrls() {
        return _includedDocUrls;
    }

    /**
     * [set] INCLUDED_DOC_URLS: {VARCHAR(4000)} <br />
     * @param includedDocUrls The value of the column 'INCLUDED_DOC_URLS'. (NullAllowed)
     */
    public void setIncludedDocUrls(final String includedDocUrls) {
        __modifiedProperties.addPropertyName("includedDocUrls");
        _includedDocUrls = includedDocUrls;
    }

    /**
     * [get] EXCLUDED_DOC_URLS: {VARCHAR(4000)} <br />
     * @return The value of the column 'EXCLUDED_DOC_URLS'. (NullAllowed)
     */
    public String getExcludedDocUrls() {
        return _excludedDocUrls;
    }

    /**
     * [set] EXCLUDED_DOC_URLS: {VARCHAR(4000)} <br />
     * @param excludedDocUrls The value of the column 'EXCLUDED_DOC_URLS'. (NullAllowed)
     */
    public void setExcludedDocUrls(final String excludedDocUrls) {
        __modifiedProperties.addPropertyName("excludedDocUrls");
        _excludedDocUrls = excludedDocUrls;
    }

    /**
     * [get] DEPTH: {INTEGER(10)} <br />
     * @return The value of the column 'DEPTH'. (NullAllowed)
     */
    public Integer getDepth() {
        return _depth;
    }

    /**
     * [set] DEPTH: {INTEGER(10)} <br />
     * @param depth The value of the column 'DEPTH'. (NullAllowed)
     */
    public void setDepth(final Integer depth) {
        __modifiedProperties.addPropertyName("depth");
        _depth = depth;
    }

    /**
     * [get] MAX_ACCESS_COUNT: {BIGINT(19)} <br />
     * @return The value of the column 'MAX_ACCESS_COUNT'. (NullAllowed)
     */
    public Long getMaxAccessCount() {
        return _maxAccessCount;
    }

    /**
     * [set] MAX_ACCESS_COUNT: {BIGINT(19)} <br />
     * @param maxAccessCount The value of the column 'MAX_ACCESS_COUNT'. (NullAllowed)
     */
    public void setMaxAccessCount(final Long maxAccessCount) {
        __modifiedProperties.addPropertyName("maxAccessCount");
        _maxAccessCount = maxAccessCount;
    }

    /**
     * [get] USER_AGENT: {NotNull, VARCHAR(200)} <br />
     * @return The value of the column 'USER_AGENT'. (NullAllowed)
     */
    public String getUserAgent() {
        return _userAgent;
    }

    /**
     * [set] USER_AGENT: {NotNull, VARCHAR(200)} <br />
     * @param userAgent The value of the column 'USER_AGENT'. (NullAllowed)
     */
    public void setUserAgent(final String userAgent) {
        __modifiedProperties.addPropertyName("userAgent");
        _userAgent = userAgent;
    }

    /**
     * [get] NUM_OF_THREAD: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'NUM_OF_THREAD'. (NullAllowed)
     */
    public Integer getNumOfThread() {
        return _numOfThread;
    }

    /**
     * [set] NUM_OF_THREAD: {NotNull, INTEGER(10)} <br />
     * @param numOfThread The value of the column 'NUM_OF_THREAD'. (NullAllowed)
     */
    public void setNumOfThread(final Integer numOfThread) {
        __modifiedProperties.addPropertyName("numOfThread");
        _numOfThread = numOfThread;
    }

    /**
     * [get] INTERVAL_TIME: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'INTERVAL_TIME'. (NullAllowed)
     */
    public Integer getIntervalTime() {
        return _intervalTime;
    }

    /**
     * [set] INTERVAL_TIME: {NotNull, INTEGER(10)} <br />
     * @param intervalTime The value of the column 'INTERVAL_TIME'. (NullAllowed)
     */
    public void setIntervalTime(final Integer intervalTime) {
        __modifiedProperties.addPropertyName("intervalTime");
        _intervalTime = intervalTime;
    }

    /**
     * [get] BOOST: {NotNull, DOUBLE(17)} <br />
     * @return The value of the column 'BOOST'. (NullAllowed)
     */
    public java.math.BigDecimal getBoost() {
        return _boost;
    }

    /**
     * [set] BOOST: {NotNull, DOUBLE(17)} <br />
     * @param boost The value of the column 'BOOST'. (NullAllowed)
     */
    public void setBoost(final java.math.BigDecimal boost) {
        __modifiedProperties.addPropertyName("boost");
        _boost = boost;
    }

    /**
     * [get] AVAILABLE: {NotNull, VARCHAR(1)} <br />
     * @return The value of the column 'AVAILABLE'. (NullAllowed)
     */
    public String getAvailable() {
        return _available;
    }

    /**
     * [set] AVAILABLE: {NotNull, VARCHAR(1)} <br />
     * @param available The value of the column 'AVAILABLE'. (NullAllowed)
     */
    public void setAvailable(final String available) {
        __modifiedProperties.addPropertyName("available");
        _available = available;
    }

    /**
     * [get] SORT_ORDER: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'SORT_ORDER'. (NullAllowed)
     */
    public Integer getSortOrder() {
        return _sortOrder;
    }

    /**
     * [set] SORT_ORDER: {NotNull, INTEGER(10)} <br />
     * @param sortOrder The value of the column 'SORT_ORDER'. (NullAllowed)
     */
    public void setSortOrder(final Integer sortOrder) {
        __modifiedProperties.addPropertyName("sortOrder");
        _sortOrder = sortOrder;
    }

    /**
     * [get] CREATED_BY: {NotNull, VARCHAR(255)} <br />
     * @return The value of the column 'CREATED_BY'. (NullAllowed)
     */
    public String getCreatedBy() {
        return _createdBy;
    }

    /**
     * [set] CREATED_BY: {NotNull, VARCHAR(255)} <br />
     * @param createdBy The value of the column 'CREATED_BY'. (NullAllowed)
     */
    public void setCreatedBy(final String createdBy) {
        __modifiedProperties.addPropertyName("createdBy");
        _createdBy = createdBy;
    }

    /**
     * [get] CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'CREATED_TIME'. (NullAllowed)
     */
    public java.sql.Timestamp getCreatedTime() {
        return _createdTime;
    }

    /**
     * [set] CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} <br />
     * @param createdTime The value of the column 'CREATED_TIME'. (NullAllowed)
     */
    public void setCreatedTime(final java.sql.Timestamp createdTime) {
        __modifiedProperties.addPropertyName("createdTime");
        _createdTime = createdTime;
    }

    /**
     * [get] UPDATED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'UPDATED_BY'. (NullAllowed)
     */
    public String getUpdatedBy() {
        return _updatedBy;
    }

    /**
     * [set] UPDATED_BY: {VARCHAR(255)} <br />
     * @param updatedBy The value of the column 'UPDATED_BY'. (NullAllowed)
     */
    public void setUpdatedBy(final String updatedBy) {
        __modifiedProperties.addPropertyName("updatedBy");
        _updatedBy = updatedBy;
    }

    /**
     * [get] UPDATED_TIME: {TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'UPDATED_TIME'. (NullAllowed)
     */
    public java.sql.Timestamp getUpdatedTime() {
        return _updatedTime;
    }

    /**
     * [set] UPDATED_TIME: {TIMESTAMP(23, 10)} <br />
     * @param updatedTime The value of the column 'UPDATED_TIME'. (NullAllowed)
     */
    public void setUpdatedTime(final java.sql.Timestamp updatedTime) {
        __modifiedProperties.addPropertyName("updatedTime");
        _updatedTime = updatedTime;
    }

    /**
     * [get] DELETED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'DELETED_BY'. (NullAllowed)
     */
    public String getDeletedBy() {
        return _deletedBy;
    }

    /**
     * [set] DELETED_BY: {VARCHAR(255)} <br />
     * @param deletedBy The value of the column 'DELETED_BY'. (NullAllowed)
     */
    public void setDeletedBy(final String deletedBy) {
        __modifiedProperties.addPropertyName("deletedBy");
        _deletedBy = deletedBy;
    }

    /**
     * [get] DELETED_TIME: {TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'DELETED_TIME'. (NullAllowed)
     */
    public java.sql.Timestamp getDeletedTime() {
        return _deletedTime;
    }

    /**
     * [set] DELETED_TIME: {TIMESTAMP(23, 10)} <br />
     * @param deletedTime The value of the column 'DELETED_TIME'. (NullAllowed)
     */
    public void setDeletedTime(final java.sql.Timestamp deletedTime) {
        __modifiedProperties.addPropertyName("deletedTime");
        _deletedTime = deletedTime;
    }

    /**
     * [get] VERSION_NO: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'VERSION_NO'. (NullAllowed)
     */
    public Integer getVersionNo() {
        return _versionNo;
    }

    /**
     * [set] VERSION_NO: {NotNull, INTEGER(10)} <br />
     * @param versionNo The value of the column 'VERSION_NO'. (NullAllowed)
     */
    public void setVersionNo(final Integer versionNo) {
        __modifiedProperties.addPropertyName("versionNo");
        _versionNo = versionNo;
    }
}
