<tiles:insert template="/WEB-INF/view/common/admin/layout.jsp"
	flush="true">
	<tiles:put name="title">
		<bean:message key="labels.failure_url_configuration" />
	</tiles:put>
	<tiles:put name="header" value="/WEB-INF/view/common/admin/header.jsp" />
	<tiles:put name="footer" value="/WEB-INF/view/common/admin/footer.jsp" />
	<tiles:put name="menu" value="/WEB-INF/view/common/admin/menu.jsp" />
	<tiles:put name="menuType" value="failureUrl" />
	<tiles:put name="headerScript" type="string"></tiles:put>
	<tiles:put name="body" type="string">

		<h3>
			<bean:message key="labels.failure_url_configuration" />
		</h3>

		<!-- Message: BEGIN -->
		<div>
			<html:messages id="msg" message="true">
				<div class="alert-message info"><bean:write name="msg" ignore="true" /></div>
			</html:messages>
			<html:errors />
		</div>
		<!-- Message: END -->

		<!-- Search: BEGIN -->
		<div class="form-table">
			<s:form>
				<table>
					<tbody>
						<tr>
							<th><bean:message key="labels.failure_url_search_url" /></th>
							<td><html:text property="searchParams.url"></html:text></td>
						</tr>
						<tr>
							<th><bean:message
									key="labels.failure_url_search_error_count" /></th>
							<td><html:text property="searchParams.errorCountMin"
									size="2" styleClass="mini"></html:text> - <html:text
									property="searchParams.errorCountMax" size="2"
									styleClass="mini"></html:text></td>
						<tr>
							<th><bean:message key="labels.failure_url_search_error_name" /></th>
							<td><html:text property="searchParams.errorName"></html:text></td>
						</tr>
					</tbody>
				</table>
				<div class="row">
					<div class="span8 offset4">
						<input type="submit" class="btn mini primary" name="search"
							value="<bean:message key="labels.crud_button_search"/>" /> <input
							type="submit" class="btn small" name="reset"
							value="<bean:message key="labels.crud_button_reset"/>" />
					</div>
				</div>
			</s:form>
		</div>
		<!-- Search: END -->

		<!-- List: BEGIN -->
		<div class="list-table">
			<c:if test="${failureUrlPager.allRecordCount == 0}">
				<p class="alert-message warning">
					<bean:message key="labels.list_could_not_find_crud_table" />
				</p>
			</c:if>
			<c:if test="${failureUrlPager.allRecordCount > 0}">
				<table class="bordered-table zebra-striped">
					<thead>
						<tr>
							<th style="text-align: center;"><bean:message
									key="labels.failure_url_url" /></th>
							<th style="text-align: center; width: 150px;"><bean:message
									key="labels.failure_url_last_access_time" /></th>
							<th style="text-align: center; width: 100px">&nbsp;</th>
						</tr>
					</thead>
					<tbody>
						<c:forEach var="data" varStatus="s" items="${failureUrlItems}">
							<tr class="${s.index % 2 == 0 ? 'row1' : 'row2'}">
								<td><div style="width: 380px; overflow-x: auto;">${f:h(data.url)}</div></td>
								<td style="text-align: center;">${f:h(data.lastAccessTimeForList)}</td>
								<td style="text-align: center;"><s:link
										href="confirmpage/4/${f:u(data.id)}">
										<bean:message key="labels.failure_url_link_confirm" />
									</s:link> <s:link href="deletepage/3/${f:u(data.id)}">
										<bean:message key="labels.crud_link_delete" />
									</s:link></td>
							</tr>
						</c:forEach>
					</tbody>
				</table>

				<div class="span12 center">
					<script>
				<!--
					function confirmToDeleteAll() {
						if (confirm('<bean:message key="labels.failure_url_delete_all_confirmation"/>')) {
							return true;
						} else {
							return false;
						}
					}
				// -->
				</script>
					<s:link href="deleteall" onclick="return confirmToDeleteAll();"
						styleClass="btn">
						<bean:message key="labels.search_log_delete_all_link" />
					</s:link>
				</div>

				<!-- Page Navigation: BEGIN -->
				<div class="row center">
					<div class="pagination">
						<ul>
							<c:if test="${failureUrlPager.existPrePage}">
								<li class="prev"><s:link
										href="list/${failureUrlPager.currentPageNumber - 1}">
										<bean:message key="labels.crud_link_prev_page" />
									</s:link></li>
							</c:if>
							<c:if test="${!failureUrlPager.existPrePage}">
								<li class="prev disabled"><a href="#"><bean:message
											key="labels.crud_link_prev_page" /></a></li>
							</c:if>
							<c:forEach var="p" varStatus="s"
								items="${failureUrlPager.pageNumberList}">
								<li
									<c:if test="${p == failureUrlPager.currentPageNumber}">class="active"</c:if>>
									<s:link href="list/${p}">${p}</s:link>
								</li>
							</c:forEach>
							<c:if test="${failureUrlPager.existNextPage}">
								<li class="next"><s:link
										href="list/${failureUrlPager.currentPageNumber + 1}">
										<bean:message key="labels.crud_link_next_page" />
									</s:link></li>
							</c:if>
							<c:if test="${!failureUrlPager.existNextPage}">
								<li class="next disabled"><a href="#"><bean:message
											key="labels.crud_link_next_page" /></a></li>
							</c:if>
						</ul>
					</div>
					<div>
						<span><bean:message key="labels.pagination_page_guide_msg"
								arg0="${f:h(failureUrlPager.currentPageNumber)}"
								arg1="${f:h(failureUrlPager.allPageCount)}"
								arg2="${f:h(failureUrlPager.allRecordCount)}" /></span>
					</div>
				</div>
				<!-- Page Navigation: END -->
			</c:if>
		</div>
		<!-- List: END -->

	</tiles:put>
</tiles:insert>
