/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.ExtendedMessageHandler;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.Tag;
import ow.routing.CallbackOnNodeFailure;
import ow.routing.CallbackOnRoute;
import ow.routing.CallbackResultFilter;
import ow.routing.RoutingAlgorithm;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingAlgorithmProvider;
import ow.routing.RoutingException;
import ow.routing.RoutingHop;
import ow.routing.RoutingResult;
import ow.routing.RoutingRuntime;
import ow.routing.RoutingService;
import ow.routing.RoutingServiceConfiguration;
import ow.routing.impl.RoutingDriverMessageFactory;
import ow.stat.impl.StatMessageFactory;

public abstract class AbstractRoutingDriver
implements RoutingRuntime,
RoutingService {
    protected static final Logger logger = Logger.getLogger("routing");
    private final Message pingMessage;
    private final Message ackMessage;
    protected RoutingServiceConfiguration config;
    private MessagingProvider msgProvider;
    protected MessageReceiver receiver;
    protected MessageSender sender;
    private final RoutingAlgorithmProvider algoProvider;
    private final RoutingAlgorithmConfiguration algoConfig;
    protected final boolean adjustLastHop;
    protected final boolean queryToAllContacts;
    protected RoutingAlgorithm algorithm;
    protected MessagingAddress statCollectorAddress;
    private final IDAddressPair selfIDAddressPair;
    private int selfAddressHashCode;
    Map<Integer, List<MessageHandler>> handlerTable = Collections.synchronizedMap(new HashMap());
    private List<CallbackOnRoute> routeCallbackList = Collections.synchronizedList(new ArrayList(1));
    private List<CallbackOnNodeFailure> failureCallbackList = Collections.synchronizedList(new ArrayList(1));

    protected AbstractRoutingDriver(RoutingServiceConfiguration conf, MessagingProvider provider, MessageReceiver receiver, RoutingAlgorithmProvider algoProvider, RoutingAlgorithmConfiguration algoConf, ID selfID) throws IOException {
        this.msgProvider = provider;
        this.receiver = receiver;
        this.sender = this.receiver.getSender();
        this.algoProvider = algoProvider;
        this.algoConfig = algoConf;
        this.adjustLastHop = algoConf.adjustRoot();
        this.queryToAllContacts = algoConf.queryToAllContacts();
        this.config = conf;
        this.receiver.addHandler(new RoutingDrvMessageHandler());
        MessagingAddress selfAddr = this.receiver.getSelfAddress();
        int idSizeInByte = algoConf.getIDSizeInByte();
        if (selfID != null) {
            selfID = selfID.copy(idSizeInByte);
            this.selfIDAddressPair = IDAddressPair.getIDAddressPair(selfID, selfAddr);
        } else {
            this.selfIDAddressPair = IDAddressPair.getIDAddressPair(idSizeInByte, selfAddr);
        }
        this.selfAddressHashCode = selfAddr.hashCode();
        this.pingMessage = RoutingDriverMessageFactory.getPingMessage(this.selfIDAddressPair);
        this.ackMessage = RoutingDriverMessageFactory.getAckMessage(this.selfIDAddressPair);
        this.prepareHandlers();
    }

    public RoutingResult routeToRootNode(ID target, int numRootCandidates) throws RoutingException {
        ID[] tgts = new ID[]{target};
        RoutingResult[] res = this.routeToRootNode(tgts, numRootCandidates);
        if (res == null || res[0] == null) {
            throw new RoutingException();
        }
        return res[0];
    }

    public RoutingResult routeToClosestNode(ID target, int numRootCandidates) throws RoutingException {
        ID[] tgts = new ID[]{target};
        RoutingResult[] res = this.routeToClosestNode(tgts, numRootCandidates);
        if (res == null || res[0] == null) {
            throw new RoutingException();
        }
        return res[0];
    }

    public RoutingResult invokeCallbacksOnRoute(ID target, int numRootCandidates, Serializable[] returnedValue, CallbackResultFilter filter, int tag, Serializable[] args) throws RoutingException {
        ID[] tgts = new ID[]{target};
        Serializable[][] returnedValues = new Serializable[][]{returnedValue};
        Serializable[][] argss = new Serializable[][]{args};
        RoutingResult[] res = this.invokeCallbacksOnRoute(tgts, numRootCandidates, returnedValues, filter, tag, argss);
        if (res == null || res[0] == null) {
            throw new RoutingException();
        }
        return res[0];
    }

    public void leave() {
        this.algorithm.reset();
    }

    public synchronized void stop() {
        logger.log(Level.INFO, "RoutingDriver#stop() called.");
        if (this.receiver != null) {
            this.receiver.stop();
            this.receiver = null;
            this.sender = null;
        }
        if (this.algorithm != null) {
            this.algorithm.stop();
            this.algorithm = null;
        }
    }

    public synchronized void suspend() {
        if (this.receiver != null) {
            this.receiver.stop();
        }
        if (this.algorithm != null) {
            this.algorithm.suspend();
        }
    }

    public synchronized void resume() {
        if (this.receiver != null) {
            this.receiver.start();
        }
        if (this.algorithm != null) {
            this.algorithm.resume();
        }
    }

    public RoutingServiceConfiguration getConfiguration() {
        return this.config;
    }

    public MessagingProvider getMessagingProvider() {
        return this.msgProvider;
    }

    public MessageSender getMessageSender() {
        return this.receiver.getSender();
    }

    public RoutingAlgorithm getRoutingAlgorithm() {
        return this.algorithm;
    }

    public RoutingAlgorithm setRoutingAlgorithm(RoutingAlgorithm algo) {
        RoutingAlgorithm old = this.algorithm;
        if (this.algorithm != null) {
            this.algorithm.stop();
        }
        this.algorithm = algo;
        return old;
    }

    public void setStatCollectorAddress(MessagingAddress address) {
        this.statCollectorAddress = address;
        this.msgProvider.setMessagingCollectorAddress(address);
    }

    public String routeToString(RoutingHop[] route) {
        if (route == null) {
            return "";
        }
        long timeBase = -1L;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (RoutingHop hop : route) {
            if (timeBase < 0L) {
                timeBase = hop.getTime();
            }
            sb.append("\n ");
            sb.append(hop.getIDAddressPair());
            sb.append(" (");
            sb.append(hop.getTime() - timeBase);
            sb.append(")");
        }
        sb.append("\n]");
        return sb.toString();
    }

    public boolean ping(MessageSender sender, IDAddressPair target) throws IOException {
        Message ret = sender.sendAndReceive(target.getAddress(), this.pingMessage);
        int tag = ret.getTag();
        if (tag == Tag.ACK.getNumber()) {
            this.algorithm.touch(target);
            return true;
        }
        logger.log(Level.WARNING, "Received message should be ACK, but it is: " + tag);
        if (this.algorithm != null) {
            this.algorithm.fail(target);
        }
        return false;
    }

    public IDAddressPair getSelfIDAddressPair() {
        MessagingAddress currentSelfAddress = this.receiver.getSelfAddress();
        if (currentSelfAddress.hashCode() != this.selfAddressHashCode) {
            this.selfIDAddressPair.setAddressAndRecalculateID(currentSelfAddress);
            this.selfAddressHashCode = currentSelfAddress.hashCode();
            try {
                this.algoProvider.initializeAlgorithmInstance(this.algoConfig, this);
            }
            catch (InvalidAlgorithmParameterException e) {
                logger.log(Level.SEVERE, "Could not create a RoutingAlgorithm instance.");
            }
        }
        return this.selfIDAddressPair;
    }

    public void addMessageHandler(int tag, MessageHandler handler) {
        List<MessageHandler> handlerList = this.handlerTable.get(tag);
        if (handlerList == null) {
            handlerList = Collections.synchronizedList(new ArrayList(1));
            this.handlerTable.put(tag, handlerList);
        }
        handlerList.add(handler);
    }

    public void addCallbackOnRoute(CallbackOnRoute callback) {
        this.routeCallbackList.add(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Serializable invokeCallbacks(ID target, int tag, Serializable[] args, CallbackResultFilter filter, IDAddressPair lastHop, boolean onRootNode) {
        MessagingAddress lastHopAddress = lastHop != null ? lastHop.getAddress() : null;
        logger.log(Level.INFO, "Invoke " + this.routeCallbackList.size() + " callbacks. lastHop: " + lastHopAddress + ", onRootNode: " + onRootNode + ", on " + this.selfIDAddressPair.getAddress());
        Serializable result = null;
        List<CallbackOnRoute> list = this.routeCallbackList;
        synchronized (list) {
            for (CallbackOnRoute cb : this.routeCallbackList) {
                result = cb.process(target, tag, args, filter, lastHop, onRootNode);
            }
        }
        if (filter != null) {
            try {
                result = filter.filter(result);
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "An Exception thrown in CallbackResultFilter#filter().", e);
            }
        }
        return result;
    }

    public void addCallbackOnNodeFailure(CallbackOnNodeFailure callback) {
        this.failureCallbackList.add(callback);
    }

    protected void fail(IDAddressPair failedNode) {
        if (this.algorithm != null) {
            this.algorithm.fail(failedNode);
        }
        for (CallbackOnNodeFailure cb : this.failureCallbackList) {
            cb.fail(failedNode);
        }
    }

    private void prepareHandlers() {
        MessageHandler handler = new MessageHandler(){

            public Message process(Message msg) {
                return AbstractRoutingDriver.this.ackMessage;
            }
        };
        this.addMessageHandler(Tag.PING.getNumber(), handler);
        handler = new MessageHandler(){

            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                int num = (Integer)contents[0];
                MessagingAddress reqSource = msg.getSource().getAddress();
                AbstractRoutingDriver.this.msgProvider.setMessagingCollectorAddress(reqSource);
                IDAddressPair[] neighbors = AbstractRoutingDriver.this.algorithm.rootCandidates(AbstractRoutingDriver.this.selfIDAddressPair.getID(), num);
                return StatMessageFactory.getRepNeighbors(AbstractRoutingDriver.this.selfIDAddressPair, neighbors);
            }
        };
        this.addMessageHandler(Tag.REQ_NEIGHBORS.getNumber(), handler);
    }

    private class RoutingDrvMessageHandler
    implements ExtendedMessageHandler {
        private RoutingDrvMessageHandler() {
        }

        public Message process(Message msg) {
            Message ret = null;
            int tag = msg.getTag();
            List<MessageHandler> handlerList = AbstractRoutingDriver.this.handlerTable.get(tag);
            if (handlerList != null) {
                for (MessageHandler handler : handlerList) {
                    try {
                        ret = handler.process(msg);
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "A MessageHandler threw an Exception.", e);
                    }
                }
            }
            return ret;
        }

        public void postProcess(Message msg) {
            IDAddressPair src;
            if (AbstractRoutingDriver.this.algorithm != null && (src = msg.getSource()).getID() != null && src.getAddress() != null) {
                AbstractRoutingDriver.this.algorithm.touch(src);
            }
        }
    }
}

