/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import ow.dht.DHT;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.id.IDUtility;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.CommandUtil;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PutCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"put"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "put [-status] <key> <value> [<value> ...] [- <key> <value> [<value> ...] ...]";
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) {
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        boolean showStatus = false;
        HashMap valueMap = new HashMap();
        int argIndex = 0;
        if (argIndex < args.length && args[argIndex].startsWith("-")) {
            showStatus = true;
            ++argIndex;
        }
        ArrayList<String> keyList = new ArrayList<String>();
        do {
            int nargs;
            if ((nargs = args.length - argIndex) >= 3) {
                for (int j = 2; j < nargs; ++j) {
                    if (!"-".equals(args[argIndex + j])) continue;
                    nargs = j;
                    break;
                }
            }
            if (nargs < 2) {
                out.print("usage: " + this.getHelp() + "\r\n");
                out.flush();
                return false;
            }
            ID key = IDUtility.parseID(args[argIndex], dht.getRoutingAlgorithmConfiguration().getIDSizeInByte());
            keyList.add(args[argIndex]);
            HashSet<String> s = (HashSet<String>)valueMap.get(key);
            if (s == null) {
                s = new HashSet<String>();
                valueMap.put(key, s);
            }
            for (int j = 1; j < nargs; ++j) {
                s.add(args[argIndex + j]);
            }
            argIndex += nargs;
            while (argIndex < args.length && "-".equals(args[argIndex])) {
                ++argIndex;
            }
        } while (argIndex < args.length);
        DHT.PutRequest[] requests = new DHT.PutRequest[valueMap.keySet().size()];
        argIndex = 0;
        for (ID k : valueMap.keySet()) {
            Set valueSet = (Set)valueMap.get(k);
            String[] values = new String[valueSet.size()];
            int j = 0;
            for (String v : valueSet) {
                values[j++] = v;
            }
            requests[argIndex++] = new DHT.PutRequest<String>(k, values);
        }
        Set<ValueInfo<String>>[] values = null;
        try {
            values = dht.put(requests);
            for (argIndex = 0; argIndex < requests.length; ++argIndex) {
                if (values[argIndex] != null) continue;
                out.print("routing failed: " + (String)keyList.get(argIndex) + "\r\n");
            }
            if (showStatus) {
                out.print(CommandUtil.buildStatusMessage(context.getOpaqueData(), -1));
                out.flush();
            }
        }
        catch (Exception e) {
            out.print("An exception thrown:\r\n");
            e.printStackTrace(out);
            out.flush();
        }
        return false;
    }
}

