/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetSecretCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"setsecret"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "setsecret <secret>";
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) {
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            out.print("usage: " + this.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        ByteArray secret = null;
        try {
            secret = ByteArray.valueOf(args[0], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        secret = secret.hashWithSHA1();
        dht.setHashedSecretForPut(secret);
        return false;
    }
}

