/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.Security;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.adaptor.AdaptorServerSocketFactory;
import mx4j.tools.adaptor.PlainAdaptorServerSocketFactory;
import mx4j.tools.adaptor.http.DefaultProcessor;
import mx4j.tools.adaptor.http.HttpAdaptorMBean;
import mx4j.tools.adaptor.http.HttpCommandProcessor;
import mx4j.tools.adaptor.http.HttpException;
import mx4j.tools.adaptor.http.HttpInputStream;
import mx4j.tools.adaptor.http.HttpOutputStream;
import mx4j.tools.adaptor.http.ProcessorMBean;
import mx4j.util.Base64Codec;
import org.w3c.dom.Document;

public class HttpAdaptor
implements HttpAdaptorMBean,
MBeanRegistration {
    private static final String VERSION = "2.1.0";
    private int port = 8080;
    private String host = "localhost";
    private MBeanServer server;
    private ServerSocket serverSocket;
    private boolean alive;
    private Map commands = new HashMap();
    private ProcessorMBean processor = null;
    private ObjectName processorName = null;
    private ProcessorMBean defaultProcessor = new DefaultProcessor();
    private String authenticationMethod = "none";
    private String realm = "MX4J";
    private Map authorizations = new HashMap();
    private HashSet JAASAuthorizedUsernames = new HashSet();
    private String JAASLoginModuleName = null;
    private AdaptorServerSocketFactory socketFactory = null;
    private ObjectName factoryName;
    private String processorClass;
    private Date startDate;
    private long requestsCount;
    private Constructor JDK15LoginContext = null;
    private Configuration conf = null;
    private String[][] defaultCommandProcessors = new String[][]{{"server", "mx4j.tools.adaptor.http.ServerCommandProcessor"}, {"serverbydomain", "mx4j.tools.adaptor.http.ServerByDomainCommandProcessor"}, {"mbean", "mx4j.tools.adaptor.http.MBeanCommandProcessor"}, {"setattributes", "mx4j.tools.adaptor.http.SetAttributesCommandProcessor"}, {"setattribute", "mx4j.tools.adaptor.http.SetAttributeCommandProcessor"}, {"getattribute", "mx4j.tools.adaptor.http.GetAttributeCommandProcessor"}, {"delete", "mx4j.tools.adaptor.http.DeleteMBeanCommandProcessor"}, {"invoke", "mx4j.tools.adaptor.http.InvokeOperationCommandProcessor"}, {"create", "mx4j.tools.adaptor.http.CreateMBeanCommandProcessor"}, {"constructors", "mx4j.tools.adaptor.http.ConstructorsCommandProcessor"}, {"relation", "mx4j.tools.adaptor.http.RelationCommandProcessor"}, {"empty", "mx4j.tools.adaptor.http.EmptyCommandProcessor"}};
    private DocumentBuilder builder;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public HttpAdaptor() {
    }

    public HttpAdaptor(int port) {
        this.port = port;
    }

    public HttpAdaptor(String host) {
        this.host = host;
    }

    public HttpAdaptor(int port, String host) {
        this.port = port;
        this.host = host;
    }

    public void setPort(int port) {
        if (this.alive) {
            throw new IllegalArgumentException("Not possible to change port with the server running");
        }
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String host) {
        if (this.alive) {
            throw new IllegalArgumentException("Not possible to change port with the server running");
        }
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setAuthenticationMethod(String method) {
        if (this.alive) {
            throw new IllegalArgumentException("Not possible to change authentication method with the server running");
        }
        if (method == null || !method.equals("none") && !method.equals("basic") && !method.equals("digest")) {
            throw new IllegalArgumentException("Only accept methods none/basic/digest");
        }
        this.authenticationMethod = method;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setProcessor(ProcessorMBean processor) {
        this.processor = processor;
        this.processorName = null;
    }

    public void setProcessorClass(String processorClass) {
        this.processorClass = processorClass;
    }

    public void setProcessorNameString(String processorName) throws MalformedObjectNameException {
        this.processorName = new ObjectName(processorName);
    }

    public void setProcessorName(ObjectName processorName) {
        this.processor = null;
        this.processorName = processorName;
    }

    public ProcessorMBean getProcessor() {
        return this.processor;
    }

    public ObjectName getProcessorName() {
        return this.processorName;
    }

    public void setSocketFactory(AdaptorServerSocketFactory factory) {
        this.factoryName = null;
        this.socketFactory = factory;
    }

    public void setSocketFactoryName(ObjectName factoryName) {
        this.socketFactory = null;
        this.factoryName = factoryName;
    }

    public void setSocketFactoryNameString(String factoryName) throws MalformedObjectNameException {
        this.socketFactory = null;
        this.factoryName = new ObjectName(factoryName);
    }

    public boolean isActive() {
        return this.alive;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public long getRequestsCount() {
        return this.requestsCount;
    }

    public String getVersion() {
        return VERSION;
    }

    public void addCommandProcessor(String path, HttpCommandProcessor processor) {
        this.commands.put(path, processor);
        if (this.alive) {
            processor.setMBeanServer(this.server);
            processor.setDocumentBuilder(this.builder);
        }
    }

    public void addCommandProcessor(String path, String processorClass) {
        try {
            HttpCommandProcessor processor = (HttpCommandProcessor)Class.forName(processorClass).newInstance();
            this.addCommandProcessor(path, processor);
        }
        catch (Exception e) {
            Logger log = this.getLogger();
            log.error("Exception creating Command Processor of class " + processorClass, e);
        }
    }

    public void removeCommandProcessor(String path) {
        if (this.commands.containsKey(path)) {
            this.commands.remove(path);
        }
    }

    public void start() throws IOException {
        final Logger logger = this.getLogger();
        if (this.server != null) {
            this.serverSocket = this.createServerSocket();
            if (this.serverSocket == null) {
                logger.error("Server socket is null");
                return;
            }
            if (this.processorClass != null && this.processorName != null) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Building processor class of type " + this.processorClass + " and name " + this.processorName);
                }
                try {
                    this.server.createMBean(this.processorClass, this.processorName, null);
                }
                catch (JMException e) {
                    logger.error("Exception creating processor class", e);
                }
            }
            Iterator i = this.commands.values().iterator();
            while (i.hasNext()) {
                HttpCommandProcessor processor = (HttpCommandProcessor)i.next();
                processor.setMBeanServer(this.server);
                processor.setDocumentBuilder(this.builder);
            }
            if (logger.isEnabledFor(10)) {
                logger.debug("HttpAdaptor server listening on port " + this.port);
            }
            this.alive = true;
            Thread serverThread = new Thread(new Runnable(){

                public void run() {
                    if (logger.isEnabledFor(20)) {
                        logger.info("HttpAdaptor version 2.1.0 started on port " + HttpAdaptor.this.port);
                    }
                    HttpAdaptor.this.startDate = new Date();
                    HttpAdaptor.this.requestsCount = 0L;
                    while (HttpAdaptor.this.alive) {
                        try {
                            Socket client = null;
                            client = HttpAdaptor.this.serverSocket.accept();
                            if (!HttpAdaptor.this.alive) {
                                client.close();
                                break;
                            }
                            HttpAdaptor httpAdaptor = HttpAdaptor.this;
                            httpAdaptor.requestsCount = httpAdaptor.requestsCount + 1L;
                            new HttpClient(client).start();
                        }
                        catch (InterruptedIOException e) {
                        }
                        catch (IOException e) {
                        }
                        catch (Exception e) {
                            logger.warn("Exception during request processing", e);
                        }
                        catch (Error e) {
                            logger.error("Error during request processing", e);
                        }
                    }
                    try {
                        HttpAdaptor.this.serverSocket.close();
                    }
                    catch (IOException e) {
                        logger.warn("Exception closing the server", e);
                    }
                    HttpAdaptor.this.serverSocket = null;
                    HttpAdaptor.this.alive = false;
                    if (logger.isEnabledFor(20)) {
                        logger.info("HttpAdaptor version 2.1.0 stopped on port " + HttpAdaptor.this.port);
                    }
                }
            });
            serverThread.start();
        } else if (logger.isEnabledFor(20)) {
            logger.info("Start failed, no server target server has been set");
        }
    }

    public void restart() throws IOException {
        this.stop();
        this.start();
    }

    public void stop() {
        try {
            if (this.alive) {
                this.alive = false;
                new Socket(this.host, this.port);
            }
        }
        catch (IOException e) {
            this.getLogger().warn(e.getMessage());
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            this.getLogger().warn(e.getMessage());
        }
    }

    public void addAuthorization(String username, String password) {
        if (username == null || password == null) {
            throw new IllegalArgumentException("username and passwords cannot be null");
        }
        this.authorizations.put(username, password);
    }

    public void removeAuthorization(String username) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        this.authorizations.remove(username);
    }

    public void setJAASLoginModule(String JAASLoginModuleName, String JAASConfigProviderClassName) {
        Class[] classArray = new Class[4];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("javax.security.auth.Subject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("javax.security.auth.callback.CallbackHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("javax.security.auth.login.Configuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        Class[] jdk15Const = classArray;
        try {
            Class<?> clazz5 = class$4;
            if (clazz5 == null) {
                try {
                    clazz5 = class$4 = Class.forName("javax.security.auth.login.LoginContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.JDK15LoginContext = clazz5.getDeclaredConstructor(jdk15Const);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (JAASConfigProviderClassName != null && jdk15Const == null) {
            Security.setProperty("login.configuration.provider", JAASConfigProviderClassName);
        }
        if (JAASConfigProviderClassName != null) {
            try {
                Class<?> configCl = this.getClass().getClassLoader().loadClass(JAASConfigProviderClassName);
                this.conf = (Configuration)configCl.newInstance();
            }
            catch (Exception ex) {
                IllegalArgumentException illegArgEx = new IllegalArgumentException("Unable to create JAAS login config " + JAASConfigProviderClassName);
                illegArgEx.initCause(ex);
                throw illegArgEx;
            }
        }
        try {
            BasicCallbackHandler handler = new BasicCallbackHandler("foo", "bar");
            this.getLoginContext(JAASLoginModuleName, handler);
        }
        catch (LoginException ex) {
            IllegalArgumentException illegArgEx = new IllegalArgumentException("Unable to create JAAS login context for setting " + JAASLoginModuleName);
            illegArgEx.initCause(ex);
            throw illegArgEx;
        }
        this.JAASLoginModuleName = JAASLoginModuleName;
    }

    public LoginContext getLoginContext(String configName, CallbackHandler handler) throws LoginException {
        LoginContext context = null;
        if (this.JDK15LoginContext != null && this.conf != null) {
            Object[] args = new Object[]{configName, new Subject(), handler, this.conf};
            try {
                context = (LoginContext)this.JDK15LoginContext.newInstance(args);
            }
            catch (Exception ex) {
                LoginException lcEx = new LoginException("Error during loginContext creation");
                lcEx.initCause(ex);
                throw lcEx;
            }
        } else {
            context = new LoginContext(configName, new Subject(), handler);
        }
        return context;
    }

    public void disableJAASLoginModule() {
        this.JAASLoginModuleName = null;
    }

    public void addJAASAuthorization(String JAASUsername) {
        if (this.JAASLoginModuleName == null) {
            throw new IllegalArgumentException("no JAAS realm defined");
        }
        if (JAASUsername == null) {
            throw new IllegalArgumentException("JAASUsername cannot be null");
        }
        this.JAASAuthorizedUsernames.add(JAASUsername.toLowerCase());
    }

    public void removeJAASAuthorization(String JAASUsername) {
        if (this.JAASLoginModuleName == null) {
            throw new IllegalArgumentException("no JAAS realm defined");
        }
        if (JAASUsername == null) {
            throw new IllegalArgumentException("JAASUsername cannot be null");
        }
        this.JAASAuthorizedUsernames.remove(JAASUsername.toLowerCase());
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.buildCommands();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    private ServerSocket createServerSocket() throws IOException {
        if (this.socketFactory == null) {
            if (this.factoryName == null) {
                this.socketFactory = new PlainAdaptorServerSocketFactory();
                return this.socketFactory.createServerSocket(this.port, 50, this.host);
            }
            try {
                return (ServerSocket)this.server.invoke(this.factoryName, "createServerSocket", new Object[]{new Integer(this.port), new Integer(50), this.host}, new String[]{"int", "int", "java.lang.String"});
            }
            catch (Exception x) {
                Logger log = this.getLogger();
                log.error("Exception invoking AdaptorServerSocketFactory via MBeanServer", x);
            }
        } else {
            return this.socketFactory.createServerSocket(this.port, 50, this.host);
        }
        return null;
    }

    private boolean isUsernameValid(String username, String password) {
        if (this.authorizations.containsKey(username)) {
            return password.equals(this.authorizations.get(username));
        }
        return false;
    }

    protected HttpCommandProcessor getProcessor(String path) {
        return (HttpCommandProcessor)this.commands.get(path);
    }

    protected void buildCommands() {
        Logger log = this.getLogger();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.builder = factory.newDocumentBuilder();
            int i = 0;
            while (i < this.defaultCommandProcessors.length) {
                try {
                    HttpCommandProcessor processor = (HttpCommandProcessor)Class.forName(this.defaultCommandProcessors[i][1]).newInstance();
                    this.commands.put(this.defaultCommandProcessors[i][0], processor);
                }
                catch (Exception e) {
                    log.warn("Exception building command procesor", e);
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            log.error("Exception building the Document Factories", e);
        }
    }

    protected void postProcess(HttpOutputStream out, HttpInputStream in, Document document) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null) {
            if (this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.tools.adaptor.http.ProcessorMBean")) {
                this.server.invoke(this.processorName, "writeResponse", new Object[]{out, in, document}, new String[]{"mx4j.tools.adaptor.http.HttpOutputStream", "mx4j.tools.adaptor.http.HttpInputStream", "org.w3c.dom.Document"});
                processed = true;
            } else {
                Logger log = this.getLogger();
                if (log.isEnabledFor(0)) {
                    log.trace(this.processorName + " not found");
                }
            }
        }
        if (!processed && this.processor != null) {
            this.processor.writeResponse(out, in, document);
            processed = true;
        }
        if (!processed) {
            this.defaultProcessor.writeResponse(out, in, document);
        }
    }

    protected void findUnknownElement(String path, HttpOutputStream out, HttpInputStream in) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null) {
            if (this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.tools.adaptor.http.ProcessorMBean")) {
                this.server.invoke(this.processorName, "notFoundElement", new Object[]{path, out, in}, new String[]{"java.lang.String", "mx4j.tools.adaptor.http.HttpOutputStream", "mx4j.tools.adaptor.http.HttpInputStream"});
                processed = true;
            } else {
                Logger log = this.getLogger();
                if (log.isEnabledFor(0)) {
                    log.trace(this.processorName + " not found");
                }
            }
        }
        if (!processed && this.processor != null) {
            this.processor.notFoundElement(path, out, in);
            processed = true;
        }
        if (!processed) {
            this.defaultProcessor.notFoundElement(path, out, in);
        }
    }

    protected String preProcess(String path) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null) {
            Logger log = this.getLogger();
            if (log.isEnabledFor(0)) {
                log.trace("Preprocess using " + this.processorName);
            }
            if (this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.tools.adaptor.http.ProcessorMBean")) {
                if (log.isEnabledFor(0)) {
                    log.trace("Preprocessing");
                }
                path = (String)this.server.invoke(this.processorName, "preProcess", new Object[]{path}, new String[]{"java.lang.String"});
                processed = true;
            } else if (log.isEnabledFor(0)) {
                log.trace(this.processorName + " not found");
            }
        }
        if (!processed && this.processor != null) {
            path = this.processor.preProcess(path);
            processed = true;
        }
        if (!processed) {
            path = this.defaultProcessor.preProcess(path);
        }
        return path;
    }

    protected void postProcess(HttpOutputStream out, HttpInputStream in, Exception e) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null) {
            if (this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.tools.adaptor.http.ProcessorMBean")) {
                this.server.invoke(this.processorName, "writeError", new Object[]{out, in, e}, new String[]{"mx4j.tools.adaptor.http.HttpOutputStream", "mx4j.tools.adaptor.http.HttpInputStream", "java.lang.Exception"});
                processed = true;
            } else {
                Logger log = this.getLogger();
                if (log.isEnabledFor(0)) {
                    log.trace(this.processorName + " not found");
                }
            }
        }
        if (!processed && this.processor != null) {
            this.processor.writeError(out, in, e);
            processed = true;
        }
        if (!processed) {
            this.defaultProcessor.writeError(out, in, e);
        }
    }

    private class BasicCallbackHandler
    implements CallbackHandler {
        private String userName;
        private String password;

        BasicCallbackHandler(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            int i = 0;
            while (i < callbacks.length) {
                Callback cb = callbacks[i];
                if (cb instanceof NameCallback) {
                    NameCallback nc = (NameCallback)cb;
                    nc.setName(this.userName);
                } else if (cb instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)cb;
                    pc.setPassword(this.password.toCharArray());
                } else {
                    Logger log = HttpAdaptor.this.getLogger();
                    if (log.isEnabledFor(10)) {
                        log.warn("Ignoring login module callback " + cb.getClass().getName());
                    }
                }
                ++i;
            }
        }
    }

    private class HttpClient
    extends Thread {
        private Socket client;
        private String providedUsername;
        private String providedPassword;

        HttpClient(Socket client) {
            this.client = client;
        }

        private boolean isValid(String authorizationString) {
            String decodeString;
            if (HttpAdaptor.this.authenticationMethod.startsWith("basic") && (decodeString = new String(Base64Codec.decodeBase64((authorizationString = authorizationString.substring(5, authorizationString.length())).getBytes()))).indexOf(":") > 0) {
                try {
                    boolean auth;
                    block8: {
                        StringTokenizer tokens = new StringTokenizer(decodeString, ":");
                        this.providedUsername = tokens.nextToken();
                        this.providedPassword = tokens.nextToken();
                        auth = HttpAdaptor.this.isUsernameValid(this.providedUsername, this.providedPassword);
                        if (!auth && HttpAdaptor.this.JAASLoginModuleName != null) {
                            boolean makeJAASLookup;
                            boolean bl = makeJAASLookup = HttpAdaptor.this.JAASAuthorizedUsernames.size() == 0 || HttpAdaptor.this.JAASAuthorizedUsernames.contains(this.providedUsername.toLowerCase());
                            if (makeJAASLookup) {
                                BasicCallbackHandler handler = new BasicCallbackHandler(this.providedUsername, this.providedPassword);
                                LoginContext context = HttpAdaptor.this.getLoginContext(HttpAdaptor.this.JAASLoginModuleName, handler);
                                try {
                                    context.login();
                                    auth = true;
                                }
                                catch (LoginException ex) {
                                    if (ex.getCause() == null || ex.getCause() instanceof LoginException) break block8;
                                    throw ex;
                                }
                            }
                        }
                    }
                    return auth;
                }
                catch (Exception e) {
                    Logger log = HttpAdaptor.this.getLogger();
                    if (log.isEnabledFor(40)) {
                        log.error("Error during authentication", e);
                    }
                    return false;
                }
            }
            return false;
        }

        private boolean handleAuthentication(HttpInputStream in, HttpOutputStream out) throws IOException {
            if (HttpAdaptor.this.authenticationMethod.equals("basic")) {
                String result = in.getHeader("authorization");
                if (result != null) {
                    if (this.isValid(result)) {
                        return true;
                    }
                    out.setCode(403);
                    throw new HttpException(403, "Authentication failed (" + this.providedUsername + "/" + this.providedPassword + ") for remote host " + this.client.getInetAddress());
                }
                out.setCode(401);
                if (HttpAdaptor.this.JAASLoginModuleName != null) {
                    out.setHeader("WWW-Authenticate", "Basic realm=\"" + HttpAdaptor.this.JAASLoginModuleName + "\"");
                } else {
                    out.setHeader("WWW-Authenticate", "Basic realm=\"" + HttpAdaptor.this.realm + "\"");
                }
                out.sendHeaders();
                out.flush();
                return false;
            }
            HttpAdaptor.this.authenticationMethod.equals("digest");
            return true;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block42: {
                log = HttpAdaptor.access$0(HttpAdaptor.this);
                httpIn = null;
                httpOut = null;
                try {
                    block37: {
                        try {
                            block39: {
                                in = this.client.getInputStream();
                                httpIn = new HttpInputStream(in);
                                if (!httpIn.readRequest()) break block37;
                                path = httpIn.getPath();
                                queryString = httpIn.getQueryString();
                                if (log.isEnabledFor(10)) {
                                    log.debug("Request " + path + (queryString == null ? "" : "?" + queryString));
                                }
                                if (!(postPath = HttpAdaptor.this.preProcess(path)).equals(path)) {
                                    if (log.isEnabledFor(10)) {
                                        log.debug("Processor replaced path " + path + " with the path " + postPath);
                                    }
                                    path = postPath;
                                }
                                if (this.handleAuthentication(httpIn, (HttpOutputStream)(httpOut = new HttpOutputStream(out = this.client.getOutputStream(), httpIn)))) break block39;
                                var11_16 = null;
                                try {
                                    try {
                                        if (httpOut != null) {
                                            httpOut.flush();
                                        }
                                    }
                                    catch (IOException e) {
                                        log.warn("Exception during request processing", e);
                                    }
                                    v0 = null;
                                }
                                catch (Throwable var15_22) {
                                    v0 = null;
                                }
                                var14_25 = v0;
                                try {
                                    this.client.close();
                                    return;
                                }
                                catch (IOException e) {
                                    log.warn("Exception during request processing", e);
                                    return;
                                }
                            }
                            processor = HttpAdaptor.this.getProcessor(path.substring(1, path.length()));
                            if (processor == null) {
                                if (log.isEnabledFor(10)) {
                                    log.debug("No suitable command processor found, requesting from processor path " + path);
                                }
                                HttpAdaptor.this.findUnknownElement(path, (HttpOutputStream)httpOut, httpIn);
                            } else {
                                document = processor.executeRequest(httpIn);
                                HttpAdaptor.this.postProcess((HttpOutputStream)httpOut, httpIn, document);
                            }
                        }
                        catch (Exception ex) {
                            if (ex instanceof IOException) {
                                log.debug("IOException during http request", ex);
                            } else {
                                log.warn("Exception during http request", ex);
                            }
                            if (httpOut != null) {
                                try {
                                    HttpAdaptor.this.postProcess((HttpOutputStream)httpOut, httpIn, ex);
                                }
                                catch (IOException e) {
                                    log.warn("IOException during http request", e);
                                }
                                catch (JMException e) {
                                    log.warn("JMException during http request", e);
                                }
                                catch (RuntimeException rte) {
                                    log.error("RuntimeException during http request", rte);
                                }
                                catch (Error er) {
                                    log.error("Error during http request ", er);
                                }
                                catch (Throwable t) {
                                    log.fatal("Throwable during http request ", t);
                                }
                            }
                        }
                        catch (Error ex) {
                            log.error("Error during http request ", ex);
                        }
                    }
                    var11_18 = null;
                }
                catch (Throwable var12_33) {
                    block41: {
                        var11_17 = null;
                        try {}
                        catch (Throwable var15_23) {
                            v1 = null;
lbl87:
                            // 2 sources

                            var14_26 = v1;
                            try {}
                            catch (IOException e) {
                                log.warn("Exception during request processing", e);
                                throw var12_33;
                            }
                            this.client.close();
                            throw var12_33;
                        }
                        ** try [egrp 4[TRYBLOCK] [10 : 450->461)] { 
lbl95:
                        // 1 sources

                        if (httpOut != null) {
                            httpOut.flush();
                        }
                        break block41;
lbl99:
                        // 1 sources

                        catch (IOException e) {
                            log.warn("Exception during request processing", e);
                        }
                    }
                    v1 = null;
                    ** GOTO lbl87
                }
                try {}
                catch (Throwable var15_24) {
                    v2 = null;
lbl107:
                    // 2 sources

                    var14_27 = v2;
                    try {}
                    catch (IOException e) {
                        log.warn("Exception during request processing", e);
                        return;
                    }
                    this.client.close();
                    return;
                }
                ** try [egrp 4[TRYBLOCK] [10 : 450->461)] { 
lbl115:
                // 1 sources

                if (httpOut != null) {
                    httpOut.flush();
                }
                break block42;
lbl119:
                // 1 sources

                catch (IOException e) {
                    log.warn("Exception during request processing", e);
                }
            }
            v2 = null;
            ** GOTO lbl107
        }
    }
}

