/*
 * Decompiled with CFR 0.152.
 */
package ow.id.comparator;

import java.math.BigInteger;
import java.util.Comparator;
import ow.id.ID;
import ow.id.IDAddressPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClockwiseFromSrcIDAddrComparator
implements Comparator<IDAddressPair> {
    private BigInteger sourceIDInteger;
    private final BigInteger ID_SPACE_SIZE;

    public ClockwiseFromSrcIDAddrComparator(int idSizeInBit, ID sourceID) {
        this.sourceIDInteger = sourceID.toBigInteger();
        this.ID_SPACE_SIZE = BigInteger.ONE.shiftLeft(idSizeInBit);
    }

    @Override
    public int compare(IDAddressPair p1, IDAddressPair p2) {
        BigInteger dist2;
        BigInteger dist1 = p1.getID().toBigInteger().subtract(this.sourceIDInteger);
        if (dist1.compareTo(BigInteger.ZERO) < 0) {
            dist1 = dist1.add(this.ID_SPACE_SIZE);
        }
        if ((dist2 = p2.getID().toBigInteger().subtract(this.sourceIDInteger)).compareTo(BigInteger.ZERO) < 0) {
            dist2 = dist2.add(this.ID_SPACE_SIZE);
        }
        return dist1.compareTo(dist2);
    }
}

