/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public final class Tag {
    private static volatile int lastNumber = 0;
    private final int number;
    private final String name;
    private boolean toBeReportedToStatCollector;
    private Color color;
    private static final Map<Integer, Color> colorTable = new HashMap<Integer, Color>();
    private static final Map<Integer, Tag> tagTable = new HashMap<Integer, Tag>();
    private static final Map<Integer, String> nameTable = new HashMap<Integer, String>();
    public static final Tag PUNCH_HOLE_REQ = new Tag(0, "PUNCH_HOLE_REQ", false);
    public static final Tag PUNCH_HOLE_REP = new Tag("PUNCH_HOLE_REP", false);
    public static final Tag PING = new Tag("PING", new Object[0]);
    public static final Tag ACK = new Tag("ACK", new Object[0]);
    public static final Tag ITE_ROUTE_NONE = new Tag("ROUTE_NONE", Color.BLACK);
    public static final Tag ITE_ROUTE_INVOKE = new Tag("ROUTE_INVOKE", Color.BLACK);
    public static final Tag ITE_ROUTE_JOIN = new Tag("ROUTE_JOIN", new Object[0]);
    public static final Tag ITE_ADJUST_LAST_HOP_REQ = new Tag("ADJUST_LAST_HOP_REQ", Color.BLACK);
    public static final Tag ITE_ADJUST_LAST_HOP_REP = new Tag("ADJUST_LAST_HOP_REP", Color.BLACK);
    public static final Tag ITE_TERMINATE_NONE = new Tag("TERMINATE_NONE", Color.BLACK);
    public static final Tag ITE_TERMINATE_INVOKE = new Tag("TERMINATE_INVOKE", Color.BLACK);
    public static final Tag ITE_TERMINATE_JOIN = new Tag("TERMINATE_JOIN", new Object[0]);
    public static final Tag ITE_REPLY = new Tag("REPLY", new Object[0]);
    public static final Tag REC_ROUTE_NONE = new Tag("ROUTE_NONE", Color.BLACK);
    public static final Tag REC_ROUTE_INVOKE = new Tag("ROUTE_INVOKE", Color.BLACK);
    public static final Tag REC_ROUTE_JOIN = new Tag("ROUTE_JOIN", new Object[0]);
    public static final Tag REC_TERMINATE_NONE = new Tag("TERMINATE_NONE", Color.BLACK);
    public static final Tag REC_TERMINATE_INVOKE = new Tag("TERMINATE_INVOKE", Color.BLACK);
    public static final Tag REC_TERMINATE_JOIN = new Tag("TERMINATE_JOIN", new Object[0]);
    public static final Tag REC_ACK = new Tag("ACK", new Object[0]);
    public static final Tag REC_RESULT = new Tag("RESULT", new Object[0]);
    public static final Tag REQ_CONNECT = new Tag("REQ_CONNECT", new Object[0]);
    public static final Tag REP_CONNECT = new Tag("REP_CONNECT", new Object[0]);
    public static final Tag REQ_SUCCESSOR = new Tag("REQ_SUCCESSOR", new Object[0]);
    public static final Tag REP_SUCCESSOR = new Tag("REP_SUCCESSOR", new Object[0]);
    public static final Tag UPDATE_FINGER_TABLE = new Tag("UPDATE_FINGER_TABLE", new Object[0]);
    public static final Tag ACK_FINGER_TABLE = new Tag("ACK_FINGER_TABLE", new Object[0]);
    public static final Tag REQ_PREDECESSOR = new Tag("REQ_PREDECESSOR", new Object[0]);
    public static final Tag REP_PREDECESSOR = new Tag("REP_PREDECESSOR", new Object[0]);
    public static final Tag UPDATE_ROUTING_TABLE = new Tag("UPDATE_ROUTING_TABLE", new Object[0]);
    public static final Tag MULTICAST_JOINING_NODE = new Tag("MULTICAST_JOINING_NODE", new Object[0]);
    public static final Tag MULTICAST_ACK = new Tag("MULTICAST_ACK", new Object[0]);
    public static final Tag NOTIFY_JOINING_NODE = new Tag("NOTIFY_JOINING_NODE", new Object[0]);
    public static final Tag REQ_LEAF_SET = new Tag("REQ_LEAF_SET", new Object[0]);
    public static final Tag REP_LEAF_SET = new Tag("REP_LEAF_SET", new Object[0]);
    public static final Tag REQ_ROUTING_TABLE_ROW = new Tag("REQ_ROUTING_TABLE_ROW", new Object[0]);
    public static final Tag REP_ROUTING_TABLE_ROW = new Tag("REP_ROUTING_TABLE_ROW", new Object[0]);
    public static final Tag GET = new Tag("GET", new Object[0]);
    public static final Tag PUT = new Tag("PUT", new Object[0]);
    public static final Tag REMOVE = new Tag("REMOVE", new Object[0]);
    public static final Tag DHT_REPLY = new Tag("DHT_REPLY", new Object[0]);
    public static final Tag PUT_VALUEINFO = new Tag("PUT_VALUEINFO", new Object[0]);
    public static final Tag REQ_TRANSFER = new Tag("REQ_TRANSFER", new Object[0]);
    public static final Tag PUT_ON_CONDITION = new Tag("PUT_ON_CONDITION", new Object[0]);
    public static final Tag CONNECT = new Tag("CONNECT", new Object[0]);
    public static final Tag ACK_CONNECT = new Tag("ACK_CONNECT", new Object[0]);
    public static final Tag NACK_CONNECT = new Tag("NACK_CONNECT", new Object[0]);
    public static final Tag DISCONNECT = new Tag("DISCONNECT", new Object[0]);
    public static final Tag DISCONNECT_AND_REFUSE = new Tag("DISCONNECT_AND_REFUSE", new Object[0]);
    public static final Tag MULTICAST = new Tag("MULTICAST", new Object[0]);
    public static final Tag ENCAPSULATED = new Tag("ENCAPSULATED", false);
    public static final Tag MESSAGE_SENT = new Tag("MESSAGE_SENT", false);
    public static final Tag DELETE_NODE = new Tag("DELETE_NODE", false);
    public static final Tag EMPHASIZE_NODE = new Tag("EMPHASIZE_NODE", false);
    public static final Tag MARK_ID = new Tag("MARK_ID", false);
    public static final Tag CONNECT_NODES = new Tag("CONNECT_NODES", false);
    public static final Tag DISCONNECT_NODES = new Tag("DISCONNECT_NODES", false);
    public static final Tag STAT_PING = new Tag("STAT_PING", false);
    public static final Tag STAT_ACK = new Tag("STAT_ACK", false);
    public static final Tag REQ_NEIGHBORS = new Tag("REQ_NEIGHBORS", false);
    public static final Tag REP_NEIGHBORS = new Tag("REP_NEIGHBORS", false);

    private Tag(String name, Object ... opts) {
        this(lastNumber, name, opts);
    }

    private Tag(int i, String name, Object ... opts) {
        lastNumber = i;
        this.number = lastNumber++;
        this.name = name;
        this.toBeReportedToStatCollector = true;
        this.color = Color.GRAY;
        for (Object o : opts) {
            if (o instanceof Boolean) {
                this.toBeReportedToStatCollector = (Boolean)o;
                continue;
            }
            if (!(o instanceof Color)) continue;
            this.color = (Color)o;
        }
        colorTable.put(this.number, this.color);
        tagTable.put(this.number, this);
        nameTable.put(this.number, name);
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public static Color getColor(int number) {
        Color ret = colorTable.get(number);
        if (ret == null) {
            ret = Color.GRAY;
        }
        return ret;
    }

    public static boolean toBeReportedToStatCollector(int tag) {
        Tag o = Tag.getTagByNumber(tag);
        if (o != null) {
            return o.toBeReportedToStatCollector;
        }
        return true;
    }

    public static Tag getTagByNumber(int number) {
        return tagTable.get(number);
    }

    public static String getNameByNumber(int number) {
        String ret = nameTable.get(number);
        if (ret == null) {
            ret = String.valueOf(number);
        }
        return ret;
    }
}

