/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.memcached.commands;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import ow.dht.ValueInfo;
import ow.dht.memcached.Item;
import ow.dht.memcached.Memcached;
import ow.id.ID;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocaldataCommand
implements Command<Memcached> {
    private static final String[] NAMES = new String[]{"localdata"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "localdata";
    }

    @Override
    public boolean execute(ShellContext<Memcached> context) {
        Item item;
        Set values;
        Memcached dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        StringBuilder sb = new StringBuilder();
        Set<ID> keySet = dht.getLocalKeys();
        if (keySet != null && !keySet.isEmpty()) {
            sb.append("# Local directory (entries which this node has put):").append("\r\n");
            for (ID key : keySet) {
                values = dht.getLocalValues(key);
                for (ValueInfo v : values) {
                    item = (Item)v.getValue();
                    sb.append("VALUE ").append(key);
                    sb.append(" ").append(item.getFlag());
                    sb.append(" ").append(item.getData().length);
                    sb.append("\r\n");
                    try {
                        sb.append(new String(item.getData(), "ASCII"));
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                    sb.append("\r\n");
                }
            }
        }
        if (!(keySet = dht.getGlobalKeys()).isEmpty()) {
            sb.append("# Global directory (local part of the DHT):").append("\r\n");
            for (ID key : keySet) {
                values = dht.getGlobalValues(key);
                for (ValueInfo v : values) {
                    item = (Item)v.getValue();
                    sb.append("VALUE ").append(key);
                    sb.append(" ").append(item.getFlag());
                    sb.append(" ").append(item.getData().length);
                    sb.append("\r\n");
                    try {
                        sb.append(new String(item.getData(), "ASCII"));
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                    sb.append("\r\n");
                }
            }
        }
        out.print(sb);
        out.flush();
        return false;
    }
}

