/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.axes.InitialContext;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class RootContext
extends EvalContext {
    private JXPathContextReferenceImpl jxpathContext;
    private NodePointer pointer;
    private Object[] registers;
    private int availableRegister = 0;
    public static final Object UNKNOWN_VALUE = new Object();
    private static final int MAX_REGISTER = 4;

    public RootContext(JXPathContextReferenceImpl jxpathContext, NodePointer pointer) {
        super(null);
        this.jxpathContext = jxpathContext;
        this.pointer = pointer;
    }

    public JXPathContext getJXPathContext() {
        return this.jxpathContext;
    }

    public RootContext getRootContext() {
        return this;
    }

    public EvalContext getAbsoluteRootContext() {
        return this.jxpathContext.getAbsoluteRootContext();
    }

    public NodePointer getCurrentNodePointer() {
        return this.pointer;
    }

    public int getCurrentPosition() {
        throw new UnsupportedOperationException();
    }

    public boolean nextNode() {
        throw new UnsupportedOperationException();
    }

    public boolean nextSet() {
        throw new UnsupportedOperationException();
    }

    public boolean setPosition(int position) {
        throw new UnsupportedOperationException();
    }

    public EvalContext getConstantContext(Object constant) {
        NodePointer pointer = constant instanceof NodePointer ? (NodePointer)constant : NodePointer.newNodePointer(new QName(null, ""), constant, null);
        return new InitialContext(new RootContext(this.jxpathContext, pointer));
    }

    public EvalContext getVariableContext(QName variableName) {
        return new InitialContext(new RootContext(this.jxpathContext, this.jxpathContext.getVariablePointer(variableName)));
    }

    public Function getFunction(QName functionName, Object[] parameters) {
        return this.jxpathContext.getFunction(functionName, parameters);
    }

    public Object getRegisteredValue(int id) {
        if (this.registers == null || id >= 4 || id == -1) {
            return UNKNOWN_VALUE;
        }
        return this.registers[id];
    }

    public int setRegisteredValue(Object value) {
        if (this.registers == null) {
            this.registers = new Object[4];
            int i = 0;
            while (i < 4) {
                this.registers[i] = UNKNOWN_VALUE;
                ++i;
            }
        }
        if (this.availableRegister >= 4) {
            return -1;
        }
        this.registers[this.availableRegister] = value;
        ++this.availableRegister;
        return this.availableRegister - 1;
    }

    public String toString() {
        return super.toString() + ":" + this.pointer.asPath();
    }
}

