/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.model;

import javax.annotation.Generated;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.gen.internal.model.ClassModelSupport;
import org.seasar.extension.jdbc.gen.internal.model.GeneratedModelSupport;
import org.seasar.extension.jdbc.gen.model.ClassModel;
import org.seasar.extension.jdbc.gen.model.NamesAssociationModel;
import org.seasar.extension.jdbc.gen.model.NamesAttributeModel;
import org.seasar.extension.jdbc.gen.model.NamesModel;
import org.seasar.extension.jdbc.gen.model.NamesModelFactory;
import org.seasar.extension.jdbc.name.PropertyName;
import org.seasar.framework.util.ClassUtil;

public class NamesModelFactoryImpl
implements NamesModelFactory {
    protected static String INNER_CLASS_NAME_PREFIX = "_";
    protected String packageName;
    protected String namesClassNameSuffix;
    protected ClassModelSupport classModelSupport = new ClassModelSupport();
    protected GeneratedModelSupport generatedModelSupport = new GeneratedModelSupport();

    public NamesModelFactoryImpl(String packageName, String namesClassNameSuffix) {
        if (namesClassNameSuffix == null) {
            throw new NullPointerException("namesClassNameSuffix");
        }
        this.packageName = packageName;
        this.namesClassNameSuffix = namesClassNameSuffix;
    }

    public NamesModel getNamesModel(EntityMeta entityMeta) {
        NamesModel namesModel = new NamesModel();
        namesModel.setPackageName(this.packageName);
        String shortClassName = entityMeta.getName() + this.namesClassNameSuffix;
        namesModel.setShortClassName(shortClassName);
        namesModel.setShortInnerClassName(INNER_CLASS_NAME_PREFIX + shortClassName);
        namesModel.setShortEntityClassName(entityMeta.getEntityClass().getSimpleName());
        for (PropertyMeta propertyMeta : entityMeta.getAllPropertyMeta()) {
            if (propertyMeta.isTransient()) continue;
            if (propertyMeta.isRelationship()) {
                this.doNamesAssociationModel(namesModel, propertyMeta);
                continue;
            }
            this.doNamesAttributeModel(namesModel, propertyMeta);
        }
        this.doImportName(namesModel, entityMeta);
        this.doGeneratedInfo(namesModel, entityMeta);
        return namesModel;
    }

    protected void doNamesAttributeModel(NamesModel namesModel, PropertyMeta propertyMeta) {
        NamesAttributeModel namesAttributeModel = new NamesAttributeModel();
        namesAttributeModel.setName(propertyMeta.getName());
        Class clazz = ClassUtil.getWrapperClassIfPrimitive((Class)propertyMeta.getPropertyClass());
        namesAttributeModel.setAttributeClass(clazz);
        namesModel.addNamesAttributeModel(namesAttributeModel);
    }

    protected void doNamesAssociationModel(NamesModel namesModel, PropertyMeta propertyMeta) {
        NamesAssociationModel namesAssociationModel = new NamesAssociationModel();
        namesAssociationModel.setName(propertyMeta.getName());
        String shortClassName = INNER_CLASS_NAME_PREFIX + propertyMeta.getRelationshipClass().getSimpleName() + this.namesClassNameSuffix;
        namesAssociationModel.setShortClassName(shortClassName);
        StringBuilder buf = new StringBuilder();
        buf.append(this.packageName);
        buf.append(".");
        buf.append(propertyMeta.getRelationshipClass().getSimpleName());
        buf.append(this.namesClassNameSuffix);
        buf.append(".");
        buf.append(shortClassName);
        namesAssociationModel.setClassName(buf.toString());
        namesModel.adddNamesAssociationModel(namesAssociationModel);
    }

    protected void doImportName(NamesModel namesModel, EntityMeta entityMeta) {
        this.classModelSupport.addImportName((ClassModel)namesModel, entityMeta.getEntityClass());
        this.classModelSupport.addImportName((ClassModel)namesModel, PropertyName.class);
        this.classModelSupport.addImportName((ClassModel)namesModel, Generated.class);
        for (NamesAttributeModel attributeModel : namesModel.getNamesAttributeModelList()) {
            this.classModelSupport.addImportName((ClassModel)namesModel, attributeModel.getAttributeClass());
        }
        for (NamesAssociationModel associationModel : namesModel.getNamesAssociationModelList()) {
            this.classModelSupport.addImportName((ClassModel)namesModel, associationModel.getClassName());
        }
    }

    protected void doGeneratedInfo(NamesModel namesModel, EntityMeta entityMeta) {
        this.generatedModelSupport.fillGeneratedInfo(this, namesModel);
    }
}

