/*
 * Copyright 1999,2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.positrium.chikarawo;

import java.io.IOException;
import java.io.OutputStream;

import org.apache.log4j.Layout;
import org.apache.log4j.WriterAppender;

/**
 * ConsoleAppender appends log events to <code>System.out</code> or
 * <code>System.err</code> using a layout specified by the user. The default
 * target is <code>System.out</code>.
 * 
 * @author <a href="http://www.qos.ch/log4j/">Ceki G&uuml;lc&uuml;</a>
 * @author Curt Arnold
 * @since 1.1
 */
public class AWTAppender extends WriterAppender {
	/**
	 * Constructs an unconfigured appender.
	 */
	public AWTAppender() {
	}

	/**
	 * Creates a configured appender.
	 * 
	 * @param layout
	 *            layout, may not be null.
	 */
	public AWTAppender(final Layout layout) {
		setLayout(layout);
		activateOptions();
	}

	/**
	 * Creates a configured appender.
	 * 
	 * @param layout
	 *            layout, may not be null.
	 * @param targetStr
	 *            target, either "System.err" or "System.out".
	 */
	public AWTAppender(final Layout layout, final String targetStr) {
		setLayout(layout);
		setTarget(targetStr);
		activateOptions();
	}

	/**
	 * Sets the value of the <b>Target</b> option. Recognized values are
	 * "System.out" and "System.err". Any other value will be ignored.
	 * */
	public void setTarget(final String value) {
	}

	/**
	 * Returns the current value of the <b>Target</b> property. The default
	 * value of the option is "System.out".
	 * 
	 * See also {@link #setTarget}.
	 * */
	public String getTarget() {
		return "System.out";
	}

	/**
	 * Prepares the appender for use.
	 */
	public void activateOptions() {
		setWriter(createWriter(new AWTStream()));

		super.activateOptions();
	}

	/**
	 * {@inheritDoc}
	 */
	protected final void closeWriter() {
		super.closeWriter();
	}

	/**
	 * An implementation of OutputStream that redirects to the current
	 * System.err.
	 * 
	 */
	private static class AWTStream extends OutputStream {
		private LogWindow instance = LogWindow.getInstance();

		public AWTStream() {
		}

		public void close() {
		}

		public void flush() {
			System.out.flush();
		}

		public void write(final byte[] b) throws IOException {
			instance.append(b);
		}

		public void write(final byte[] b, final int off, final int len)
				throws IOException {
			instance.append(b, off, len);
		}

		public void write(final int b) throws IOException {
			instance.append(b);
		}
	}
}
