package org.positrium.chikarawo;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.dokukino.genkidama.DHTConfig;
import com.dokukino.genkidama.VersionInfo;

/**
 * append Genkidama controller to System Tray
 * 
 * @author token , 2009 CC BY-SA
 * @version $Rev: 141 $
 * 
 */
public class Chikarawo {
	public static Log logger = LogFactory.getLog(Chikarawo.class);

	private String version;

	private SystemTray tray;
	private MyTrayIcon normalTrayIcon;

//	private Image trayImage;

	public Chikarawo() {
		this.version = VersionInfo.getFullVersion();

		this.tray = SystemTray.getSystemTray();

		PopupMenu popup = new PopupMenu();

		MenuItem dashboard = new MenuItem("dashboard");
		dashboard.addActionListener(this.getDashboardAction());
		popup.add(dashboard);
		
		MenuItem logWindow = new MenuItem("log window");
		logWindow.addActionListener(this.getLogWindowAction());
		popup.add(logWindow);

		// separtor
		popup.addSeparator();

		// quit
		MenuItem quit = new MenuItem("quit");
		quit.addActionListener(this.getQuitAction());
		popup.add(quit);

		try {
			this.normalTrayIcon = new MyTrayIcon(this.version, popup);
		} catch (FileNotFoundException e) {
			logger.fatal(e);
		}
		LogWindow.getInstance().show();
	}

	private ActionListener getLogWindowAction() {
		return new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				LogWindow.getInstance().show();
			}
		};
	}

	/**
	 * <code>http://genkidama.dokukino.com/</code>JNANV
	 * @return
	 */
	private ActionListener getDashboardAction() {

		return new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Desktop desktop = Desktop.getDesktop();
				try {
					desktop.browse(new URI(DHTConfig.DHT_DASHBOARD_URL));
				} catch (IOException e1) {
					logger.error("Error Occurs:", e1);
				} catch (URISyntaxException e1) {
					logger.error("Error Occurs:", e1);
				}
			}
		};
	}

	/**
	 * gCACRtooltipo͂
	 * @param message
	 */
	public void showTooltip(String message) {
		this.tray.getTrayIcons()[0].displayMessage(this.version, message,
				TrayIcon.MessageType.INFO);
	}

	/**
	 * VXegCɍڂ
	 */
	public void openTray() {
		if (SystemTray.isSupported()) {
			try {
				tray.add(normalTrayIcon);
			} catch (AWTException e1) {
				logger.error("Error Occurs:", e1);
			}
		} else {
			logger.warn("System Tray not supported on your Environment");
		}
	}

	// TODO for ActionSourceClasses
	//	
	// private final Vector<StateChangeListener> listenerList = new
	// Vector<StateChangeListener>();
	// public void addGenkidamaStateChangeListener(
	// GenkidamaStateChangeListener listener) {
	// if (!listenerList.contains(listener))
	// listenerList.add(listener);
	// }
	//
	// public void stateChange(int cmd) {
	// Vector list = (Vector) listenerList.clone();
	// Enumeration e = list.elements();
	// GenkidamaStateChangeEvent evt = new GenkidamaStateChangeEvent(this, cmd);
	// while (e.hasMoreElements()) {
	// GenkidamaStateChangeListener listener = (GenkidamaStateChangeListener) e
	// .nextElement();
	// listener.serverStateChanged(evt);
	// }

	/**
	 * quitANV
	 */
	private ActionListener getQuitAction() {
		return new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.exit(0);
			}
		};
	}

}
