package org.positrium.ui;

import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

import org.positrium.util.BBCommand;
import org.positrium.util.BBMenuParser;

public class AwtMenu implements MenuFactory {

	@Override
	public Object createPopupMenu() {
		BBMenuParser bbmenu = new BBMenuParser("menu.rc");
		PopupMenu popup = new PopupMenu();

		
		for (BBCommand c : bbmenu.getCommands()) {
			if (BBCommand.Tag.EXEC.equals(c.tag)) {
				MenuItem item = new MenuItem(c.label);
				try {
					item.addActionListener((ActionListener) Class.forName(
							c.target).newInstance());
				} catch (InstantiationException e) {
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					e.printStackTrace();
				} catch (ClassNotFoundException e) {
					e.printStackTrace();
				}
				popup.add(item);
				
			} else if (BBCommand.Tag.SEPARATOR.equals(c.tag)) {
				popup.addSeparator();
				
			}
		}

		MenuItem quit = new MenuItem("quit");
		quit.addActionListener(new org.positrium.ui.action.QuitAction());
		popup.add(quit);

		return popup;
	}

}
