package waket.remote;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public abstract class AbstractJsoner {
	public static Log logger = LogFactory
		.getLog(AbstractJsoner.class);

	protected String json;
	protected String destfile;

	public AbstractJsoner() {
		SingletonS2ContainerFactory
			.init();
	}

	public abstract void jsonize();

	public void setDestfile(String filename) {
		destfile = filename;
	}

	public void setJsonData(String jsondata) {
		json = jsondata;
	}

	public abstract void setup();

	public void chain() {
		setup();
		jsonize();

		File dist = new File(
			"htdocs/global/" + destfile);
		PrintWriter pw = null;
		try {
			pw = new PrintWriter(
				new BufferedWriter(
					new FileWriter(
						dist)));
			pw
				.println(json);
		} catch (IOException e) {
			e
				.printStackTrace();
		} finally {
			pw
				.close();
		}

		logger.debug(json);

	}

}
