package waket.remote;

import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import javassist.bytecode.Descriptor.Iterator;

import net.arnx.jsonic.JSON;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import waket.remote.dto.GlobalEntriesDto;
import waket.remote.dto.GlobalStatusDto;
import waket.remote.entity.VideoInfo;
import waket.remote.service.OnlineDataService;
import waket.remote.service.OnlineUsersService;

public class GlobalEntriesJsoner extends AbstractJsoner {
	public static Log logger = LogFactory
		.getLog(GlobalEntriesJsoner.class);

	private GlobalEntriesDto globalEntriesDto;
	private OnlineDataService onlineDataService;

	@Override
	public void setup() {
		{
			SingletonS2ContainerFactory
				.init();

			S2Container container = SingletonS2ContainerFactory
				.getContainer();
			globalEntriesDto = (GlobalEntriesDto) container
				.getComponent("globalEntriesDto");

			onlineDataService = SingletonS2Container
				.getComponent("onlineDataService");

		}

		List video_ids = onlineDataService
			.listOnlineData();
		globalEntriesDto.videos = new VideoInfo[video_ids
			.size()];

		for (int i = 0; i < globalEntriesDto.videos.length; i++) {
			VideoInfo v = new VideoInfo();
			v.id = (String) video_ids
				.get(i);
			// v = ThumbInfoService.selectById((String)video_ids.get(i));
			globalEntriesDto.videos[i] = v;
		}

	}

	@Override
	public void jsonize() {
		setDestfile("globalEntries");
		setJsonData(JSON
			.encode(
				globalEntriesDto,
				true));

	}
}
