package waket.remote;

import net.arnx.jsonic.JSON;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import waket.remote.dto.GlobalHistoryDto;
import waket.remote.service.VideoAccessLogService;

public class GlobalHistoryJsoner extends AbstractJsoner {
	public static Log logger = LogFactory
		.getLog(GlobalHistoryJsoner.class);

	private GlobalHistoryDto globalHistoryDto;
	private VideoAccessLogService videoAccessLogService;

	@Override
	public void setup() {
		{
			SingletonS2ContainerFactory
				.init();

			S2Container container = SingletonS2ContainerFactory
				.getContainer();

			globalHistoryDto = (GlobalHistoryDto) container
				.getComponent("globalHistoryDto");

			videoAccessLogService = SingletonS2Container
				.getComponent("videoAccessLogService");
		}

		globalHistoryDto.cacheCount = videoAccessLogService
			.countUseCache();
		globalHistoryDto.dhtCount = videoAccessLogService
			.countUseDht();
		globalHistoryDto.directCount = videoAccessLogService
			.countUseDirect();
	}

	@Override
	public void jsonize() {
		setDestfile("globalHistory");
		setJsonData(JSON
			.encode(
				globalHistoryDto,
				true));
	}
}
