/*
 * Copyright (C) 2011 OgakiSoft
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package ogakisoft.android.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

/**
 * This class is the utility which collected common methods.
 * 
 * @author noritoshi ogaki
 * @version 1.0
 */
public class Utils {
	/** LOG TAG */
	private static final String TAG = "Utils";

	/**
	 * Concatenate strings
	 * 
	 * @param args
	 * @return String
	 */
	public static final String concat(String... args) {
		final StringBuffer sb = new StringBuffer();
		final int count = args.length;
		for (int i = 0; i < count; i++) {
			sb.append(args[i]);
		}
		return sb.toString();
	}

	/**
	 * Compare double value
	 * 
	 * @param d1
	 * @param d2
	 * @return boolean
	 */
	public static boolean equalDouble(double d1, double d2) {
		// return (Double.compare(d1, d2) == 0) ? true : false;
		boolean result = false;
		if (0 == Double.compare(d1, d2)) {
			result = true;
		}
		return result;
	}

	/**
	 * Compare float value
	 * 
	 * @param f1
	 * @param f2
	 * @return boolean
	 */
	public static boolean equalFloat(float f1, float f2) {
		// return (Float.compare(f1, f2) == 0) ? true : false;
		boolean result = false;
		if (0 == Float.compare(f1, f2)) {
			result = true;
		}
		return result;
	}

	/**
	 * Cast float value to int
	 * 
	 * @param value
	 * @return int
	 */
	public static final int castInt(float value) {
		if (Integer.MAX_VALUE < value || Integer.MIN_VALUE > value) {
			LOG.e(TAG, "castInt: overflow or underflow: {0,number,#.##}", value);
		}
		return (int) value;
	}

	/**
	 * Cast float value to long
	 * 
	 * @param value
	 * @return long
	 */
	public static final long castLong(float value) {
		if (Long.MAX_VALUE < value || Long.MIN_VALUE > value) {
			LOG.e(TAG, "castLong: overflow or underflow: {0,number,#.##}",
					value);
		}
		return (long) value;
	}

	/**
	 * Cast int value to char
	 * 
	 * @param value
	 * @return char
	 */
	public static final char castChar(int value) {
		// if (Character.MAX_VALUE < value || Character.MIN_VALUE > value) {
		// Do not check MIN_VALUE > value, minus value key-code used
		if (Character.MAX_VALUE < value) {
			LOG.e(TAG, "castChar: overflow: {0,number,#}", value);
		}
		return (char) value;
	}

	/**
	 * System Current Time
	 * 
	 * @return long millisecond
	 */
	public static final long currentTime() {
		// return System.currentTimeMillis();
		return android.os.SystemClock.elapsedRealtime();
	}

	/**
	 * Copy File
	 * @param srcPath
	 * @param destPath
	 * @throws IOException
	 */
	public static void copyFile(String srcPath, String destPath)
			throws IOException {
		FileChannel srcChannel = new FileInputStream(srcPath).getChannel();
		FileChannel destChannel = new FileOutputStream(destPath).getChannel();
		try {
			srcChannel.transferTo(0, srcChannel.size(), destChannel);
		} finally {
			srcChannel.close();
			destChannel.close();
		}
	}
}
