///////////////////////////////////////////////////////////////
//ListView.cpp
//t@Cꗗ\ - CListView

///////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"
#include "ListView.h"
#include "CommandBandsPPC.h"
#include "FolderDlgPPC.h"
#include "FileProperty.h"
#include "CopyDlg.h"
#include "DeleteDlg.h"
#include "UserPathDlg.h"
#include "FileSearch.h"
#include "Association.h"
#include "MultiBuff.h"

///////////////////////////////////////////////////////////////
#define ID_LISTVIEW			0

#define DEF_LIST_STYLE			(WS_BORDER | WS_TABSTOP | WS_VISIBLE | WS_CHILD | \
								LVS_SHAREIMAGELISTS | \
								LVS_ALIGNTOP | LVS_EDITLABELS | \
								LVS_SHOWSELALWAYS)
#define	DEF_LIST_STYLE_VIRTUAL	(DEF_LIST_STYLE|LVS_OWNERDATA)

#define DEF_LIST_EXSTYLE			(0)
#define DEF_LIST_EXSTYLE_VIRTUAL	(DEF_LIST_EXSTYLE|LVS_EX_ONECLICKACTIVATE)

///////////////////////////////////////////////////////////////
BOOL SeekFolder(LPARAM lParam1, LPARAM lParam2)
{
	LISTITEMCOMP* plic = (LISTITEMCOMP*)lParam1;
	LPTSTR foldername = (LPTSTR)lParam2;

	return (_tcscmp(plic->lpszName, foldername) != 0);
}

///////////////////////////////////////////////////////////////
BOOL SeekFowardFindFolder(LPARAM lParam1, LPARAM lParam2)
{
	LISTITEMCOMP* plic = (LISTITEMCOMP*)lParam1;
	LPTSTR foldername = (LPTSTR)lParam2;
	TCHAR basename[MAX_PATH];

	_tcsncpy(basename, plic->lpszName, MAX_PATH);
	_tcslwr(basename);

	return (_tcsncmp(basename, foldername, _tcslen(foldername)) != 0);
}

///////////////////////////////////////////////////////////////
LRESULT CALLBACK ListViewProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) 
	{
	//L[
	case WM_KEYDOWN:
		if (g_MainWnd.m_ListView.m_bOnComposition)			//IME͒ȂSĂWM_KEYUP/WM_KEYDOWN𖳎
		{
			g_MainWnd.m_ListView.m_bThroughKeyup = TRUE;	//(WM_IME_ENDCOMPOSITIONWM_KEYUPɗĂ܂̂WM_KEYUP̂߂̃tO𗧂ĂĂ)
			return 0;
		}
		g_MainWnd.m_ListView.m_bThroughContextMenu = FALSE;
		switch (wParam)
		{
		case VK_RETURN:
			//ENTERL[
			if (GetKeyState(VK_CONTROL) & 0x8000)
				wParam = VK_SPACE;		//CTRL+ENTERȂCTRL+SPACEɑ}ւ
			else
				g_MainWnd.m_ListView.m_bOwnKeyup = TRUE;
			break;

		case VK_SPACE:
		case VK_BACK:
			return 0;

		case VK_LEFT:
			if (g_MainWnd.m_ListView.OnKeydownArrow(wParam, lParam))
				return 0;
			if (g_MainWnd.m_ListView.m_Settings.dwListStyle == LVS_REPORT)
			{
				if (g_MainWnd.m_ListView.m_bArrowPageMove)
				{
					keybd_event(VK_PRIOR, 0, 0, 0);
					return 0;
				}
			}
			break;

		case VK_RIGHT:
			if (g_MainWnd.m_ListView.OnKeydownArrow(wParam, lParam))
				return 0;
			if (g_MainWnd.m_ListView.m_Settings.dwListStyle == LVS_REPORT)
			{
				if (g_MainWnd.m_ListView.m_bArrowPageMove)
				{
					keybd_event(VK_NEXT, 0, 0, 0);
					return 0;
				}
			}
			break;

		case VK_UP:
			if (g_MainWnd.m_bIsZero3)
			{
				if ((g_MainWnd.m_nZero3ModelNumber == 27 && (lParam&0x00FF0000) == 0x00C30000) || 
					(g_MainWnd.m_nZero3ModelNumber != 27 && (lParam&0x00FF0000) == 0))	//Xcrawl UP
				{
					if (g_MainWnd.m_bXcrawlPageMove)
					{
						keybd_event(VK_PRIOR, 0, 0, 0);
						return 0;
					}
				}
			}
			if (GetKeyState(VK_MENU)&0x8000)	//ALT+
			{
				keybd_event(VK_PRIOR, 0, 0, 0);
				return 0;
			}
			if (g_MainWnd.m_ListView.OnKeydownArrow(wParam, lParam))
				return 0;
			if (g_MainWnd.m_ListView.OnKeydownMoveTail(wParam, lParam))
				return 0;
			break;

		case VK_DOWN:
			if (g_MainWnd.m_bIsZero3)
			{
				if ((g_MainWnd.m_nZero3ModelNumber == 27 && (lParam&0x00FF0000) == 0x00C20000) ||
					(g_MainWnd.m_nZero3ModelNumber != 27 && (lParam&0x00FF0000) == 0))	//Xcrawl DOWN
				{
					if (g_MainWnd.m_bXcrawlPageMove)
					{
						keybd_event(VK_NEXT, 0, 0, 0);
						return 0;
					}
				}
			}
			if (GetKeyState(VK_MENU)&0x8000)	//ALT+
			{
				keybd_event(VK_NEXT, 0, 0, 0);
				return 0;
			}
			if (g_MainWnd.m_ListView.OnKeydownArrow(wParam, lParam))
				return 0;
			if (g_MainWnd.m_ListView.OnKeydownMoveTop(wParam, lParam))
				return 0;
			break;

		default:
			break;
		}
		g_MainWnd.m_ListView.m_bScrollbarMove = FALSE;
		break;

	case WM_KEYUP:
		if (g_MainWnd.m_ListView.m_bThroughKeyup)			//WM_KEYDOWN̎_IME͒łꍇɂWM_KEYUP𖳎
		{
			g_MainWnd.m_ListView.m_bThroughKeyup = FALSE;	//(̓͂ɔătO~낷)
			return 0;
		}
		switch (wParam)
		{
		case VK_RETURN:
			//SHIFT/CTRLL[
			if (g_MainWnd.m_ListView.m_bOwnKeyup)
			{
				g_MainWnd.m_ListView.m_bOwnKeyup = FALSE;
				if (!g_MainWnd.m_ListView.m_bThroughContextMenu)
				{
					if (GetKeyState(VK_CONTROL) & 0x8000)
						wParam = VK_SPACE;	//CTRL+ENTERȂCTRL+SPACEɑ}ւ
					else
					{
						if (g_MainWnd.m_bControlKey)
						{
							keybd_event(VK_CONTROL, 0x32, 0, 0);
							keybd_event(VK_RETURN, 0x37, 0, 0);
							keybd_event(VK_RETURN, 0x37, KEYEVENTF_KEYUP, 0);
							keybd_event(VK_CONTROL, 0x32, KEYEVENTF_KEYUP, 0);
							return 0;
						}
						else
						{
							g_MainWnd.m_ListView.OnFileOpen();
						}
					}
				}
			}
			break;

		case VK_SPACE:
			if (GetKeyState(VK_CONTROL) & 0x8000)
			{
				keybd_event(VK_RETURN, 0x37, 0, 0);
				keybd_event(VK_RETURN, 0x37, KEYEVENTF_KEYUP, 0);
			}
			else if (g_MainWnd.m_bControlKey)
			{
				keybd_event(VK_CONTROL, 0x32, 0, 0);
				keybd_event(VK_RETURN, 0x37, 0, 0);
				keybd_event(VK_RETURN, 0x37, KEYEVENTF_KEYUP, 0);
				keybd_event(VK_CONTROL, 0x32, KEYEVENTF_KEYUP, 0);
			}
			return 0;

		case VK_BACK:
			if (_tcslen(g_MainWnd.m_ListView.m_szCurrentFolder) == 0 && g_MainWnd.m_bShowFolder)
				SetFocus(g_MainWnd.m_TreeView.m_hWnd);
			else
				g_MainWnd.m_ListView.OnViewUpFolder();
			return 0;

		case VK_LEFT:
			if (g_MainWnd.m_ListView.OnKeyupArrow(wParam, lParam))
				return 0;
			if (g_MainWnd.m_ListView.m_Settings.dwListStyle == LVS_REPORT)
			{
				keybd_event(VK_PRIOR, 0, KEYEVENTF_KEYUP, 0);
				return 0;
			}
			break;

		case VK_RIGHT:
			if (g_MainWnd.m_ListView.OnKeyupArrow(wParam, lParam))
				return 0;
			if (g_MainWnd.m_ListView.m_Settings.dwListStyle == LVS_REPORT)
			{
				keybd_event(VK_NEXT, 0, KEYEVENTF_KEYUP, 0);
				return 0;
			}
			break;

		case VK_UP:
			if (g_MainWnd.m_ListView.OnKeyupArrow(wParam, lParam))
				return 0;
			break;

		case VK_DOWN:
			if (g_MainWnd.m_ListView.OnKeyupArrow(wParam, lParam))
				return 0;
			break;

		default:
			break;
		}
		g_MainWnd.m_ListView.m_bThroughContextMenu = FALSE;
		break;

	case WM_CONTEXTMENU:
		//ReNXgj[̃I[v
		g_MainWnd.m_ListView.m_bThroughContextMenu = TRUE;
		g_MainWnd.m_ListView.m_bOwnKeyup = FALSE;
		//SHIFT/CTRLL[
		if (g_MainWnd.m_bShiftKey)
			g_MainWnd.OnEditShiftOn();
		if (g_MainWnd.m_bControlKey)
			g_MainWnd.OnEditCtrlOn();
		break;

	case WM_LBUTTONDOWN:
		//^bvJn
		g_MainWnd.m_ListView.m_bScrollbarMove = FALSE;
		g_MainWnd.m_ListView.OnTapHoldBegin((DWORD)lParam);
		//SHIFT/CTRLL[
		if (g_MainWnd.m_bShiftKey)
			wParam |= MK_SHIFT;
		if (g_MainWnd.m_bControlKey)
			wParam |= MK_CONTROL;
		break;

	case WM_LBUTTONUP:
		//SHIFT/CTRLL[
		if (g_MainWnd.m_bShiftKey)
			wParam |= MK_SHIFT;
		if (g_MainWnd.m_bControlKey)
			wParam |= MK_CONTROL;
		break;

	case WM_MOUSEWHEEL:
		if (GET_WHEEL_DELTA_WPARAM(wParam) < 0)
		{
			BYTE bVk,bScan;
			if (g_MainWnd.m_bXcrawlPageMove)
				bVk = VK_NEXT, bScan = 0;
			else
				bVk = VK_DOWN, bScan = 0x3D;
			keybd_event(bVk, bScan, 0, 0);
			keybd_event(bVk, bScan, KEYEVENTF_KEYUP, 0);
		}
		else if (GET_WHEEL_DELTA_WPARAM(wParam) > 0)
		{
			BYTE bVk,bScan;
			if (g_MainWnd.m_bXcrawlPageMove)
				bVk = VK_PRIOR, bScan = 0;
			else
				bVk = VK_UP, bScan = 0x3E;
			keybd_event(bVk, bScan, 0, 0);
			keybd_event(bVk, bScan, KEYEVENTF_KEYUP, 0);
		}
		return 0;

	case WM_KILLFOCUS:
		g_MainWnd.m_ListView.m_bScrollbarMove = FALSE;
		//SHIFT/CTRLL[
		if (g_MainWnd.m_bShiftKey)
			g_MainWnd.OnEditShiftOn();
		if (g_MainWnd.m_bControlKey)
			g_MainWnd.OnEditCtrlOn();
		KillTimer(g_MainWnd.m_ListView.m_hWnd, ID_TIMER_FOWARDFIND);
		memset(g_MainWnd.m_ListView.m_szFowardFindName, 0, MAX_PATH*sizeof(TCHAR));
		break;

	case WM_CHAR:
		switch (wParam)
		{
		case 0x3000://SPACEPƂŉۂɑĂR[h on WS011SH
			return 0;//
		default:
			break;
		}
		if (g_MainWnd.m_bVirtualListView)
		{
			//zXgr[͑OȂȂ̂ł̑֏s
			if (iswprint(wParam))
			{
				g_MainWnd.m_ListView.m_bScrollbarMove = FALSE;
				*_tcsrchr(g_MainWnd.m_ListView.m_szFowardFindName, _T('\0')) = towlower(wParam);
				int nItem = g_MainWnd.m_ListView.m_ItemStruct.Find((LPFINDFUNC)SeekFowardFindFolder, 0, (DWORD)g_MainWnd.m_ListView.m_szFowardFindName);
				if (_tcslen(g_MainWnd.m_ListView.m_szFowardFindName) >= (MAX_PATH-1) || nItem < 0)
				{
					memset(g_MainWnd.m_ListView.m_szFowardFindName, 0, MAX_PATH*sizeof(TCHAR));
					PlaySound(_T("Default"), NULL, SND_ASYNC);
				}
				if (nItem >= 0)
				{
					KillTimer(g_MainWnd.m_ListView.m_hWnd, ID_TIMER_FOWARDFIND);
					SetTimer(g_MainWnd.m_ListView.m_hWnd, ID_TIMER_FOWARDFIND, TIMER_FOWARDFIND_INT, NULL);
					ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, -1, 0, LVIS_FOCUSED|LVIS_SELECTED);
					ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, nItem, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);
					ListView_EnsureVisible(g_MainWnd.m_ListView.m_hWnd, nItem, TRUE);
				}
				return 0;
			}
		}
		break;

	case WM_TIMER:
		if (wParam == ID_TIMER_FOWARDFIND)
		{
			KillTimer(g_MainWnd.m_ListView.m_hWnd, ID_TIMER_FOWARDFIND);
			memset(g_MainWnd.m_ListView.m_szFowardFindName, 0, MAX_PATH*sizeof(TCHAR));
			return 0;
		}
		break;

	//IME͏Ԃ̎擾
	case WM_IME_STARTCOMPOSITION:
		g_MainWnd.m_ListView.m_bOnComposition = TRUE;	//IME͊Jn
		break;
	case WM_IME_ENDCOMPOSITION:
		g_MainWnd.m_ListView.m_bOnComposition = FALSE;	//IME͏I
		break;

	//case WM_WINDOWPOSCHANGED:
	//	{
	//		SIPINFO si;
	//		memset(&si, 0, sizeof(si));
	//		si.cbSize = sizeof(si);
	//		if (SipGetInfo(&si))
	//		{
	//			if ((si.fdwFlags ^ g_MainWnd.m_dwLastSipInfo) & SIPF_ON)
	//			{
	//				LPWINDOWPOS lpwp = (LPWINDOWPOS)lParam;
	//				g_MainWnd.m_dwLastSipInfo = si.fdwFlags;
	//				if (si.fdwFlags & SIPF_ON)
	//					lpwp->cy -= RECT_HEIGHT(&si.rcSipRect);
	//				SendMessage(g_MainWnd.m_ListView.m_hWnd, WM_MOVE, 0, MAKELPARAM(lpwp->x, lpwp->y));
	//				SendMessage(g_MainWnd.m_ListView.m_hWnd, WM_SIZE, 0, MAKELPARAM(lpwp->cx, lpwp->cy));
	//				ListView_Scroll(g_MainWnd.m_ListView.m_hWnd, 0, 0);	//(SIPŃtH[JX̂t@CBĂ܂ւ̑Ώ)
	//				return 0;
	//			}
	//		}
	//	}
	//	break;
	//
	case WM_VSCROLL:
		g_MainWnd.m_ListView.m_bScrollbarMove = TRUE;
		break;

	case WM_HSCROLL:
		if (g_MainWnd.m_ListView.m_Settings.dwListStyle != LVS_REPORT)
			g_MainWnd.m_ListView.m_bScrollbarMove = TRUE;
		break;

	//ȊO
	default:
		break;
	}

	return CallWindowProc((WNDPROC)GetWindowLong(hWnd, GWL_USERDATA), hWnd, message, wParam, lParam);
}

////////////////////////////////////////////////////////////////
LRESULT CALLBACK FileOpenParamDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_INITDIALOG:
		{
			SHINITDLGINFO shidi;
			shidi.dwMask = SHIDIM_FLAGS;
			shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIZEDLGFULLSCREEN;
			shidi.hDlg = hDlg;
			SHINITDIALOG(&shidi);
			if (!g_MainWnd.m_bIsSmartphone)	//Smartphone/Standard̏ꍇPPC2SPLIBɔĈŕsv
			{
				//j[o[ǉ
				SHMENUBARINFO mbi;
				memset(&mbi, 0, sizeof(SHMENUBARINFO));
				mbi.cbSize = sizeof(SHMENUBARINFO);
				mbi.hwndParent = hDlg;
				mbi.nToolBarId = IDR_OPENPARAM;
				mbi.hInstRes = g_hInst;
				mbi.nBmpId = 0;
				mbi.cBmpImages = 0;	
				SHCreateMenuBar(&mbi);
			}

			//EBhE^Cg
			SetWindowText(hDlg, APP_MAINWND_TITLE);

			int nIndex = g_MainWnd.m_ListView.GetSelectedItemIndex(0);
			LISTITEMCOMP* plic = g_MainWnd.m_ListView.GetListItemStruct(nIndex);
			TCHAR szTemp[MAX_PATH];
			_stprintf(szTemp, GetResourceString(IDS_FMT_OPENPARAM), plic->lpszName);
			SetWindowText(GetDlgItem(hDlg, IDC_MESSAGE), szTemp);
		}
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK)
		{
			int nIndex = g_MainWnd.m_ListView.GetSelectedItemIndex(0);
			LISTITEMCOMP* plic = g_MainWnd.m_ListView.GetListItemStruct(nIndex);

			TCHAR szParam[MAX_PATH];
			GetWindowText(GetDlgItem(hDlg, IDC_EDIT_PATH), szParam, 512);
			TCHAR szPath[MAX_PATH];
			_stprintf(szPath, _T("%s\\%s"), g_MainWnd.m_ListView.m_szCurrentFolder, plic->lpszName);

			SHELLEXECUTEINFO sei;
			ZeroMemory(&sei, sizeof(SHELLEXECUTEINFO));
			sei.cbSize = sizeof(SHELLEXECUTEINFO);
			//sei.fMask = 0;
			sei.hwnd = hDlg;
			sei.lpVerb = _T("open");
			sei.lpFile = szPath;
			sei.lpParameters = szParam;
			sei.lpDirectory = _T("");
			sei.nShow = SW_SHOW;
			sei.hInstApp = g_hInst;
			ShellExecuteEx(&sei);

			EndDialog(hDlg, LOWORD(wParam));

			return TRUE;
		}
		else if (LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));

			return TRUE;
		}
		break;

	case WM_PAINT:
		return DefDlgPaintProc(hDlg, wParam, lParam);

	case WM_CTLCOLORSTATIC:
		return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);

	default:
		break;
	}

	return FALSE;
}

///////////////////////////////////////////////////////////////
CListView::CListView()
{
	m_Settings.nSort = LIST_SORT_NAME;
	m_Settings.bSortRaise = TRUE;
	m_Settings.dwListStyle = LVS_ICON;
	m_Settings.dwListExStyle = 0;

	m_Settings.bHideHidden = TRUE;
	m_Settings.bHideSystem = FALSE;
	m_Settings.bHideROM = FALSE;

	m_Settings.nNameColumnSize = 145;
	m_Settings.nSizeColumnSize = 75;
	m_Settings.nTypeColumnSize = 75;
	m_Settings.nTimeColumnSize = 75;

	m_Settings.bSaveFolder = FALSE;
	_tcscpy(m_szCurrentFolder, _T(""));
	m_Settings.bNotShortcutName = FALSE;
	m_Settings.bNotShowExt = TRUE;
	m_Settings.bShowSecond = FALSE;
	m_Settings.bSingleClick = TRUE;
	m_Settings.bAddUpper = TRUE;
	m_Settings.bHideHeader = FALSE;
	m_Settings.nCompDLL = COMPDLL_MODE_ZIP;
	m_Settings.bAutoUnComp = FALSE;
	m_Settings.bMakeDir = FALSE;
	m_Settings.bMoveDir = FALSE;
	m_Settings.bDblClick = FALSE;
	_tcscpy(m_szCompressFolder, _T("\\Temp"));
	_tcscpy(m_szOldFolder, _T(""));
	m_bTimeStump = FALSE;
	m_bHideFolder = FALSE;
	m_bNoExtShortcut = TRUE;

	m_bMenu = FALSE;
	m_lpHistory = NULL;
	m_lpHistoryCurrent = NULL;
	m_lpSearchData = NULL;
	m_lpFavorites = NULL;
	m_lpFavoritesCurrent = NULL;
	m_nFavoritesCount = 0;
	m_bThroughContextMenu = FALSE;
	m_bOwnKeyup = FALSE;
	m_bArrowPageMove = FALSE;
	memset(m_szFowardFindName, 0, MAX_PATH*sizeof(TCHAR));
	memset(m_szLastCreateName, 0, MAX_PATH*sizeof(TCHAR));
	m_bScrollbarMove = FALSE;
	m_bOnComposition = FALSE;
	m_bThroughKeyup = FALSE;

#if defined(SUPPORT_FTP)
	_tcscpy(m_szFtpServer, _T(""));
	_tcscpy(m_szFtpPath, _T(""));
	_tcscpy(m_szFtpUser, _T(""));
	_tcscpy(m_szFtpPassword, _T(""));
#endif//SUPPORT_FTP

	m_nCount = 0;
	m_bFileMove = FALSE;
	m_lpliinfo = NULL;
	_tcscpy(m_szFolderFrom, _T(""));
	m_nFileSize = 0;
	m_hMenuPopup = NULL;
	m_pFileImageList = NULL;
	m_bEditing = FALSE;
	m_dwUpperParam = NULL;
	m_nOpenPthInfoCount = 0;

	m_ImageListSettings.bNotLoadFileIcon = FALSE;
	m_ImageListSettings.bNotLoadROMIcon = TRUE;
	m_ImageListSettings.bNotLoadCompIcon = TRUE;
	m_ImageListSettings.bStuffingIcons = FALSE;
}

///////////////////////////////////////////////////////////////
CListView::~CListView()
{
	//̍폜
	DeleteHistory(m_lpHistory);

	//ʂ̍폜
	DeleteSearch(m_lpSearchData);
}

///////////////////////////////////////////////////////////////
void CListView::Init(HWND hwndParent)
{
	//JWlݒ
	m_Settings.nNameColumnSize = (int)(200.0 * g_MainWnd.m_fpHighResolutionScale);
	m_Settings.nSizeColumnSize = (int)( 70.0 * g_MainWnd.m_fpHighResolutionScale);
	m_Settings.nTypeColumnSize = (int)(100.0 * g_MainWnd.m_fpHighResolutionScale);
	m_Settings.nTimeColumnSize = (int)(100.0 * g_MainWnd.m_fpHighResolutionScale);

	//ݒǂݍ
	GetSettings();

	DWORD dwStyle = g_MainWnd.m_bVirtualListView? DEF_LIST_STYLE_VIRTUAL: DEF_LIST_STYLE;
	DWORD dwExStyle = 0;

	m_hWnd = CreateWindowEx(dwExStyle,
							WC_LISTVIEW,
							NULL, dwStyle, 0, 0, 0, 0,
							hwndParent, (HMENU)ID_LISTVIEW,
							g_hInst, NULL);

	SetWindowLong(m_hWnd, GWL_USERDATA, GetWindowLong(m_hWnd, GWL_WNDPROC));
	SetWindowLong(m_hWnd, GWL_WNDPROC, (DWORD)ListViewProc);

	//
	LVCOLUMN lvc;
	lvc.mask = LVCF_FMT | LVCF_SUBITEM | LVCF_TEXT | LVCF_WIDTH;
	lvc.fmt = LVCFMT_LEFT;
	lvc.cx = m_Settings.nNameColumnSize;
	lvc.pszText = GetResourceString(IDS_COLUMN_NAME);
	lvc.iSubItem = 0;
	ListView_InsertColumn(m_hWnd, 0, &lvc);
	lvc.fmt = LVCFMT_RIGHT;
	lvc.cx = m_Settings.nSizeColumnSize;
	lvc.pszText = GetResourceString(IDS_COLUMN_SIZE);
	lvc.iSubItem = 1;
	ListView_InsertColumn(m_hWnd, 1, &lvc);
	lvc.fmt = LVCFMT_LEFT;
	lvc.cx = m_Settings.nTypeColumnSize;
	lvc.pszText = GetResourceString(IDS_COLUMN_TYPE);
	lvc.iSubItem = 2;
	ListView_InsertColumn(m_hWnd, 2, &lvc);
	lvc.fmt = LVCFMT_LEFT;
	lvc.cx = m_Settings.nTimeColumnSize;
	lvc.pszText = GetResourceString(IDS_COLUMN_DATE);
	lvc.iSubItem = 3;
	ListView_InsertColumn(m_hWnd, 3, &lvc);

	SetImageList();

	if (g_lpszFirstLoadFolder == NULL)
	{
		//R}hCp[^w莞
		if (m_Settings.bSaveFolder)
		{
			DWORD dwAttr = GetFileAttributes(m_szCurrentFolder);
			if (dwAttr == 0xFFFFFFFF || !(dwAttr & FILE_ATTRIBUTE_DIRECTORY))
				_tcscpy(m_szCurrentFolder, _T(""));
		}
		else
			_tcscpy(m_szCurrentFolder, _T(""));
	}
	else 
	{
		DWORD dwAttr = GetFileAttributes(g_lpszFirstLoadFolder);
		if (dwAttr != 0xFFFFFFFF && (dwAttr & FILE_ATTRIBUTE_DIRECTORY))
			_tcscpy(m_szCurrentFolder, g_lpszFirstLoadFolder);
	}

	g_MainWnd.m_CmdBands.SetCheckSort(m_Settings.nSort, m_Settings.bSortRaise);
	g_MainWnd.m_CmdBands.SetEnableEditPaste(FALSE);
	m_hMenuPopup = LoadMenu(g_hInst, (LPCTSTR)(g_MainWnd.m_bNumberShortcut? IDR_POPUP1: IDR_POPUP));

	InitOpenAppMenu();
	InitUserPathMenu();
	InitFavoritesMenu();
	InitShellNewMenu();

	//\`ݒ
	OnChangeListStyle(0);
}

///////////////////////////////////////////////////////////////
void CListView::Destroy()
{
	//ݒۑ
	SaveSettings();

	if (m_lpliinfo)
	{
		delete[] m_lpliinfo;
		m_lpliinfo = NULL;
		m_nCount = 0;
	}

	int i;
	for (i = 0; i < m_nOpenAppInfoCount; i++)
	{
		OPENAPPINFO* poa= m_lpOpenAppInfo[i];
		if (poa)
		{
			delete poa->lpszPath;
			delete poa;
			m_lpOpenAppInfo[i] = NULL;
		}
	}

	m_nOpenAppInfoCount = NULL;
	for (i = 0; i < m_nShellNewInfoCount; i++)
	{
		OPENAPPINFO* pcn = m_lpShellNewInfo[i];
		if (pcn)
		{
			delete pcn->lpszPath;
			delete pcn;
			m_lpShellNewInfo[i] = NULL;
		}
	}
	m_nShellNewInfoCount = 0;

	DeleteAllItem();
	DeleteUserPathMenu();
	DeleteFavoritesMenu();

	DestroyMenu(m_hMenuPopup);

	m_FileImageListLarge.Destroy();
	m_FileImageListSmall.Destroy();
	//DestroyWindow(m_hWnd);	//(eEChEDestroyWindowőp)
}

///////////////////////////////////////////////////////////////
void CListView::SetImageList()
{
	m_FileImageListSmall.InitImageList(FALSE);
	ListView_SetImageList(m_hWnd, m_FileImageListSmall.m_hImageList, LVSIL_SMALL);
	m_FileImageListLarge.InitImageList(TRUE);
	ListView_SetImageList(m_hWnd, m_FileImageListLarge.m_hImageList, LVSIL_NORMAL);

	if ((m_Settings.dwListStyle&LVS_TYPEMASK) == LVS_ICON)
		m_pFileImageList = &m_FileImageListLarge;
	else
		m_pFileImageList = &m_FileImageListSmall;
}

///////////////////////////////////////////////////////////////
void CListView::GetSettings()
{
	HKEY hKey = 0;
	DWORD dwDisposition;

	//L[擾
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_SETTINGS, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		DWORD dwDataSize;
		DWORD dwValue;
		BYTE bString[MAX_PATH*2];

		//m_nOpenPthInfoCount
		dwDataSize = sizeof(dwValue);
		int iTemp = 0;
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("OpenPthInfoCount"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			iTemp = dwValue;

		//m_lpOpenPthInfo
		CUserPathDlg *pup = new CUserPathDlg((HWND)0, (HINSTANCE)0);
		for (int i=0; i<iTemp; i++)
		{
			BYTE bString[MAX_PATH*sizeof(TCHAR)];
			dwDataSize = sizeof(bString);
			TCHAR szKey[16];
			_stprintf(szKey, _T("OpenPthInfo%d"), i);
			if (RegQueryValueEx(hKey, szKey, 0, NULL, bString, &dwDataSize) == ERROR_SUCCESS)
				pup->AddPath(i, (LPTSTR)bString);
		}
		if (pup) delete pup;

		//m_szCurrentFolder
		dwDataSize = sizeof(bString);
		if (RegQueryValueEx(hKey, _T("LastFolder"), 0, NULL, bString, &dwDataSize) == ERROR_SUCCESS)
			memcpy(&m_szCurrentFolder, bString, dwDataSize);
		
		//m_szCompressFolder
		dwDataSize = sizeof(bString);
		if (RegQueryValueEx(hKey, _T("CompressFolder"), 0, NULL, bString, &dwDataSize) == ERROR_SUCCESS)
			memcpy(&m_szCompressFolder, bString, dwDataSize);

		//m_bTimeStump
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TimeStump"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bTimeStump = dwValue;

		//m_bHideFolder
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("HideFolder"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bHideFolder = dwValue;

		//m_bNoExtShortcut
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NoExtShortcut"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bNoExtShortcut = dwValue;

		//m_bArrowPageMove
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ArrowPageMove"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bArrowPageMove = dwValue;
		else
		{//Gg̋~
			dwDataSize = sizeof(dwValue);
			dwValue = 0;
			if (RegQueryValueEx(hKey, _T("UseReportPageMove"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
				m_bArrowPageMove = dwValue;
		}

		RegCloseKey(hKey);
	}
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_LISTVIEW, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		DWORD dwDataSize;
		DWORD dwValue;

		//m_Settings.nSort
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("Sort"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.nSort = dwValue;

		//m_Settings.bSortRaise
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("SortRaise"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bSortRaise = dwValue;

		//m_Settings.dwListStyle
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ListStyle"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.dwListStyle = dwValue;

		//m_Settings.dwListExStyle
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ListExStyle"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.dwListExStyle = dwValue;

		//m_Settings.bHideHidden
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("HideHidden"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bHideHidden = dwValue;

		//m_Settings.bHideSystem
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("HideSystem"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bHideSystem = dwValue;

		//m_Settings.bHideROM
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("HideROM"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bHideROM = dwValue;

		//m_Settings.nNameColumnSize
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NameColumnSize"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.nNameColumnSize = dwValue;

		//m_Settings.nSizeColumnSize
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("SizeColumnSize"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.nSizeColumnSize = dwValue;

		//m_Settings.nTypeColumnSize
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TypeColumnSize"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.nTypeColumnSize = dwValue;

		//m_Settings.nTimeColumnSize
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TimeColumnSize"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.nTimeColumnSize = dwValue;

		//m_Settings.bSaveFolder
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("SaveFolder"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bSaveFolder = dwValue;

		//m_Settings.bNotShortcutName
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NotShortcutName"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bNotShortcutName = dwValue;

		//m_Settings.bNotShowExt
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NotShowExt"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bNotShowExt = dwValue;

		//m_Settings.bShowSecond
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ShowSecond"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bShowSecond = dwValue;

		//m_Settings.bSingleClick
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("SingleClick"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bSingleClick = dwValue;

		//m_Settings.bHideHeader
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("HideHeader"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bHideHeader = dwValue;

		//m_Settings.bAddUpper
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("AddUpper"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bAddUpper = dwValue;

		//m_Settings.nCompDLL
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("CompDLL"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.nCompDLL = dwValue;

		//m_Settings.bAutoUnComp
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("AutoUnComp"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bAutoUnComp = dwValue;

		//m_Settings.bMakeDir
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("MakeDir"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bMakeDir = dwValue;

		//m_Settings.bMoveDir
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("MoveDir"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bMoveDir = dwValue;

		//m_Settings.bDblClick
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("DblClick"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bDblClick = dwValue;
	}
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_FILEIMAGELIST, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		DWORD dwDataSize;
		DWORD dwValue;

		//m_ImageListSettings.bNotLoadFileIcon
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NotLoadFileIcon"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_ImageListSettings.bNotLoadFileIcon = dwValue;

		//m_ImageListSettings.bNotLoadROMIcon
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NotLoadROMIcon"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_ImageListSettings.bNotLoadROMIcon = dwValue;

		//m_ImageListSettings.bNotLoadCompIcon
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NotLoadCompIcon"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_ImageListSettings.bNotLoadCompIcon = dwValue;

		//m_ImageListSettings.bStuffingIcons
		dwDataSize = sizeof(dwValue);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("StuffingIcons"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_ImageListSettings.bStuffingIcons = dwValue;
	}
}

///////////////////////////////////////////////////////////////
void CListView::SaveSettings()
{
	//ۑOɃJTCY擾
	if (m_Settings.dwListStyle == LVS_REPORT)
	{
		m_Settings.nNameColumnSize = ListView_GetColumnWidth(m_hWnd, 0);
		m_Settings.nSizeColumnSize = ListView_GetColumnWidth(m_hWnd, 1);
		m_Settings.nTypeColumnSize = ListView_GetColumnWidth(m_hWnd, 2);
		m_Settings.nTimeColumnSize = ListView_GetColumnWidth(m_hWnd, 3);
	}

	HKEY hKey;
	DWORD dwDisposition;

	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_SETTINGS, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		//m_nOpenPthInfoCount
		RegSetValueEx(hKey, _T("OpenPthInfoCount"), 0, REG_DWORD,
				(LPBYTE)&m_nOpenPthInfoCount, sizeof(m_nOpenPthInfoCount));

		for (int i=0; i<m_nOpenPthInfoCount; i++)
		{
			OPENAPPINFO* poa= m_lpOpenPthInfo[i];
			TCHAR szKey[16];
			_stprintf(szKey, _T("OpenPthInfo%d"), i);
			RegSetValueEx(hKey, szKey, 0, REG_SZ,
					(LPBYTE)poa->lpszPath, ((_tcslen(poa->lpszPath)+1) * sizeof(TCHAR)));
		}

		//m_szCurrentFolder[MAX_PATH];
#if defined(SUPPORT_FTP)
		if (IsSearchFolder(m_szCurrentFolder) || IsFtpFolder(m_szCurrentFolder))
		//tH_FTPꍇ̓[gtH_(k)Ƃĕۑ
#else
		if (IsSearchFolder(m_szCurrentFolder))
		//tH_ꍇ̓[gtH_(k)Ƃĕۑ
#endif
			RegSetValueEx(hKey, _T("LastFolder"), 0, REG_SZ,
					(LPBYTE)_T(""), (0+1) * sizeof(TCHAR));
		else
			RegSetValueEx(hKey, _T("LastFolder"), 0, REG_SZ,
					(LPBYTE)m_szCurrentFolder, (_tcslen(m_szCurrentFolder)+1) * sizeof(TCHAR));

		//m_szCompressFolder[MAX_PATH];
		RegSetValueEx(hKey, _T("CompressFolder"), 0, REG_SZ,
				(LPBYTE)m_szCompressFolder, (_tcslen(m_szCompressFolder)+1) * sizeof(TCHAR));

		//m_bTimeStump
		RegSetValueEx(hKey, _T("TimeStump"), 0, REG_DWORD,
				(LPBYTE)&m_bTimeStump, sizeof(m_bTimeStump));

		//m_bHideFolder
		RegSetValueEx(hKey, _T("HideFolder"), 0, REG_DWORD,
				(LPBYTE)&m_bHideFolder, sizeof(m_bHideFolder));

		//m_bNoExtShortcut
		RegSetValueEx(hKey, _T("NoExtShortcut"), 0, REG_DWORD,
				(LPBYTE)&m_bNoExtShortcut, sizeof(m_bNoExtShortcut));

		//m_bArrowPageMove
		RegSetValueEx(hKey, _T("ArrowPageMove"), 0, REG_DWORD,
				(LPBYTE)&m_bArrowPageMove, sizeof(m_bArrowPageMove));
		RegDeleteKey(hKey, _T("UseReportPageMove"));

		RegCloseKey(hKey);
	}
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_LISTVIEW, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		//m_Settings.nSort
		RegSetValueEx(hKey, _T("Sort"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.nSort, sizeof(m_Settings.nSort));

		//m_Settings.bSortRaise
		RegSetValueEx(hKey, _T("SortRaise"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bSortRaise, sizeof(m_Settings.bSortRaise));

		//m_Settings.dwListStyle
		RegSetValueEx(hKey, _T("ListStyle"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.dwListStyle, sizeof(m_Settings.dwListStyle));

		//m_Settings.dwListExStyle
		RegSetValueEx(hKey, _T("ListExStyle"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.dwListExStyle, sizeof(m_Settings.dwListExStyle));

		//m_Settings.bHideHidden
		RegSetValueEx(hKey, _T("HideHidden"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bHideHidden, sizeof(m_Settings.bHideHidden));

		//m_Settings.bHideSystem
		RegSetValueEx(hKey, _T("HideSystem"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bHideSystem, sizeof(m_Settings.bHideSystem));

		//m_Settings.bHideROM
		RegSetValueEx(hKey, _T("HideROM"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bHideROM, sizeof(m_Settings.bHideROM));

		//m_Settings.nNameColumnSize
		RegSetValueEx(hKey, _T("NameColumnSize"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.nNameColumnSize, sizeof(m_Settings.nNameColumnSize));

		//m_Settings.nSizeColumnSize
		RegSetValueEx(hKey, _T("SizeColumnSize"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.nSizeColumnSize, sizeof(m_Settings.nSizeColumnSize));

		//m_Settings.nTypeColumnSize
		RegSetValueEx(hKey, _T("TypeColumnSize"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.nTypeColumnSize, sizeof(m_Settings.nTypeColumnSize));

		//m_Settings.nTimeColumnSize
		RegSetValueEx(hKey, _T("TimeColumnSize"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.nTimeColumnSize, sizeof(m_Settings.nTimeColumnSize));

		//m_Settings.bSaveFolder
		RegSetValueEx(hKey, _T("SaveFolder"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bSaveFolder, sizeof(m_Settings.bSaveFolder));

		//m_Settings.bNotShortcutName
		RegSetValueEx(hKey, _T("NotShortcutName"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bNotShortcutName, sizeof(m_Settings.bNotShortcutName));

		//m_Settings.bNotShowExt
		RegSetValueEx(hKey, _T("NotShowExt"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bNotShowExt, sizeof(m_Settings.bNotShowExt));

		//m_Settings.bShowSecond
		RegSetValueEx(hKey, _T("ShowSecond"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bShowSecond, sizeof(m_Settings.bShowSecond));

		//m_Settings.bSingleClick
		RegSetValueEx(hKey, _T("SingleClick"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bSingleClick, sizeof(m_Settings.bSingleClick));

		//m_Settings.bHideHeader
		RegSetValueEx(hKey, _T("HideHeader"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bHideHeader, sizeof(m_Settings.bHideHeader));

		//m_Settings.bAddUpper
		RegSetValueEx(hKey, _T("AddUpper"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bAddUpper, sizeof(m_Settings.bAddUpper));

		//m_Settings.nCompDLL
		RegSetValueEx(hKey, _T("CompDLL"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.nCompDLL, sizeof(m_Settings.nCompDLL));

		//m_Settings.bAutoUnComp
		RegSetValueEx(hKey, _T("AutoUnComp"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bAutoUnComp, sizeof(m_Settings.bAutoUnComp));

		//m_Settings.bMakeDir
		RegSetValueEx(hKey, _T("MakeDir"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bMakeDir, sizeof(m_Settings.bMakeDir));

		//m_Settings.bMoveDir
		RegSetValueEx(hKey, _T("MoveDir"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bMoveDir, sizeof(m_Settings.bMoveDir));

		//m_Settings.bDblClick
		RegSetValueEx(hKey, _T("DblClick"), 0, REG_DWORD,
				(LPBYTE)&m_Settings.bDblClick, sizeof(m_Settings.bDblClick));

	}
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_FILEIMAGELIST, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		//m_ImageListSettings.bNotLoadFileIcon
		RegSetValueEx(hKey, _T("NotLoadFileIcon"), 0, REG_DWORD,
				(LPBYTE)&m_ImageListSettings.bNotLoadFileIcon, sizeof(m_ImageListSettings.bNotLoadFileIcon));

		//m_ImageListSettings.bNotLoadROMIcon
		RegSetValueEx(hKey, _T("NotLoadROMIcon"), 0, REG_DWORD,
				(LPBYTE)&m_ImageListSettings.bNotLoadROMIcon, sizeof(m_ImageListSettings.bNotLoadROMIcon));

		//m_ImageListSettings.bNotLoadCompIcon
		RegSetValueEx(hKey, _T("NotLoadCompIcon"), 0, REG_DWORD,
				(LPBYTE)&m_ImageListSettings.bNotLoadCompIcon, sizeof(m_ImageListSettings.bNotLoadCompIcon));

		//m_ImageListSettings.bStuffingIcons
		RegSetValueEx(hKey, _T("StuffingIcons"), 0, REG_DWORD,
				(LPBYTE)&m_ImageListSettings.bStuffingIcons, sizeof(m_ImageListSettings.bStuffingIcons));
	}
}

///////////////////////////////////////////////////////////////
void CListView::MainWindowReset(LPCTSTR lpszPath, LONGLONG nAllSize)
{
	TCHAR szTemp[MAX_PATH];

	//JgtH_XV
	_tcscpy(m_szCurrentFolder, lpszPath);

	//AhXo[փpXݒ
	g_MainWnd.m_CmdBands.SetFolderName(lpszPath);
	
	//ACeATCY\
	if (g_MainWnd.m_CmdBands.m_Settings.bShowAddressBar)
	{
		//AhXo[\
		TCHAR szItemCount[64];
		TCHAR szAllSize[64];
		_stprintf(szTemp, _T("%d"), (m_dwUpperParam && _tcslen(lpszPath) && !IsSearchFolder(lpszPath))?
			(ListView_GetItemCount(m_hWnd) - 1): ListView_GetItemCount(m_hWnd));

		SetFormatInteger(szTemp, 64);
		_stprintf(szItemCount, GetResourceString(IDS_FMT_OBJECTSCOUNT), szTemp);
		_stprintf(szTemp, _T("%I64d"), nAllSize);
		SetFormatInteger(szTemp, 64);
		_stprintf(szAllSize, GetResourceString(IDS_FMT_TOTALBYTES), szTemp);
		g_MainWnd.m_StatusWnd.SetTwoPaneText(szItemCount, szAllSize);
	}
	else
	{
		//AhXo[\
		TCHAR szItemCount[64];
		TCHAR szAllSize[64];
		TCHAR szFolder[64];
		_stprintf(szTemp, _T("%d"), (m_dwUpperParam && _tcslen(lpszPath) && !IsSearchFolder(lpszPath))?
			(ListView_GetItemCount(m_hWnd) - 1): ListView_GetItemCount(m_hWnd));

		SetFormatInteger(szTemp, 64);
		_stprintf(szItemCount, GetResourceString(IDS_FMT_OBJECTSCOUNT_S), szTemp);
		SetFormatSize(nAllSize, szAllSize, GetResourceString(IDS_FMT_TOTALBYTES_SKB), GetResourceString(IDS_FMT_TOTALBYTES_SMB));
		LPTSTR lpszFolderName = _tcsrchr(m_szCurrentFolder, _T('\\'));
		if (lpszFolderName)
			_tcscpy(szFolder, ++lpszFolderName);
		else
			_tcscpy(szFolder, GetRootName());

		g_MainWnd.m_StatusWnd.SetThreePaneText(szFolder, szItemCount, szAllSize);
	}

	//̃tH_ւLE
	g_MainWnd.m_CmdBands.SetEnableUpperFolder(_tcslen(lpszPath)? TRUE: FALSE);

	//iރ{^L/
	g_MainWnd.m_CmdBands.SetEnableFront(m_lpHistoryCurrent->lpNext? TRUE: FALSE);
	
	//߂{^L/
	g_MainWnd.m_CmdBands.SetEnableBack(m_lpHistoryCurrent->lpPrev? TRUE: FALSE);
}

///////////////////////////////////////////////////////////////
void CListView::LoadFolderReset(LPCTSTR lpszPath)
{
	//ACeATCỸJEg
	LONGLONG nAllSize = 0;

	//t@C̓ǂݍ
	TCHAR szTemp[MAX_PATH];
	_stprintf(szTemp, _T("%s\\*.*"), lpszPath);
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do{
			//ACet@C̏ꍇ̂
			if (!(finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
				//TCYJEg
				nAllSize += finddata.nFileSizeLow;
		}while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}
	
	//ʍč\z
	MainWindowReset(lpszPath, nAllSize);
	m_nFileSize = nAllSize;
}

///////////////////////////////////////////////////////////////
void CListView::LoadFolderSearch(LPCTSTR lpszPath)
{
	//J[\ɂ
	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

	//Xe[^Xo[\(\)
	TCHAR szTemp[MAX_PATH];
	_stprintf(szTemp, GetResourceString(IDS_FMT_LOADING));
	g_MainWnd.m_StatusWnd.SetSimpleText(szTemp);

	//ACeATCỸJEg
	LONGLONG nAllSize = 0;

	//ACe̍폜
	DeleteAllItem();

	//ȍ~̃AhX폜
	SEARCHDATA *pCurrent = m_lpSearchData;
	while (pCurrent)
	{
		SEARCHDATA *pNext = pCurrent->lpNext;
		
		TCHAR szTemp[MAX_PATH];
		_stprintf(szTemp, _T("%s\\%s"), pCurrent->lpszPath, pCurrent->lpszName);
		if (GetFileAttributes(szTemp) == 0xFFFFFFFF)
		{
			//Xg̘A
			if (pCurrent->lpPrev)
				pCurrent->lpPrev->lpNext = pNext;
			else
				m_lpSearchData = pNext;
			if (pCurrent->lpNext)
				pCurrent->lpNext->lpPrev = pCurrent->lpPrev;

			//ACe̍폜
			pCurrent->lpNext = NULL;
			DeleteSearch(pCurrent);
		}
		else
		{
			//ACe̒ǉ
			AddFolderItemSub(pCurrent->lpszPath,
							 pCurrent->lpszName,
							 pCurrent->dwAttr,
							 pCurrent->ft,
							 pCurrent->dwSize,
							 &nAllSize);
		}

		//̃o
		pCurrent = pNext;

	}

	// \[g
	if (g_MainWnd.m_bVirtualListView)
	{
		if (m_ItemStruct.GetCount())
			SortList();
	}
	else
	{
		if (ListView_GetItemCount(m_hWnd))
			SortList();
	}

	//ʍč\z
	MainWindowReset(lpszPath, nAllSize);
	m_nFileSize = nAllSize;

	//c[r[XV
	g_MainWnd.m_TreeView.SetCurrentFolder(lpszPath, FALSE, TRUE);

	//ACeI
	ListView_SetItemState(m_hWnd, 0, LVIS_SELECTED, LVIS_SELECTED);
	ListView_SetItemState(m_hWnd, 0, LVIS_FOCUSED, LVIS_FOCUSED);

	//J[\ɖ߂
	SetCursor(hCursor);
}

#if defined(SUPPORT_FTP)
///////////////////////////////////////////////////////////////
void CListView::LoadFolderFtp(LPCTSTR lpszPath)
{
	//J[\ɂ
	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

	//Xe[^Xo[\(\)
	TCHAR szTemp[MAX_PATH];
	_stprintf(szTemp, GetResourceString(IDS_FMT_LOADING));
	g_MainWnd.m_StatusWnd.SetSimpleText(szTemp);

	//FTPT[oEt@CpXE[U[EpX[h𒊏o
	ParseFtpPath(lpszPath);

	//ACeATCỸJEg
	LONGLONG nAllSize = 0;

	//ACe̍폜
	DeleteAllItem();

	// ̃tH_ւǉ
	if (_tcslen(m_szFtpPath) > 1 && m_Settings.bAddUpper && (!m_bHideFolder || !g_MainWnd.m_bShowFolder))
		AddUpper();
	else
		m_dwUpperParam = NULL;

	//ÕtH_𔻒
	LPTSTR lpszUpprFolder = NULL;
	if (_tcslen(m_szOldFolder) != 0)
	{
		if (lpszUpprFolder=_tcsrchr(m_szOldFolder, _T('/')))
		{
			if (_tcsncmp(lpszPath, m_szOldFolder, (lpszUpprFolder - m_szOldFolder)) == 0)
				lpszUpprFolder++;
			else
				lpszUpprFolder = NULL;
		}
	}

	//t@C̓ǂݍ
	HINTERNET hInternet = InternetOpen(APP_MAINWND_TITLE, INTERNET_OPEN_TYPE_DIRECT, NULL, NULL, 0);
	if (hInternet == NULL)
		MessageBox(g_MainWnd.m_hWnd, GetResourceString(IDS_MSG_NOTFOUND_PATH), NULL, MB_OK|MB_ICONSTOP);
	else
	{
		HINTERNET hFtp = InternetConnect(hInternet, m_szFtpServer, INTERNET_DEFAULT_FTP_PORT, m_szFtpUser, m_szFtpPassword, INTERNET_SERVICE_FTP, 0, 0);
		if (hFtp == NULL)
			MessageBox(g_MainWnd.m_hWnd, GetResourceString(IDS_MSG_NOTFOUND_PATH), NULL, MB_OK|MB_ICONSTOP);
		else
		{
			WIN32_FIND_DATA finddata;
			HINTERNET hFind = FtpFindFirstFile(hFtp, m_szFtpPath, &finddata, 0, 0);
			if (hFind != NULL)
			{
				do{
					//tH_\̏ꍇtH_𖳎
					if (m_bHideFolder && g_MainWnd.m_bShowFolder && (finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
						continue;

					//ACeǉ
					AddFolderItem(&finddata, lpszPath, &nAllSize);
				}while (InternetFindNextFile(hFind, &finddata));
				InternetCloseHandle(hFind);
			}
			InternetCloseHandle(hFtp);
		}
		InternetCloseHandle(hInternet);
	}

	// \[g
	if (g_MainWnd.m_bVirtualListView)
	{
		if (m_ItemStruct.GetCount())
			SortList();
	}
	else
	{
		if (ListView_GetItemCount(m_hWnd))
			SortList();
	}

	//ʍč\z
	MainWindowReset(lpszPath, nAllSize);
	m_nFileSize = nAllSize;

	//ACeI
	int nItem = 0;
	if (g_MainWnd.m_bVirtualListView)
	{
		if (lpszUpprFolder)
			nItem = m_ItemStruct.Find((LPFINDFUNC)SeekFolder, 0, (DWORD)lpszUpprFolder);
	}
	else
	{
		if (lpszUpprFolder)
		{
			LVFINDINFO lvfi;
			lvfi.flags = LVFI_STRING;
			lvfi.psz = lpszUpprFolder;
			nItem = ListView_FindItem(m_hWnd, -1, &lvfi);
		}
	}
	if (nItem < 0)
		nItem = 0;
	ListView_SetItemState(m_hWnd, -1, 0, LVIS_SELECTED);
	ListView_SetItemState(m_hWnd, nItem, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);
	ListView_EnsureVisible(m_hWnd, nItem, FALSE);

	//J[\ɖ߂
	SetCursor(hCursor);

	//OpXƂăpXۑ
	_tcscpy(m_szOldFolder, lpszPath);
}
#endif//SUPPORT_FTP

///////////////////////////////////////////////////////////////
void CListView::LoadFolderFiles(LPCTSTR lpszPath, BOOL bTVUpdate)
{
	//J[\ɂ
	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

	//Xe[^Xo[\(\)
	TCHAR szTemp[MAX_PATH];
	_stprintf(szTemp, GetResourceString(IDS_FMT_LOADING));
	g_MainWnd.m_StatusWnd.SetSimpleText(szTemp);

	//ǉ
	m_lpHistoryCurrent = AddHistory(m_lpHistoryCurrent, lpszPath);
	if (!m_lpHistory)
		m_lpHistory = m_lpHistoryCurrent;

	//ACeATCỸJEg
	LONGLONG nAllSize = 0;

	//ACe̍폜
	DeleteAllItem();

	// ̃tH_ւǉ
	if (_tcslen(lpszPath) && m_Settings.bAddUpper && (!m_bHideFolder || !g_MainWnd.m_bShowFolder))
		AddUpper();
	else
		m_dwUpperParam = NULL;

	//ÕtH_𔻒
	LPTSTR lpszUpprFolder = NULL;
	if (_tcslen(m_szOldFolder) != 0)
	{
		if (lpszUpprFolder=_tcsrchr(m_szOldFolder, _T('\\')))
		{
			if (_tcsncmp(lpszPath, m_szOldFolder, (lpszUpprFolder-m_szOldFolder)) == 0)
				lpszUpprFolder++;
			else
				lpszUpprFolder = NULL;
		}
	}

	//t@C̓ǂݍ
	_stprintf(szTemp, _T("%s\\*.*"), lpszPath);
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do{
			//tH_\̏ꍇtH_𖳎
			if (m_bHideFolder && g_MainWnd.m_bShowFolder && (finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
				continue;

			//ACeǉ
			AddFolderItem(&finddata, lpszPath, &nAllSize);
		}while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}

	// \[g
	if (g_MainWnd.m_bVirtualListView)
	{
		if (m_ItemStruct.GetCount())
			SortList();
	}
	else
	{
		if (ListView_GetItemCount(m_hWnd))
			SortList();
	}

	//ʍč\z
	MainWindowReset(lpszPath, nAllSize);
	m_nFileSize = nAllSize;

	//c[r[XV
	g_MainWnd.m_TreeView.SetCurrentFolder(lpszPath, bTVUpdate);

	//ACeI
	int nItem = 0;
	if (g_MainWnd.m_bVirtualListView)
	{
		if (lpszUpprFolder)
			nItem = m_ItemStruct.Find((LPFINDFUNC)SeekFolder, 0, (DWORD)lpszUpprFolder);
	}
	else
	{
		if (lpszUpprFolder)
		{
			LVFINDINFO lvfi;
			lvfi.flags = LVFI_STRING;
			lvfi.psz = lpszUpprFolder;
			nItem = ListView_FindItem(m_hWnd, -1, &lvfi);
		}
	}
	if (nItem < 0)
		nItem = 0;
	ListView_SetItemState(m_hWnd, -1, 0, LVIS_SELECTED);
	ListView_SetItemState(m_hWnd, nItem, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);
	ListView_EnsureVisible(m_hWnd, nItem, FALSE);

	//J[\ɖ߂
	SetCursor(hCursor);

	//OpXƂăpXۑ
	_tcscpy(m_szOldFolder, lpszPath);
}

///////////////////////////////////////////////////////////////
void CListView::LoadFolderItem(LPCTSTR lpszPath, BOOL bTVUpdate)
{
	//XVʒmsv
	DisableUpdateNotify();

	//ĕ`~
	SendMessage(m_hWnd, WM_SETREDRAW, (WPARAM)0, (LPARAM)0);

	//̏ꍇ
	if (IsSearchFolder(lpszPath))
		LoadFolderSearch(lpszPath);
#if defined(SUPPORT_FTP)
	//FTP̏ꍇ
	if (IsFtpFolder(lpszPath))
		LoadFolderFtp(lpszPath);
#endif//SUPPORT_FTP
	else
		LoadFolderFiles(lpszPath, bTVUpdate);

	//ĕ`Jn
	SendMessage(m_hWnd, WM_SETREDRAW, (WPARAM)1, (LPARAM)0);

	SetUpdateNotify(lpszPath);
	EnableUpdateNotify();
}

///////////////////////////////////////////////////////////////
//(WS007SHɂāuڍׁv\Ńt@C̕ƎNɗĂւ̑Ώ)
void CListView::InitFolderItem(LPCTSTR lpszPath)
{
	//XVʒmsv
	DisableUpdateNotify();

	LoadFolderFiles(lpszPath, TRUE);

	SetUpdateNotify(lpszPath);
	EnableUpdateNotify();
}

///////////////////////////////////////////////////////////////
void CListView::LoadFolderItemSub(LPCTSTR lpszPath)
{
	//ĕ`~
	SendMessage(m_hWnd, WM_SETREDRAW, (WPARAM)0, (LPARAM)0);

	//ACe폜
	DeleteAllItem();

	// ̃tH_ւݒ肵Ȃ
	m_dwUpperParam = NULL;

	//ACeATCỸJEgp
	LONGLONG nAllSize = 0;

	//t@C̓ǂݍ
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(lpszPath, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		//pXƃfBNg𕪗
		TCHAR szPath[MAX_PATH];
		_tcscpy(szPath, lpszPath);
		LPTSTR lpszTemp = _tcsrchr(szPath, _T('\\'));
		*lpszTemp = _T('\0');

		//ACeǉ
		AddFolderItem(&finddata, szPath, &nAllSize);

		//nhN[Y
		FindClose(hFind);
	}
	
	//JgtH_ݒ
	_tcscpy(m_szCurrentFolder, lpszPath);

	//ĕ`Jn
	SendMessage(m_hWnd, WM_SETREDRAW, (WPARAM)1, (LPARAM)0);
}

///////////////////////////////////////////////////////////////
void CListView::SelectFile(LPCTSTR lpszPath)
{
	//[gfBNg̏ꍇ
	if (_tcslen(lpszPath) == 0 || _tcscmp(lpszPath, GetRootName()) == 0)
		_tcscpy(m_szCurrentFolder, _T(""));
	else
	{
		//fBNgֈړ
		LoadFolderItemSub(lpszPath);
	
		//SẴACeIԂƂ
		ListView_SetItemState(m_hWnd, -1, LVIS_SELECTED, LVIS_SELECTED);
	}
}

///////////////////////////////////////////////////////////////
void CListView::AddUpper()
{
	// ̃tH_ւǉ
	LISTITEMCOMP *plic = new LISTITEMCOMP;
	memset(plic, 0, sizeof(LISTITEMCOMP));
	plic->nItem = LIST_ITEM_UPPER;

	plic->lpszName = new TCHAR[2+1];
	_tcscpy(plic->lpszName, _T(".."));
	if (g_MainWnd.m_bVirtualListView)
	{
		m_ItemStruct.Insert((DWORD)plic);
		m_dwUpperParam = (DWORD)plic;
		ListView_SetItemCountEx(m_hWnd, m_ItemStruct.GetCount(), 0);
	}
	else
	{
		LVITEM li;
		li.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
		li.iItem = 0;
		li.iSubItem = 0;
		li.iImage = I_IMAGECALLBACK;
		li.lParam = (DWORD)plic;
		li.pszText = _T("..");
		ListView_InsertItem(m_hWnd, &li);
		m_dwUpperParam = li.lParam;
	}
}

///////////////////////////////////////////////////////////////
void CListView::AddFolderItemFolder(LPCTSTR lpszPath, LPCTSTR lpszName, DWORD dwAttr, FILETIME ft, DWORD dwSize, LONGLONG* lpAllSize)
{
	//Bt@C`FbN
	if ((dwAttr & FILE_ATTRIBUTE_HIDDEN) && m_Settings.bHideHidden)
		return;

	//tH_
	LISTITEMCOMP *plic = new LISTITEMCOMP;
	plic->nItem = LIST_ITEM_FOLDER;
	plic->lpszName = new TCHAR[_tcslen(lpszName)+1];
	_tcscpy(plic->lpszName, lpszName);
	plic->lpszPath = new TCHAR[_tcslen(lpszPath)+1];
	_tcscpy(plic->lpszPath, lpszPath);
	for (LPTSTR lpszTemp = _tcsrchr(plic->lpszPath, _T('\0')) - 1; *lpszTemp == _T('\\') || *lpszTemp == _T('/'); lpszTemp--)
		*lpszTemp = _T('\0');
	plic->dwSize = 0;
	plic->ft = ft;
	plic->dwAttr = dwAttr;
	if (g_MainWnd.m_bVirtualListView)
	{
		m_ItemStruct.Add((DWORD)plic);
		ListView_SetItemCountEx(m_hWnd, m_ItemStruct.GetCount(), 0);
	}
	else
	{
		LVITEM li;
		li.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
		li.iItem = 0;
		li.iSubItem = 0;
		li.iImage = I_IMAGECALLBACK;
		li.lParam = (DWORD)plic;
		li.pszText = LPSTR_TEXTCALLBACK;
		ListView_InsertItem(m_hWnd, &li);
		ListView_SetItemText(m_hWnd, 0, 2, LPSTR_TEXTCALLBACK);
	}
}
///////////////////////////////////////////////////////////////
void CListView::AddFolderItemFile(LPCTSTR lpszPath, LPCTSTR lpszName, DWORD dwAttr, FILETIME ft, DWORD dwSize, LONGLONG* lpAllSize)
{
	//Bt@C`FbN
	if ((dwAttr & FILE_ATTRIBUTE_HIDDEN) && m_Settings.bHideHidden)
		return;

	//VXet@C`FbN
	if ((dwAttr & FILE_ATTRIBUTE_SYSTEM) && m_Settings.bHideSystem)
		return;

	//ROM`FbN
	if ((dwAttr & FILE_ATTRIBUTE_INROM) && m_Settings.bHideROM)
		return;

	// t@C
	LISTITEMCOMP *plic = new LISTITEMCOMP;
	plic->nItem = LIST_ITEM_FILE;
	plic->lpszName = new TCHAR[_tcslen(lpszName)+1];
	_tcscpy(plic->lpszName, lpszName);
	plic->lpszPath = new TCHAR[_tcslen(lpszPath)+1];
	_tcscpy(plic->lpszPath, lpszPath);
	plic->dwSize = dwSize;
	plic->ft = ft;
	plic->dwAttr = dwAttr;
	FileTimeToLocalFileTime(&plic->ft, &plic->ft);
	if (g_MainWnd.m_bVirtualListView)
	{
		*lpAllSize += dwSize;
		m_ItemStruct.Add((DWORD)plic);
		ListView_SetItemCountEx(m_hWnd, m_ItemStruct.GetCount(), 0);
	}
	else
	{
		LVITEM li;
		li.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
		li.iItem = 0;
		li.iSubItem = 0;
		li.iImage = I_IMAGECALLBACK;
		li.lParam = (DWORD)plic;
		li.pszText = LPSTR_TEXTCALLBACK;
		ListView_InsertItem(m_hWnd, &li);
		ListView_SetItemText(m_hWnd, 0, 1, LPSTR_TEXTCALLBACK);
		ListView_SetItemText(m_hWnd, 0, 2, LPSTR_TEXTCALLBACK);
		ListView_SetItemText(m_hWnd, 0, 3, LPSTR_TEXTCALLBACK);
		*lpAllSize += plic->dwSize;
	}
}

///////////////////////////////////////////////////////////////
void CListView::AddFolderItemSub(LPCTSTR lpszPath, LPCTSTR lpszName, DWORD dwAttr, FILETIME ft, DWORD dwSize, LONGLONG* lpAllSize)
{
	if (dwAttr & FILE_ATTRIBUTE_DIRECTORY)
		AddFolderItemFolder(lpszPath, lpszName, dwAttr, ft, dwSize, lpAllSize);
	else
		AddFolderItemFile(lpszPath, lpszName, dwAttr, ft, dwSize, lpAllSize);
}

///////////////////////////////////////////////////////////////
void CListView::AddFolderItem(WIN32_FIND_DATA *finddata, LPCTSTR lpszPath, LONGLONG* lpAllSize)
{
	if (finddata->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
	{
		AddFolderItemFolder(lpszPath,
						 finddata->cFileName,
						 finddata->dwFileAttributes,
						 finddata->ftCreationTime,
						 0,
						 lpAllSize);
	}
	else
	{
		AddFolderItemFile(lpszPath,
						 finddata->cFileName,
						 finddata->dwFileAttributes,
						 finddata->ftLastWriteTime,
						 finddata->nFileSizeLow,
						 lpAllSize);
	}
}

///////////////////////////////////////////////////////////////
void CListView::ComFileOpen(LPCTSTR lpszPath)
{
	//gq݂̂Rs[
	LPTSTR lpszExt = _tcsrchr(lpszPath, _T('.'));

	//ŏIIɃI[vpX
	LPTSTR lpszOpen = (LPTSTR)lpszPath;
	LPTSTR lpszParam = NULL;
	
	//gq`FbN
	if (_tcsicmp(lpszExt, _T(".LNK")) == 0)
	{
		//Nt@CƔF
		TCHAR szPath[MAX_PATH];
		if (SHGetShortcutTarget(lpszPath, szPath, MAX_PATH))
		{
			LPTSTR lpszStart = szPath;
			if (lpszStart[0] == _T('\"'))
			{
				LPTSTR lpszEnd = _tcschr(++lpszStart, _T('\"'));
				if (lpszEnd)
				{
					*lpszEnd = _T('\0');
					if (*(++lpszEnd))
						lpszParam = lpszEnd;
				}
			}
			else
			{
				LPTSTR lpszEnd = _tcschr(lpszStart, _T(' '));
				if (lpszEnd)
				{
					*lpszEnd = _T('\0');
					if (*(++lpszEnd))
						lpszParam = lpszEnd;
				}
			}
			
			//p[^l(󔒍폜)
			while (lpszParam)
			{
				if (!(*lpszParam))
					break;

				if (*lpszParam == _T(' '))
					lpszParam++;
				else
					break;

			}

			HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
			DWORD dwAttr = GetFileAttributes(lpszStart);
			SetCursor(hCursor);
			//fBNg̏ꍇ
			if ( dwAttr != 0xFFFFFFFF && (dwAttr & FILE_ATTRIBUTE_DIRECTORY))
			{
				LoadFolderItem(lpszStart);
				return;
			}
			
			//pX擾Nɐݒ
			lpszOpen = lpszStart;
			
			//gq݂̂ăRs[
			LPTSTR lpszExt = _tcsrchr(lpszStart, _T('.'));
		}
	}

	//kt@C𔻒
	if ((m_Settings.bDblClick) &&
	   ((g_MainWnd.m_Compress.IsCompress(COMPDLL_MODE_LHA) && _tcsicmp(lpszExt, _T(".LZH")) == 0) ||
	    (g_MainWnd.m_Compress.IsCompress(COMPDLL_MODE_ZIP) && _tcsicmp(lpszExt, _T(".ZIP")) == 0)))
	{
		//t@C𓀂̎s
		OnFileUnCompress();
		return;
	}
	
	//J
	SHELLEXECUTEINFO sei;
	ZeroMemory(&sei, sizeof(SHELLEXECUTEINFO));
	sei.cbSize = sizeof(SHELLEXECUTEINFO);
	//sei.fMask = 0;
	sei.hwnd = g_MainWnd.m_hWnd;
	sei.lpVerb = _T("open");
	sei.lpFile = lpszOpen;
	sei.lpParameters = lpszParam;
	//sei.lpDirectory = NULL;
	sei.nShow = SW_SHOW;
	sei.hInstApp = g_hInst;
	ShellExecuteEx(&sei);
}

///////////////////////////////////////////////////////////////
//\`̕ύX
void CListView::OnChangeListStyle(UINT nCmdID)
{
	switch (nCmdID)
	{
	case ID_VIEW_LARGEICON:
		m_Settings.dwListExStyle = 0;
		m_Settings.dwListStyle = LVS_ICON;
		break;

	case ID_VIEW_SMALLICON:
		m_Settings.dwListExStyle = 0;
		m_Settings.dwListStyle = LVS_SMALLICON;
		break;

	case ID_VIEW_LIST:
		m_Settings.dwListExStyle = 0;
		m_Settings.dwListStyle = LVS_LIST;
		break;

	case ID_VIEW_REPORT:
		m_Settings.dwListExStyle = 0;
		m_Settings.dwListStyle = LVS_REPORT;
		break;

	case ID_VIEW_REPORTLINE:
		m_Settings.dwListExStyle = LVS_EX_FULLROWSELECT;
		m_Settings.dwListStyle = LVS_REPORT;
		break;

	default:
		//ȂɂȂ(ݒ̂܂)
		break;
	}
	g_MainWnd.m_CmdBands.SetCheckListStyle(m_Settings.dwListStyle, m_Settings.dwListExStyle);

	DWORD dwStyle = m_Settings.dwListStyle;
	DWORD dwExStyle = m_Settings.dwListExStyle;
	if (g_MainWnd.m_bVirtualListView)
	{
		dwStyle |= DEF_LIST_STYLE_VIRTUAL;
		dwExStyle |= DEF_LIST_EXSTYLE_VIRTUAL;
	}
	else
	{
		dwStyle |= DEF_LIST_STYLE;
		dwExStyle |= DEF_LIST_EXSTYLE;
	}
	if (g_MainWnd.m_bTouchUI)
		dwExStyle |= LVS_EX_THEME;

	if (m_Settings.dwListStyle == LVS_REPORT && m_Settings.bHideHeader)
		dwStyle |= LVS_NOCOLUMNHEADER;
	if (m_Settings.dwListStyle == LVS_ICON)
		m_pFileImageList = &m_FileImageListLarge;
	else
		m_pFileImageList = &m_FileImageListSmall;

	SetWindowLong(m_hWnd, GWL_STYLE, dwStyle);
	ListView_SetExtendedListViewStyle(m_hWnd, dwExStyle);

	if (m_Settings.dwListStyle == LVS_ICON)
	{
		int cx = GetSystemMetrics(SM_CXICONSPACING);
		int cy = GetSystemMetrics(SM_CYICONSPACING);
		cx = (int)((float)cx * (m_ImageListSettings.bStuffingIcons? 0.75: 1) + 0.5);
		if (g_MainWnd.m_bHighRresolutionMode && g_MainWnd.m_bHighDpiHardware)
		{
			cx = (int)((float)cx / g_MainWnd.m_fpHighResolutionScale + 0.5);
			cy = (int)((float)cy / g_MainWnd.m_fpHighResolutionScale + 0.5);
		}
		ListView_SetIconSpacing(m_hWnd, cx, cy);
	}

	if (g_MainWnd.m_bVirtualListView)
	{
		if (m_Settings.dwListStyle == LVS_SMALLICON || m_Settings.dwListStyle == LVS_LIST)
		{
			int cx = GetSystemMetrics(SM_CXICONSPACING) * 2;
			if (m_Settings.dwListStyle == LVS_SMALLICON)
				cx = (int)((float)cx * (m_ImageListSettings.bStuffingIcons? 0.75: 1) + 0.5);
			if (g_MainWnd.m_bHighRresolutionMode && g_MainWnd.m_bHighDpiHardware)
				cx = (int)((float)cx / g_MainWnd.m_fpHighResolutionScale + 0.5);
			ListView_SetColumnWidth(m_hWnd, 0, cx);
			ListView_SetIconSpacing(m_hWnd, 640, -1);
		}
	}

	ListView_Arrange(m_hWnd, LVA_DEFAULT);

	//ʍXV
	InvalidateRect(g_MainWnd.m_hWnd, NULL, FALSE);
}
///////////////////////////////////////////////////////////////
//Xg̕בւ
void CListView::OnChangeSort(UINT nCmdID)
{
	switch (nCmdID)
	{
	case ID_VIEW_SORT_NAME:
		m_Settings.nSort = LIST_SORT_NAME;
		break;

	case ID_VIEW_SORT_EXT:
		m_Settings.nSort = LIST_SORT_EXT;
		break;

	case ID_VIEW_SORT_SIZE:
		m_Settings.nSort = LIST_SORT_SIZE;
		break;

	case ID_VIEW_SORT_TIME:
		m_Settings.nSort = LIST_SORT_TIME;
		break;

	case ID_VIEW_SORT_NOT_RAISE:
		m_Settings.bSortRaise = !m_Settings.bSortRaise;
		break;

	default:
		break;
	}

	SortList();
	
	g_MainWnd.m_CmdBands.SetCheckSort(m_Settings.nSort, m_Settings.bSortRaise);
}
///////////////////////////////////////////////////////////////
void CListView::OnViewUpdate(LPCTSTR lpszPath)
{
	TCHAR szTemp[MAX_PATH];

	if (lpszPath)
		_tcscpy(szTemp, lpszPath);
	else
		GetWindowText(g_MainWnd.m_CmdBands.m_hComboBox, szTemp, MAX_PATH);

	if (_tcscmp(szTemp, GetRootName()) == 0 || _tcscmp(szTemp, _T("\\")) == 0 ||
		_tcscmp(szTemp, _T("\\\\")) == 0 || _tcscmp(szTemp, _T("/")) == 0 || _tcslen(szTemp) == 0)
		LoadFolderItem(_T(""));
	else
	{
		//zpX̏ꍇ`FbNȂ
		if (IsSearchFolder(szTemp))
		{
			LoadFolderItem(szTemp);
			return;
		}
#if defined(SUPPORT_FTP)
		//ftp̏ꍇ`FbNȂ
		if (IsFtpFolder(szTemp))
		{
			LoadFolderItem(szTemp);
			return;
		}
#endif//SUPPORT_FTP

		//݂邩̊mF
		HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
		DWORD dwAttr = GetFileAttributes(szTemp);
		SetCursor(hCursor);
		if (dwAttr != 0xFFFFFFFF)
		{
			if (dwAttr & FILE_ATTRIBUTE_DIRECTORY)
				LoadFolderItem(szTemp);
			else
				ComFileOpen(szTemp);
		}
		else
			MessageBox(g_MainWnd.m_hWnd, GetResourceString(IDS_MSG_NOTFOUND_PATH), NULL, MB_OK|MB_ICONSTOP);
	}
}

///////////////////////////////////////////////////////////////
void CListView::OnViewUpFolder()
{
	LPTSTR lpszTemp;

	//pX̋؂蕶폜
	for (lpszTemp = _tcsrchr(m_szCurrentFolder, _T('\0')) - 1; *lpszTemp == _T('\\') || *lpszTemp == _T('/'); lpszTemp--)
		*lpszTemp = _T('\0');

	//tH_̏ꍇ
	if (IsSearchFolder(m_szCurrentFolder))
	{
		*m_szOldFolder = _T('\0');
		LoadFolderItem(_T(""));
	}
#if defined(SUPPORT_FTP)
	//FTP̏ꍇ
	else if (IsFtpFolder(m_szCurrentFolder))
	{
		lpszTemp = _tcsrchr(m_szCurrentFolder + 6, _T('/'));
		if (lpszTemp)
			*lpszTemp = _T('\0');
		LoadFolderItem(m_szCurrentFolder);
	}
#endif//SUPPORT_FTP
	else if (_tcscmp(m_szCurrentFolder, _T("")) != 0)
	{
		lpszTemp = _tcsrchr(m_szCurrentFolder, _T('\\'));
		if (lpszTemp)
		{
			*lpszTemp = _T('\0');
			if (_tcscmp(m_szCurrentFolder, _T("\\")) == 0)
				*m_szCurrentFolder = _T('\0');
			LoadFolderItem(m_szCurrentFolder);
		}
		else
			LoadFolderItem(_T(""));
	}
}

///////////////////////////////////////////////////////////////
void CListView::OnFileOpen()
{
	int nIndex = GetSelectedItemIndex(0);
	OnFileOpen(nIndex);
}
///////////////////////////////////////////////////////////////
void CListView::OnFileOpen(int nIndex)
{
	if (nIndex != -1)
	{
		LISTITEMCOMP *plic = GetListItemStruct(nIndex);
		TCHAR szPath[MAX_PATH];
		//pX쐬
#if defined(SUPPORT_FTP)
		//FTP̏ꍇ͋؂蕶"/"
		if (IsFtpFolder(plic->lpszPath))
			_stprintf(szPath, _T("%s/%s"), plic->lpszPath, plic->lpszName);
		//łȂ΋؂蕶"\"
		else
			_stprintf(szPath, _T("%s\\%s"), plic->lpszPath, plic->lpszName);
#else//SUPPORT_FTP
		_stprintf(szPath, _T("%s\\%s"), plic->lpszPath, plic->lpszName);
#endif//SUPPORT_FTP
		switch (plic->nItem)
		{
		case LIST_ITEM_FOLDER:
			//tH_J
			LoadFolderItem(szPath);
			break;

		case LIST_ITEM_FILE:
			//t@CJ
			ComFileOpen(szPath);
			break;

		case LIST_ITEM_UPPER:
			OnViewUpFolder();
			break;

		default:
			break;
		}
	}
}

///////////////////////////////////////////////////////////////
void CListView::OnItemChanged(LPNMLISTVIEW lpnmlv)
{
	if (!(lpnmlv->uOldState&LVIS_SELECTED) && (lpnmlv->uNewState&LVIS_SELECTED))
		g_MainWnd.m_CmdBands.SetEnableItemSelected();
}

///////////////////////////////////////////////////////////////
void CListView::OnFileCreateFolder()
{
	int nCount = 1;
	TCHAR szFolderPath[MAX_PATH];
	TCHAR szFolderName[MAX_PATH];
	BOOL bRet = FALSE;
	DisableUpdateNotify();
	_tcscpy(m_szLastCreateName, _T(""));
	while (!bRet)
	{
		if (nCount == 1)
		{
			_stprintf(szFolderPath, _T("%s\\%s"), m_szCurrentFolder, GetResourceString(IDS_NEW_FOLDER_NAME));
			_stprintf(szFolderName, _T("%s"), GetResourceString(IDS_NEW_FOLDER_NAME));
		}
		else
		{
			_stprintf(szFolderPath, _T("%s\\%s(%d)"), m_szCurrentFolder, GetResourceString(IDS_NEW_FOLDER_NAME), nCount);
			_stprintf(szFolderName, _T("%s(%d)"), GetResourceString(IDS_NEW_FOLDER_NAME), nCount);
		}
		nCount++;
		bRet = CreateDirectory(szFolderPath, NULL);
		if (nCount > 4096)
		{
			MessageBox(g_MainWnd.m_hWnd, GetResourceString(IDS_MSG_CANNOTCREATEFOLDER), NULL, MB_OK);
			EnableUpdateNotify();

			return;
		}
	}
	LoadFolderItem(m_szCurrentFolder, TRUE);
	_tcscpy(m_szLastCreateName, szFolderName);

	SetFocus(m_hWnd);
	if (g_MainWnd.m_bVirtualListView)
		ListView_EditLabel(m_hWnd, m_ItemStruct.Find((LPFINDFUNC)SeekFolder, 0, (DWORD)szFolderName));
	else
	{
		LVFINDINFO lvfi;
		lvfi.flags = LVFI_STRING;
		lvfi.psz = szFolderName;
		ListView_EditLabel(m_hWnd, ListView_FindItem(m_hWnd, -1, &lvfi));
	}
	EnableUpdateNotify();
}
///////////////////////////////////////////////////////////////
BOOL CListView::OnEndLabelEdit(LV_DISPINFO* pdi)
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pdi;

	int nIndex = pDispInfo->item.iItem;
	if (!pDispInfo->item.pszText) return FALSE;

	//G[`FbN
	if (_tcschr(pDispInfo->item.pszText, _T('\\')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T('/')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T(':')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T(',')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T(';')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T('*')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T('?')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T('<')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T('>')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T('|')) != NULL)
	{
		MessageBox(g_MainWnd.m_hWnd, GetResourceString(IDS_MSG_CANNOTUSECHAR), NULL, MB_OK|MB_ICONSTOP);
		SetFocus(m_hWnd);
		ListView_EditLabel(m_hWnd, nIndex);
		return FALSE;
	}
	else
	{
		LISTITEMCOMP* plic = GetListItemStruct(nIndex);
		TCHAR szOldName[MAX_PATH];
		TCHAR szTo[MAX_PATH];
		_tcscpy(szOldName,  plic->lpszName);
		_tcscpy(szTo,  pDispInfo->item.pszText);

		if (plic->nItem == LIST_ITEM_UPPER)
			return FALSE;

		//gq\Ȃݒł͊gq
		if (m_Settings.bNotShowExt && plic->nItem == LIST_ITEM_FILE)
			SetExtFromFileName(szTo, szOldName);
		if (_tcslen(pDispInfo->item.pszText))
		{
			TCHAR szNewPath[MAX_PATH];
			TCHAR szOldPath[MAX_PATH];

			_stprintf(szOldPath, _T("%s\\%s"), plic->lpszPath, szOldName);
			_stprintf(szNewPath, _T("%s\\%s"), plic->lpszPath, szTo);
			DisableUpdateNotify();
			if (MoveFile(szOldPath, szNewPath) != 0)
			{
				EnableUpdateNotify();

				//\̂̕ύX
				delete[] plic->lpszName;
				if (plic->lpszDispName) delete[] plic->lpszDispName;
				if (plic->lpszDispSize) delete[] plic->lpszDispSize;
				if (plic->lpszDispType) delete[] plic->lpszDispType;
				if (plic->lpszDispTime) delete[] plic->lpszDispTime;
				plic->lpszDispName = NULL;
				plic->lpszDispSize = NULL;
				plic->lpszDispType = NULL;
				plic->lpszDispTime = NULL;
				plic->lpszName = new TCHAR[_tcslen(szTo)+1];
				_tcscpy(plic->lpszName, szTo);
				if (plic->nItem != LIST_ITEM_FOLDER)
					plic->nIcon = -1;
				
				if (IsSearchFolder(m_szCurrentFolder))
					EditSearch(plic->lpszPath, szOldName, plic->lpszPath, szTo);

				g_MainWnd.m_TreeView.SetCurrentFolder(m_szCurrentFolder);
			}
			else
			{
				MessageBox(g_MainWnd.m_hWnd, GetResourceString(IDS_MSG_RENAMEERROR), NULL, MB_OK|MB_ICONSTOP);
				EnableUpdateNotify();

				return FALSE;
			}

		}
		else
		{
			//s
			MessageBox(g_MainWnd.m_hWnd, GetResourceString(IDS_MSG_INPUTNAME), NULL, MB_OK|MB_ICONSTOP);
			SetFocus(m_hWnd);
			ListView_EditLabel(m_hWnd, nIndex);

			return FALSE;
		}
	}

	return TRUE;
}
///////////////////////////////////////////////////////////////
void CListView::OnFileRename()
{
	int nIndex = GetSelectedItemIndex(0);
	if (nIndex != -1)
	{
		SetFocus(m_hWnd);
		ListView_EditLabel(m_hWnd, nIndex);
	}
}
////////////////////////////////////////////////////////////////
int CListView::GetSelectedItemIndex(int nStart)
{
	return ListView_GetNextItem(m_hWnd, nStart - 1, LVNI_SELECTED);
}

////////////////////////////////////////////////////////////////
void CListView::OnEditCopyFileName() 
{
	int nIndex;
	TCHAR *szPath = new TCHAR[(MAX_PATH + 2) * GetValidAndSelectedCount() + 2];
	if (!szPath)
		return;

	*szPath = _T('\0');
	nIndex = GetSelectedItemIndex(0);
	if (nIndex != -1)
	{
		for (; nIndex != -1; nIndex = GetSelectedItemIndex(nIndex + 1))
		{
			LISTITEMCOMP *plic = GetListItemStruct(nIndex);
			if (plic->nItem != LIST_ITEM_UPPER)
			{
				if (_tcslen(szPath))
					_tcscat(szPath, _T("\n\r"));
				_tcscat(szPath, plic->lpszName);
				if (plic->nItem == LIST_ITEM_FOLDER)
					_tcscat(szPath, _T("\\"));
			}
		}
	}
	if (_tcslen(szPath))
	{
		if (OpenClipboard(g_MainWnd.m_hWnd))
		{
			EmptyClipboard();
			HANDLE hHandle = GlobalAlloc(GMEM_FIXED, (_tcslen(szPath) + 1) * sizeof(TCHAR));
			TCHAR* lpszCb = (TCHAR*)GlobalLock(hHandle);
			_tcscpy(lpszCb, szPath);
			GlobalUnlock(hHandle);
			SetClipboardData(CF_UNICODETEXT, hHandle);
			CloseClipboard();
		}
	}

	delete szPath;
}

////////////////////////////////////////////////////////////////
LISTITEMCOMP* CListView::GetListItemStruct(int nIndex)
{
	if (g_MainWnd.m_bVirtualListView)
		return (LISTITEMCOMP*)m_ItemStruct.GetAt(nIndex);
	else
	{
		LVITEM li;
		li.iItem = nIndex;
		li.iSubItem = 0;
		li.mask = LVIF_PARAM;
		ListView_GetItem(m_hWnd, &li);

		return (LISTITEMCOMP*)li.lParam;
	}
}

////////////////////////////////////////////////////////////////
void CListView::OnEditCopyFilePath() 
{
	int nIndex;
	TCHAR *szPath = new TCHAR[(MAX_PATH + 2) * GetValidAndSelectedCount() + 2];
	if (!szPath)
		return;

	*szPath = _T('\0');
	nIndex = GetSelectedItemIndex(0);
	if (nIndex != -1)
	{
		for (; nIndex != -1; nIndex = GetSelectedItemIndex(nIndex + 1))
		{
			LISTITEMCOMP *plic = GetListItemStruct(nIndex);
			if (plic->nItem != LIST_ITEM_UPPER)
			{
				TCHAR szTemp[MAX_PATH * 2];
				_stprintf(szTemp, _T("%s\\%s"), plic->lpszPath, plic->lpszName);
				if (_tcslen(szPath))
					_tcscat(szPath, _T("\n\r"));
				_tcscat(szPath, szTemp);
				if (plic->nItem == LIST_ITEM_FOLDER)
					_tcscat(szPath, _T("\\"));
			}
		}
	}
	else
	{
		if (_tcslen(m_szCurrentFolder) == 0)
			_tcscpy(szPath, _T("\\"));
		else
			_tcscpy(szPath, m_szCurrentFolder);
	}
	if (_tcslen(szPath))
	{
		if (OpenClipboard(g_MainWnd.m_hWnd))
		{
			EmptyClipboard();
			HANDLE hHandle = GlobalAlloc(GMEM_FIXED, (_tcslen(szPath) + 1) * sizeof(TCHAR));
			TCHAR* lpszCb = (TCHAR*)GlobalLock(hHandle);
			_tcscpy(lpszCb, szPath);
			GlobalUnlock(hHandle);
			SetClipboardData(CF_UNICODETEXT, hHandle);
			CloseClipboard();
		}
	}

	delete szPath;
}

////////////////////////////////////////////////////////////////
void CListView::OnSelEndOK()
{
	TCHAR szTemp[MAX_PATH];
	SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_GETLBTEXT,
		SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_GETCURSEL, 0, 0), (LPARAM)szTemp);

	SetFocus(m_hWnd);

	//AhXo[̃R}hs
	OnViewUpdate(szTemp);
}

////////////////////////////////////////////////////////////////
void CListView::OnFileCreateShortcut()
{
	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

	//V[gJbg̍쐬
	int nIndex = GetSelectedItemIndex(0);
	while (nIndex != -1)
	{
		LISTITEMCOMP* plic = GetListItemStruct(nIndex);
		CreateShortcut(m_szCurrentFolder, plic->lpszPath, plic->lpszName, m_Settings.bNotShortcutName);
		nIndex = GetSelectedItemIndex(nIndex+1);
	}
	LoadFolderItem(m_szCurrentFolder, FALSE);

	SetCursor(hCursor);
}
////////////////////////////////////////////////////////////////
void CListView::OnFileShortcutFolder(LPTSTR lpszPath)
{
	TCHAR szFolder[MAX_PATH];
	BOOL bRefresh = FALSE;
	int Rtn = IDOK;

	if (lpszPath)
		_tcscpy(szFolder, lpszPath);
	else
	{
		_tcscpy(szFolder, m_szCurrentFolder);
		CFolderDlg fd;
		Rtn = fd.ShowFolderDlg(GetResourceString(IDS_TITLE_SHORTCUT), szFolder, MAX_PATH);
	}
	if (Rtn == IDOK)
	{
		if (_tcsicmp(szFolder, m_szCurrentFolder) == 0)
			bRefresh = TRUE;

		HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

		//V[gJbg̍쐬
		int nIndex = GetSelectedItemIndex(0);
		while (nIndex != -1)
		{
			LISTITEMCOMP* plic = GetListItemStruct(nIndex);
			CreateShortcut(szFolder, plic->lpszPath, plic->lpszName, m_Settings.bNotShortcutName);
			nIndex = GetSelectedItemIndex(nIndex + 1);
		}
		SetCursor(hCursor);
	}

	if (bRefresh)
		LoadFolderItem(m_szCurrentFolder, FALSE);
}

////////////////////////////////////////////////////////////////
void CListView::OnFileCreateNewShortcut()
{
	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
	TCHAR	szCreateName[MAX_PATH];

	//V[gJbg̍쐬
	CreateShortcut(m_szCurrentFolder, NULL, GetResourceString(IDS_NEW_SHORTCUT_NAME), TRUE);
	LoadFolderItem(m_szCurrentFolder, FALSE);
	_tcscpy(szCreateName, m_szLastCreateName);

	int nItem;

	if (g_MainWnd.m_bVirtualListView)
		nItem = m_ItemStruct.Find((LPFINDFUNC)SeekFolder, 0, (DWORD)szCreateName);
	else
	{
		LVFINDINFO lvfi;
		lvfi.flags = LVFI_STRING;
		lvfi.psz = szCreateName;
		nItem = ListView_FindItem(m_hWnd, -1, &lvfi);
	}
	if (nItem < 0)
		nItem = 0;
	ListView_SetItemState(m_hWnd, -1, 0, LVIS_SELECTED);
	ListView_SetItemState(m_hWnd, nItem, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);
	ListView_EnsureVisible(m_hWnd, nItem, FALSE);
	SetCursor(hCursor);

	//vpeBʂJ
	SendMessage(g_MainWnd.m_hWnd, WM_COMMAND, (WPARAM)ID_FILE_PROPERTY, 0);
}

////////////////////////////////////////////////////////////////
void CListView::OnViewFolder()
{
	TCHAR szPath[MAX_PATH];
	_tcscpy(szPath, m_szCurrentFolder);
	CFolderDlg fd;
	int nRet = fd.ShowFolderDlg(GetResourceString(IDS_TITLE_FOLDERVIEW), szPath, MAX_PATH);
	if (nRet == IDOK)
	{
		LoadFolderItem(szPath);
	}
	else
	{
		if (fd.m_bRefresh)
			LoadFolderItem(m_szCurrentFolder);
	}
}
////////////////////////////////////////////////////////////////
void CListView::OnFileProperty()
{
	DisableUpdateNotify();
	int nCount = GetValidAndSelectedCount();
	if (nCount > 0)
	{
		LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
		MakeSelectedItemsStrings(pliinfo, nCount);

		CFileProperty fp;

		if (fp.ShowFileProperty(pliinfo->szPath, pliinfo, nCount))
			LoadFolderItem(pliinfo->szPath);

		delete[] pliinfo;
	}
	else if (_tcslen(m_szCurrentFolder) && (ListView_GetSelectedCount(m_hWnd) == 0 || nCount ==0))
	{
		LISTITEMINFO liinfo;
		TCHAR szParent[MAX_PATH];
		_tcscpy(szParent, m_szCurrentFolder);
		LPTSTR psz = _tcsrchr(szParent, _T('\\'));
		if (psz) *psz = _T('\0');
		liinfo.nItem = LIST_ITEM_FOLDER;
		_tcscpy(liinfo.szName, ++psz);

		CFileProperty fp;
		if (fp.ShowFileProperty(szParent, &liinfo, 1))
		{
			_stprintf(m_szCurrentFolder, _T("%s\\%s"), szParent, fp.m_szNewName);
			LoadFolderItem(m_szCurrentFolder);
		}
	}
	else
	{
		LISTITEMINFO liinfo;
		liinfo.nItem = LIST_ITEM_FOLDER;
		liinfo.bDone = FALSE;
		liinfo.nIndex = 1;
		_tcscpy(liinfo.szPath, _T(""));
		_tcscpy(liinfo.szName, GetRootName());

		CFileProperty fp;
		if (fp.ShowFileProperty(liinfo.szPath, &liinfo, 1))
			LoadFolderItem(liinfo.szPath);
	}

	EnableUpdateNotify();
}

////////////////////////////////////////////////////////////////
void CListView::MakeSelectedItemsStrings(LISTITEMINFO* lpListItemComp, int nCount)
{
	int i = 0;
	int nIndex = GetSelectedItemIndex(0);
	ZeroMemory(lpListItemComp, sizeof(LISTITEMINFO)*nCount);//(SđIRs[ŃnOAbvւ̑Ώ)
	while (nIndex != -1)
	{
		LISTITEMCOMP* plic = GetListItemStruct(nIndex);
		if (plic->nItem == LIST_ITEM_UPPER) 
		{
			nIndex = GetSelectedItemIndex(++nIndex);	
			continue;
		}

		_tcscpy(lpListItemComp[i].szPath, plic->lpszPath);
		_tcscpy(lpListItemComp[i].szName, plic->lpszName);
		lpListItemComp[i].nItem = plic->nItem;
		lpListItemComp[i].bDone = FALSE;
		lpListItemComp[i].nIndex = nIndex;
		i++;

		nIndex = GetSelectedItemIndex(++nIndex);
	}
}
////////////////////////////////////////////////////////////////
void CListView::OnFileIRSend()
{
	int nIndex = GetSelectedItemIndex(0);
	if (nIndex != -1)
	{
		LISTITEMCOMP* plic = GetListItemStruct(nIndex);
		if (plic->nItem == LIST_ITEM_FILE)
		{
			TCHAR szPath[MAX_PATH];
			_stprintf(szPath, _T("%s\\%s"), plic->lpszPath, plic->lpszName);

			SHELLEXECUTEINFO sei;
			ZeroMemory(&sei, sizeof(SHELLEXECUTEINFO));
			sei.cbSize = sizeof(SHELLEXECUTEINFO);
			//sei.fMask = 0;
			sei.hwnd = g_MainWnd.m_hWnd;
			sei.lpVerb = _T("open");
			sei.lpParameters = szPath;
			sei.lpDirectory = g_MainWnd.m_szWindowsPath;
			sei.nShow = SW_SHOW;
			sei.hInstApp = g_hInst;
			sei.lpFile = _T(":MSBEAM");
			ShellExecuteEx(&sei);
		}
	}
}
////////////////////////////////////////////////////////////////
void CListView::OnFileCopyFolder()
{
	TCHAR szFolderTo[MAX_PATH] = {0};
	_tcscpy(szFolderTo, m_szCurrentFolder);
	CFolderDlg fd;
	int nRet = fd.ShowFolderDlg(GetResourceString(IDS_TITLE_COPY), szFolderTo, MAX_PATH);
	if (nRet == IDOK)
	{
		//t@C̃Rs[s
		int nCount = ListView_GetSelectedCount(m_hWnd);
		if (nCount > 0)
		{
			LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
			MakeSelectedItemsStrings(pliinfo, nCount);

			CCopyFileDlg cfd;
			int nRet = cfd.ShowCopyFileDlg(m_szCurrentFolder, szFolderTo, pliinfo, nCount, FALSE);
			if (fd.m_bRefresh || nRet == IDOK)
			{
				g_MainWnd.m_TreeView.SetCurrentFolder(szFolderTo);
				LoadFolderItem(m_szCurrentFolder, FALSE);
			}

			delete[] pliinfo;
		}
	}
	else
	{
		if (fd.m_bRefresh)
		{
			g_MainWnd.m_TreeView.SetCurrentFolder(szFolderTo);
			LoadFolderItem(m_szCurrentFolder, FALSE);
		}
	}
}

////////////////////////////////////////////////////////////////
void CListView::OnFileMoveFolder()
{
	TCHAR szFolderTo[MAX_PATH] = {0};
	_tcscpy(szFolderTo, m_szCurrentFolder);
	CFolderDlg fd;
	int nRet = fd.ShowFolderDlg(GetResourceString(IDS_TITLE_MOVE), szFolderTo, MAX_PATH);
	if (nRet == IDOK)
	{
		//t@C̃Rs[s
		int nCount = ListView_GetSelectedCount(m_hWnd);
		if (nCount > 0)
		{
			LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
			MakeSelectedItemsStrings(pliinfo, nCount);

			CCopyFileDlg cfd;
			int nRet = cfd.ShowCopyFileDlg(m_szCurrentFolder, szFolderTo, pliinfo, nCount, TRUE);
			if (fd.m_bRefresh || nRet == IDOK)
			{
				g_MainWnd.m_TreeView.SetCurrentFolder(szFolderTo);
				LoadFolderItem(m_szCurrentFolder, TRUE);
			}

			delete[] pliinfo;
		}
	}
	else
	{
		if (fd.m_bRefresh)
		{
			g_MainWnd.m_TreeView.SetCurrentFolder(szFolderTo);
			LoadFolderItem(m_szCurrentFolder, TRUE);
		}
	}
}

////////////////////////////////////////////////////////////////
void CListView::OnFileToApp()
{
	//IACe擾
	int nIndex = GetSelectedItemIndex(0);
	if (nIndex == -1)
		return;

	LISTITEMCOMP* plic = GetListItemStruct(nIndex);
	if (plic->nItem != LIST_ITEM_FILE)
		return;

	//AvP[VI_CAO쐬
	CAssociation Dlg(g_MainWnd.m_hWnd, g_hInst);
	Dlg.OpenChoose(plic->lpszPath, plic->lpszName);
}

////////////////////////////////////////////////////////////////
void CListView::OnFileMailSend()
{
	TCHAR szProc[MAX_PATH];
	TCHAR szParam[1024];
	STARTUPINFO info;
	PROCESS_INFORMATION pinfo;
	LISTITEMCOMP *plic;
	int nIndex;

	nIndex = GetSelectedItemIndex(0);
	if (nIndex != -1)
	{
		plic = GetListItemStruct(nIndex);
		if (plic->nItem == LIST_ITEM_FILE)
		{
			_stprintf(szProc, _T("%s\\tmail.exe"), g_MainWnd.m_szWindowsPath);
			_stprintf(szParam, _T("-attach \"%s\\%s\""), plic->lpszPath, plic->lpszName);
			memset(&info, 0, sizeof(info));
			info.cb = sizeof(info);
			info.wShowWindow = SW_SHOWNORMAL;	
			CreateProcess(szProc,szParam,NULL,NULL,FALSE,0,NULL,NULL,&info,&pinfo);
		}
	}
}

////////////////////////////////////////////////////////////////
void CListView::OnEditCut(LPCWCH lpszFolderFrom)
{
	//؂
	int nCount = GetValidAndSelectedCount();
	if (nCount > 0)
	{
		if (m_lpliinfo)
		{
			delete[] m_lpliinfo;
			m_lpliinfo = NULL;
			m_nCount = 0;
		}
	
		LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
		MakeSelectedItemsStrings(pliinfo, nCount);

		_tcscpy(m_szFolderFrom, lpszFolderFrom? lpszFolderFrom: m_szCurrentFolder);

		m_lpliinfo = pliinfo;
		m_nCount = nCount;
		m_bFileMove = TRUE;

		g_MainWnd.m_CmdBands.SetEnableEditPaste(TRUE);

		for (int i = 0; i < ListView_GetItemCount(m_hWnd); i++)
		{
			if (ListView_GetItemState(m_hWnd, i, LVIS_SELECTED) == LVIS_SELECTED)
			{
				ListView_SetItemState(m_hWnd, i, LVIS_CUT, LVIS_CUT);
			}
			else
			{
				ListView_SetItemState(m_hWnd, i, 0, LVIS_CUT);
			}
		}
	}
}
////////////////////////////////////////////////////////////////
void CListView::OnEditCopy(LPCWCH lpszFolderFrom)
{
	//Rs[
	if (m_lpliinfo)
	{
		delete[] m_lpliinfo;
		m_lpliinfo = NULL;
		m_nCount = 0;
	}

	int nCount = GetValidAndSelectedCount();
	if (nCount > 0)
	{
		LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
		MakeSelectedItemsStrings(pliinfo, nCount);

		_tcscpy(m_szFolderFrom, lpszFolderFrom? lpszFolderFrom: m_szCurrentFolder);

		m_lpliinfo = pliinfo;
		m_nCount = nCount;
		m_bFileMove = FALSE;

		g_MainWnd.m_CmdBands.SetEnableEditPaste(TRUE);

		ListView_SetItemState(m_hWnd, -1, 0, LVIS_CUT);
	}
}

////////////////////////////////////////////////////////////////
void CListView::OnEditPaste(BOOL bUpdate)
{
	//\t
	if (m_nCount > 0 && m_lpliinfo)
	{
		// ݊mF
		for (int i = 0; i < m_nCount; i++)
		{
			if (m_lpliinfo[i].nItem == LIST_ITEM_UPPER)
				continue;

			TCHAR szPath[MAX_PATH];
			_stprintf(szPath, _T("%s\\%s"), m_lpliinfo[i].szPath, m_lpliinfo[i].szName);
			if (GetFileAttributes(szPath) == 0xFFFFFFFF)
			{
				// G[
				MessageBox(g_MainWnd.m_hWnd, GetResourceString(IDS_MSG_PASTEERROR), NULL, MB_OK|MB_ICONSTOP);

				delete[] m_lpliinfo;
				m_lpliinfo = NULL;
				m_nCount = 0;
				_tcscpy(m_szFolderFrom, _T(""));
				g_MainWnd.m_CmdBands.SetEnableEditPaste(FALSE);
				return;
			}
		}

		// \t
		CCopyFileDlg cfd;
		if (cfd.ShowCopyFileDlg(m_szFolderFrom, m_szCurrentFolder, m_lpliinfo, m_nCount, m_bFileMove) == IDOK)
		{
			//Xgr[XV
			if (bUpdate)
				LoadFolderItem(m_szCurrentFolder, FALSE);

			//tH_Ȃ̂
			BOOL bSearch = IsSearchFolder(m_szFolderFrom);

			// Rs[orړ̂ɃtH_ꍇ̓c[r[XV
			BOOL bFolders = FALSE;
			for (int i = 0; i < m_nCount; i++)
			{
				if (bSearch && m_bFileMove)
					EditSearch(m_lpliinfo[i].szPath, m_lpliinfo[i].szName, m_szCurrentFolder, m_lpliinfo[i].szName);

				if (m_lpliinfo[i].nItem == LIST_ITEM_FOLDER)
				{
					g_MainWnd.m_TreeView.SetCurrentFolder(m_lpliinfo[i].szPath, TRUE, FALSE);
					bFolders = TRUE;
				}
			}

			//XVΏۂꍇ
			if (bFolders)
				g_MainWnd.m_TreeView.SetCurrentFolder(m_szCurrentFolder, TRUE, bUpdate);
		}

		if (m_bFileMove)
		{
			delete[] m_lpliinfo;
			m_lpliinfo = NULL;
			m_nCount = 0;
			_tcscpy(m_szFolderFrom, _T(""));
			g_MainWnd.m_CmdBands.SetEnableEditPaste(FALSE);
		}
	}
}
////////////////////////////////////////////////////////////////
void CListView::OnFileDelete()
{
	//t@C̍폜
	int nCount = GetValidAndSelectedCount();
	if (nCount > 0)
	{
		LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
		MakeSelectedItemsStrings(pliinfo, nCount);

		CDeleteFileDlg dfd;
		if (dfd.ShowDeleteFileDlg(m_szCurrentFolder, pliinfo, nCount) == IDOK)
		{
			for (int i = nCount - 1; i >= 0; i--)
			{
				if (pliinfo[i].bDone)
				{
					LISTITEMCOMP* pDel = GetListItemStruct(pliinfo[i].nIndex);
					delete[] pDel->lpszDispName;
					delete[] pDel->lpszDispSize;
					delete[] pDel->lpszDispType;
					delete[] pDel->lpszDispTime;
					delete[] pDel->lpszName; 
					delete[] pDel->lpszPath;
					delete pDel;
					if (g_MainWnd.m_bVirtualListView)
						m_ItemStruct.RemoveAt(pliinfo[i].nIndex);
					ListView_DeleteItem(m_hWnd, pliinfo[i].nIndex);
					if (pliinfo[i].nItem == LIST_ITEM_FOLDER)
						g_MainWnd.m_TreeView.SetCurrentFolder(pliinfo[i].szPath);
				}
			}
			ListView_Arrange(m_hWnd, LVA_DEFAULT);
			LoadFolderReset(m_szCurrentFolder);
		}

		delete[] pliinfo;
	}
}

////////////////////////////////////////////////////////////////
BOOL CListView::OnFileCompress()
{
	//IACe擾
	int nCount = GetValidAndSelectedCount();
	//G[
	if (nCount <= 0) return FALSE;

	//ACeXg쐬
	LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
	MakeSelectedItemsStrings(pliinfo, nCount);

	//k
	BOOL bRtn = g_MainWnd.m_Compress.OnFileCompress(
						m_szCurrentFolder,
						nCount,
						pliinfo,
						m_Settings.nCompDLL,
						m_Settings.bMoveDir,
						m_Settings.bAutoUnComp,
						m_szCompressFolder);

	//Xg폜
	delete[] pliinfo;

	//k
	if (bRtn)
	{
		//c[r[/Xgr[̍XV
		LoadFolderItem(m_szCurrentFolder);
		return TRUE;
	}

	return FALSE;
}

////////////////////////////////////////////////////////////////
BOOL CListView::OnFileUnCompress()
{
	//IACe擾
	int nCount = GetValidAndSelectedCount();
	//G[
	if (nCount <= 0) return FALSE;

	//ACeXg쐬
	LISTITEMINFO* pliinfo = new LISTITEMINFO[nCount];
	MakeSelectedItemsStrings(pliinfo, nCount);

	//
	BOOL bRtn = g_MainWnd.m_Compress.OnFileUnCompress(
						m_szCurrentFolder,
						nCount,
						pliinfo,
						m_Settings.nCompDLL,
						m_Settings.bMoveDir,
						m_Settings.bMakeDir,
						m_Settings.bAutoUnComp,
						m_szCompressFolder);

	//Xg폜
	delete[] pliinfo;

	//𓀂ꍇ
	if (bRtn)
	{
		//c[r[/Xgr[̍XV
		LoadFolderItem(m_szCurrentFolder);
	}

	return bRtn;
}

////////////////////////////////////////////////////////////////
void CListView::OnFileOpenParam()
{
	int nIndex = GetSelectedItemIndex(0);
	if (nIndex != -1)
	{
		LISTITEMCOMP* plic = GetListItemStruct(nIndex);
		if (plic->nItem == LIST_ITEM_FILE)
		{
			DialogBox(g_hInst, (LPCTSTR)IDD_EXECUTE_DLG, g_MainWnd.m_hWnd, (DLGPROC)FileOpenParamDlgProc);
			SipShowIM(SIPF_OFF);
		}
	}
}

////////////////////////////////////////////////////////////////
HMENU CListView::GetOpenAppSubMenu1() 
{
	return GetSubMenu(GetSubMenu(m_hMenuPopup, ID_POPUP_FILEVIEW_FILE), 1);
}

////////////////////////////////////////////////////////////////
HMENU CListView::GetOpenAppSubMenu2() 
{
	return GetSubMenu(g_MainWnd.m_CmdBands.m_hMenuFile, 1);
}

////////////////////////////////////////////////////////////////
void CListView::DeleteOpenAppSubMenuSep(HMENU hMenu)
{
	DeleteMenu(hMenu, 7, MF_BYPOSITION);
}

////////////////////////////////////////////////////////////////
void CListView::InitOpenAppMenu()
{
	HMENU hSubMenu1 = GetOpenAppSubMenu1();
	HMENU hSubMenu2 = GetOpenAppSubMenu2();

	if (m_nOpenAppInfoCount)
	{
		DeleteOpenAppSubMenuSep(hSubMenu1);
		DeleteOpenAppSubMenuSep(hSubMenu2);
	}

	for (int i = 0; i < m_nOpenAppInfoCount; i++)
	{
		OPENAPPINFO* poa= m_lpOpenAppInfo[i];
		if (poa)
		{
			delete poa->lpszPath;
			delete poa;
			m_lpOpenAppInfo[i] = NULL;
		}
		
		DeleteMenu(hSubMenu1, ID_FILE_OPEN_APP + i, MF_BYCOMMAND);
		DeleteMenu(hSubMenu2, ID_FILE_OPEN_APP + i, MF_BYCOMMAND);
	}
	m_nOpenAppInfoCount = 0;

	TCHAR szTemp[MAX_PATH + 4];
	int nCount = 0;

	_stprintf(szTemp, _T("%s\\*.*"), g_MainWnd.m_szSendAppPath);
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do{
			if (!(finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			{
				LPTSTR lpszExt = _tcsrchr(finddata.cFileName, _T('.'));
				if (lpszExt != NULL)
				{
					if (_tcsicmp(lpszExt, _T(".EXE")) == 0 || _tcsicmp(lpszExt, _T(".LNK")) == 0)
					{
						nCount += 1;
						if (nCount >= MAX_OPENAPP) break;
					}
				}
			}
		}while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}

	m_nOpenAppInfoCount = nCount;
	if (nCount == 0) return;

	hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		nCount = 0;
		AppendMenu(hSubMenu1, MF_SEPARATOR, NULL, NULL);
		AppendMenu(hSubMenu2, MF_SEPARATOR, NULL, NULL);
		do{
			if (!(finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			{
				LPTSTR lpszExt = _tcsrchr(finddata.cFileName, _T('.'));
				if (lpszExt != NULL)
				{
					if (_tcsicmp(lpszExt, _T(".EXE")) == 0 || _tcsicmp(lpszExt, _T(".LNK")) == 0)
					{
						//ǉ
						TCHAR szPath[MAX_PATH];
						if (g_MainWnd.m_bNumberShortcut)
						{
							int t = nCount+7;
							if (t < 11)
								_stprintf(szPath, _T("&%1d %s"), t%10, finddata.cFileName);
							else
								_stprintf(szPath, _T("%s"), finddata.cFileName);
							SetKickExt(szPath);
						}
						else
						{
							int t = nCount+1;
							_tcscpy(szPath, finddata.cFileName);
							SetKickExt(szPath);
							if (t < 11)
								_stprintf(_tcsrchr(szPath, '\0'), _T("(&%1d)"), t%10);
						}

						//j[쐬
						AppendMenu(hSubMenu1, MF_STRING|MF_ENABLED, ID_FILE_OPEN_APP + nCount, szPath);
						AppendMenu(hSubMenu2, MF_STRING|MF_ENABLED, ID_FILE_OPEN_APP + nCount, szPath);

						TCHAR szAppPath[MAX_PATH];
						_stprintf(szPath, _T("%s\\%s"), g_MainWnd.m_szSendAppPath, finddata.cFileName);
						//NpX擾
						if (_tcsicmp(lpszExt, _T(".LNK")) == 0)
							SHGetShortcutTarget(szPath, szAppPath, sizeof(szAppPath));
						else
							_tcscpy(szAppPath, szPath);

						//_uNH[e[V̍폜
						LPTSTR lpszStart = szAppPath;
						if (lpszStart[0] == _T('\"'))
						{
							LPTSTR lpszEnd = _tcschr(++lpszStart, _T('\"'));
							if (lpszEnd)
								*lpszEnd = _T('\0');
						}

						//pXۑ
						OPENAPPINFO* poa = new OPENAPPINFO;
						poa->lpszPath = new TCHAR[_tcslen(lpszStart) + 1];
						_tcscpy(poa->lpszPath, lpszStart);
						m_lpOpenAppInfo[nCount] = poa;
						nCount += 1;

						if (nCount >= MAX_OPENAPP) break;
					}
				}
			}
		}while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}
}

////////////////////////////////////////////////////////////////
void CListView::OnFileOpenApp(int nMenuIndex)
{
	int nIndex;
	TCHAR *szPath = new TCHAR[(MAX_PATH + 1) * GetValidAndSelectedCount() + 2];
	if (!szPath)
		return;
	if (nMenuIndex >= m_nOpenAppInfoCount)
		return;
	*szPath = _T('\0');

	if (GetValidAndSelectedCount() > 1 && g_MainWnd.m_bSendMulti)
	{
		TCHAR szTemp[MAX_PATH * 2];
		for (nIndex = GetSelectedItemIndex(0); nIndex != -1; nIndex = GetSelectedItemIndex(nIndex + 1))
		{
			LISTITEMCOMP* plic = GetListItemStruct(nIndex);
			if (plic->nItem == LIST_ITEM_FILE)
			{
				if (g_MainWnd.m_bCheckQAdd)
					_stprintf(szTemp, _T("\"%s\\%s\""), plic->lpszPath, plic->lpszName);
				else
					_stprintf(szTemp, _T("%s\\%s"), plic->lpszPath, plic->lpszName);
				if (_tcslen(szPath))
					_tcscat(szPath, _T(" "));
				_tcscat(szPath, szTemp);
			}
		}
	}
	else
	{
		nIndex = GetSelectedItemIndex(0);
		if (nIndex != -1)
		{
			LISTITEMCOMP* plic = GetListItemStruct(nIndex);
			if (plic->nItem == LIST_ITEM_FILE)
			{
				if (g_MainWnd.m_bCheckQAdd)
					_stprintf(szPath, _T("\"%s\\%s\""), plic->lpszPath, plic->lpszName);
				else
					_stprintf(szPath, _T("%s\\%s"), plic->lpszPath, plic->lpszName);
			}
		}
	}
	if (_tcslen(szPath))
	{
		SHELLEXECUTEINFO sei;
		ZeroMemory(&sei, sizeof(SHELLEXECUTEINFO));
		sei.cbSize = sizeof(SHELLEXECUTEINFO);
		//sei.fMask = 0;
		sei.hwnd = g_MainWnd.m_hWnd;
		sei.lpVerb = _T("open");
		sei.lpFile = m_lpOpenAppInfo[nMenuIndex]->lpszPath;
		sei.lpParameters = szPath;
		//sei.lpDirectory = NULL;
		sei.nShow = SW_SHOW;
		sei.hInstApp = g_hInst;
		ShellExecuteEx(&sei);
	}

	delete szPath;
}

////////////////////////////////////////////////////////////////
HMENU CListView::GetUserPathSubMenu1() 
{
	return GetSubMenu(m_hMenuPopup, ID_POPUP_GOTO);
}

////////////////////////////////////////////////////////////////
HMENU CListView::GetUserPathSubMenu2() 
{
	return GetSubMenu(g_MainWnd.m_CmdBands.m_hMenuMain, 1);
}

////////////////////////////////////////////////////////////////
void CListView::DeleteUserPathMenuSep(HMENU hSubMenu)
{
	DeleteMenu(hSubMenu, 7, MF_BYPOSITION);
}

////////////////////////////////////////////////////////////////
void CListView::DeleteUserPathMenu()
{
	//pXo^ȂꍇȂ
	if (!m_nOpenPthInfoCount)
		return;

	//j[̃nh擾
	HMENU hSubMenu1 = GetUserPathSubMenu1();
	HMENU hSubMenu2 = GetUserPathSubMenu2();

	//[U[pX폜
	int j = 0;
	for (int i = 0; i < m_nOpenPthInfoCount; i++)
	{
		j = ID_TOOL_USERPATH_MENU+i;
		DeleteMenu(hSubMenu1, j, MF_BYCOMMAND);
		DeleteMenu(hSubMenu2, j, MF_BYCOMMAND);
	}

	//Zp[^폜
	DeleteUserPathMenuSep(hSubMenu1);
	DeleteUserPathMenuSep(hSubMenu2);
}

////////////////////////////////////////////////////////////////
void CListView::InitUserPathMenu()
{
	//pXo^ȂꍇȂ
	if (!m_nOpenPthInfoCount)
		return;
	
	//j[̃nh擾
	HMENU hSubMenu1 = GetUserPathSubMenu1();
	HMENU hSubMenu2 = GetUserPathSubMenu2();

	//o^ĂpXj[o^
	for (int i = 0; i < m_nOpenPthInfoCount; i++)
	{
		TCHAR szMenu[MAX_PATH+7];
		LPTSTR lpszTemp = _tcsrchr(m_lpOpenPthInfo[i]->lpszPath, _T('\\'));

		if (!i)
		{
			AppendMenu(hSubMenu1, MF_SEPARATOR, 0, NULL);
			AppendMenu(hSubMenu2, MF_SEPARATOR, 0, NULL);
		}
		lpszTemp = lpszTemp? (lpszTemp + 1): m_lpOpenPthInfo[i]->lpszPath;
		if (g_MainWnd.m_bNumberShortcut)
		{
			int t = i + 6;
			if (t < 11)
				_stprintf(szMenu, _T("&%1d %s"), t%10, lpszTemp);
			else
				_stprintf(szMenu, _T("%s"), lpszTemp);
		}
		else
		{
			int t = i + 1;
			_stprintf(szMenu, (t < 11)? _T("%s(&%1d)"): _T("%s"), lpszTemp, t%10);
		}
		AppendMenu(hSubMenu1, MF_STRING|MF_ENABLED, ID_TOOL_USERPATH_MENU+i, szMenu);
		AppendMenu(hSubMenu2, MF_STRING|MF_ENABLED, ID_TOOL_USERPATH_MENU+i, szMenu);
	}
}

////////////////////////////////////////////////////////////////
void CListView::OnToolUserPath(int nMenuIndex)
{
	if (nMenuIndex >= m_nOpenPthInfoCount) return;

	//[U[pXֈړ
	OnViewUpdate(m_lpOpenPthInfo[nMenuIndex]->lpszPath);
}

////////////////////////////////////////////////////////////////
HMENU CListView::GetFavoritesSubMenu1() 
{
	return GetSubMenu(GetSubMenu(m_hMenuPopup, ID_POPUP_GOTO), 0);
}

////////////////////////////////////////////////////////////////
HMENU CListView::GetFavoritesSubMenu2() 
{
	return GetSubMenu(GetSubMenu(g_MainWnd.m_CmdBands.m_hMenuMain, 1), 0);
}

///////////////////////////////////////////////////////////////
int CListView::DeleteFavoritesItem(FAVORITESINFO *lpList)
{
	//폜
	if (!lpList) return 0;

	//ȍ~̃AhX폜
	FAVORITESINFO *pCurrent = lpList;
	for (int cnt=0; pCurrent; cnt++)
	{
		FAVORITESINFO *pNext = pCurrent->lpNext;
		
		//\̍폜
		delete[] pCurrent->lpszPath;
		delete pCurrent;

		//̍폜o
		pCurrent = pNext;

	}
	
	return 0;
}

///////////////////////////////////////////////////////////////
FAVORITESINFO *CListView::AddFavoritesItem(FAVORITESINFO *lpList, LPCTSTR lpszPath)
{
	//VKo쐬
	FAVORITESINFO *fav = new FAVORITESINFO;
	fav->lpszPath = new TCHAR[_tcslen(lpszPath)+1];
	_tcscpy(fav->lpszPath, lpszPath);
	fav->lpNext = NULL;

	//VKoXgɘA
	if (lpList)
		lpList->lpNext = fav;

	//R[h|WVړ
	return fav;
}

////////////////////////////////////////////////////////////////
void CListView::DeleteFavoritesMenu()
{
	//j[̃nh擾
	HMENU hSubMenu1 = GetFavoritesSubMenu1();
	HMENU hSubMenu2 = GetFavoritesSubMenu2();

	//쐬ꂽj[̍폜
	DeleteFavoritesItem(m_lpFavorites);
	int j=0;
	for (int i = 0; i < m_nFavoritesCount; i++)
	{
		j = ID_TOOL_FAVORITES_LNK + i;
		DeleteMenu(hSubMenu1, j, MF_BYCOMMAND);
		DeleteMenu(hSubMenu2, j, MF_BYCOMMAND);
	}
	m_lpFavorites = m_lpFavoritesCurrent = NULL;
	m_nFavoritesCount = 0;

	//Tuj[̍폜
	HMENU hworkMenu;
	while ((hworkMenu=GetSubMenu(hSubMenu1, 3)))
	{
		DeleteSubMenu(hworkMenu);
		DeleteMenu(hSubMenu1, 3, MF_BYPOSITION);
	}
	
	while ((hworkMenu=GetSubMenu(hSubMenu2, 3)))
	{
		DeleteSubMenu(hworkMenu);
		DeleteMenu(hSubMenu2, 3, MF_BYPOSITION);
	}

	//Xvb^̍폜
	DeleteMenu(hSubMenu1, 2, MF_BYPOSITION);
	DeleteMenu(hSubMenu2, 2, MF_BYPOSITION);
}

////////////////////////////////////////////////////////////////
void CListView::DeleteSubMenu(HMENU hMenu)
{
	HMENU hworkMenu;
	while ((hworkMenu=GetSubMenu(hMenu, 0)))
	{
		DeleteSubMenu(hworkMenu);
		DeleteMenu(hMenu, 0, MF_BYPOSITION);
	}
}

////////////////////////////////////////////////////////////////
void CListView::InitFavoritesMenu()
{
	//j[̃nh擾
	HMENU hSubMenu1 = GetFavoritesSubMenu1();
	HMENU hSubMenu2 = GetFavoritesSubMenu2();

	//j[폜
	DeleteFavoritesMenu();

	//j[쐬
	InitFavoritesSubMenu(hSubMenu1, g_MainWnd.m_szFavoritesPath);
 	InitFavoritesSubMenu(hSubMenu2, g_MainWnd.m_szFavoritesPath);
}

////////////////////////////////////////////////////////////////
void CListView::InitFavoritesSubMenu(HMENU hMenu, LPTSTR szCurrentFolder, int *pnCnt)
{
	TCHAR szTemp[MAX_PATH];
	_stprintf(szTemp, _T("%s\\*.*"), szCurrentFolder);

	HMENU hSubMenu=0;
	WIN32_FIND_DATA finddata;
	
	//fBNg
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do{
			//̂ݎ{
			if (hMenu && !hSubMenu)
			{
				if (lstrcmp(g_MainWnd.m_szFavoritesPath, szCurrentFolder) == 0)
				{
					//Zp[^ǉ
					AppendMenu(hMenu, MF_SEPARATOR, NULL, NULL);
					hSubMenu = hMenu;
				}
				else
				{
					hSubMenu = CreatePopupMenu();
				}
			}

			//fBNg̏ꍇ
			if (finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
				//ċNĂяo
				TCHAR szPath[MAX_PATH];
				_stprintf(szPath, _T("%s\\%s"), szCurrentFolder, finddata.cFileName);
				InitFavoritesSubMenu(hSubMenu, szPath, pnCnt);
			}
		}while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}

	//t@C
	hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do{
			//̂ݎ{
			if (hMenu && !hSubMenu)
			{
				if (lstrcmp(g_MainWnd.m_szFavoritesPath, szCurrentFolder) != 0)
				{
					hSubMenu = CreatePopupMenu();
				}
				else
				{
					hSubMenu = hMenu;
					//Zp[^ǉ
					AppendMenu(hSubMenu, MF_SEPARATOR, NULL, NULL);
				}
			}

			//fBNgł͂Ȃꍇ
			if (!(finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			{
				LPTSTR lpszExt = _tcsrchr(finddata.cFileName, _T('.'));
				if (lpszExt != NULL)
				{
					if (hSubMenu)
					{
						TCHAR szPath[MAX_PATH];
						_stprintf(szPath, _T("%s\\%s"), szCurrentFolder, finddata.cFileName);
						
						//Cɓǉ
						m_lpFavoritesCurrent = AddFavoritesItem(m_lpFavoritesCurrent, szPath);
						if (!m_lpFavorites)
							m_lpFavorites = m_lpFavoritesCurrent;

						*lpszExt = _T('\0');
						AppendMenu(hSubMenu, MF_STRING|MF_ENABLED,
							ID_TOOL_FAVORITES_LNK + m_nFavoritesCount, finddata.cFileName);
					
						m_nFavoritesCount += 1;
					}
					if (pnCnt) (*pnCnt)++;
				}
			}
		}while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}

	//쐬j[ǉ([gȊO)
	if (hMenu && hSubMenu && hSubMenu != hMenu)
	{
		LPTSTR lpszFolder = _tcsrchr(szCurrentFolder, _T('\\'));
		AppendMenu(hMenu, MF_STRING|MF_POPUP, (UINT)hSubMenu, lpszFolder+1);
	}
}

////////////////////////////////////////////////////////////////
void CListView::OnToolFavoritesLnk(int nMenuIndex)
{
	FAVORITESINFO *lpList = m_lpFavorites;
	for (int i=0; i<nMenuIndex; i++)
		lpList = lpList->lpNext;

	//t@CJ
	ComFileOpen(lpList->lpszPath);
}

////////////////////////////////////////////////////////////////
HMENU CListView::GetShellNewSubMenu1()
{
	return GetSubMenu(GetSubMenu(m_hMenuPopup, ID_POPUP_FILEVIEW_NOSELECT), 3);
}

////////////////////////////////////////////////////////////////
HMENU CListView::GetShellNewSubMenu2()
{
	return GetSubMenu(g_MainWnd.m_CmdBands.m_hMenuFile, 8);
}

////////////////////////////////////////////////////////////////
void CListView::DeleteShellNewSubMenuSep(HMENU hMenu)
{
	DeleteMenu(hMenu, 2, MF_BYPOSITION);
}

////////////////////////////////////////////////////////////////
void CListView::InitShellNewMenu()
{
	HMENU hSubMenu1 = GetShellNewSubMenu1();
	HMENU hSubMenu2 = GetShellNewSubMenu2();

	if (m_nShellNewInfoCount)
	{
		DeleteShellNewSubMenuSep(hSubMenu1);
		DeleteShellNewSubMenuSep(hSubMenu2);
	}
	for (int i = 0; i < m_nShellNewInfoCount; i++)
	{
		OPENAPPINFO* pcn=m_lpShellNewInfo[i];
		if (pcn)
		{
			delete pcn->lpszPath;
			delete pcn;
			m_lpShellNewInfo[i] = NULL;
		}
		DeleteMenu(hSubMenu1, ID_FILE_SHELL_NEW_MENU+i, MF_BYCOMMAND);
		DeleteMenu(hSubMenu2, ID_FILE_SHELL_NEW_MENU+i, MF_BYCOMMAND);
	}
	m_nShellNewInfoCount = 0;

	TCHAR szTemp[MAX_PATH+4];
	int nCount = 0;

	_stprintf(szTemp, _T("%s\\*.*"), g_MainWnd.m_szShellNewPath);
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do{
			if (!(finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			{
				nCount++;
				if (nCount >= MAX_OPENAPP)
					break;
			}
		}while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}

	m_nShellNewInfoCount = nCount;
	if (nCount == 0) return;

	hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		nCount = 0;
		AppendMenu(hSubMenu1, MF_SEPARATOR, NULL, NULL);
		AppendMenu(hSubMenu2, MF_SEPARATOR, NULL, NULL);
		do{
			if (!(finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			{
				TCHAR szPath[MAX_PATH];

				if (g_MainWnd.m_bNumberShortcut)
				{
					int t = nCount+3;
					if (t < 11)
						_stprintf(szPath, _T("&%1d %s"), t%10, finddata.cFileName);
					else
						_stprintf(szPath, _T("%s"), finddata.cFileName);
					SetKickExt(szPath);
				}
				else
				{
					int t = nCount+1;
					_tcscpy(szPath, finddata.cFileName);
					SetKickExt(szPath);
					if (t < 11)
						_stprintf(_tcsrchr(szPath, '\0'), _T("(&%1d)"), t%10);
				}
				//j[쐬
				AppendMenu(hSubMenu1, MF_STRING|MF_ENABLED, ID_FILE_SHELL_NEW_MENU+nCount, szPath);
				AppendMenu(hSubMenu2, MF_STRING|MF_ENABLED, ID_FILE_SHELL_NEW_MENU+nCount, szPath);

				//pXۑ
				_stprintf(szPath, _T("%s\\%s"), g_MainWnd.m_szShellNewPath, finddata.cFileName);
				OPENAPPINFO* pcn = new OPENAPPINFO;
				pcn->lpszPath = new TCHAR[_tcslen(szPath)+1];
				_tcscpy(pcn->lpszPath, szPath);
				m_lpShellNewInfo[nCount] = pcn;
				if (++nCount >= MAX_OPENAPP)
					break;
			}
		}while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}
}

////////////////////////////////////////////////////////////////
void CListView::OnFileShellNew(int nMenuIndex)
{
	if (nMenuIndex >= m_nShellNewInfoCount)
		return;
	_tcscpy(m_szLastCreateName, _T(""));

	//EFCgJ[\̕\
	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

	TCHAR szTo[MAX_PATH], szName[MAX_PATH], szExt[MAX_PATH];
	LPTSTR lpszTemp;

	//VKt@C̃t@C쐬
	_tcscpy(szExt, _T(""));
	_tcscpy(szName, _tcsrchr(m_lpShellNewInfo[nMenuIndex]->lpszPath, _T('\\'))+1);
	lpszTemp = _tcsrchr(szName, _T('.'));
	if (lpszTemp)
	{
		_tcscpy(szExt, lpszTemp);
		*lpszTemp = _T('\0');
	}
	_stprintf(szTo, GetResourceString(IDS_FMT_SHELLNEW_NAME1), m_szCurrentFolder, szName);
	_tcscat(szTo, szExt);
	if (GetFileAttributes(szTo) != 0xFFFFFFFF)
	{
		for (int n = 2; n < 512; n++)
		{
			_stprintf(szTo, GetResourceString(IDS_FMT_SHELLNEW_NAME2), m_szCurrentFolder, szName, n);
			_tcscat(szTo, szExt);
			if (GetFileAttributes(szTo) == 0xFFFFFFFF)
				break;
		}
	}

	//ShellNewtH_JgtH_ւ̐VKt@C̃Rs[
	CopyFile(m_lpShellNewInfo[nMenuIndex]->lpszPath, szTo, FALSE);
	LoadFolderItem(m_szCurrentFolder);

	//ACeI
	int nItem = 0;
	_tcscpy(szName, _tcsrchr(szTo, _T('\\'))+1);
	if (m_Settings.bNotShowExt)
	{
		lpszTemp = _tcsrchr(szName, _T('.'));
		if (lpszTemp)
			*lpszTemp = _T('\0');
	}
	_tcscpy(m_szLastCreateName, szName);

	if (g_MainWnd.m_bVirtualListView)
		nItem = m_ItemStruct.Find((LPFINDFUNC)SeekFolder, 0, (DWORD)szName);
	else
	{
		LVFINDINFO lvfi;
		lvfi.flags = LVFI_STRING;
		lvfi.psz = szName;
		nItem = ListView_FindItem(m_hWnd, -1, &lvfi);
	}
	if (nItem >= 0)
		ListView_EditLabel(m_hWnd, nItem);

	//J[\ɖ߂
	SetCursor(hCursor);
}

////////////////////////////////////////////////////////////////
void CListView::OnColumnClick(NMLISTVIEW* lpnmlv)
{
	int nSort;
	switch (lpnmlv->iSubItem)
	{
	default: nSort = LIST_SORT_NAME; break;
	case 1: nSort = LIST_SORT_SIZE; break;
	case 2: nSort = LIST_SORT_EXT; break;
	case 3: nSort = LIST_SORT_TIME; break;
	}

	if (nSort == m_Settings.nSort)
		m_Settings.bSortRaise = !m_Settings.bSortRaise;
	
	m_Settings.nSort = nSort;
	SortList();
	g_MainWnd.m_CmdBands.SetCheckSort(m_Settings.nSort, m_Settings.bSortRaise);
}
////////////////////////////////////////////////////////////////
void CListView::OnKeydown(HWND hwnd, LPNMLVKEYDOWN lpnkd)
{
	if (m_bEditing)
		return;

	if (g_bDraging)
	{
		if (lpnkd->wVKey == VK_ESCAPE)
		{
			g_MainWnd.OnDropCansel();
			g_bDraging = FALSE;
		}
		return;
	}

	//V[gJbgL[
	if (ProcessShortcutKey(hwnd, lpnkd->wVKey))
		return;
	if ((lpnkd->wVKey == 'M' && (GetKeyState(VK_CONTROL)&0x8000)) || (lpnkd->wVKey == VK_CONTROL && (GetKeyState(VK_MENU)&0x8000)))
	{
		int nIndex = GetSelectedItemIndex(0);
		if (nIndex == -1)
			OnRClick(0, 0);
		else
		{
			RECT rc;	
			ListView_GetItemRect(m_hWnd, nIndex, &rc, LVIR_ICON);
			OnRClick(rc.left + (rc.right - rc.left) / 2, rc.top + (rc.bottom - rc.top) / 2);
		}
	}
	return;
}

////////////////////////////////////////////////////////////////
BOOL CListView::OnKeydownArrow(WPARAM wParam, LPARAM lParam)
{
	//XN[o[ł̈ړ̏
	if (g_MainWnd.m_ListView.m_bScrollbarMove)
	{
		g_MainWnd.m_ListView.m_bScrollbarMove = FALSE;

		RECT irc,crc;
		int fi = ListView_GetNextItem(m_hWnd, -1, LVIS_FOCUSED);

		ListView_GetItemRect(m_hWnd, fi, &irc, LVIR_BOUNDS);
		GetClientRect(m_hWnd, &crc);

		if (irc.right < crc.left || irc.bottom < crc.top || irc.left > crc.right || irc.top > crc.bottom)
		{
			int ti = -1;

			switch (m_Settings.dwListStyle & LVS_TYPEMASK)
			{
			case LVS_REPORT:
				ti = ListView_GetTopIndex(m_hWnd);
				if (ti >= 0 && (wParam == VK_UP || wParam == VK_LEFT))
					ti += (ListView_GetCountPerPage(m_hWnd) - 1);
				break;
			case LVS_ICON:
				{
					LVHITTESTINFO lvhti;

					ZeroMemory(&lvhti, sizeof(LVHITTESTINFO));
					lvhti.pt.x = RECT_WIDTH(&irc) / 2;
					lvhti.pt.y = RECT_HEIGHT(&irc) / 2;
					if (wParam == VK_UP || wParam == VK_LEFT)
						lvhti.pt.y = crc.bottom - lvhti.pt.y;
					ListView_HitTest(m_hWnd, &lvhti);
					ti = lvhti.iItem;
				}
				break;
			case LVS_SMALLICON:
			case LVS_LIST:
				{
					LVHITTESTINFO lvhti;

					ZeroMemory(&lvhti, sizeof(LVHITTESTINFO));
					//lvhti.pt.x = 0;
					lvhti.pt.y = RECT_HEIGHT(&irc) - 1;
					if (wParam == VK_UP || wParam == VK_LEFT)
						lvhti.pt.y = crc.bottom - lvhti.pt.y;
					ListView_HitTest(m_hWnd, &lvhti);
					ti = lvhti.iItem;
				}
				break;
			}
			if (ti >= 0 && ti != fi)
			{
				if ((GetKeyState(VK_SHIFT)&0x8000) || (GetKeyState(VK_CONTROL)&0x8000))
				{
					ListView_SetItemState(m_hWnd, -1, 0, LVIS_FOCUSED);
					ListView_SetItemState(m_hWnd, ti, LVIS_FOCUSED, LVIS_FOCUSED);
					ListView_EnsureVisible(m_hWnd, ti, FALSE);
				}
				else
				{
					ListView_SetItemState(m_hWnd, -1, 0, LVIS_FOCUSED|LVIS_SELECTED);
					ListView_SetItemState(m_hWnd, ti, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);
					ListView_EnsureVisible(m_hWnd, ti, FALSE);
				}
				return TRUE;
			}
		}
	}

	//SHIFT/CTRLL[
	if (g_MainWnd.m_bShiftKey)
	{
		if (!(GetKeyState(VK_SHIFT)&0x8000))
		{
			keybd_event(VK_SHIFT, 0x31, 0, 0);
			keybd_event(wParam, (BYTE)((lParam>>16)&0xFF), 0, 0);
			return TRUE;
		}
	}
	if (g_MainWnd.m_bControlKey)
	{
		if (!(GetKeyState(VK_CONTROL)&0x8000))
		{
			keybd_event(VK_CONTROL, 0x32, 0, 0);
			keybd_event(wParam, (BYTE)((lParam>>16)&0xFF), 0, 0);
			return TRUE;
		}
	}

	return FALSE;
}

////////////////////////////////////////////////////////////////
BOOL CListView::OnKeydownMoveTop(WPARAM wParam, LPARAM lParam)
{
	if (g_MainWnd.m_bEdgeLoop)
	{
		int fi = ListView_GetNextItem(m_hWnd, -1, LVIS_FOCUSED);
		int ic = ListView_GetItemCount(m_hWnd);
		if (fi == (ic-1))
		{
			if ((GetKeyState(VK_SHIFT)&0x8000) || (GetKeyState(VK_CONTROL)&0x8000))
			{
				ListView_SetItemState(m_hWnd, fi, 0, LVIS_FOCUSED);
				ListView_SetItemState(m_hWnd, 0, LVIS_FOCUSED, LVIS_FOCUSED);
			}
			else
			{
				ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, -1, 0, LVIS_FOCUSED|LVIS_SELECTED);
				ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, 0, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);
			}
			ListView_EnsureVisible(g_MainWnd.m_ListView.m_hWnd, 0, FALSE);

			return TRUE;
		}
	}

	return FALSE;
}

////////////////////////////////////////////////////////////////
BOOL CListView::OnKeydownMoveTail(WPARAM wParam, LPARAM lParam)
{
	if (g_MainWnd.m_bEdgeLoop)
	{
		int fi = ListView_GetNextItem(m_hWnd, -1, LVIS_FOCUSED);
		if (fi == 0)
		{
			int ic = ListView_GetItemCount(m_hWnd);
			if ((GetKeyState(VK_SHIFT)&0x8000) || (GetKeyState(VK_CONTROL)&0x8000))
			{
				ListView_SetItemState(m_hWnd, fi, 0, LVIS_FOCUSED);
				ListView_SetItemState(m_hWnd, ic-1, LVIS_FOCUSED, LVIS_FOCUSED);
			}
			else
			{
				ListView_SetItemState(m_hWnd, -1, 0, LVIS_FOCUSED|LVIS_SELECTED);
				ListView_SetItemState(m_hWnd, ic-1, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);
			}
			ListView_EnsureVisible(m_hWnd, ic-1, FALSE);

			return TRUE;
		}
	}

	return FALSE;
}

////////////////////////////////////////////////////////////////
BOOL CListView::OnKeyupArrow(WPARAM wParam, LPARAM lParam)
{
	//SHIFT/CTRLL[
	if (g_MainWnd.m_bShiftKey)
		keybd_event(VK_SHIFT, 0x31, KEYEVENTF_KEYUP, 0);
	if (g_MainWnd.m_bControlKey)
		keybd_event(VK_CONTROL, 0x32, KEYEVENTF_KEYUP, 0);

	return FALSE;
}

////////////////////////////////////////////////////////////////
int CListView::CheckMessageID(int dwWID)
{
	//ȊO͖
	if (!IsSearchFolder(m_szCurrentFolder))
		return dwWID;

	//bZ[WID
	int wID = dwWID;
	switch (wID)
	{
	//\t
	case ID_EDIT_PASTE:
		wID = 0;
		break;
	// V[gJbg̓\t
	case ID_EDIT_PASTE_SHORTCUT:
		wID = 0;
		break;
	//VKtH_쐬
	case ID_FILE_CREATEFOLDER:
		wID = 0;
		break;
	//V[gJbg쐬
	case ID_FILE_CREATE_SHORTCUT:
		wID = 0;
		break;
	//VKV[gJbg쐬
	case ID_FILE_CREATE_NEWSHORTCUT:
		wID = 0;
		break;
	//k
	case ID_FILE_COMPRESS:
		wID = 0;
		break;
	}

	return wID;
}

///////////////////////////////////////////////////////////////
void CListView::OnRClick(int cx, int cy)
{
	//j[\
	RECT rc;
	GetWindowRect(m_hWnd, &rc);
	cx += rc.left;
	cy += rc.top;

	int nCount = GetValidAndSelectedCount();
	if (nCount == 1)
	{
		//ACePI
		int nIndex = GetSelectedItemIndex(0);
		if (nIndex != -1)
		{
			HMENU hMenu;
			if (GetListItemStruct(nIndex)->nItem == LIST_ITEM_FILE)
				hMenu = GetSubMenu(m_hMenuPopup, ID_POPUP_FILEVIEW_FILE);
			else
				hMenu = GetSubMenu(m_hMenuPopup, ID_POPUP_FILEVIEW_FOLDER);

			//k/̗L/
			g_MainWnd.m_CmdBands.SetEnableCompressSelected(hMenu, hMenu, 0, 2, m_Settings.nCompDLL);
			g_MainWnd.m_CmdBands.SetEnableSearchSelected(hMenu, m_szCurrentFolder);

			TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_TOPALIGN, cx, cy, 0, g_MainWnd.m_hWnd, NULL);
		}
	}
	else if (nCount > 1)
	{
		//ACeI
		int nIndex = GetSelectedItemIndex(0);
		if (nIndex != -1)
		{
			HMENU hMenu = GetSubMenu(m_hMenuPopup, ID_POPUP_FILEVIEW_MULTI);

			//k/̗L/
			g_MainWnd.m_CmdBands.SetEnableCompressSelected(hMenu, hMenu, 0, 0, m_Settings.nCompDLL);
			g_MainWnd.m_CmdBands.SetEnableSearchSelected(hMenu, m_szCurrentFolder);

			TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_TOPALIGN, cx, cy, 0, g_MainWnd.m_hWnd, NULL);
		}
	}
	else if (ListView_GetSelectedCount(m_hWnd) == 0 || nCount == 0)
	{
		//ACeI
		HMENU hMenu = GetSubMenu(m_hMenuPopup, ID_POPUP_FILEVIEW_NOSELECT);
		CheckMenuItem(hMenu, ID_VIEW_SORT_NAME, (m_Settings.nSort == LIST_SORT_NAME)?
												(MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
		CheckMenuItem(hMenu, ID_VIEW_SORT_EXT, (m_Settings.nSort == LIST_SORT_EXT)? 
												(MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
		CheckMenuItem(hMenu, ID_VIEW_SORT_SIZE, (m_Settings.nSort == LIST_SORT_SIZE)?
												(MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
		CheckMenuItem(hMenu, ID_VIEW_SORT_TIME, (m_Settings.nSort == LIST_SORT_TIME)? 
												(MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
		CheckMenuItem(hMenu, ID_VIEW_SORT_NOT_RAISE, m_Settings.bSortRaise? 
												(MF_BYCOMMAND|MF_UNCHECKED): (MF_BYCOMMAND|MF_CHECKED));
		EnableMenuItem(hMenu, ID_EDIT_PASTE, m_nCount? (MF_BYCOMMAND|MF_ENABLED): (MF_BYCOMMAND|MF_GRAYED));
		EnableMenuItem(hMenu, ID_EDIT_PASTE_SHORTCUT, m_nCount? (MF_BYCOMMAND|MF_ENABLED): (MF_BYCOMMAND|MF_GRAYED));
		EnableMenuItem(hMenu, ID_FILE_PROPERTY, _tcslen(m_szCurrentFolder)? (MF_BYCOMMAND|MF_ENABLED): (MF_BYCOMMAND|MF_GRAYED));
		EnableMenuItem(hMenu, ID_FILE_CREATEFOLDER, MF_BYCOMMAND|MF_ENABLED);
		g_MainWnd.m_CmdBands.SetEnableSearchSelected(hMenu, m_szCurrentFolder);

		TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_TOPALIGN, cx, cy, 0, g_MainWnd.m_hWnd, NULL);
	}
}

////////////////////////////////////////////////////////////////
void CListView::OnEditSelectSwitch()
{
	for (int i=0; i<ListView_GetItemCount(m_hWnd); i++)
	{
		if (ListView_GetItemState(m_hWnd, i, LVIS_SELECTED) == LVIS_SELECTED)
		{
			ListView_SetItemState(m_hWnd, i, 0, LVIS_SELECTED);
		}
		else
		{
			ListView_SetItemState(m_hWnd, i, LVIS_SELECTED, LVIS_SELECTED);
		}
	}
}

////////////////////////////////////////////////////////////////
void CListView::SortList()
{
	if (g_MainWnd.m_bVirtualListView)
	{
		switch (m_Settings.nSort)
		{
			case LIST_SORT_EXT:
				m_ItemStruct.Sort((LPCOMPAREFUNC)ListSortCompareFuncByExt, m_Settings.bSortRaise);
				break;
			case LIST_SORT_SIZE:
				m_ItemStruct.Sort((LPCOMPAREFUNC)ListSortCompareFuncBySize, m_Settings.bSortRaise);
				break;
			case LIST_SORT_TIME:
				m_ItemStruct.Sort((LPCOMPAREFUNC)ListSortCompareFuncByTime, m_Settings.bSortRaise);
				break;
			//case LIST_SORT_NAME:
			default:
				m_ItemStruct.Sort((LPCOMPAREFUNC)ListSortCompareFuncByName, m_Settings.bSortRaise);
				break;
		}
	}
	else
	{
		switch (m_Settings.nSort)
		{
			case LIST_SORT_NAME:
				ListView_SortItems(m_hWnd, ListSortCompareFuncByName, m_Settings.bSortRaise);
				break;
			case LIST_SORT_EXT:
				ListView_SortItems(m_hWnd, ListSortCompareFuncByExt, m_Settings.bSortRaise);
				break;
			case LIST_SORT_SIZE:
				ListView_SortItems(m_hWnd, ListSortCompareFuncBySize, m_Settings.bSortRaise);
				break;
			case LIST_SORT_TIME:
				ListView_SortItems(m_hWnd, ListSortCompareFuncByTime, m_Settings.bSortRaise);
				break;
			default:
				ListView_SortItems(m_hWnd, ListSortCompareFuncByName, m_Settings.bSortRaise);
				break;
		}
	}
	ListView_Update(m_hWnd, -1);
}

////////////////////////////////////////////////////////////////
void CListView::SetFormatDateTime(SYSTEMTIME* lpst, LPTSTR lpszBuff, UINT nSize, BOOL bToday)
{
	memset(lpszBuff, 0, sizeof(TCHAR) * nSize);

	if (bToday)
	{
		SYSTEMTIME sys;
		GetLocalTime(&sys);
		//ȊȌꍇ͓t\ ̏ꍇ͎ԕ\
		if (lpst->wYear  != sys.wYear
			|| lpst->wMonth != sys.wMonth
			|| lpst->wDay   != sys.wDay)
			GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, lpst, NULL, lpszBuff, nSize);
		else
			GetTimeFormat(LOCALE_USER_DEFAULT, g_MainWnd.m_ListView.m_Settings.bShowSecond? 0: TIME_NOSECONDS, lpst, NULL, lpszBuff, nSize);
	}
	else
	{
		//t/ԕ\
		GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, lpst, NULL, lpszBuff, nSize);
		_tcscat(lpszBuff, _T(" "));
		GetTimeFormat(LOCALE_USER_DEFAULT, g_MainWnd.m_ListView.m_Settings.bShowSecond? 0: TIME_NOSECONDS, lpst, NULL, (lpszBuff+_tcslen(lpszBuff)), (nSize-_tcslen(lpszBuff)));
	}
}

///////////////////////////////////////////////////////////////
void CListView::OnGetDispInfo(NMLVDISPINFO* lpnmdi)
{
	//xACRǂݍ
	LISTITEMCOMP* lplic = GetListItemStruct(lpnmdi->item.iItem);
	if (lpnmdi->item.mask & LVIF_IMAGE)
	{
		if (lplic->nIcon == -1)
			lpnmdi->item.iImage = lplic->nIcon = m_pFileImageList->GetImageListIndex(lplic->lpszName, lplic->lpszPath, lplic->dwAttr);
		else
			lpnmdi->item.iImage = lplic->nIcon;
	}
	if ((lpnmdi->item.mask & LVIF_TEXT))
	{
		switch (lplic->nItem)
		{
		case LIST_ITEM_UPPER:
			if (!lpnmdi->item.iSubItem)
				lpnmdi->item.pszText = lplic->lpszName;
			break;
		case LIST_ITEM_FOLDER:
			switch (lpnmdi->item.iSubItem)
			{
			case 0: //Name
				lpnmdi->item.pszText = lplic->lpszName;
				break;
			case 2: //Type
				lpnmdi->item.pszText = GetResourceString(IDS_FOLDER);
				break;
			default:
				break;
			}
			break;
		case LIST_ITEM_FILE:
			switch (lpnmdi->item.iSubItem)
			{
			case 0: //Name
				if (m_Settings.bNotShowExt)
				{
					if (!lplic->lpszDispName)
					{
						lplic->lpszDispName = new TCHAR[_tcslen(lplic->lpszName)+1];
						_tcscpy(lplic->lpszDispName, lplic->lpszName);
						SetKickExt(lplic->lpszDispName);
					}
					lpnmdi->item.pszText = lplic->lpszDispName;
				}
				else
				{
					lpnmdi->item.pszText = lplic->lpszName;
				}
				break;
			case 1: //Size
				if (!lplic->lpszDispSize)
				{
					TCHAR szTemp[32];
					SetFormatSize(lplic->dwSize, szTemp, _T("%s KB"), _T("%s MB"));
					lplic->lpszDispSize = new TCHAR[_tcslen(szTemp)+1];
					_tcscpy(lplic->lpszDispSize, szTemp);
				}
				lpnmdi->item.pszText = lplic->lpszDispSize;
				break;
			case 2: //Type
				if (!lplic->lpszDispType)
				{
					TCHAR szTemp[MAX_PATH];
					SHFILEINFO shfi;
					_stprintf(szTemp, _T("%s\\%s"), lplic->lpszPath, lplic->lpszName);
					SHGetFileInfo(szTemp, NULL, &shfi, sizeof(shfi), SHGFI_TYPENAME);
					lplic->lpszDispType = new TCHAR[_tcslen(shfi.szTypeName)+1];
					_tcscpy(lplic->lpszDispType, shfi.szTypeName);
				}
				lpnmdi->item.pszText = lplic->lpszDispType;
				break;
			case 3: //Date
				if (!lplic->lpszDispTime)
				{
					SYSTEMTIME st;
					TCHAR szTemp[64];
					FileTimeToSystemTime(&lplic->ft, &st);
					SetFormatDateTime(&st, szTemp, sizeof(szTemp)/sizeof(TCHAR), m_bTimeStump);
					lplic->lpszDispTime = new TCHAR[_tcslen(szTemp)+1];
					_tcscpy(lplic->lpszDispTime, szTemp);
				}
				lpnmdi->item.pszText = lplic->lpszDispTime;
				break;
			default:
				break;
			}
			break;
		default:
			break;
		}
	}
}
///////////////////////////////////////////////////////////////
void CListView::OnListStyle()
{
	switch (m_Settings.dwListStyle)
	{
		case LVS_ICON: OnChangeListStyle(ID_VIEW_SMALLICON); break;
		case LVS_SMALLICON: OnChangeListStyle(ID_VIEW_LIST); break;
		case LVS_LIST: OnChangeListStyle(ID_VIEW_REPORT); break;
		case LVS_REPORT:
			if (!m_Settings.dwListExStyle)
				OnChangeListStyle(ID_VIEW_REPORTLINE);
			else
				OnChangeListStyle(ID_VIEW_LARGEICON);
			break;
		default: OnChangeListStyle(ID_VIEW_LARGEICON); break;
	}	
}

///////////////////////////////////////////////////////////////
void CListView::OnTapAndHold(NMRGINFO* pnmri)
{
	RECT rc;
	GetWindowRect(m_hWnd, &rc);
	int cx = pnmri->ptAction.x - rc.left;
	int cy = pnmri->ptAction.y - rc.top;
	OnRClick(cx, cy);
}

///////////////////////////////////////////////////////////////
void CListView::OnTapHoldBegin(DWORD dwPos)
{
	SetFocus(m_hWnd);

	//IACeۑ
	m_nSelectItem = GetValidAndSelectedCount();
	m_nSelectMin = -1;
	
	//^bvACe擾
	LVHITTESTINFO lv_ht;
	memset(&lv_ht, 0, sizeof(lv_ht));
	lv_ht.flags = LVHT_ONITEM;
	lv_ht.pt.x = GET_X_LPARAM(dwPos);
	lv_ht.pt.y = GET_Y_LPARAM(dwPos);
	int nIndex = ListView_HitTest(m_hWnd, &lv_ht);
	if (ListView_GetItemState(m_hWnd, nIndex, LVIS_SELECTED) != LVIS_SELECTED)
		m_nSelectItem = 0;
}

///////////////////////////////////////////////////////////////
void CListView::DeleteAllItem()
{
	if (g_MainWnd.m_bVirtualListView)
	{
		int end = m_ItemStruct.GetCount();
		for (int i = 0; i < end; i++)
		{
			LISTITEMCOMP* pDel = (LISTITEMCOMP*)m_ItemStruct.GetAt(i);
			delete[] pDel->lpszDispName;
			delete[] pDel->lpszDispSize;
			delete[] pDel->lpszDispType;
			delete[] pDel->lpszDispTime;
			delete[] pDel->lpszName; 
			delete[] pDel->lpszPath;
			delete pDel;
		}
		m_ItemStruct.RemoveAll();
	}
	else
	{
		int end = ListView_GetItemCount(m_hWnd);
		for (int i = 0; i < end; i++)
		{
			LISTITEMCOMP* pDel = GetListItemStruct(i);
			delete[] pDel->lpszDispName;
			delete[] pDel->lpszDispSize;
			delete[] pDel->lpszDispType;
			delete[] pDel->lpszDispTime;
			delete[] pDel->lpszName; 
			delete[] pDel->lpszPath;
			delete pDel;
		}
	}
	ListView_DeleteAllItems(m_hWnd);
}

///////////////////////////////////////////////////////////////
void CListView::OnEditPasteShortcut(BOOL bUpdate)
{
	TCHAR szFolder[MAX_PATH];
	_tcscpy(szFolder, m_szCurrentFolder);

	if (m_nCount)
	{
		HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
		for (int i = 0; i < m_nCount; i++) 
			CreateShortcut(m_szCurrentFolder, m_lpliinfo[i].szPath, m_lpliinfo[i].szName, m_Settings.bNotShortcutName);
		SetCursor(hCursor);

		if (bUpdate)
			LoadFolderItem(m_szCurrentFolder, FALSE);
	}
}
//MOD END
///////////////////////////////////////////////////////////////
int CListView::GetValidAndSelectedCount()
{
	int nCount = ListView_GetSelectedCount(m_hWnd);

	if (m_dwUpperParam)
	{
		LV_FINDINFO lvfi;
		lvfi.flags = LVFI_STRING;
		lvfi.psz = ((LISTITEMCOMP*)m_dwUpperParam)->lpszName;
		int nUpper = ListView_FindItem(m_hWnd, -1, &lvfi);
		if (nUpper != -1)
			if (ListView_GetItemState(m_hWnd, nUpper, LVIS_SELECTED) == LVIS_SELECTED)
				nCount -= 1;
	}

	return nCount;
}

///////////////////////////////////////////////////////////////
void CListView::OnMouseMove(POINT ptWnd)
{
	HWND hMain = g_MainWnd.m_hWnd;
	ClientToScreen(hMain, &ptWnd);

	//ÕhbOnCCg
	ListView_SetItemState(m_hWnd, -1, 0, LVIS_DROPHILITED);
	
	//|C^̈ʒuɂACeփnCCgݒ
	LVHITTESTINFO lv_ht;
	memset(&lv_ht, 0, sizeof(lv_ht));
	lv_ht.flags = LVHT_ONITEM;
	lv_ht.pt.x = ptWnd.x;
	lv_ht.pt.y = ptWnd.y;
	ScreenToClient(m_hWnd, &(lv_ht.pt));

	int nIndex = ListView_HitTest(m_hWnd, &lv_ht);
	if (nIndex >= 0)
	{
		LISTITEMCOMP *plic = GetListItemStruct(nIndex);
		if (plic->nItem == LIST_ITEM_FOLDER)
			ListView_SetItemState(m_hWnd, nIndex, LVIS_DROPHILITED, LVIS_DROPHILITED);
	}

	//EBhEĕ`(cc)
	UpdateWindow(m_hWnd);
}

///////////////////////////////////////////////////////////////
void CListView::OnMouseMoveArea(POINT ptWnd)
{
	HWND hMain = g_MainWnd.m_hWnd;
	ClientToScreen(hMain, &ptWnd);

	//|C^̈ʒuɂACeփnCCgݒ
	LVHITTESTINFO lv_ht;
	memset(&lv_ht, 0, sizeof(lv_ht));
	lv_ht.flags = LVHT_ONITEM;
	lv_ht.pt.x = ptWnd.x;
	lv_ht.pt.y = ptWnd.y;
	ScreenToClient(m_hWnd, &(lv_ht.pt));

	int nIndex = ListView_HitTest(m_hWnd, &lv_ht);
	if (nIndex >= 0)
	{
		int nMin = ((nIndex <= m_nSelectStart)? nIndex: m_nSelectStart);
		int nMax = ((nIndex > m_nSelectStart)? nIndex: m_nSelectStart);

		for (int i = ((m_nSelectMin == -1)? 0: m_nSelectMin); i < nMin; i++)
			ListView_SetItemState(m_hWnd, i, 0, LVIS_SELECTED);

		for (int j = nMin; j <= nMax; j++)
			ListView_SetItemState(m_hWnd, j, LVIS_SELECTED, LVIS_SELECTED);

		int nItem = nMax;
		while ((nItem = ListView_GetNextItem(m_hWnd, nItem, LVNI_SELECTED)) != -1)
			ListView_SetItemState(m_hWnd, nItem, 0, LVIS_SELECTED);

		m_nSelectMin = nMin;
	}
}

///////////////////////////////////////////////////////////////
BOOL CListView::OnLButtonUp(HWND hWnd)
{
	HWND hMain = g_MainWnd.m_hWnd;
	
	//Xgr[̃hbv
	DWORD dwPos = GetMessagePos();
	LVHITTESTINFO lv_ht;
	memset(&lv_ht, 0, sizeof(lv_ht));
	lv_ht.flags = LVHT_ONITEM;
	lv_ht.pt.x = GET_X_LPARAM(dwPos);
	lv_ht.pt.y = GET_Y_LPARAM(dwPos);
	ScreenToClient(m_hWnd, &(lv_ht.pt));

	int nIndex = ListView_HitTest(m_hWnd, &lv_ht);
	if ((nIndex >= 0) || (lv_ht.flags & LVHT_NOWHERE))
	{
		OnDropEnter(hWnd, nIndex);

		return TRUE;
	}
	else
		return FALSE;
}

///////////////////////////////////////////////////////////////
void CListView::OnDropEnter(HWND hWnd, int nIndex)
{
	HWND hMain = g_MainWnd.m_hWnd;
	BOOL b_shortcut = FALSE;
	BOOL b_cut = FALSE;
	
	DWORD iMenuID=0;
	//ShiftL[̓j[\
	if (GetKeyState(VK_LSHIFT)&0x8000  ||
		GetKeyState(VK_RSHIFT)&0x8000 ||
		g_MainWnd.m_bShiftKey ||
		g_MainWnd.m_bContextMenu)
	{
		DWORD dwPos = GetMessagePos();
		POINT pt;
		pt.x = GET_X_LPARAM(dwPos);
		pt.y = GET_Y_LPARAM(dwPos);
		HMENU hMenu = GetSubMenu(m_hMenuPopup, ID_POPUP_DRAGDROP);
		iMenuID = TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_TOPALIGN|TPM_RETURNCMD, pt.x, pt.y, 0, m_hWnd, NULL);
		
		//j[I𖳂yуLZ̏ꍇ
		if (!iMenuID || iMenuID == ID_DROP_CANCEL)
		{
			//hbvACȅԂ
			ListView_SetItemState(m_hWnd, -1, 0, LVIS_DROPHILITED);

			return;
		}
	}

	//hbvACȅԂ
	ListView_SetItemState(m_hWnd, -1, 0, LVIS_DROPHILITED);

	//Rs[ȌԂ[ۑ
	TCHAR szFromFolder[MAX_PATH];
	_tcscpy(szFromFolder, m_szCurrentFolder);

	//Rs[쐬
	TCHAR szToFolder[MAX_PATH];
	_tcscpy(szToFolder, m_szCurrentFolder);
	
	//fBNgIĂꍇ
	if (nIndex >= 0)
	{
		LISTITEMCOMP *plic = GetListItemStruct(nIndex);
		if (plic->nItem == LIST_ITEM_FOLDER)
		{
			//tH_IĂꍇ
			_stprintf(szToFolder, _T("%s\\%s"), m_szCurrentFolder, plic->lpszName);
		}
	}

	//Rs[/؂/V[gJbg쐬s
	if (hWnd == m_hWnd)
	{
		//Xgr[̃hbv
		if (iMenuID == ID_DROP_COPY ||
		   GetKeyState(VK_CONTROL)&0x8000 ||
		   g_MainWnd.m_bControlKey)
		{
			//1.Rs[̏ꍇ(+Ctrl)
			OnEditCopy();
		}
		else if (iMenuID == ID_DROP_SHORTCUT ||
			      GetKeyState(VK_MENU)&0x8000)
		{
			//2.V[gJbg쐬(+Alt)̏ꍇ
			OnEditCopy();
			b_shortcut = TRUE;
		}
		else
		{
			//3.؂̏ꍇ
			OnEditCut();
		}
	}
	else
	{
		//c[r[̃hbv
		//hbOACeI
		HWND hTree = g_MainWnd.m_TreeView.m_hWnd;
		TreeView_SelectItem(hTree, g_MainWnd.m_hDragTree);

		if (iMenuID == ID_DROP_COPY ||
		   GetKeyState(VK_CONTROL)&0x8000 ||
		   g_MainWnd.m_bControlKey)
		{
			//1.Rs[̏ꍇ(+Ctl)
			g_MainWnd.m_TreeView.OnEditCopy();
		}
		else if (iMenuID == ID_DROP_SHORTCUT ||
				  GetKeyState(VK_MENU)&0x8000)
		{
			//2.V[gJbg쐬(+Alt)̏ꍇ
			g_MainWnd.m_TreeView.OnEditCopy();
			b_shortcut = TRUE;
		}
		else
		{
			//3.؂̏ꍇ
			g_MainWnd.m_TreeView.OnEditCut();
			b_cut = TRUE;
		}
		
		//̃tH_ֈړ
		LoadFolderItem(szFromFolder, FALSE);
	}

	//\tpXݒ
	_tcscpy(m_szCurrentFolder, szToFolder);

	//\ts
	if (b_shortcut)
		OnEditPasteShortcut(FALSE);
	else
		OnEditPaste(FALSE);

	//\t悪JgtH_̏ꍇ
	if (0 == _tcscmp(szFromFolder, szToFolder))
		_tcscpy(m_szCurrentFolder, szFromFolder);

	LoadFolderItem(m_szCurrentFolder, FALSE);
}

///////////////////////////////////////////////////////////////
void CListView::OnDropCansel()
{
	//hbvI
	ListView_SetItemState(m_hWnd, -1, 0, LVIS_DROPHILITED);
}

///////////////////////////////////////////////////////////////
void CListView::OnFavoritesAdd()
{
	//݂̃fBNgۑ
	TCHAR szFromFolder[MAX_PATH];
	_tcscpy(szFromFolder, m_szCurrentFolder);

	//Rs[s
	if (ListView_GetSelectedCount(m_hWnd) > 0)
		OnEditCopy();
	else
		g_MainWnd.m_TreeView.OnEditCopy();

	//Cɓ̃fBNgֈړ
	_tcscpy(m_szCurrentFolder, g_MainWnd.m_szFavoritesPath);

	//V[gJbg̓\t(ݒɊ֌WȂ"`ւ̃V[gJbg"͕tȂ)
	BOOL bTemp = m_Settings.bNotShortcutName;
	m_Settings.bNotShortcutName = TRUE;
	OnEditPasteShortcut(FALSE);
	m_Settings.bNotShortcutName = bTemp;

	//Ỉ
	ListView_SetItemState(m_hWnd, -1, 0, LVIS_SELECTED);
	_tcscpy(m_szCurrentFolder, szFromFolder);

	//Cɓ胁j[̍č쐬
	//DeleteFavoritesMenu();	//(InitFavoritesMenu()Ɉړ)
	InitFavoritesMenu();
}

///////////////////////////////////////////////////////////////
void CListView::OnFavoritesOrganize()
{
	//Cɓ̃pXֈړ
	OnViewUpdate(g_MainWnd.m_szFavoritesPath);

	//Cɓ胁j[̍č쐬
	//DeleteFavoritesMenu();	//(InitFavoritesMenu()Ɉړ)
	InitFavoritesMenu();
}

///////////////////////////////////////////////////////////////
void CListView::OnUserPath()
{
	//O񃁃j[̍폜
	DeleteUserPathMenu();

	//[UpX_CAO
	CUserPathDlg *upd = new CUserPathDlg(g_MainWnd.m_hWnd, g_hInst);
	upd->Open();
	delete upd;

	//폜j[č쐬
	InitUserPathMenu();
}

///////////////////////////////////////////////////////////////
HISTORYINFO *CListView::AddHistory(HISTORYINFO *lpHistory, LPCTSTR lpszPath)
{
	//ǉ/폜
	if (lpHistory)
	{
		//ύXȂꍇ͒ǉȂ
		if (0 == _tcscmp(lpszPath, lpHistory->lpszPath))
			return lpHistory;
		
		//ȍ~̃o[폜
		DeleteHistory(lpHistory->lpNext);
		lpHistory->lpNext = NULL;
	}		

	//VKo쐬
	HISTORYINFO *his = new HISTORYINFO;
	his->lpszPath = new TCHAR[_tcslen(lpszPath)+1];
	_tcscpy(his->lpszPath, lpszPath);
	his->lpPrev = lpHistory;
	his->lpNext = NULL;

	//VKoXgɘA
	if (lpHistory)
	{
		lpHistory->lpNext = his;
	}

	//R[h|WVړ
	return his;
}

///////////////////////////////////////////////////////////////
void CListView::DeleteHistory(HISTORYINFO *lpHistory)
{
	//폜
	if (!lpHistory) return;

	//ȍ~̃AhX폜
	HISTORYINFO *pCurrent = lpHistory;
	while (pCurrent)
	{
		HISTORYINFO *pNext = pCurrent->lpNext;
		
		//\̍폜
		delete[] pCurrent->lpszPath;
		delete pCurrent;

		//̍폜o
		pCurrent = pNext;

	}
}
///////////////////////////////////////////////////////////////
void CListView::OnGoFront()
{
	//zpXȊȌꍇ̂
	if (!IsSearchFolder(m_szCurrentFolder))
	{
		//Ȃꍇ͈ړȂ
		if (!m_lpHistoryCurrent->lpNext) return;

		//ړ
		m_lpHistoryCurrent = m_lpHistoryCurrent->lpNext;
	}

	LoadFolderItem(m_lpHistoryCurrent->lpszPath);
}
///////////////////////////////////////////////////////////////
void CListView::OnGoBack()
{
	//zpXȊȌꍇ̂
	if (!IsSearchFolder(m_szCurrentFolder))
	{
		//OȂꍇ͈ړȂ
		if (!m_lpHistoryCurrent->lpPrev) return;

		//ړ
		m_lpHistoryCurrent = m_lpHistoryCurrent->lpPrev;
	}

	LoadFolderItem(m_lpHistoryCurrent->lpszPath);
}
///////////////////////////////////////////////////////////////
SEARCHDATA *CListView::AddSearch(
	SEARCHDATA	*lpSearch,
	LPCTSTR		lpszPath,
	LPCTSTR		lpszName,
	FILETIME	ft,
	DWORD		dwSize,
	DWORD		dwAttr)
{
	//VKo쐬
	SEARCHDATA *sch = new SEARCHDATA;
	sch->lpszPath = new TCHAR[_tcslen(lpszPath)+1];
	_tcscpy(sch->lpszPath, lpszPath);
	sch->lpszName = new TCHAR[_tcslen(lpszName)+1];
	_tcscpy(sch->lpszName, lpszName);
	sch->ft = ft;
	sch->dwSize = dwSize;
	sch->dwAttr = dwAttr;
	sch->lpPrev = lpSearch;
	sch->lpNext = NULL;

	//VKoXgɘA
	if (lpSearch)
	{
		//ŏIR[h擾
		SEARCHDATA *lpCurrent = lpSearch;
		for (int i=0; lpCurrent->lpNext; i++)
		{
			lpCurrent = lpCurrent->lpNext;
		}

		//R[hA
		lpCurrent->lpNext = sch;
		return lpSearch;
	}

	return sch;
}
///////////////////////////////////////////////////////////////
void CListView::DeleteSearch(SEARCHDATA *lpSearch)
{
	//폜
	if (!lpSearch) return;

	//ȍ~̃AhX폜
	SEARCHDATA *pCurrent = lpSearch;
	while (pCurrent)
	{
		SEARCHDATA *pNext = pCurrent->lpNext;
		
		//\̍폜
		delete[] pCurrent->lpszName;
		delete[] pCurrent->lpszPath;
		delete pCurrent;

		//̍폜o
		pCurrent = pNext;

	}
}
///////////////////////////////////////////////////////////////
void CListView::EditSearch(LPTSTR lpszOldPath, LPTSTR lpszOldName, LPTSTR lpszNewPath, LPTSTR lpszTo, BOOL bDelete)
{
	SEARCHDATA *pCurrent = m_lpSearchData;
	for (int i=0; pCurrent; i++)
	{
		SEARCHDATA *pNext = pCurrent->lpNext;
	
		//ΏۃR[hXV
		if (0 == _tcscmp(pCurrent->lpszPath, lpszOldPath) &&
		   0 == _tcscmp(pCurrent->lpszName, lpszOldName))
		{
			if (pCurrent->lpszPath) delete[] pCurrent->lpszPath;
			if (pCurrent->lpszName) delete[] pCurrent->lpszName;

			//폜
			if (bDelete)
			{
				if (pCurrent->lpPrev)
					pCurrent->lpPrev->lpNext = pCurrent->lpNext;
				else
					m_lpSearchData = pCurrent->lpNext;
				delete pCurrent;
			}
			//ύX
			else
			{
				pCurrent->lpszPath = new TCHAR[_tcslen(lpszNewPath)+1];
				_tcscpy(pCurrent->lpszPath, lpszNewPath);
				pCurrent->lpszName = new TCHAR[_tcslen(lpszTo)+1];
				_tcscpy(pCurrent->lpszName, lpszTo);
			}
			break;
		}
		
		//̃o
		pCurrent = pNext;

	}
}
///////////////////////////////////////////////////////////////
void CListView::OnFileSearch()
{
	//_CAO쐬
	CFileSearch Dlg(g_MainWnd.m_hWnd, g_hInst, m_szCurrentFolder);
	if (Dlg.Open())
	{
		//ʓWJ
		LoadFolderItem(GetResourceString(IDS_SEARCH_FOLDER_NAME));
	}
	SetFocus(m_hWnd);
}
///////////////////////////////////////////////////////////////
void CListView::OnGotoFolderDropDown()
{
	//c[{^ʒu擾
	RECT rc;
	HWND hToolbar = g_MainWnd.m_CmdBands.m_hToolbar;
	SendMessage(hToolbar, TB_GETRECT, (WPARAM)IDC_BTN_GOTOFOLDER, (LPARAM)&rc);
	MapWindowPoints(hToolbar, HWND_DESKTOP, (LPPOINT)&rc, 2);

	//|bvAbvj[̃nh擾
	HMENU hSubMenu = GetUserPathSubMenu1();

	//c[{^̃hbv_Ej[\
	TPMPARAMS tpm;
	memset(&tpm, 0, sizeof(tpm));
	tpm.cbSize = sizeof(TPMPARAMS);
	tpm.rcExclude = rc;

	//j[̕\
	TrackPopupMenu(hSubMenu, TPM_LEFTALIGN|TPM_BOTTOMALIGN,
			rc.left, rc.top, 0, g_MainWnd.m_hWnd, NULL);
}

///////////////////////////////////////////////////////////////
BOOL CListView::IsSelectionFile()
{
	int nIndex = GetSelectedItemIndex(0);
	if (nIndex == -1)
		return FALSE;
	LISTITEMCOMP *plic = GetListItemStruct(nIndex);
	return (plic->nItem == LIST_ITEM_FILE)? TRUE: FALSE;
}

///////////////////////////////////////////////////////////////
BOOL CListView::CreateShortcut(LPTSTR szDir, LPTSTR szTargetDir, LPTSTR szTargetFile, BOOL bNotName)
{
	int n = 0;
	TCHAR szTarget[MAX_PATH];
	TCHAR szPath[MAX_PATH];
	TCHAR szFileName[MAX_PATH];

	DisableUpdateNotify();
	_tcscpy(m_szLastCreateName, _T(""));
	if (szTargetDir)
		_stprintf(szTarget, _T("\"%s\\%s\""), szTargetDir, szTargetFile);
	else
		_tcscpy(szTarget, _T(""));
	_tcscpy(szFileName, szTargetFile);
	if (m_Settings.bNotShowExt || m_bNoExtShortcut)
	{
		LPTSTR p = _tcsrchr(szFileName, _T('.'));
		if (p)
			*p = _T('\0');
	}
	
	for (int i = 1; i < 512; i++)
	{
		if (bNotName)
		{
			//`ւ̃V[gJbgȂ
			_stprintf(szPath, GetResourceString((i == 1)? IDS_FMT_NEWSHORTCUT3: IDS_FMT_NEWSHORTCUT4), szDir, szFileName, i);
		}
		else
		{
			//`ւ̃V[gJbg
			_stprintf(szPath, GetResourceString((i == 1)? IDS_FMT_NEWSHORTCUT1: IDS_FMT_NEWSHORTCUT2), szDir, szFileName, i);
		}

		if (SHCreateShortcut(szPath, szTarget))
		{
			_tcscpy(m_szLastCreateName, _tcsrchr(szPath, _T('\\'))+1);
			if (m_Settings.bNotShowExt)
				*_tcsrchr(m_szLastCreateName, _T('.')) = _T('\0');
			break;
		}
	}
	EnableUpdateNotify();
	return TRUE;
}

///////////////////////////////////////////////////////////////
void CListView::OnSetFocus()
{
	g_MainWnd.m_CmdBands.SetEnableItemSelected();
}

#if defined(SUPPORT_FTP)
///////////////////////////////////////////////////////////////
// FTPł邩ǂ`FbN
BOOL CListView::IsFtpFolder(LPCTSTR lpszPath)
{
	TCHAR szTemp[6 + 1];

	_tcsncpy(szTemp, lpszPath, 6);
	szTemp[6] = _T('\0');

	return (_tcsicmp(szTemp, _T("ftp://")) == 0);
}

///////////////////////////////////////////////////////////////
// FTP̃pX𕪉
// (FTPT[oEt@CpXE[U[EpX[h𒊏o)
BOOL CListView::ParseFtpPath(LPCTSTR lpszPath)
{
	TCHAR szFtpServer[MAX_PATH];
	TCHAR szFtpPath[MAX_PATH];
	TCHAR szFtpUser[MAX_PATH];
	TCHAR szFtpPassword[MAX_PATH];
	TCHAR szTemp[MAX_PATH];

	//FTPT[oEt@CpXE[U[EpX[h𒊏o
	_tcscpy(szFtpServer, lpszPath + 6);
	_tcscpy(szFtpUser, _T("anonymous"));
	_tcscpy(szFtpPassword, _T("gsfinderuser@"));
	if (_tcschr(szFtpServer, _T('/')))
	{
		_tcscpy(szFtpPath, _tcschr(szFtpServer, _T('/')));
		*_tcschr(szFtpServer, _T('/')) = _T('\0');
	}
	else
	{
		_tcscpy(szFtpPath, _T("/"));
	}
	if (_tcschr(szFtpServer, _T(':')) && _tcschr(szFtpServer, _T('@')))
	{
		_tcscpy(szFtpUser, szFtpServer);
		*_tcschr(szFtpUser, _T(':')) = _T('\0');
		_tcscpy(szFtpPassword, _tcschr(szFtpServer, _T(':')) + 1);
		*_tcsrchr(szFtpPassword, _T('@')) = _T('\0');
		_tcscpy(szTemp, szFtpServer);
		_tcscpy(szFtpServer, _tcsrchr(szTemp, _T('@')) + 1);
	}
	for (LPTSTR lpszTemp = _tcsrchr(szFtpPath, _T('\0')) - 1; *lpszTemp == _T('\\') || *lpszTemp == _T('/'); lpszTemp--)
		*lpszTemp = _T('\0');

	_tcscpy(m_szFtpPath, szFtpPath);
	if (_tcscmp(m_szFtpServer, szFtpServer) != 0)
	{
		_tcscpy(m_szFtpServer, szFtpServer);
		_tcscpy(m_szFtpUser, szFtpUser);
		_tcscpy(m_szFtpPassword, szFtpPassword);
	}

	return TRUE;
}
#endif//SUPPORT_FTP