///////////////////////////////////////////////////////////////
//ListView.h
//t@Cꗗ\ - CListView

#if !defined(__LISTVIEW_H_INCLUDED)
#define __LISTVIEW_H_INCLUDED

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

///////////////////////////////////////////////////////////////
//INCLUDE
#include "resource.h"
#include "FileImageList.h"
#include "MultiBuff.h"
#include "Compress.h"

///////////////////////////////////////////////////////////////
typedef struct _tagListItemComp
{
	LPTSTR lpszPath;	//p
	LPTSTR lpszName;
	FILETIME ft;
	DWORD dwSize;
	int nItem;
	DWORD dwAttr;

	//\p
	int nState;
	int nIcon;
	LPTSTR lpszDispName;
	LPTSTR lpszDispSize;
	LPTSTR lpszDispType;
	LPTSTR lpszDispTime;
	_tagListItemComp()
	{
		nIcon = -1;
		lpszDispName = NULL;
		lpszDispSize = NULL;
		lpszDispType = NULL;
		lpszDispTime = NULL;
	}
} LISTITEMCOMP;

typedef struct _tagListItemInfo
{
	int		nIndex;
	int		nItem;
	TCHAR	szPath[MAX_PATH];
	TCHAR	szName[MAX_PATH];
	BOOL	bDone;
} LISTITEMINFO;

typedef struct _tagOpenAppInfo
{
	LPTSTR lpszPath;
} OPENAPPINFO;

typedef struct _tagFavoritesInfo
{
	LPTSTR lpszPath;
	struct _tagFavoritesInfo	*lpNext;
} FAVORITESINFO;

typedef struct _tagHistoryInfo
{
	LPTSTR					lpszPath;
	struct _tagHistoryInfo	*lpPrev;
	struct _tagHistoryInfo	*lpNext;
} HISTORYINFO;

typedef struct _tabSearchData
{
	LPTSTR					lpszPath;
	LPTSTR					lpszName;
	DWORD					dwAttr;
	FILETIME				ft;
	DWORD					dwSize;
	struct _tabSearchData	*lpPrev;
	struct _tabSearchData	*lpNext;
} SEARCHDATA;

///////////////////////////////////////////////////////////////
//DEFINE
#define MAX_OPENAPP 16
#define KEY_ACTION_COUNT 1000

///////////////////////////////////////////////////////////////
//MACRO
#define IsSearchFolder(s)	(_tcsicmp(GetResourceString(IDS_SEARCH_FOLDER_NAME),(s))==0)

///////////////////////////////////////////////////////////////
// CListViewNX
typedef struct _tagFileImageListSettings
{
	BOOL bNotLoadFileIcon;		//t@C̃ACRǂݍނ
	BOOL bNotLoadROMIcon;		//ROMt@C̃ACRǂݍނ
	BOOL bNotLoadCompIcon;		//kt@C̃ACRǂݍނ
	BOOL bStuffingIcons;		//ACRl߂ĕ\邩ǂ
} FILEIMAGELISTSETTINGS;

typedef struct _tagListViewSettings
{
	int		nSort;
	BOOL	bSortRaise;
	DWORD	dwListStyle;
	DWORD	dwListExStyle;
	BOOL	bHideHidden;
	BOOL	bHideSystem;
	BOOL	bHideROM;
	int		nNameColumnSize;
	int		nSizeColumnSize;
	int		nTypeColumnSize;
	int		nTimeColumnSize;
	BOOL	bSaveFolder;
	BOOL	bNotShortcutName;
	BOOL	bNotShowExt;
	BOOL	bShowSecond;
	BOOL	bSingleClick;
	BOOL	bHideHeader;
	BOOL	bAddUpper;

	DWORD	nCompDLL;
	BOOL	bAutoUnComp;
	BOOL	bMakeDir;
	BOOL	bMoveDir;
	BOOL	bDblClick;
}LISTVIEWSETTINGS;


class CListView
{
public:
	HWND		m_hWnd;// R}h o[ nh

	CFileImageList m_FileImageListLarge;
	CFileImageList m_FileImageListSmall;
	CFileImageList* m_pFileImageList;
	FILEIMAGELISTSETTINGS m_ImageListSettings;
	LISTVIEWSETTINGS m_Settings;
	TCHAR	m_szCurrentFolder[MAX_PATH];
	TCHAR	m_szCompressFolder[MAX_PATH];
	TCHAR	m_szOldFolder[MAX_PATH];
	BOOL	m_bTimeStump;
	BOOL	m_bHideFolder;
	BOOL	m_bNoExtShortcut;
	CCompress	*m_pCompress;
	CMultiBuff	m_ItemStruct;
	BOOL	m_bArrowPageMove;
	TCHAR	m_szFowardFindName[MAX_PATH];
	TCHAR	m_szLastCreateName[MAX_PATH];

	//CUT & PASTEp
	int m_nCount;
	BOOL m_bFileMove;
	LISTITEMINFO* m_lpliinfo;
	TCHAR m_szFolderFrom[MAX_PATH];

	LONGLONG m_nFileSize;
	
	//j[
	HMENU m_hMenuPopup;

	OPENAPPINFO* m_lpOpenAppInfo[MAX_OPENAPP];
	OPENAPPINFO* m_lpOpenPthInfo[MAX_OPENAPP];
	int m_nOpenAppInfoCount;
	int m_nOpenPthInfoCount;
	OPENAPPINFO* m_lpShellNewInfo[MAX_OPENAPP];
	int m_nShellNewInfoCount;
	
	BOOL			m_bEditing;
	DWORD			m_dwUpperParam;
	BOOL			m_bMenu;
	HWND			m_hFocus;
	DWORD			m_dwTapPos;
	int				m_nItemCnt;
	int				*m_lpnItem;
	int				m_nSelectStart;
	int				m_nSelectMin;
	int				m_nSelectItem;
	HISTORYINFO		*m_lpHistory;
	HISTORYINFO		*m_lpHistoryCurrent;
	SEARCHDATA		*m_lpSearchData;
	FAVORITESINFO	*m_lpFavorites;
	FAVORITESINFO	*m_lpFavoritesCurrent;
	int				m_nFavoritesCount;
	BOOL			m_bThroughContextMenu;
	BOOL			m_bOwnKeyup;
	BOOL			m_bScrollbarMove;
	BOOL			m_bOnComposition;
	BOOL			m_bThroughKeyup;

#if defined(SUPPORT_FTP)
	//FTPp
	TCHAR m_szFtpServer[MAX_PATH];
	TCHAR m_szFtpPath[MAX_PATH];
	TCHAR m_szFtpUser[MAX_PATH];
	TCHAR m_szFtpPassword[MAX_PATH];
#endif//SUPPORT_FTP

public:
	CListView();
	~CListView();
	void Init(HWND);
	void Destroy();
	void SetImageList();
	void GetSettings();
	void SaveSettings();

	void SortList();

	void OnSelEndOK();
	void OnColumnClick(NMLISTVIEW*);

	void MainWindowReset(LPCTSTR, LONGLONG);
	void LoadFolderReset(LPCTSTR);
	void LoadFolderSearch(LPCTSTR);
	void LoadFolderFiles(LPCTSTR, BOOL);
	void LoadFolderItem(LPCTSTR lpszPath, BOOL bTVUpdate = TRUE);
	void InitFolderItem(LPCTSTR lpszPath);
	void LoadFolderItemSub(LPCTSTR);
	void SelectFile(LPCTSTR);
	void AddFolderItemSub(LPCTSTR, LPCTSTR, DWORD, FILETIME, DWORD, LONGLONG*);
	void AddFolderItemFolder(LPCTSTR, LPCTSTR, DWORD, FILETIME, DWORD, LONGLONG*);
	void AddFolderItemFile(LPCTSTR, LPCTSTR, DWORD, FILETIME, DWORD, LONGLONG*);
	void AddFolderItem(WIN32_FIND_DATA*, LPCTSTR, LONGLONG*);
	void ComFileOpen(LPCTSTR);
#if defined(SUPPORT_FTP)
	//FTPp
	void LoadFolderFtp(LPCTSTR);
	BOOL IsFtpFolder(LPCTSTR);
	BOOL ParseFtpPath(LPCTSTR);
#endif//SUPPORT_FTP

	HMENU GetOpenAppSubMenu1();
	HMENU GetOpenAppSubMenu2();
	void DeleteOpenAppSubMenuSep(HMENU);
	void InitOpenAppMenu();
	HMENU GetUserPathSubMenu1();
	HMENU GetUserPathSubMenu2();
	void DeleteUserPathMenuSep(HMENU);
	void DeleteUserPathMenu();
	void InitUserPathMenu();
	void OnToolUserPath(int);
	HMENU GetFavoritesSubMenu1();
	HMENU GetFavoritesSubMenu2();
	int  DeleteFavoritesItem(FAVORITESINFO*);
	FAVORITESINFO *AddFavoritesItem(FAVORITESINFO*,LPCTSTR);
	void DeleteFavoritesMenu();
	void DeleteSubMenu(HMENU);
	void InitFavoritesMenu();
	void InitFavoritesSubMenu(HMENU, LPTSTR, int *pnCnt=NULL);
	void OnToolFavoritesLnk(int);
	HMENU GetShellNewSubMenu1();
	HMENU GetShellNewSubMenu2();
	void DeleteShellNewSubMenuSep(HMENU);
	void InitShellNewMenu();
	void OnFileShellNew(int);

	void OnChangeListStyle(UINT);
	void OnChangeSort(UINT);

	void OnViewUpdate(LPCTSTR lpszPath=NULL);
	void OnViewUpFolder();
	void OnViewFolder();

	void OnItemChanged(LPNMLISTVIEW);
	void OnKeydown(HWND, LPNMLVKEYDOWN);
	int CheckMessageID(int);
	void OnRClick(int, int);

	BOOL OnEndLabelEdit(LV_DISPINFO*);
	void OnFileRename();
	void OnEditCopyFileName();
	void OnEditCopyFilePath();
	void OnEditCut(LPCWCH lpszFolderFrom = NULL);
	void OnEditCopy(LPCWCH lpszFolderFrom = NULL);
	void OnEditPaste(BOOL bUpdate = TRUE);
	void OnEditSelectSwitch();
	void OnEditPasteShortcut(BOOL bUpdate = TRUE);

	int GetSelectedItemIndex(int);
	LISTITEMCOMP* GetListItemStruct(int);
	void MakeSelectedItemsStrings(LISTITEMINFO*, int);

	void OnFileCreateFolder();
	void OnFileCreateShortcut();
	void OnFileCreateNewShortcut();
	void OnFileShortcutFolder(LPTSTR lpszPath = NULL);
	void OnFileProperty();
	void OnFileOpen();
	void OnFileOpen(int);
	void OnFileOpenParam();
	void OnFileOpenApp(int);
	void OnFileToApp();
	void OnFileIRSend();
	void OnFileCopyFolder();
	void OnFileMoveFolder();
	void OnFileDelete();

	BOOL OnFileCompress();
	BOOL OnFileUnCompress();

	void OnTapAndHold(NMRGINFO*);
	void OnTapHoldBegin(DWORD);
	void OnTapHoldEnter();
	void SetFormatDateTime(SYSTEMTIME*, LPTSTR, UINT, BOOL bToday=FALSE);
	void OnGetDispInfo(NMLVDISPINFO*);
	void OnListStyle();

	void DeleteAllItem();
	void AddUpper();
	int GetValidAndSelectedCount();

	void OnMouseMove(POINT);
	void OnMouseMoveArea(POINT);
	BOOL OnLButtonUp(HWND);
	void OnDropEnter(HWND, int);
	void OnDropCansel();
	void OnFavoritesAdd();
	void OnFavoritesOrganize();
	void OnUserPath();
	HISTORYINFO* AddHistory(HISTORYINFO*, LPCTSTR);
	void DeleteHistory(HISTORYINFO*);
	void OnGoFront();
	void OnGoBack();
	
	SEARCHDATA *AddSearch(SEARCHDATA*,LPCTSTR,LPCTSTR,FILETIME,DWORD,DWORD);
	void DeleteSearch(SEARCHDATA*);
	void EditSearch(LPTSTR,LPTSTR,LPTSTR,LPTSTR,BOOL bDelete=FALSE);
	void OnFileSearch();
	void OnGotoFolderDropDown();
	BOOL IsSelectionFile();
	BOOL CreateShortcut(LPTSTR, LPTSTR, LPTSTR, BOOL);
	void OnFileMailSend();
	BOOL OnKeydownArrow(WPARAM, LPARAM);
	BOOL OnKeyupArrow(WPARAM, LPARAM);
	BOOL OnKeydownMoveTop(WPARAM, LPARAM);
	BOOL OnKeydownMoveTail(WPARAM, LPARAM);
	void OnSetFocus();
};

#endif // !defined(__LISTVIEW_H_INCLUDED)
