///////////////////////////////////////////////////////////////
//MainWnd.h
//CEChE - CMainWnd

#if !defined(__MAINWND_H_INCLUDED)
#define __MAINWND_H_INCLUDED

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

///////////////////////////////////////////////////////////////
//INCLUDE
#include "resource.h"
#include "CommandBandsPPC.h"
#include "StatusWnd.h"
#include "ListView.h"
#include "TreeView2.h"
#include "Compress.h"
#undef   _WINNETWK_
#include <winnetwk.h>

///////////////////////////////////////////////////////////////
//DEFINE
#define MAINWND_MINIMUM		(0)
#define MAINWND_NOMAL		(1)
#define MAINWND_MAXIMUM		(2)

#define	INPUTMODE_ZEN_HIRAGANA	(0)
#define	INPUTMODE_ZEN_KATAKANA	(1)
#define	INPUTMODE_HAN_KATAKANA	(2)
#define	INPUTMODE_ZEN_ALPHA_L	(3)
#define	INPUTMODE_ZEN_ALPHA_S	(4)
#define	INPUTMODE_HAN_ALPHA_L	(5)
#define	INPUTMODE_HAN_ALPHA_S	(6)
#define	INPUTMODE_HAN_NUMERIC	(7)

///////////////////////////////////////////////////////////////
class CMainWnd
{
public:
	HWND	m_hWnd;			//CEChẼnh
	CCmdBands m_CmdBands;	//R}hoh
	CStatusWnd m_StatusWnd; //Xe[^Xo[
	CListView m_ListView;	//Xgr[
	CTreeView m_TreeView;	//c[r[
	CCompress m_Compress;	//k/

	BOOL m_bControlKey;
	BOOL m_bShiftKey;

	DWORD m_nMainWndTop;
	DWORD m_nMainWndLeft;
	DWORD m_nMainWndWidth;
	DWORD m_nMainWndHeight;
	DWORD m_nMainWndStyle;

	BOOL m_bShowStatusWnd;
	BOOL m_bShowFolder;
	BOOL m_bViewSideP;
	BOOL m_bOverLapped;
	BOOL m_bContextMenu;
	BOOL m_bFontChange;
	BOOL m_bDragDrop;
	BOOL m_bSelectDrop;
	BOOL m_bSelectFlg;
	int m_nTreeViewWidthP;
	int m_nTreeViewHeightP;
	int m_nFontSize;
	TCHAR m_szFontName[128];

	//ݒ荀
	BOOL m_bViewSideL;
	int m_nTreeViewWidthL;
	int m_nTreeViewHeightL;
	BOOL m_bNumberShortcut;
	BOOL m_bSwapMenu;
	BOOL m_bXcrawlPageMove;
	BOOL m_bEdgeLoop;
	BOOL m_bVirtualListView;
	BOOL m_bTouchUI;
	//ԕێ
	BOOL m_bLandscapeMode;
	DWORD m_dwInputMode;
	DWORD m_dwInitialInputMode;
	HFONT m_hFont;
	HFONT m_hFontFix;
	BOOL m_bIsZero3;
	int m_nZero3ModelNumber;
	//ݒ荀
	BOOL m_bHighRresolutionMode;
	//ԕێ
	BOOL m_bHighDpiHardware;
	float m_fpHighResolutionScale;
	//ݒ荀
	BOOL m_bDisableResizeSpIcon;
	//ԕێ
	BOOL m_bIsSmartphone;

	TCHAR m_szSendAppPath[MAX_PATH];
	TCHAR m_szShellNewPath[MAX_PATH];
	BOOL m_bCheckQAdd;
	BOOL m_bSendMulti;
	HIMAGELIST	m_hDragImg;
	HWND		m_hDragWnd;
	HTREEITEM	m_hDragTree;

	// sip֘A
	HWND m_hwndPrev;
	DWORD m_dwLastSipInfo;
	TCHAR	m_szWindowsPath[MAX_PATH];
	TCHAR	m_szNetworkPath[MAX_PATH];
	TCHAR	m_szFavoritesPath[MAX_PATH];
	TCHAR	m_szStartMenuPath[MAX_PATH];
	TCHAR	m_szMyDocumentPath[MAX_PATH];
	LPTSTR	m_lpszNetwork;
	LPTSTR	m_lpszMyDocument;
	LPTSTR	m_lpszStartMenu;
	BOOL	m_bPaste;
public:
	CMainWnd();
	~CMainWnd();
	ATOM MainWndRegisterClass(HINSTANCE, LPTSTR);
	void Init();
	void ShowWindow();
	void GetSystemPath();
	void OnCreate();
	void OnDestroy();
	void OnSize(int, int);
	void OnClose();
	void OnEditCtrlOn();
	void OnEditShiftOn();
	void OnDragDropMode();
	void OnViewStatusBar();
	void OnViewFolder();
	void OnViewSide();
	void SaveSettings();
	void GetSettings();

	void OnViewUpdate(LPCTSTR lpszPath=NULL);
	BOOL NetworkFolderEnable(BOOL bEnable, BOOL bMsg=TRUE);
	void OnNetworkDriveConnect();
	void OnNetworkDriveDisconnect();
	void OnToolActivesync();
	void OnToolIRRecive();

	void SaveModulePath();
	void OnActivate(int nActive);
	void OnSettingChange(int nFlag);
	void RecalcLayout();
	void RecalcBarLayout(WPARAM,LPARAM);
	void OnMouseMove(LPARAM, int, int, int);

	HIMAGELIST ListViewImageCreate(LPNMLISTVIEW);
	HIMAGELIST TreeViewImageCreate(LPNMTREEVIEW);
	void ImageLeave();
	void ImageMove(POINT);
	void ImageDestory(HIMAGELIST);
	void OnBeginDrag(NMHDR*);
	void OnMouseMove(POINT);
	void OnLButtopUp();
	void OnDropCansel();
	void OnSetFocus(HWND);
	void OnDeviceChange(BOOL, BOOL bStart=TRUE);
	void OnBeginLabelEdit();
	void OnEndLabelEdit();
	void SetFont();
	void OnViewSideL();
	void OnViewHighRes(BOOL);
	void SetInputMode(int);
	DWORD GetInputMode();
	VOID SaveInputMode();
	VOID RestoreInputMode();
};

#endif // !defined(__MAINWND_H_INCLUDED)
