///////////////////////////////////////////////////////////////
//UserPathDlg.cpp
//[UpX̓o^ҏW - CUserPathDlg, UserPathDlgProc

///////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"
#include "UserPathDlg.h"
#include "FolderDlgPPC.h"

///////////////////////////////////////////////////////////////
//PROTOTYPE
LRESULT CALLBACK UserPathDlgProc(HWND,UINT,WPARAM,LPARAM);

///////////////////////////////////////////////////////////////
//MACRO
#define ITEM_SPACE	(3)

///////////////////////////////////////////////////////////////
CUserPathDlg::CUserPathDlg(HWND hWnd, HINSTANCE hInst)
{
	//p[^̕ۑ
	m_hparWnd = hWnd;
	m_hInst = hInst;

	//Rg[̏
	InitCommonControls();

	//oϐ̏
	m_bEditing = FALSE;
}

///////////////////////////////////////////////////////////////
CUserPathDlg::~CUserPathDlg()
{
}

///////////////////////////////////////////////////////////////
void CUserPathDlg::Open()
{
	//EBhE쐬
	DialogBoxParam(m_hInst,
				(LPCTSTR)IDD_USERPATH_DLG,
				m_hparWnd,
				(DLGPROC)UserPathDlgProc,
				LPARAM(this));

	//SIPN[Y
	SipShowIM(SIPF_OFF);

	return;
}

///////////////////////////////////////////////////////////////
void CUserPathDlg::OnInit()
{
	SHINITDLGINFO shidi;
	shidi.dwMask = SHIDIM_FLAGS;
	shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIZEDLGFULLSCREEN;
	shidi.hDlg = m_hWnd;
	SHINITDIALOG(&shidi);

	if (!g_MainWnd.m_bIsSmartphone)	//Smartphone/Standard̏ꍇPPC2SPLIBɔĈŕsv
	{
		//OK̃j[o[ǉ
		SHMENUBARINFO mbi;
		memset(&mbi, 0, sizeof(SHMENUBARINFO));
		mbi.cbSize = sizeof(SHMENUBARINFO);
		mbi.hwndParent = m_hWnd;
		mbi.nToolBarId = IDR_USERPATH;
		mbi.hInstRes = g_hInst;
		mbi.nBmpId = 0;
		mbi.cBmpImages = 0;	
		SHCreateMenuBar(&mbi);
	}

	//TCY (TreeView)
	OnSize();

	//EBhE^Cg
	SetWindowText(m_hWnd, GetResourceString(IDS_TITLE_USERPATHDLG));

	//Xgr[̃^b`UIΉ
	if (g_MainWnd.m_bTouchUI)
		ListView_SetExtendedListViewStyle(m_hList, ListView_GetExtendedListViewStyle(m_hList) | LVS_EX_THEME);

	//Jwb_̍쐬
	RECT rc;
	GetClientRect(m_hList, &rc);
	
	LVCOLUMN lvclm;
	lvclm.mask = LVCF_FMT|LVCF_WIDTH|LVCF_TEXT|LVCF_SUBITEM;
	lvclm.fmt = LVCFMT_LEFT;
	lvclm.cx = rc.right - rc.left;
	lvclm.pszText = GetResourceString(IDS_COLUMN_USERPATH);
	lvclm.cchTextMax = 0;
	lvclm.iSubItem = 0;
	ListView_InsertColumn(m_hList, 0, &lvclm);

	//Oo^pXǉ
	for (int i=0; i<g_MainWnd.m_ListView.m_nOpenPthInfoCount; i++)
	{
		//ACe̒ǉ
		LVITEM lvitem;
		lvitem.mask = LVIF_TEXT;
		lvitem.iItem = i;
		lvitem.iSubItem = 0;
		lvitem.pszText = g_MainWnd.m_ListView.m_lpOpenPthInfo[i]->lpszPath;
		ListView_InsertItem(m_hList, &lvitem);
	}

	//{^̏ݒ
	SetButton();

	//tH[JXXg֐ݒ
	SetFocus(m_hList);
}

///////////////////////////////////////////////////////////////
void CUserPathDlg::OnSize()
{
	RECT rcw,rc;
	POINT pt;
	HWND hlv;

	GetWindowRect(m_hWnd, &rcw);

	//TCY (TreeView)
	hlv = GetDlgItem(m_hWnd, IDC_LIST_PATH);
	GetWindowRect(hlv, &rc);
	pt.x = rc.left; pt.y = rc.top;
	ScreenToClient(m_hWnd, &pt);
	MoveWindow(hlv, pt.x, pt.y, RECT_WIDTH(&rcw), RECT_HEIGHT(&rcw)-pt.y, TRUE);

	//ʒu (Button)
	hlv = GetDlgItem(m_hWnd, IDDOWNMOVE);
	GetWindowRect(hlv, &rc);
	pt.x = 0;//dummy
	pt.y = rc.top;
	ScreenToClient(m_hWnd, &pt);
	pt.x = rcw.right;
	pt.x -= RECT_WIDTH(&rc)+(int)(ITEM_SPACE*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(hlv, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc), TRUE);
	hlv = GetDlgItem(m_hWnd, IDUPMOVE);
	GetWindowRect(hlv, &rc);
	pt.x -= RECT_WIDTH(&rc)+(int)(ITEM_SPACE*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(hlv, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc), TRUE);
	hlv = GetDlgItem(m_hWnd, IDEDIT);
	GetWindowRect(hlv, &rc);
	pt.x -= RECT_WIDTH(&rc)+(int)(ITEM_SPACE*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(hlv, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc), TRUE);
	hlv = GetDlgItem(m_hWnd, IDDELETE);
	GetWindowRect(hlv, &rc);
	pt.x -= RECT_WIDTH(&rc)+(int)(ITEM_SPACE*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(hlv, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc), TRUE);
	hlv = GetDlgItem(m_hWnd, IDADD);
	GetWindowRect(hlv, &rc);
	pt.x -= RECT_WIDTH(&rc)+(int)(ITEM_SPACE*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(hlv, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc), TRUE);
}

///////////////////////////////////////////////////////////////
void CUserPathDlg::SetButton()
{
	//ǉ{^
	if (g_MainWnd.m_ListView.m_nOpenPthInfoCount >= MAX_OPENAPP)
	{
		SetWindowLong(GetDlgItem(m_hWnd, IDADD), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDADD), GWL_STYLE)|WS_DISABLED);
	}
	else
	{
		SetWindowLong(GetDlgItem(m_hWnd, IDADD), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDADD), GWL_STYLE)&~WS_DISABLED);
	}

	//폜 & ҏW{^
	if (g_MainWnd.m_ListView.m_nOpenPthInfoCount <= 0)
	{
		SetWindowLong(GetDlgItem(m_hWnd, IDDELETE), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDDELETE), GWL_STYLE)|WS_DISABLED);
		SetWindowLong(GetDlgItem(m_hWnd, IDEDIT), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDEDIT), GWL_STYLE)|WS_DISABLED);
	}
	else
	{
		SetWindowLong(GetDlgItem(m_hWnd, IDDELETE), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDDELETE), GWL_STYLE)&~WS_DISABLED);
		SetWindowLong(GetDlgItem(m_hWnd, IDEDIT), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDEDIT), GWL_STYLE)&~WS_DISABLED);
	}
	
	// & փ{^
	if (g_MainWnd.m_ListView.m_nOpenPthInfoCount <= 1)
	{
		SetWindowLong(GetDlgItem(m_hWnd, IDUPMOVE), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDUPMOVE), GWL_STYLE)|WS_DISABLED);
		SetWindowLong(GetDlgItem(m_hWnd, IDDOWNMOVE), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDDOWNMOVE), GWL_STYLE)|WS_DISABLED);
	}
	else
	{
		SetWindowLong(GetDlgItem(m_hWnd, IDUPMOVE), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDUPMOVE), GWL_STYLE)&~WS_DISABLED);
		SetWindowLong(GetDlgItem(m_hWnd, IDDOWNMOVE), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDDOWNMOVE), GWL_STYLE)&~WS_DISABLED);
	}
	
	//{^ĕ`
	InvalidateRect(GetDlgItem(m_hWnd, IDADD), NULL, TRUE);
	UpdateWindow(GetDlgItem(m_hWnd, IDADD));
	InvalidateRect(GetDlgItem(m_hWnd, IDDELETE), NULL, TRUE);
	UpdateWindow(GetDlgItem(m_hWnd, IDDELETE));
	InvalidateRect(GetDlgItem(m_hWnd, IDEDIT), NULL, TRUE);
	UpdateWindow(GetDlgItem(m_hWnd, IDEDIT));
	InvalidateRect(GetDlgItem(m_hWnd, IDUPMOVE), NULL, TRUE);
	UpdateWindow(GetDlgItem(m_hWnd, IDUPMOVE));
	InvalidateRect(GetDlgItem(m_hWnd, IDDOWNMOVE), NULL, TRUE);
	UpdateWindow(GetDlgItem(m_hWnd, IDDOWNMOVE));
}

///////////////////////////////////////////////////////////////
void CUserPathDlg::OnAdd()
{
	TCHAR szPath[MAX_PATH];
	_tcscpy(szPath, g_MainWnd.m_ListView.m_szCurrentFolder);

	//tH[JXۑ
	HWND hFocusSave = GetFocus();

	//tH_I_CAO
	CFolderDlg fd;
	int nRet = fd.ShowFolderDlg(GetResourceString(IDS_TITLE_SELECTFOLDER), szPath, MAX_PATH);
	if (nRet == IDOK)
	{
		//[gtH_̓ꏈ
		if (!_tcslen(szPath) || IsSearchFolder(szPath))
			_tcscpy(szPath, GetRootName());

		//ACe̒ǉ
		LVITEM lvitem;
		lvitem.mask = LVIF_TEXT;
		lvitem.iItem = g_MainWnd.m_ListView.m_nOpenPthInfoCount;
		lvitem.iSubItem = 0;
		lvitem.pszText = szPath;
		ListView_InsertItem(m_hList, &lvitem);

		//J
		if (ListView_GetItemCount(m_hList))
			ListView_SetColumnWidth(m_hList, 0, LVSCW_AUTOSIZE);
		else
		{
			RECT rc;

			GetWindowRect(m_hList, &rc);
			ListView_SetColumnWidth(m_hList, 0, RECT_WIDTH(&rc) - 2 * g_MainWnd.m_fpHighResolutionScale);
		}

		//e[uփpXǉ
		AddPath(lvitem.iItem, lvitem.pszText);

		//ACeIԂɂ
		SetFocus(m_hList);
		ListView_SetItemState(m_hList, lvitem.iItem, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);

		//{^̐ݒ
		SetButton();
	}
	else
	{
		//tH[JX𕜋A
		SetFocus(hFocusSave);
	}
}

///////////////////////////////////////////////////////////////
void CUserPathDlg::OnDelete()
{
	//IACe
	int nItem = ListView_GetNextItem(m_hList, -1, LVNI_ALL | LVNI_SELECTED);
	if (nItem == -1)
		return;

	//ACe폜
	SetFocus(m_hList);
	ListView_DeleteItem(m_hList, nItem);

	//J
	if (ListView_GetItemCount(m_hList))
		ListView_SetColumnWidth(m_hList, 0, LVSCW_AUTOSIZE);
	else
	{
		RECT rc;

		GetWindowRect(m_hList, &rc);
		ListView_SetColumnWidth(m_hList, 0, RECT_WIDTH(&rc) - 2 * g_MainWnd.m_fpHighResolutionScale);
	}

	//e[ũpX폜
	DelPath(nItem);

	//ACe̍đI
	nItem = ListView_GetNextItem(m_hList, -1, LVNI_ALL | LVIS_FOCUSED);
	if (nItem != -1)
		ListView_SetItemState(m_hList, nItem, LVNI_SELECTED, LVNI_SELECTED);

	//{^̐ݒ
	SetButton();
}

///////////////////////////////////////////////////////////////
void CUserPathDlg::OnUpMove()
{
	//IACe
	int nItem = ListView_GetNextItem(m_hList, -1, LVNI_ALL|LVNI_SELECTED);
	if (nItem == -1 || nItem == 0)
		return;

	//ACe폜
	ListView_DeleteItem(m_hList, nItem);

	//ACe̒ǉ
	LVITEM lvitem;
	lvitem.mask = LVIF_TEXT;
	lvitem.iItem = nItem-1;
	lvitem.iSubItem = 0;
	lvitem.pszText = g_MainWnd.m_ListView.m_lpOpenPthInfo[nItem]->lpszPath;
	ListView_InsertItem(m_hList, &lvitem);

	//tH[JXړ
	ListView_SetItemState(m_hList, nItem-1, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);

	//e[ũpXړ
	MovPath(nItem, -1);
}

///////////////////////////////////////////////////////////////
void CUserPathDlg::OnDownMove()
{
	//IACe
	int nItem = ListView_GetNextItem(m_hList, -1, LVNI_ALL|LVNI_SELECTED);
	if (nItem == -1 || nItem == (ListView_GetItemCount(m_hList)-1))
		return;

	//ACe폜
	ListView_DeleteItem(m_hList, nItem);

	//ACe̒ǉ
	LVITEM lvitem;
	lvitem.mask = LVIF_TEXT;
	lvitem.iItem = nItem+1;
	lvitem.iSubItem = 0;
	lvitem.pszText = g_MainWnd.m_ListView.m_lpOpenPthInfo[nItem]->lpszPath;
	ListView_InsertItem(m_hList, &lvitem);

	//tH[JXړ
	ListView_SetItemState(m_hList, nItem+1, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);

	//e[ũpXړ
	MovPath(nItem, +1);
}

///////////////////////////////////////////////////////////////
void CUserPathDlg::OnEdit()
{
	TCHAR szPath[MAX_PATH];

	//IACe
	int nItem = ListView_GetNextItem(m_hList, -1, LVNI_ALL | LVNI_SELECTED);
	if (nItem == -1)
		return;

	//IACẽtH_擾
	ListView_GetItemText(m_hList, nItem, 0, szPath, MAX_PATH);

	//tH_I_CAO
	CFolderDlg fd;
	int nRet = fd.ShowFolderDlg(GetResourceString(IDS_TITLE_SELECTFOLDER), szPath, MAX_PATH);
	if (nRet == IDOK)
	{
		//[gtH_̓ꏈ
		if (!_tcslen(szPath) || IsSearchFolder(szPath))
			_tcscpy(szPath, GetRootName());

		//ύX̃pXݒ
		ListView_SetItemText(m_hList, nItem, 0, szPath);

		//J
		if (ListView_GetItemCount(m_hList))
			ListView_SetColumnWidth(m_hList, 0, LVSCW_AUTOSIZE);
		else
		{
			RECT rc;

			GetWindowRect(m_hList, &rc);
			ListView_SetColumnWidth(m_hList, 0, RECT_WIDTH(&rc) - 2 * g_MainWnd.m_fpHighResolutionScale);
		}
	}
	SetFocus(m_hList);
}

///////////////////////////////////////////////////////////////
BOOL CUserPathDlg::OnEndLabelEdit(LV_DISPINFO* pdi)
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pdi;

	int nIndex = pDispInfo->item.iItem;
	if (!pDispInfo->item.pszText) return FALSE;

	//G[`FbN
	if (_tcschr(pDispInfo->item.pszText, _T('/')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T(':')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T(',')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T(';')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T('*')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T('?')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T('<')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T('>')) != NULL
		|| _tcschr(pDispInfo->item.pszText, _T('|')) != NULL)
	{
		//G[̏ꍇ
		MessageBox(g_MainWnd.m_hWnd, GetResourceString(IDS_MSG_CANNOTUSECHAR), NULL, MB_OK|MB_ICONSTOP);
		SetFocus(m_hList);
		ListView_EditLabel(m_hList, nIndex);
		return FALSE;
	}
	else
	{
		TCHAR szPath[MAX_PATH];
		_tcscpy(szPath, pDispInfo->item.pszText);
		if (!_tcslen(szPath))
			_tcscpy(szPath, GetRootName());

		//݂邩̊mF
		DWORD dwAttr = GetFileAttributes(szPath);
		if (dwAttr == 0xFFFFFFFF || !(dwAttr & FILE_ATTRIBUTE_DIRECTORY))
		{
			MessageBox(g_MainWnd.m_hWnd, GetResourceString(IDS_MSG_NOTFOUND_PATH), NULL, MB_OK|MB_ICONSTOP);
			SetFocus(m_hList);
			ListView_EditLabel(m_hList, nIndex);
			return FALSE;
		}

		//̏ꍇ
		while (szPath[_tcslen(szPath)-1] == _T('\\'))	//\폜(j[ŕ\ȂȂւ̑Ώ)
			szPath[_tcslen(szPath)-1] = _T('\0');
		ListView_SetItemText(m_hList, pDispInfo->item.iItem, 0, szPath);
		ModPath(pDispInfo->item.iItem, szPath);
	}

	return TRUE;
}

///////////////////////////////////////////////////////////////
BOOL CUserPathDlg::AddPath(int nIndex, LPTSTR lpszPath)
{
	//f[^̍쐬
	OPENAPPINFO *pup = new OPENAPPINFO;
	pup->lpszPath = new TCHAR[_tcslen(lpszPath)+1];
	_tcscpy(pup->lpszPath, lpszPath);
	g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex] = pup;
	g_MainWnd.m_ListView.m_nOpenPthInfoCount++;

	return TRUE;
}

///////////////////////////////////////////////////////////////
BOOL CUserPathDlg::ModPath(int nIndex, LPTSTR lpszPath)
{
	//f[^̍폜
	OPENAPPINFO* pup= g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex];
	if (pup)
	{
		delete pup->lpszPath;
		delete pup;
	}

	//f[^̍č쐬
	pup = new OPENAPPINFO;
	pup->lpszPath = new TCHAR[_tcslen(lpszPath)+1];
	_tcscpy(pup->lpszPath, lpszPath);
	g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex] = pup;

	return TRUE;
}

///////////////////////////////////////////////////////////////
BOOL CUserPathDlg::DelPath(int nIndex)
{
	//f[^̍폜
	OPENAPPINFO* pup= g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex];
	if (pup)
	{
		delete pup->lpszPath;
		delete pup;
		g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex] = NULL;
	}
	
	//㑱f[^Oֈړ
	for (int i=nIndex; i<g_MainWnd.m_ListView.m_nOpenPthInfoCount; i++)
	{
		g_MainWnd.m_ListView.m_lpOpenPthInfo[i]
					= g_MainWnd.m_ListView.m_lpOpenPthInfo[i+1];
		g_MainWnd.m_ListView.m_lpOpenPthInfo[i+1] = NULL;
	}

	g_MainWnd.m_ListView.m_nOpenPthInfoCount--;
	return TRUE;
}

///////////////////////////////////////////////////////////////
BOOL CUserPathDlg::MovPath(int nIndex, int nDirection)
{
	//wf[^̈ړ
	OPENAPPINFO* ptmp = g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex];
	if (nDirection < 0)
	{
		//
		if (nIndex > 0)
		{
			//Ώۃf[^1Õf[^ւ
			g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex] = g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex-1];
			g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex-1] = ptmp;
			return TRUE;
		}
	}
	else
	{
		//
		if (nIndex < (g_MainWnd.m_ListView.m_nOpenPthInfoCount-1))
		{
			//Ώۃf[^1̃f[^ւ
			g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex] = g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex+1];
			g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex+1] = ptmp;
			return TRUE;
		}
	}

	return FALSE;
}

///////////////////////////////////////////////////////////////
LRESULT CALLBACK UserPathDlgProc(
		HWND hDlg,
		UINT message,
		WPARAM wParam,
		LPARAM lParam)
{
	CUserPathDlg* pusrDlg = (CUserPathDlg*)GetWindowLong(hDlg, GWL_USERDATA);

	switch (message)
	{
	case WM_INITDIALOG:
		//DialogBoxParamœnꂽCUserPathDlg̃CX^XUSERDATAɊi[
		SetWindowLong(hDlg, GWL_USERDATA, lParam);
		pusrDlg = (CUserPathDlg*)lParam;
		//
		pusrDlg->m_hWnd = hDlg;
		pusrDlg->m_hList = GetDlgItem(hDlg, IDC_LIST_PATH);
		pusrDlg->OnInit();
		break;

	case WM_SIZE:
		pusrDlg->OnSize();
		break;

	case WM_NOTIFY:
		{
			LPNMHDR pNMHDR = (LPNMHDR)lParam;
			switch (pNMHDR->code)
			{
			case NM_RECOGNIZEGESTURE:
				//^bvz[hуvXz[h̃Aj[VoȂ悤ɂ
				SetWindowLong(hDlg, DWL_MSGRESULT, 1);
				return TRUE;

			case LVN_BEGINLABELEDIT:
				//O̕ύXJn
				pusrDlg->m_bEditing = TRUE;
				break;

			case LVN_ENDLABELEDIT:
				{
					//O̕ύXI
					LV_DISPINFO* pdi = (LV_DISPINFO*)lParam;
					pusrDlg->m_bEditing = FALSE;
					return pusrDlg->OnEndLabelEdit(pdi);
				}
				break;

			default:
				break;
			}
		}
		break;

	case WM_COMMAND:
		{
			if (pusrDlg->m_bEditing)
				break;
			int wmId    = LOWORD(wParam);
			int wmEvent = HIWORD(wParam);
			switch (wmId)
			{
			case IDADD:
				pusrDlg->OnAdd();
				break;

			case IDDELETE:
				pusrDlg->OnDelete();
				break;

			case IDEDIT:
				pusrDlg->OnEdit();
				break;

			case IDUPMOVE:
				pusrDlg->OnUpMove();
				break;

			case IDDOWNMOVE:
				pusrDlg->OnDownMove();
				break;

			case IDOK:
			case IDCANCEL:
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;

			default:
				break;
			}
		}
		break;

	case WM_CTLCOLORSTATIC:
		return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);

	default:
		break;
	}

    return FALSE;
}
