#include "stdafx.h"
#include <vector>
#include <list>

// PNGƂ̓ǂݍݗp
#include <gdiplus.h>
#pragma comment(lib, "gdiplus.lib")

// PATH APIp
#include <Shlwapi.h>
#pragma comment(lib, "shlwapi.lib")

#include <CommCtrl.h>
#pragma comment(lib, "comctl32.lib")
#include <CommDlg.h>
#pragma comment(lib, "Comdlg32.lib")


#include "GVONavish.h"
#include "GVOConfig.h"
#include "GVOGameProcess.h"
#include "GVOWorldMap.h"
#include "GVOShip.h"
#include "GVOSpeedMeter.h"




// fobO̕`ptH[}XpB
//#define GVO_PERF_CHECK



// O[oϐ:
HINSTANCE g_hinst;										// ݂̃C^[tFCX
HWND g_hwndMain;
HDC g_hdcMain;


// ֐vg^Cv錾
static ATOM MyRegisterClass( HINSTANCE hInstance );
static BOOL InitInstance( HINSTANCE, int );
LRESULT CALLBACK WndProc( HWND, UINT, WPARAM, LPARAM );
static LRESULT s_mainLoop();


// bZ[Wnh
static bool s_onCreate( HWND, LPCREATESTRUCT );
static void s_onMove( HWND, WORD, WORD );
static void s_onSize( HWND, UINT, WORD, WORD );
static void s_onMouseWheel( HWND, int16_t, UINT, int16_t, int16_t );
static void s_onMouseMove( HWND, UINT, int16_t, int16_t );
static void s_onMouseLeftButtonDown( HWND, UINT, int16_t, int16_t );
static void s_onMouseLeftButtonUp( HWND, UINT, int16_t, int16_t );
static void s_onMouseLeftButtonDoubleClick( HWND, UINT, int16_t, int16_t );
static void s_onMouseRightButtonUp( HWND, UINT, int16_t, int16_t );
static void s_onPaint( HWND );


// Av
static std::wstring s_makeVersionString();
static std::wstring s_getMapFileName();
static void s_updateFrame(HWND hwnd, HDC hdc);
static void s_updateWindowTitle( HWND );
static void s_toggleKeepForeground( HWND );
static void s_popupMenu( HWND, int16_t, int16_t );
static void s_popupCoord( HWND, int16_t, int16_t );


// [Jϐ
static LPCWSTR const k_appName = L"GVANaviiۂj";	// AvP[V
static LPCWSTR const k_version = L"ver 1.0";	// o[Wԍ
static LPCWSTR const k_copyright = L"copyright(c) mandheling";	// 쌠\i[j

static LPCWSTR const k_windowClassName = L"GVANavish";		// C EBhE NX
static const LPCWSTR k_configFileName = L"GVONavish.ini";	// ݒt@C
static LPCWSTR const k_appMutexName = L"Global\\{7554E265-3247-4FCA-BC60-5AA814658351}";
static HANDLE s_appMutex;

static const std::wstring k_aboutText = s_makeVersionString();	// o[WeLXg

static GVOImage s_backbuffer;	//!<@brief `p24bitC[Wobt@
static HANDLE s_pollingTimerEvent = ::CreateEvent( NULL, TRUE, TRUE, NULL );
static UINT s_pollingTimerID = 0;

static Gdiplus::GdiplusStartupInput s_gdisi;
static ULONG_PTR s_gdiToken;

static GVOConfig s_config( k_configFileName );
static GVOGameProcess s_gvoGameProcess;
static GVOWorldMap s_worldMap;
static GVOShip s_ship;
static GVOSpeedMeter s_speedMeter;

static UINT s_pollingInterval = 1000;	// ԊĎԊui1bj
static bool s_isUpdated = false;		// ԍXVtO
static bool s_isDragging = false;		// hbOԃtO
static SIZE s_clientSize;				// NCAg̈̑傫
static POINT s_dragOrg;					// hbO_iړʎZopj


#ifndef NDEBUG
// fobOpqsϐ
static double s_xDebugAutoCruise;
static double s_yDebugAutoCruise;
static double s_debugAutoCruiseAngle = 0;
#endif




int APIENTRY _tWinMain( _In_ HINSTANCE hInstance,
	_In_opt_ HINSTANCE hPrevInstance,
	_In_ LPTSTR    lpCmdLine,
	_In_ int       nCmdShow )
{
	UNREFERENCED_PARAMETER( hPrevInstance );
	UNREFERENCED_PARAMETER( lpCmdLine );

	::SetLastError( NOERROR );
	s_appMutex = ::CreateMutex( NULL, TRUE, k_appMutexName );
	if ( ::GetLastError() == ERROR_ALREADY_EXISTS ) {
		HWND hwnd = ::FindWindow( k_windowClassName, NULL );
		if ( hwnd ) {
			::SetForegroundWindow( hwnd );
		}
		return 0;
	}

	::CoInitialize( NULL );
	TIMECAPS tc;
	::timeGetDevCaps( &tc, sizeof(tc) );
	::timeBeginPeriod( tc.wPeriodMin );
	INITCOMMONCONTROLSEX icc = { sizeof(icc), ICC_WIN95_CLASSES };
	::InitCommonControlsEx( &icc );
	GdiplusStartup( &s_gdiToken, &s_gdisi, NULL );
	s_config.load();

	MyRegisterClass( hInstance );

	// AvP[V̏s܂:
	if ( !InitInstance( hInstance, nCmdShow ) ) {
		return 0;
	}

	s_pollingTimerID = ::timeSetEvent( s_config.m_pollingInterval, tc.wPeriodMin, LPTIMECALLBACK( s_pollingTimerEvent ), 0, TIME_PERIODIC | TIME_CALLBACK_EVENT_SET );

	// C bZ[W [v:
	const LRESULT retVal = s_mainLoop();

	::timeKillEvent( s_pollingTimerID );

	s_config.save();
	Gdiplus::GdiplusShutdown( s_gdiToken );
	::timeEndPeriod( tc.wPeriodMin );
	::CoUninitialize();
	return retVal;
}

static ATOM MyRegisterClass( HINSTANCE hInstance )
{
	WNDCLASSEX wcex = { sizeof(wcex) };

	wcex.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS | CS_OWNDC;
	wcex.lpfnWndProc = WndProc;
	wcex.hInstance = hInstance;
	wcex.hIcon = LoadIcon( hInstance, MAKEINTRESOURCE( IDR_MAINFRAME ) );
	wcex.hCursor = LoadCursor( NULL, IDC_ARROW );
	wcex.hbrBackground = (HBRUSH)::GetStockObject( BLACK_BRUSH );
	//wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_GVONAVISH);
	wcex.lpszClassName = k_windowClassName;
	wcex.hIconSm = LoadIcon( wcex.hInstance, MAKEINTRESOURCE( IDI_SMALL ) );

	return RegisterClassEx( &wcex );
}

static BOOL InitInstance( HINSTANCE hInstance, int nCmdShow )
{
	if ( !s_worldMap.loadFromFile( s_config ) ) {
		// sΕۑȂ̂ővB
		s_config.m_mapFileName = s_getMapFileName();
		if ( !s_worldMap.loadFromFile( s_config ) ) {
			::MessageBox( NULL,
				L"}bv摜J܂łB",
				k_appName,
				MB_ICONERROR | MB_SETFOREGROUND | MB_OK );
			return FALSE;
		}
	}

	HWND hwnd;

	g_hinst = hInstance; // O[oϐɃCX^Xi[܂B

	DWORD exStyle = 0;
	if ( s_config.m_keepForeground ) {
		exStyle |= WS_EX_TOPMOST;
	}
	hwnd = CreateWindowEx( exStyle, k_windowClassName, k_appName, WS_OVERLAPPEDWINDOW,
		s_config.m_windowPos.x, s_config.m_windowPos.y,
		s_config.m_windowSize.cx, s_config.m_windowSize.cy,
		NULL, NULL, hInstance, NULL );

	if ( !hwnd ) {
		return FALSE;
	}

	s_pollingInterval = s_config.m_pollingInterval;
	s_gvoGameProcess.setConfig( s_config );
	s_worldMap.setConfig( s_config );
	s_ship.setInitialSurveyCoord( s_config.m_initialSurveyCoord );
#ifndef NDEBUG
	s_xDebugAutoCruise = s_config.m_initialSurveyCoord.x;
	s_yDebugAutoCruise = s_config.m_initialSurveyCoord.y;
#endif

	if ( s_gvoGameProcess.updateState() ) {
		s_ship.updateWithSurveyCoord( s_gvoGameProcess.surveyCoord(), s_gvoGameProcess.timeStamp() );
		s_worldMap.setShipPosition( s_gvoGameProcess.surveyCoord(), s_config.m_traceShipPositionEnabled );
	}
	s_updateWindowTitle( hwnd );

	ShowWindow( hwnd, nCmdShow );
	UpdateWindow( hwnd );
	g_hwndMain = hwnd;
	g_hdcMain = ::GetDC( g_hwndMain );

	return TRUE;
}

static LRESULT s_mainLoop()
{
	MSG msg;
	HACCEL hAccelTable;

	hAccelTable = LoadAccelerators( g_hinst, MAKEINTRESOURCE( IDC_GVONAVISH ) );

	for ( ;; ) {
		if ( ::PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) ) {
			if ( msg.message == WM_QUIT ) {
				break;
			}
			if ( !TranslateAccelerator( msg.hwnd, hAccelTable, &msg ) ) {
				TranslateMessage( &msg );
				DispatchMessage( &msg );
			}
			continue;
		}
		std::vector<HANDLE> handles;

		// ĎnhǉB
		if ( s_gvoGameProcess.processHandle() ) {
			handles.push_back( s_gvoGameProcess.processHandle() );
		}
		handles.push_back( s_pollingTimerEvent );

		if ( handles.empty() ) {
			::WaitMessage();
			continue;
		}

		DWORD const waitResult = ::MsgWaitForMultipleObjects( handles.size(), &handles[0], FALSE, INFINITE, QS_ALLINPUT );
		if ( handles.size() <= waitResult ) {
			continue;
		}

		// ĎnhɑΉB
		HANDLE const activeHandle = handles[waitResult];

		if ( activeHandle == s_gvoGameProcess.processHandle() ) {
			// Q[vZXIB
			s_gvoGameProcess.clear();
			continue;
		}
		if ( activeHandle == s_pollingTimerEvent ) {
			::ResetEvent( s_pollingTimerEvent );
			s_updateFrame( g_hwndMain, g_hdcMain );
			continue;
		}
	}
	return (int)msg.wParam;
}


LRESULT CALLBACK WndProc( HWND hwnd, UINT message, WPARAM wp, LPARAM lp )
{
	int wmId, wmEvent;

	switch ( message ) {
	case WM_ERASEBKGND:
		return TRUE;
	case WM_PAINT:
		s_onPaint( hwnd );
		break;

	case WM_MOVE:
		s_onMove( hwnd, int16_t( LOWORD( lp ) ), int16_t( HIWORD( lp ) ) );
		break;
	case WM_SIZE:
		s_onSize( hwnd, wp, LOWORD( lp ), HIWORD( lp ) );
		break;

	case WM_COMMAND:
		wmId = LOWORD( wp );
		wmEvent = HIWORD( wp );
		// Iꂽj[̉:
		switch ( wmId ) {
		case IDM_ABOUT:
			::MessageBox( hwnd,
				k_aboutText.c_str(),
				k_appName,
				MB_OK | MB_ICONINFORMATION );
			break;
		case IDM_EXIT:
			DestroyWindow( hwnd );
			break;
		case IDM_TOGGLE_TRACE_SHIP:
			s_config.m_traceShipPositionEnabled = !s_config.m_traceShipPositionEnabled;
			break;
		case IDM_ERASE_SHIP_ROUTE:
			s_worldMap.clearShipRoute();
			break;
		case IDM_TOGGLE_KEEP_FOREGROUND:
			s_toggleKeepForeground( hwnd );
			break;
		case IDM_TOGGLE_SPEED_METER:
			s_config.m_speedMeterEnabled = !s_config.m_speedMeterEnabled;
			::InvalidateRect( hwnd, NULL, FALSE );
			break;
		case IDM_TOGGLE_VECTOR_LINE:
			s_config.m_shipVectorLineEnabled = !s_config.m_shipVectorLineEnabled;
			s_worldMap.setVisibleShipRoute( s_config.m_shipVectorLineEnabled );
			break;
		default:
			return DefWindowProc( hwnd, message, wp, lp );
		}
		break;

	case WM_KEYUP:
		switch ( wp ) {
		case VK_F1:
			s_toggleKeepForeground( hwnd );
			break;
		case VK_ADD:
			if ( s_worldMap.zoomIn() ) {
				s_updateWindowTitle( hwnd );
				::InvalidateRect( hwnd, NULL, FALSE );
			}
			break;
		case VK_OEM_MINUS:
			if ( s_worldMap.zoomOut() ) {
				s_updateWindowTitle( hwnd );
				::InvalidateRect( hwnd, NULL, FALSE );
			}
			break;
		default:
			break;
		}
		break;

	case WM_MOUSEWHEEL:
		s_onMouseWheel( hwnd, HIWORD( wp ), LOWORD( wp ), int16_t( LOWORD( lp ) ), int16_t( HIWORD( lp ) ) );
		break;
	case WM_MOUSEMOVE:
		s_onMouseMove( hwnd, wp, int16_t( LOWORD( lp ) ), int16_t( HIWORD( lp ) ) );
		break;
	case WM_LBUTTONDOWN:
		s_onMouseLeftButtonDown( hwnd, wp, int16_t( LOWORD( lp ) ), int16_t( HIWORD( lp ) ) );
		break;
	case WM_LBUTTONUP:
		s_onMouseLeftButtonUp( hwnd, wp, int16_t( LOWORD( lp ) ), int16_t( HIWORD( lp ) ) );
		break;
	case WM_RBUTTONUP:
		s_onMouseRightButtonUp( hwnd, wp, int16_t( LOWORD( lp ) ), int16_t( HIWORD( lp ) ) );
		break;
	case WM_LBUTTONDBLCLK:
		s_onMouseLeftButtonDoubleClick( hwnd, wp, int16_t( LOWORD( lp ) ), int16_t( HIWORD( lp ) ) );
		break;

	case WM_CREATE:
		if ( !s_onCreate( hwnd, reinterpret_cast<LPCREATESTRUCT>(lp) ) ) {
			return -1;
		}
		break;
	case WM_DESTROY:
		PostQuitMessage( 0 );
		break;
	default:
		return DefWindowProc( hwnd, message, wp, lp );
	}
	return 0;
}


static bool s_onCreate( HWND hwnd, LPCREATESTRUCT /*cs*/ )
{
	return true;
}


static void s_onMove( HWND hwnd, WORD /*cx*/, WORD /*cy*/ )
{
	const DWORD style = ::GetWindowLong( hwnd, GWL_STYLE );
	if ( style & WS_MAXIMIZE ) {
		return;
	}
	RECT rc = { 0 };
	::GetWindowRect( hwnd, &rc );
	s_config.m_windowPos.x = rc.left;
	s_config.m_windowPos.y = rc.top;
}


static void s_onSize( HWND hwnd, UINT state, WORD cx, WORD cy )
{
	RECT rc = { 0 };

	switch ( state ) {
	case SIZE_RESTORED:
		::GetWindowRect( hwnd, &rc );
		s_config.m_windowSize.cx = rc.right - rc.left;
		s_config.m_windowSize.cy = rc.bottom - rc.top;
		break;
	case SIZE_MAXIMIZED:
		break;
	default:
		return;
	}

	if ( s_clientSize.cx != cx || s_clientSize.cy != cy ) {
		s_clientSize.cx = cx;
		s_clientSize.cy = cy;
		if ( !s_backbuffer.isCompatible( s_clientSize ) ) {
			s_backbuffer.createDIBImage( s_clientSize );
		}
		s_worldMap.setViewSize( s_clientSize );
	}
}


static void s_onMouseWheel( HWND hwnd, int16_t delta, UINT vkey, int16_t x, int16_t y )
{
	bool isChanged = false;

	if ( 0 < delta ) {
		isChanged = s_worldMap.zoomIn();
	}
	else {
		isChanged = s_worldMap.zoomOut();
	}

	if ( isChanged ) {
		s_updateWindowTitle( hwnd );
		::InvalidateRect( hwnd, NULL, FALSE );
	}
}


static void s_onMouseMove( HWND hwnd, UINT vkey, int16_t x, int16_t y )
{
	if ( s_isDragging ) {
		const int dx = x - s_dragOrg.x;
		const int dy = y - s_dragOrg.y;
		const int threshold = 1;	// xǂƒǏ]ȒPɐ؂Ă܂̂œKɑ΍
		if ( s_config.m_traceShipPositionEnabled ) {
			if ( ::abs( dx ) <= threshold && ::abs( dy ) < threshold ) {
				return;
			}
		}
		const POINT offset = { -dx, -dy };

		s_worldMap.offsetFocusInViewCoord( offset );
		::InvalidateRect( hwnd, NULL, FALSE );

		s_dragOrg.x = x;
		s_dragOrg.y = y;
		s_config.m_traceShipPositionEnabled = false;
	}
	else {

	}
}


static void s_onMouseLeftButtonDown( HWND hwnd, UINT vkey, int16_t x, int16_t y )
{
	if ( s_isDragging ) {

	}
	else {
		::SetCapture( hwnd );
		s_isDragging = true;
		s_dragOrg.x = x;
		s_dragOrg.y = y;
	}
}


static void s_onMouseLeftButtonUp( HWND hwnd, UINT vkey, int16_t x, int16_t y )
{
	if ( s_isDragging ) {
		::ReleaseCapture();
		s_isDragging = false;
		s_dragOrg.x = 0;
		s_dragOrg.y = 0;
	}
	else {

	}
}


static void s_onMouseLeftButtonDoubleClick( HWND hwnd, UINT vkey, int16_t x, int16_t y )
{
	if ( s_isDragging ) {

	}
	else {
		s_popupCoord( hwnd, x, y );
	}
}


static void s_onMouseRightButtonUp( HWND hwnd, UINT vkey, int16_t x, int16_t y )
{
	if ( s_isDragging ) {

	}
	else {
		s_popupMenu( hwnd, x, y );
	}
}


// _uobt@Ołh~B
static void s_onPaint( HWND hwnd )
{
#ifdef GVO_PERF_CHECK
	int64_t perfBegin = 0, perfEnd = 0;
	::QueryPerformanceCounter((LARGE_INTEGER*)&perfBegin);
#endif
	if ( !s_backbuffer.bitmapHandle() ) {
		s_backbuffer.createDIBImage( s_clientSize );
	}

	PAINTSTRUCT ps;
	HDC hdc = BeginPaint( hwnd, &ps );
	HDC hdcBackbuffer = ::CreateCompatibleDC( hdc );
	::SaveDC( hdcBackbuffer );
	::SelectObject( hdcBackbuffer, s_backbuffer.bitmapHandle() );
	RECT rc = { 0, 0, s_clientSize.cx, s_clientSize.cy };
	::FillRect( hdcBackbuffer, &rc, (HBRUSH)::GetStockObject( BLACK_BRUSH ) );

	// `hdcBackbufferɑ΂čsB
	s_worldMap.drawMap( hdcBackbuffer, s_ship );

	// xv`
	if ( s_config.m_speedMeterEnabled ) {
		const double velocity = s_speedMeter.velocityByKnot();
		wchar_t buf[4096] = { 0 };
		swprintf( buf, _countof( buf ), L"%.2f kt", velocity );

		RECT rc = { 0 };
		::DrawText( hdcBackbuffer, buf, -1, &rc, DT_SINGLELINE | DT_RIGHT | DT_TOP | DT_CALCRECT );
		const int width = rc.right - rc.left;
		rc.left = s_clientSize.cx - width;
		rc.right = rc.left + width;
		::DrawText( hdcBackbuffer, buf, -1, &rc, DT_SINGLELINE | DT_RIGHT | DT_TOP );
	}

#ifndef NDEBUG
	// ʍW`
	{
		const GVOImage& surveyCoordImage = s_gvoGameProcess.surveyCoordImage();
		HDC hdcSurvey = ::CreateCompatibleDC( hdcBackbuffer );
		::SaveDC( hdcSurvey );
		::SelectObject( hdcSurvey, surveyCoordImage.bitmapHandle() );
		::BitBlt( hdcBackbuffer, 0, 0, surveyCoordImage.size().cx, surveyCoordImage.size().cy,
			hdcSurvey, 0, 0, SRCCOPY );
		::RestoreDC( hdcSurvey, -1 );
		::DeleteDC( hdcSurvey );
	}
#endif

#ifndef NDEBUG
	if ( s_config.m_debugAutoCruiseEnabled ) {
		const double rad = ((s_debugAutoCruiseAngle)* M_PI) / 180;
		const double vx = ::cos( rad );
		const double vy = ::sin( rad );
		const LONG length = max( s_clientSize.cx, s_clientSize.cy );

		COLORREF rgb = (::fabs(s_ship.vector().angleTo(GVOVector(vx,vy))) <= FLT_EPSILON) ? RGB( 0, 255, 0 ) : RGB( 255, 255, 0 );

		LONG x2 = s_clientSize.cx / 2 + LONG( vx * length );
		LONG y2 = s_clientSize.cy / 2 + LONG( vy * length );
		HPEN pen = ::CreatePen( PS_SOLID, 3, rgb );
		HGDIOBJ old = ::SelectObject( hdcBackbuffer, pen );
		::MoveToEx( hdcBackbuffer, s_clientSize.cx / 2, s_clientSize.cy / 2, NULL );
		::LineTo( hdcBackbuffer, x2, y2 );
		::SelectObject( hdcBackbuffer, old );
		::DeleteObject( pen );
	}
#endif	// #ifndef NDEBUG

	::BitBlt( hdc, 0, 0, s_clientSize.cx, s_clientSize.cy,
		hdcBackbuffer, 0, 0, SRCCOPY );

	::RestoreDC( hdcBackbuffer, -1 );
	::DeleteDC( hdcBackbuffer );
	EndPaint( hwnd, &ps );


#ifdef GVO_PERF_CHECK
	::QueryPerformanceCounter((LARGE_INTEGER*)&perfEnd);
	int64_t freq = 0;
	::QueryPerformanceFrequency((LARGE_INTEGER*)&freq);
	const double deltaPerSec = (double(perfEnd - perfBegin) / double(freq)) * 1000.0;
	typedef std::list<double> PerfList;
	static PerfList perf;
	perf.push_back(deltaPerSec);

	const double ave = std::accumulate( perf.begin(), perf.end(), 0.0 ) / perf.size();
	if ( 100 < perf.size() ) {
		perf.pop_front();
	}

	std::wstring s;
	s = std::wstring( L"perf:" ) + std::to_wstring( ave ) + L"(ms)\n";
	::SetWindowText( hwnd, s.c_str() );
	::InvalidateRect( hwnd, NULL, FALSE );
#endif
}


static std::wstring s_makeVersionString()
{
	std::wstring s;
	s += std::wstring(k_appName) + L" " + k_version + L"\n";
	s += k_copyright;
	return s;
}


// }bv摜I
static std::wstring s_getMapFileName()
{
	wchar_t dir[MAX_PATH] = { 0 };
	::GetModuleFileName( g_hinst, dir, _countof( dir ) );
	::PathRemoveFileSpec( dir );

	wchar_t filePath[MAX_PATH] = { 0 };
	OPENFILENAME ofn = { sizeof(ofn) };
	ofn.lpstrTitle = L"}bv摜t@CIĂB";
	ofn.lpstrInitialDir = &dir[0];
	ofn.lpstrFilter = L"C[Wt@C\0L" L"*.bmp;*.jpg;*.jpeg;*.png;*.gif;*.tif;*.tiff" L"\0"
		L"SẴt@C\0" L"*.*" L"\0\0";
	ofn.Flags = OFN_READONLY | OFN_FILEMUSTEXIST;
	ofn.nMaxFile = _countof( filePath );
	ofn.lpstrFile = &filePath[0];
	if ( !::GetOpenFileName( &ofn ) ) {
		return L"";
	}
	return filePath;
}


static void s_updateFrame( HWND hwnd, HDC hdc )
{
#ifndef NDEBUG
	if ( s_config.m_debugAutoCruiseEnabled ) {
		static bool isRandInitialized = false;
		if ( !isRandInitialized ) {
			srand( ::timeGetTime() );
			isRandInitialized = true;
		}

		const double rad = ((s_debugAutoCruiseAngle)* M_PI) / 180;
		const double vx = ::cos( rad );
		const double vy = ::sin( rad );

		s_xDebugAutoCruise += vx * s_config.m_debugAutoCruiseVelocity;
		s_yDebugAutoCruise += vy * s_config.m_debugAutoCruiseVelocity;

		static DWORD tick = ::timeGetTime();
		static DWORD count = 0;
		if ( (tick + s_config.m_debugAutoCruiseTurnInterval) < ::timeGetTime() ) {
			if ( 10 < (++count) ) {
				count = 0;
				s_debugAutoCruiseAngle += 90 + (LONG( rand() / double( RAND_MAX ) * 90 ) & ~0x1);
			}
			else {
				s_debugAutoCruiseAngle += (rand() & 1) ? s_config.m_debugAutoCruiseTurnAngle : -s_config.m_debugAutoCruiseTurnAngle;
			}
			tick = ::timeGetTime();
		}
		s_debugAutoCruiseAngle = fmod( ::fabs( s_debugAutoCruiseAngle ), 360 );

		if ( s_xDebugAutoCruise < 0 ) {
			s_xDebugAutoCruise += k_worldWidth;
		}
		if ( s_yDebugAutoCruise < 0 ) {
			s_yDebugAutoCruise += k_worldHeight;
		}
		s_xDebugAutoCruise = fmod( s_xDebugAutoCruise, (double)k_worldWidth );
		s_yDebugAutoCruise = fmod( s_yDebugAutoCruise, (double)k_worldHeight );

		//// n}ׂ̊mFpfobOR[h
		//if ( 100 <= s_xDebugAutoCruise && s_xDebugAutoCruise <= (GVOWorldMap::k_worldWidth - 100) ) {
		//	s_xDebugAutoCruise = 0;
		//}


		POINT p = {
			LONG( s_xDebugAutoCruise ),
			LONG( s_yDebugAutoCruise )
		};
		uint32_t timeStamp = ::timeGetTime();
		s_ship.updateWithSurveyCoord( p, timeStamp );
		s_speedMeter.updateVelocity( s_ship.velocity(), timeStamp );
		s_gvoGameProcess.setSurveyCoord( p );
		s_worldMap.setShipPosition( p, s_config.m_traceShipPositionEnabled );
		s_worldMap.updateShipRouteMap( hdc );
		s_updateWindowTitle( hwnd );
		::InvalidateRect( hwnd, NULL, FALSE );
		return;
	}
#endif	// #ifndef NDEBUG

	s_isUpdated = s_gvoGameProcess.updateState();

	if ( s_isUpdated ) {
		s_config.m_initialSurveyCoord = s_gvoGameProcess.surveyCoord();
		s_ship.updateWithSurveyCoord( s_gvoGameProcess.surveyCoord(), s_gvoGameProcess.timeStamp() );
		s_speedMeter.updateVelocity( s_ship.velocity(), s_gvoGameProcess.timeStamp() );
		s_worldMap.setShipPosition( s_gvoGameProcess.surveyCoord(), s_config.m_traceShipPositionEnabled );
		s_worldMap.updateShipRouteMap( hdc );
		s_updateWindowTitle( hwnd );
		::InvalidateRect( hwnd, NULL, FALSE );
	}
}


static void s_updateWindowTitle( HWND hwnd )
{
	const POINT& surveyCoord = s_gvoGameProcess.surveyCoord();

	std::vector<wchar_t> buf( 4096 );
	::swprintf( &buf[0], buf.size(), L"%d,%d - (%.1f%%) - %s %s",
		surveyCoord.x, surveyCoord.y,
		s_worldMap.viewScale() * s_worldMap.viewScaleOrder(),
		k_appName, k_version
		);
	::SetWindowText( hwnd, &buf[0] );
}


static void s_toggleKeepForeground( HWND hwnd )
{
	if ( ::GetWindowLong( hwnd, GWL_EXSTYLE ) & WS_EX_TOPMOST ) {
		::SetWindowPos( hwnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOREDRAW );
		s_config.m_keepForeground = false;
	}
	else {
		::SetWindowPos( hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOREDRAW );
		s_config.m_keepForeground = true;
	}
}


static void s_popupMenu( HWND hwnd, int16_t x, int16_t y )
{
	HMENU hmenu = ::LoadMenu( g_hinst, MAKEINTRESOURCE( IDC_POPUPMENU ) );
	HMENU popupMenu = ::GetSubMenu( hmenu, 0 );

	::CheckMenuItem( popupMenu, IDM_TOGGLE_TRACE_SHIP, s_config.m_traceShipPositionEnabled ? MF_CHECKED : MF_UNCHECKED );
	::CheckMenuItem( popupMenu, IDM_TOGGLE_KEEP_FOREGROUND, s_config.m_keepForeground ? MF_CHECKED : MF_UNCHECKED );
	::CheckMenuItem( popupMenu, IDM_TOGGLE_SPEED_METER, s_config.m_speedMeterEnabled ? MF_CHECKED : MF_UNCHECKED );
	::CheckMenuItem( popupMenu, IDM_TOGGLE_VECTOR_LINE, s_config.m_shipVectorLineEnabled ? MF_CHECKED : MF_UNCHECKED );

	POINT p = { x, y };
	::ClientToScreen( hwnd, &p );
	::TrackPopupMenu( popupMenu, TPM_NONOTIFY | TPM_NOANIMATION | TPM_LEFTALIGN | TPM_TOPALIGN,
		p.x, p.y, 0, hwnd, NULL );
}


static void s_popupCoord( HWND hwnd, int16_t x, int16_t y )
{

}
