#if !defined(_BAYGUI_AWT_COMPONENT_H_INCLUDED_)
#define _BAYGUI_AWT_COMPONENT_H_INCLUDED_

using namespace baygui::lang;
using namespace baygui::util;
using namespace baygui::awt::event;

namespace baygui {
    namespace awt {
        class Container;

        /** uR|[lgv́Aʂɕ\łA[UƑΘbłOtBJȕ\IuWFNgłB*/
        class Component : public Object {
        protected:
            /** gbvxEBhE̍[̈ʒułB*/
            int tx;
            /** gbvxEBhE̍[̈ʒułB*/
            int ty;
            /** ̃R|[lg̔wiFłB*/
            unsigned int background;
            /** ̃R|[lg̑OiFłB*/
            unsigned int foreground;
            /** ̃R|[lgɃtH[JX邩ǂ킵܂B*/
            bool focused;
            /** ̃R|[lggp\ǂ킵܂B*/
            bool enabled;
            /** ̃R|[lgɃ}EXǂ킵܂B*/
            bool mouseEntered;
            /** ̃R|[lg Rectangle łB*/
            Rectangle* rectangle;
            /** ̃R|[lg̃OtBbNReLXgłB*/
            Graphics* graphics;
            /** ̃R|[lg̐eR|[lgłB*/
            Container* parent;
            /** L[CxgpXi[XgłB*/
            ArrayList* keyListeners;
            /** }EXCxgpXi[XgłB*/
            ArrayList* mouseListeners;
            /** }EX[VCxgpXi[XgłB*/
            ArrayList* mouseMotionListeners;

        public:
            /** R|[lgV\z܂B*/
            Component();

            /** fXgN^łB*/
            virtual ~Component();

            /**
             * ̃R|[lgL[Cxg󂯎邽߂ɁA
             * w肳ꂽL[Xi[ǉ܂B
            */
            void addKeyListener(KeyListener* l);

            /**
             * ̃R|[lg}EXCxg󂯎邽߂ɁA
             * w肳ꂽ}EXXi[ǉ܂B
            */
            void addMouseListener(MouseListener* l);

            /**
             * ̃R|[lg}EX[VCxg󂯎邽߂ɁA
             * w肳ꂽ}EX[VXi[ǉ܂B
            */
            void addMouseMotionListener(MouseMotionListener* l);

            /** ̃R|[lg܂͂̃TuR|[lg 1 ɃCxgfBXpb`܂B*/
            virtual void dispatchEvent(AWTEvent* e);

            /** ̃R|[lg̃obNOEhJ[Ԃ܂B*/
            unsigned int getBackground();

            /** ̃R|[lg̋E Rectangle IuWFNgƂĕԂ܂B*/
            Rectangle* getBounds();

            /**
             * ̃R|[lg܂͂̒ڂ̃TuR|[lgʒu (x, y) 
             * ܂ł邩ǂ𔻒肵܂B
            */
            virtual Component* getComponentAt(int x, int y);

            /** ̃R|[lg̃tHAOEhJ[Ԃ܂B*/
            unsigned int getForeground();

            /** ̃R|[lg̃OtBbNXReLXg쐬܂B*/
            virtual Graphics* getGraphics();

            /** ̃R|[lg̃TCYԂ܂B*/
            int getHeight();

            /**  Component L[{[htH[JXꍇ true Ԃ܂B*/
            bool hasFocus();

            /** ̃R|[lggp\ł邩ǂ𔻒肵܂B*/
            bool isEnabled();

            /** ̃R|[lg̐eԂ܂B*/
            Container* getParent();

            /** ̃R|[lg̃TCYԂ܂B*/
            int getWidth();

            /** ̃R|[lg̈ʒuAR|[lg̍w肷_ƂĕԂ܂B*/
            int getX();

            /** ̃R|[lg̈ʒuAR|[lg̍w肷_ƂĕԂ܂B*/
            int getY();

            /** ̃R|[lgyCg܂B*/
            virtual void paint(Graphics* g);

        protected:
            /** ̃R|[lgŔR|[lgCxg܂B*/
            virtual void processEvent(AWTEvent* e);

            /**
             * ̃R|[lgŔL[CxgA
             * o^Ă邷ׂĂ KeyListener IuWFNgɑ邱ƂɂA
             * L[Cxg܂B
            */
            virtual void processKeyEvent(KeyEvent* e);

            /**
             * ̃R|[lgŔ}EXCxgA
             * o^Ă邷ׂĂ MouseListener IuWFNgɑ邱ƂɂA
             * }EXCxg܂B
            */
            virtual void processMouseEvent(MouseEvent* e);

            /**
             * ̃R|[lgŔ}EX[VCxgA
             * o^Ă邷ׂĂ MouseMotionListener IuWFNgɑ邱ƂɂA
             * }EX[VCxg܂B
            */
            virtual void processMouseMotionEvent(MouseEvent* e);

        public:
            /**
             * ̃R|[lgL[Cxg󂯎Ȃ悤ɁA
             * w肳ꂽL[Xi[폜܂B
            */
            void removeKeyListener(KeyListener* l);

            /**
             * ̃R|[lg}EXCxg󂯎Ȃ悤ɁA
             * w肳ꂽ}EXXi[폜܂B
            */
            void removeMouseListener(MouseListener* l);

            /**
             * ̃R|[lg}EX[VCxg󂯎Ȃ悤ɁA
             * w肳ꂽ}EX[VXi[폜܂B
            */
            void removeMouseMotionListener(MouseMotionListener* l);

            /** ̃R|[lgĕ`悵܂B*/
            virtual void repaint(int x = 0, int y = 0, int w = 0, int h = 0);

            /** ̃R|[lg̓tH[JX擾邱Ƃv܂B*/
            virtual void requestFocus();

            /** ̃R|[lg̃obNOEhJ[ݒ肵܂B*/
            void setBackground(unsigned int c);

            /** ̃R|[lgړATCYύX܂B*/
            virtual void setBounds(int x, int y, int width, int height);

            /** ̃R|[lg̃tHAOEhJ[ݒ肵܂B*/
            void setForeground(unsigned int c);

            /** ̃R|[lg̐eR|[lgw肵܂B*/
            virtual void setParent(Container* parent);

            /** ̃R|[lgɃtH[JXړ܂B*/
            virtual void transferFocus();

            /** ̃R|[lgXV܂B*/
            virtual void update(Graphics* g, int x = 0, int y = 0, int w = 0, int h = 0);
        };
    }
}

#endif
