/* R\[֌W */

#include "bootpack.h"
#include <stdio.h>
#include <string.h>

extern unsigned short table_8_565[256];

void console_task(Sheet *sheet, int memtotal)
{
	Task *task = Task::now();
	MemoryManager *memory_manager = (MemoryManager *) MEMMAN_ADDR;
	int i, *fat = (int *) MemoryManager::allocate_4k(memory_manager, 4 * 2880);
	Console console;
	FileHandle fhandle[8];
	char cmdline[30];
	unsigned char *nihongo = (unsigned char *) *((int *) 0x0fe8);

	console.sheet = sheet;
	console.cur_x =  8;
	console.cur_y = 28;
	console.cur_c = -1;
	task->console = &console;
	task->cmdline = cmdline;

	if (console.sheet != 0) {
		console.timer = Timer::allocate();
		Timer::init(console.timer, &task->queue, 1);
		Timer::set_time(console.timer, 50);
	}
	File::read_fat(fat, (unsigned char *) (ADR_DISKIMG + 0x000200));
	for (i = 0; i < 8; i++) {
		fhandle[i].buf = 0;	/* gp}[N */
	}
	task->fhandle = fhandle;
	task->fat = fat;
	if (nihongo[4096] != 0xff) {	/* {tHgt@Cǂݍ߂H */
		task->langmode = 1;
	} else {
		task->langmode = 0;
	}
	task->langbyte1 = 0;

	/* vvg\ */
	Console::put_char(&console, '>', 1);

	for (;;) {
		io_cli();
		if (Queue::status(&task->queue) == 0) {
			Task::sleep(task);
			io_sti();
		} else {
			i = Queue::pop(&task->queue);
			io_sti();
			if (i <= 1 && console.sheet != 0) { /* J[\p^C} */
				if (i != 0) {
					Timer::init(console.timer, &task->queue, 0); /* 0 */
					if (console.cur_c >= 0) {
						console.cur_c = COL8_000000;
					}
				} else {
					Timer::init(console.timer, &task->queue, 1); /* 1 */
					if (console.cur_c >= 0) {
						console.cur_c = COL8_C6C6C6;
					}
				}
				Timer::set_time(console.timer, 50);
			}
			if (i == 2) {	/* J[\ON */
				console.cur_c = COL8_000000;
			}
			if (i == 3) {	/* J[\OFF */
				if (console.sheet != 0) {
					Graphics::fill_rect(console.sheet->buf, console.sheet->bxsize, COL8_C6C6C6,
						console.cur_x, console.cur_y, console.cur_x + 7, console.cur_y + 15);
				}
				console.cur_c = -1;
			}
			if (i == 4) {	/* R\[́u~v{^NbN */
				Console::command_exit(&console, fat);
			}
			if (256 <= i && i <= 511) { /* L[{[hf[^i^XNAoRj */
				if (i == 8 + 256) {
					/* obNXy[X */
					if (console.cur_x > 16) {
						/* J[\Xy[XŏĂAJ[\1߂ */
						Console::put_char(&console, ' ', 0);
						console.cur_x -= 8;
					}
				} else if (i == 10 + 256) {
					/* Enter */
					/* J[\Xy[XŏĂs */
					Console::put_char(&console, ' ', 0);
					cmdline[console.cur_x / 8 - 2] = 0;
					Console::new_line(&console);
					Console::run_command(cmdline, &console, fat, memtotal);	/* R}hs */
					if (console.sheet == 0) {
						Console::command_exit(&console, fat);
					}
					/* vvg\ */
					Console::put_char(&console, '>', 1);
				} else {
					/* ʕ */
					if (console.cur_x < 240) {
						/* ꕶ\ĂAJ[\1i߂ */
						cmdline[console.cur_x / 8 - 2] = i - 256;
						Console::put_char(&console, i - 256, 1);
					}
				}
			}
			/* J[\ĕ\ */
			if (console.sheet != 0) {
				if (console.cur_c >= 0) {
					Graphics::fill_rect(console.sheet->buf, console.sheet->bxsize, console.cur_c, 
						console.cur_x, console.cur_y, console.cur_x + 7, console.cur_y + 15);
				}
				Sheet::refresh(console.sheet, console.cur_x, console.cur_y, console.cur_x + 8, console.cur_y + 16);
			}
		}
	}
}

void Console::put_char(Console *console, int chr, char move)
{
	char s[2];
	s[0] = chr;
	s[1] = 0;
	if (s[0] == 0x09) {	/* ^u */
		for (;;) {
			if (console->sheet != 0) {
				Window::putfonts_asc_sheet(console->sheet, console->cur_x, console->cur_y, COL8_000000, COL8_C6C6C6, " ", 1);
			}
			console->cur_x += 8;
			if (console->cur_x == 8 + 240) {
				Console::new_line(console);
			}
			if (((console->cur_x - 8) & 0x1f) == 0) {
				break;	/* 32Ŋ؂ꂽbreak */
			}
		}
	} else if (s[0] == 0x0a) {	/* s */
		Console::new_line(console);
	} else if (s[0] == 0x0d) {	/* A */
		/* Ƃ肠ȂɂȂ */
	} else {	/* ʂ̕ */
		if (console->sheet != 0) {
			Window::putfonts_asc_sheet(console->sheet, console->cur_x, console->cur_y, COL8_000000, COL8_C6C6C6, s, 1);
		}
		if (move != 0) {
			/* move0̂Ƃ̓J[\i߂Ȃ */
			console->cur_x += 8;
			if (console->cur_x == 8 + 240) {
				Console::new_line(console);
			}
		}
	}
	return;
}

void Console::new_line(Console *console)
{
	int x, y;
	Sheet *sheet = console->sheet;
	Task *task = Task::now();
	if (console->cur_y < 28 + 112) {
		console->cur_y += 16; /* ̍s */
	} else {
		/* XN[ */
		if (sheet != 0) {
			for (y = 28; y < 28 + 112; y++) {
				for (x = 8; x < 8 + 240; x++) {
					sheet->buf[x + y * sheet->bxsize] = sheet->buf[x + (y + 16) * sheet->bxsize];
				}
			}
			for (y = 28 + 112; y < 28 + 128; y++) {
				for (x = 8; x < 8 + 240; x++) {
					sheet->buf[x + y * sheet->bxsize] = table_8_565[COL8_C6C6C6];
				}
			}
			Sheet::refresh(sheet, 8, 28, 8 + 240, 28 + 128);
		}
	}
	console->cur_x = 8;
	if (task->langmode == 1 && task->langbyte1 != 0) {
		console->cur_x = 16;
	}
	return;
}

void Console::put_str0(Console *console, char *s)
{
	for (; *s != 0; s++) {
		Console::put_char(console, *s, 1);
	}
	return;
}

void Console::put_str1(Console *console, char *s, int l)
{
	int i;
	for (i = 0; i < l; i++) {
		Console::put_char(console, s[i], 1);
	}
	return;
}

void Console::run_command(char *cmdline, Console *console, int *fat, int memtotal)
{
	if (strcmp(cmdline, "mem") == 0 && console->sheet != 0) {
		Console::command_mem(console, memtotal);
	} else if (strcmp(cmdline, "cls") == 0 && console->sheet != 0) {
		Console::command_cls(console);
	} else if (strcmp(cmdline, "dir") == 0 && console->sheet != 0) {
		Console::command_dir(console);
	} else if (strcmp(cmdline, "exit") == 0) {
		Console::command_exit(console, fat);
	} else if (strncmp(cmdline, "start ", 6) == 0) {
		Console::command_start(console, cmdline, memtotal);
	} else if (strncmp(cmdline, "ncst ", 5) == 0) {
		Console::command_ncst(console, cmdline, memtotal);
	} else if (strncmp(cmdline, "langmode ", 9) == 0) {
		Console::command_langmode(console, cmdline);
	} else if (cmdline[0] != 0) {
		if (Console::command_app(console, fat, cmdline) == 0) {
			/* R}hł͂ȂAAvłȂAɋsłȂ */
			Console::put_str0(console, "Bad command.\n\n");
		}
	}
	return;
}

void Console::command_mem(Console *console, int memtotal)
{
	MemoryManager *memory_manager = (MemoryManager *) MEMMAN_ADDR;
	char s[60];
	sprintf(s, "total   %dMB\nfree %dKB\n\n", memtotal / (1024 * 1024), MemoryManager::total(memory_manager) / 1024);
	Console::put_str0(console, s);
	return;
}

void Console::command_cls(Console *console)
{
	int x, y;
	Sheet *sheet = console->sheet;
	for (y = 28; y < 28 + 128; y++) {
		for (x = 8; x < 8 + 240; x++) {
			sheet->buf[x + y * sheet->bxsize] = table_8_565[COL8_C6C6C6];
		}
	}
	Sheet::refresh(sheet, 8, 28, 8 + 240, 28 + 128);
	console->cur_y = 28;
	return;
}

void Console::command_dir(Console *console)
{
	FileInfo *finfo = (FileInfo *) (ADR_DISKIMG + 0x002600);
	int i, j;
	char s[30];
	for (i = 0; i < 224; i++) {
		if (finfo[i].name[0] == 0x00) {
			break;
		}
		if (finfo[i].name[0] != 0xe5) {
			if ((finfo[i].type & 0x18) == 0) {
				sprintf(s, "filename.ext   %7d\n", finfo[i].size);
				for (j = 0; j < 8; j++) {
					s[j] = finfo[i].name[j];
				}
				s[ 9] = finfo[i].ext[0];
				s[10] = finfo[i].ext[1];
				s[11] = finfo[i].ext[2];
				Console::put_str0(console, s);
			}
		}
	}
	Console::new_line(console);
	return;
}

void Console::command_exit(Console *console, int *fat)
{
	MemoryManager *memory_manager = (MemoryManager *) MEMMAN_ADDR;
	Task *task = Task::now();
	SheetManager *sheet_manager = (SheetManager *) *((int *) 0x0fe4);
	Queue *queue = (Queue *) *((int *) 0x0fec);
	if (console->sheet != 0) {
		Timer::cancel(console->timer);
	}
	MemoryManager::deallocate_4k(memory_manager, (int) fat, 4 * 2880);
	io_cli();
	if (console->sheet != 0) {
		Queue::push(queue, console->sheet - sheet_manager->sheets0 + 768);	/* 768`1023 */
	} else {
		Queue::push(queue, task - task_manager->tasks0 + 1024);	/* 1024`2023 */
	}
	io_sti();
	for (;;) {
		Task::sleep(task);
	}
}

void Console::command_start(Console *console, char *cmdline, int memtotal)
{
	SheetManager *sheet_manager = (SheetManager *) *((int *) 0x0fe4);
	Sheet *sheet = open_console(sheet_manager, memtotal);
	Queue *queue = &sheet->task->queue;
	int i;
	Sheet::slide(sheet, 32, 4);
	Sheet::up_down(sheet, sheet_manager->top);
	/* R}hCɓ͂ꂽAꕶVR\[ɓ */
	for (i = 6; cmdline[i] != 0; i++) {
		Queue::push(queue, cmdline[i] + 256);
	}
	Queue::push(queue, 10 + 256);	/* Enter */
	Console::new_line(console);
	return;
}

void Console::command_ncst(Console *console, char *cmdline, int memtotal)
{
	Task *task = open_console_task(0, memtotal);
	Queue *queue = &task->queue;
	int i;
	/* R}hCɓ͂ꂽAꕶVR\[ɓ */
	for (i = 5; cmdline[i] != 0; i++) {
		Queue::push(queue, cmdline[i] + 256);
	}
	Queue::push(queue, 10 + 256);	/* Enter */
	Console::new_line(console);
	return;
}

void Console::command_langmode(Console *console, char *cmdline)
{
	Task *task = Task::now();
	unsigned char mode = cmdline[9] - '0';
	if (mode <= 2) {
		task->langmode = mode;
	} else {
		Console::put_str0(console, "mode number error.\n");
	}
	Console::new_line(console);
	return;
}

int Console::command_app(Console *console, int *fat, char *cmdline)
{
	MemoryManager *memory_manager = (MemoryManager *) MEMMAN_ADDR;
	FileInfo *finfo;
	char name[13], *q;
	unsigned char *p;
	Task *task = Task::now();
	int i, segsiz, datsiz, esp, dathrb, appsiz;
	SheetManager *sheet_manager;
	Sheet *sheet;

	/* R}hCt@C𐶐 */
	for (i = 0; i < 8; i++) {
		if (cmdline[i] <= ' ') {
			break;
		}
		name[i] = cmdline[i];
	}
	name[i] = 0; /* Ƃ肠t@Č0ɂ */

	/* t@CT */
	finfo = File::search(name, (FileInfo *) (ADR_DISKIMG + 0x002600), 224);
	if (finfo == 0) {
		/* Ȃ̂Ō".HRB"ĂxTĂ݂ */
		name[i    ] = '.';
		name[i + 1] = 'H';
		name[i + 2] = 'R';
		name[i + 3] = 'B';
		name[i + 4] = 0;
		finfo = File::search(name, (FileInfo *) (ADR_DISKIMG + 0x002600), 224);
	}

	if (finfo != 0) {
		/* t@Cꍇ */
		appsiz = finfo->size;
		p = File::load_file2(finfo->clustno, &appsiz, fat);
		if (appsiz >= 36 && strncmp((char *) p + 4, "Hari", 4) == 0 && *p == 0x00) {
			segsiz = *((int *) (p + 0x0000));
			esp    = *((int *) (p + 0x000c));
			datsiz = *((int *) (p + 0x0010));
			dathrb = *((int *) (p + 0x0014));
			q = (char *) MemoryManager::allocate_4k(memory_manager, segsiz);
			task->ds_base = (int) q;
			SegmentDescriptor::set(task->ldt + 0, appsiz - 1, (int) p, AR_CODE32_ER + 0x60);
			SegmentDescriptor::set(task->ldt + 1, segsiz - 1, (int) q, AR_DATA32_RW + 0x60);
			for (i = 0; i < datsiz; i++) {
				q[esp + i] = p[dathrb + i];
			}
			start_app(0x1b, 0 * 8 + 4, esp, 1 * 8 + 4, &(task->tss.esp0));
			sheet_manager = (SheetManager *) *((int *) 0x0fe4);
			for (i = 0; i < MAX_SHEETS; i++) {
				sheet = &(sheet_manager->sheets0[i]);
				if ((sheet->flags & 0x11) == 0x11 && sheet->task == task) {
					/* AvJςȂɂ𔭌 */
					Sheet::deallocate(sheet);	/*  */
				}
			}
			for (i = 0; i < 8; i++) {	/* N[YĂȂt@CN[Y */
				if (task->fhandle[i].buf != 0) {
					MemoryManager::deallocate(memory_manager, (int) task->fhandle[i].buf, task->fhandle[i].size);
					task->fhandle[i].buf = 0;
				}
			}
			Timer::cancel_all(&task->queue);
			MemoryManager::deallocate_4k(memory_manager, (int) q, segsiz);
			task->langbyte1 = 0;
		} else {
			Console::put_str0(console, ".hrb file format error.\n");
		}
		MemoryManager::deallocate_4k(memory_manager, (int) p, appsiz);
		Console::new_line(console);
		return 1;
	}
	/* t@CȂꍇ */
	return 0;
}

int *hrb_api(int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax)
{
	Task *task = Task::now();
	int ds_base = task->ds_base;
	Console *console = task->console;
	SheetManager *sheet_manager = (SheetManager *) *((int *) 0x0fe4);
	Sheet *sheet;
	Queue *sys_queue = (Queue *) *((int *) 0x0fec);
	int *reg = &eax + 1;	/* eax̎̔Ԓn */
		/* ۑ̂߂PUSHADɏ */
		/* reg[0] : EDI,   reg[1] : ESI,   reg[2] : EBP,   reg[3] : ESP */
		/* reg[4] : EBX,   reg[5] : EDX,   reg[6] : ECX,   reg[7] : EAX */
	int i;
	FileInfo *finfo;
	FileHandle *fh;
	MemoryManager *memory_manager = (MemoryManager *) MEMMAN_ADDR;

	if (edx == 1) {
		Console::put_char(console, eax & 0xff, 1);
	} else if (edx == 2) {
		Console::put_str0(console, (char *) ebx + ds_base);
	} else if (edx == 3) {
		Console::put_str1(console, (char *) ebx + ds_base, ecx);
	} else if (edx == 4) {
		return &(task->tss.esp0);
	} else if (edx == 5) {
		sheet = SheetManager::allocate(sheet_manager);
		sheet->task = task;
		sheet->flags |= 0x10;
		Sheet::set_buffer(sheet, (unsigned short *) (ebx + ds_base), esi, edi, eax);
		//Window::make_window((unsigned short *) (ebx + ds_base), esi, edi, (char *) ecx + ds_base, 0);
		Gui::drawFrame(sheet, (char *) ecx + ds_base);
		Sheet::slide(sheet, ((sheet_manager->xsize - esi) / 2) & ~3, (sheet_manager->ysize - edi) / 2);
		Sheet::up_down(sheet, sheet_manager->top); /* ̃}EXƓɂȂ悤ɎwF }EX͂̏ɂȂ */
		reg[7] = (int) sheet;
	} else if (edx == 6) {
		sheet = (Sheet *) (ebx & 0xfffffffe);
		//Graphics::draw_string(sheet->buf, sheet->bxsize, esi, edi, eax, (char *) ebp + ds_base);
		Gui::drawString(sheet, (char *) ebp + ds_base, esi, edi, table_8_565[eax]);
		if ((ebx & 1) == 0) {
			Sheet::refresh(sheet, esi, edi, esi + ecx * 8, edi + 16);
		}
	} else if (edx == 7) {
		sheet = (Sheet *) (ebx & 0xfffffffe);
		Graphics::fill_rect(sheet->buf, sheet->bxsize, ebp, eax, ecx, esi, edi);
		if ((ebx & 1) == 0) {
			Sheet::refresh(sheet, eax, ecx, esi + 1, edi + 1);
		}
	} else if (edx == 8) {
		MemoryManager::init((MemoryManager *) (ebx + ds_base));
		ecx &= 0xfffffff0;	/* 16oCgPʂ */
		MemoryManager::deallocate((MemoryManager *) (ebx + ds_base), eax, ecx);
	} else if (edx == 9) {
		ecx = (ecx + 0x0f) & 0xfffffff0; /* 16oCgPʂɐ؂グ */
		reg[7] = MemoryManager::allocate((MemoryManager *) (ebx + ds_base), ecx);
	} else if (edx == 10) {
		ecx = (ecx + 0x0f) & 0xfffffff0; /* 16oCgPʂɐ؂グ */
		MemoryManager::deallocate((MemoryManager *) (ebx + ds_base), eax, ecx);
	} else if (edx == 11) {
		sheet = (Sheet *) (ebx & 0xfffffffe);
		sheet->buf[sheet->bxsize * edi + esi] = table_8_565[eax];
		if ((ebx & 1) == 0) {
			Sheet::refresh(sheet, esi, edi, esi + 1, edi + 1);
		}
	} else if (edx == 12) {
		sheet = (Sheet *) ebx;
		Sheet::refresh(sheet, eax, ecx, esi, edi);
	} else if (edx == 13) {
		sheet = (Sheet *) (ebx & 0xfffffffe);
		Console::hrb_api_linewin(sheet, eax, ecx, esi, edi, table_8_565[ebp]);
		if ((ebx & 1) == 0) {
			if (eax > esi) {
				i = eax;
				eax = esi;
				esi = i;
			}
			if (ecx > edi) {
				i = ecx;
				ecx = edi;
				edi = i;
			}
			Sheet::refresh(sheet, eax, ecx, esi + 1, edi + 1);
		}
	} else if (edx == 14) {
		Sheet::deallocate((Sheet *) ebx);
	} else if (edx == 15) {
		for (;;) {
			io_cli();
			if (Queue::status(&task->queue) == 0) {
				if (eax != 0) {
					Task::sleep(task);	/* FIFOȂ̂ŐQđ҂ */
				} else {
					io_sti();
					reg[7] = -1;
					return 0;
				}
			}
			i = Queue::pop(&task->queue);
			io_sti();
			if (i <= 1 && console->sheet != 0) { /* J[\p^C} */
				/* Avs̓J[\oȂ̂ŁA͕\p1𒍕Ă */
				Timer::init(console->timer, &task->queue, 1); /* 1 */
				Timer::set_time(console->timer, 50);
			}
			if (i == 2) {	/* J[\ON */
				console->cur_c = COL8_000000;
			}
			if (i == 3) {	/* J[\OFF */
				console->cur_c = -1;
			}
			if (i == 4) {	/* R\[ */
				Timer::cancel(console->timer);
				io_cli();
				Queue::push(sys_queue, console->sheet - sheet_manager->sheets0 + 2024);	/* 2024`2279 */
				console->sheet = 0;
				io_sti();
			}
			if (i >= 256) { /* L[{[hf[^i^XNAoRjȂ */
				reg[7] = i - 256;
				return 0;
			}
		}
	} else if (edx == 16) {
		reg[7] = (int) Timer::allocate();
		((Timer *) reg[7])->flags2 = 1;	/* LZL */
	} else if (edx == 17) {
		Timer::init((Timer *) ebx, &task->queue, eax + 256);
	} else if (edx == 18) {
		Timer::set_time((Timer *) ebx, eax);
	} else if (edx == 19) {
		Timer::deallocate((Timer *) ebx);
	} else if (edx == 20) {
		if (eax == 0) {
			i = io_in8(0x61);
			io_out8(0x61, i & 0x0d);
		} else {
			i = 1193180000 / eax;
			io_out8(0x43, 0xb6);
			io_out8(0x42, i & 0xff);
			io_out8(0x42, i >> 8);
			i = io_in8(0x61);
			io_out8(0x61, (i | 0x03) & 0x0f);
		}
	} else if (edx == 21) {
		for (i = 0; i < 8; i++) {
			if (task->fhandle[i].buf == 0) {
				break;
			}
		}
		fh = &task->fhandle[i];
		reg[7] = 0;
		if (i < 8) {
			finfo = File::search((char *) ebx + ds_base,
					(FileInfo *) (ADR_DISKIMG + 0x002600), 224);
			if (finfo != 0) {
				reg[7] = (int) fh;
				fh->size = finfo->size;
				fh->pos = 0;
				fh->buf = File::load_file2(finfo->clustno, &fh->size, task->fat);
			}
		}
	} else if (edx == 22) {
		fh = (FileHandle *) eax;
		MemoryManager::deallocate(memory_manager, (int) fh->buf, fh->size);
		fh->buf = 0;
	} else if (edx == 23) {
		fh = (FileHandle *) eax;
		if (ecx == 0) {
			fh->pos = ebx;
		} else if (ecx == 1) {
			fh->pos += ebx;
		} else if (ecx == 2) {
			fh->pos = fh->size + ebx;
		}
		if (fh->pos < 0) {
			fh->pos = 0;
		}
		if (fh->pos > fh->size) {
			fh->pos = fh->size;
		}
	} else if (edx == 24) {
		fh = (FileHandle *) eax;
		if (ecx == 0) {
			reg[7] = fh->size;
		} else if (ecx == 1) {
			reg[7] = fh->pos;
		} else if (ecx == 2) {
			reg[7] = fh->pos - fh->size;
		}
	} else if (edx == 25) {
		fh = (FileHandle *) eax;
		for (i = 0; i < ecx; i++) {
			if (fh->pos == fh->size) {
				break;
			}
			*((char *) ebx + ds_base + i) = fh->buf[fh->pos];
			fh->pos++;
		}
		reg[7] = i;
	} else if (edx == 26) {
		i = 0;
		for (;;) {
			*((char *) ebx + ds_base + i) =  task->cmdline[i];
			if (task->cmdline[i] == 0) {
				break;
			}
			if (i >= ecx) {
				break;
			}
			i++;
		}
		reg[7] = i;
	} else if (edx == 27) {
		reg[7] = task->langmode;
	}
	return 0;
}

int *inthandler0c(int *esp)
{
	Task *task = Task::now();
	Console *console = task->console;
	char s[30];
	Console::put_str0(console, "\nINT 0C :\n Stack Exception.\n");
	sprintf(s, "EIP = %08X\n", esp[11]);
	Console::put_str0(console, s);
	return &(task->tss.esp0);	/* ُI */
}

int *inthandler0d(int *esp)
{
	Task *task = Task::now();
	Console *console = task->console;
	char s[30];
	Console::put_str0(console, "\nINT 0D :\n General Protected Exception.\n");
	sprintf(s, "EIP = %08X\n", esp[11]);
	Console::put_str0(console, s);
	return &(task->tss.esp0);	/* ُI */
}

void Console::hrb_api_linewin(Sheet *sheet, int x0, int y0, int x1, int y1, int col)
{
	int i, x, y, len, dx, dy;

	dx = x1 - x0;
	dy = y1 - y0;
	x = x0 << 10;
	y = y0 << 10;
	if (dx < 0) {
		dx = - dx;
	}
	if (dy < 0) {
		dy = - dy;
	}
	if (dx >= dy) {
		len = dx + 1;
		if (x0 > x1) {
			dx = -1024;
		} else {
			dx =  1024;
		}
		if (y0 <= y1) {
			dy = ((y1 - y0 + 1) << 10) / len;
		} else {
			dy = ((y1 - y0 - 1) << 10) / len;
		}
	} else {
		len = dy + 1;
		if (y0 > y1) {
			dy = -1024;
		} else {
			dy =  1024;
		}
		if (x0 <= x1) {
			dx = ((x1 - x0 + 1) << 10) / len;
		} else {
			dx = ((x1 - x0 - 1) << 10) / len;
		}
	}

	for (i = 0; i < len; i++) {
		sheet->buf[(y >> 10) * sheet->bxsize + (x >> 10)] = col;
		x += dx;
		y += dy;
	}

	return;
}
