package jp.hasc.loggerserver;

import org.eclipse.core.runtime.IProgressMonitor;

/**
 * 処理が終了するまでブロックするためのProgressMonitorです
 * @author iwasaki
 */
public class ProgressMonitorForBlocking implements IProgressMonitor {
	
	private boolean canceled_=false;
	private boolean done_=false;
	
	/**
	 * 処理が終了するまでブロックします
	 */
	public boolean awaitDone() throws InterruptedException {
		synchronized (this) {
			while(!done_ && !canceled_) {
				wait();
			}
			return done_;
		}
	}

	@Override
	public void beginTask(String name, int totalWork) {
	}

	@Override
	public void done() {
		synchronized (this) {
			done_=true;
			notifyAll();
		}
	}

	@Override
	public void internalWorked(double work) {
	}

	@Override
	public boolean isCanceled() {
		return canceled_;
	}

	@Override
	public void setCanceled(boolean value) {
		synchronized (this) {
			canceled_=value;
			notifyAll();
		}
	}

	@Override
	public void setTaskName(String name) {
	}

	@Override
	public void subTask(String name) {
	}

	@Override
	public void worked(int work) {
	}

}
