package jp.hasc.hasctool.core.data;

/**
 * 値を持たないSignalMessageです。しばらくSignalMessageを出力しなかった時に、後続ブロックの時刻を進めるために出力します。
 * @author iwasaki
 */
public class NullSignalMessage extends AbstractSignalMessage {

	public NullSignalMessage(long time) {
		super(time);
	}

	@Override
	public SignalMessage createDelayedElement(long delay) {
		if (delay==0) return this;
		return new NullSignalMessage(getTime()+delay);
	}
	
	@Override
	public String toString() {
		return "Null{time:"+getTime()+"}";
	}
}
