package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.ScalarSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;

/**
 * ベクトルの各要素（スカラ値）を変換するフィルタです
 * @author iwasaki
 */
public abstract class AbstractScalarFilter extends AbstractFilter {

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof ScalarSignalMessage) {
			ScalarSignalMessage se = (ScalarSignalMessage) message;
			double newVal=filterScalarValue(se.getScalarValue());
			outputMessage(new ScalarSignalMessage(se.getTime(), newVal));
			
		}else if (message instanceof VectorSignalMessage) {
			VectorSignalMessage ve = (VectorSignalMessage) message;
			double[] newVal=new double[ve.getVectorSize()];
			for(int i=0;i<ve.getVectorSize();++i) {
				newVal[i]=filterScalarValue(ve.getVectorElement(i));
			}
			outputMessage(VectorSignalMessages.create(ve.getTime(), newVal, false));
			
		}else{
			outputMessage(message);
		}
	}
	
	public abstract double filterScalarValue(double scalarValue);
}
