package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.data.SignalMessage;

/**
 * 部分的にtime順でないSignalMessage系列を、time順に出力するフィルターです。
 * 現在の実装では、単に古い（同時刻を含む）メッセージが来た場合に破棄します。
 * UDPパケットの受信など、メッセージの順序が入れ替わる可能性がある場合に利用して下さい。
 * @author iwasaki
 */
public class SignalTimeSorter extends AbstractFilter {

	protected long previousTime_=Long.MAX_VALUE;
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof SignalMessage) {
			SignalMessage sig = (SignalMessage) message;
			long time=sig.getTime();
			if (time>previousTime_) outputMessage(sig);
			previousTime_=time;
		}else if (message==EnumCommand.BEGIN) {
			previousTime_=Long.MIN_VALUE;
			outputMessage(message);
		}else if (message==EnumCommand.END) {
			previousTime_=Long.MAX_VALUE;
			outputMessage(message);
		}else{
			outputMessage(message);
		}
	}

}
