package jp.hasc.hasctool.core.runtime.filter;

import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;

/**
 * VectorSignalMessageのノルムを出力するフィルタです
 * @author hiro
 */
public class VectorNormFilter extends AbstractFilter {

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof VectorSignalMessage) {
			VectorSignalMessage vsig = (VectorSignalMessage) message;
			// output
			outputMessage(VectorSignalMessages.createScalar(vsig.getTime(),vsig.getVectorNorm()));
		}else{
			outputMessage(message);
		}
	}
}
