package jp.hasc.hasctool.core.runtime.filter.evaluation;

import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * 評価用フィルタ
 * 推定ファイル名から正解ファイルのパスを生成するフィルタです
 * 変換前：/result/person_HASC.label
 * 変換後:/person/HASC.label
 * @author hiro
 */
public class EvaluationFilePathCreator extends AbstractFilter{

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s =(String)message;
			String[] dpart = s.split("/");
			int dlen = dpart.length;
			String[] fpart = dpart[dlen-1].split("_");
			String newPath = fpart[0]+"/"+fpart[1];
			outputMessage(s.replace(dpart[dlen-2]+"/"+dpart[dlen-1], newPath));
		}else{
			//BEGIN,END message
			outputMessage(message);
		}
	}
}
