package jp.hasc.hasctool.core.runtime.filter.file;

import java.util.TreeSet;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.data.LabelInfo;
import jp.hasc.hasctool.core.data.LabelSignalMessage;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.annotation.PortInfo;
import jp.hasc.hasctool.core.runtime.annotation.RuntimeBeanInfo;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.filter.file.label.LabelFileParser;
import jp.hasc.hasctool.core.runtime.filter.file.label.LabelLine;

/**
 * CSVの文字列系列をパースして、LabelSignalMessageとして出力するフィルタです。
 * コメント行（#ではじまる）は、Stringオブジェクトとして出力します。
 * 全て読み込んでから、一括してmessageを出力します。
 * @author iwasaki
 */
@RuntimeBeanInfo(
		inputPorts = { @PortInfo(name = "inputPort", classes = {String.class}) },
		outputPorts = { @PortInfo(name = "outputPort", classes = {LabelSignalMessage.class, String.class}) }
)
public class CSVToLabelFilter extends AbstractFilter {
	private TreeSet<LabelSignalMessage> labelSignalMessages_=new TreeSet<LabelSignalMessage>();
	
	private LabelFileParser parser_=new LabelFileParser();
	
	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		parser_.setup(context);
		parser_.getOutputPort().connect(this);
	}
	
	@Override
	public MessageProcessor getInputPort() {
		return parser_.getInputPort();
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		// 注意：inputPortからの入力は、内部のLabelFileParser（parser_）を経由してから、ここで処理されます
		if (message instanceof String) {
			// comment
			outputMessage(message);
		}else if (message instanceof LabelLine) {
			// label line
			LabelLine line=(LabelLine)message;
			LabelInfo li=new LabelInfo(line.label);
			labelSignalMessages_.add(li.createBeginMessage(line.timeBegin)); // begin
			labelSignalMessages_.add(li.createEndMessage(line.timeEnd)); // end
		}else if (message==EnumCommand.END) {
			// 最後に時刻ソートされたメッセージを一括出力
			for(LabelSignalMessage sig:labelSignalMessages_) outputMessage(sig);
			labelSignalMessages_.clear();
			//　END
			outputMessage(message);
		}else{
			outputMessage(message);
		}
	}
}
