package jp.hasc.hasctool.core.runtime.filter.file;

import com.thoughtworks.xstream.XStream;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * メッセージをXStreamでダンプして、文字列系列として出力するフィルタです。
 * @author iwasaki
 */
public class XStreamDumpFilter extends AbstractFilter {
	
	private XStream xstream_=null;

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message==EnumCommand.BEGIN) outputMessage(message);
		
		outputMessage(xstream_.toXML(message));
		
		if (message==EnumCommand.END) outputMessage(message);
	}
	
	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
		xstream_=new XStream();
		xstream_.autodetectAnnotations(true);
	}
}
