package jp.hasc.hasctool.core.runtime.filter.file.label;

import java.util.concurrent.TimeUnit;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.runtime.annotation.PortInfo;
import jp.hasc.hasctool.core.runtime.annotation.RuntimeBeanInfo;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.util.CSVUtil;

/**
 * ラベルファイルの文字列系列を入力し、LabelLineオブジェクトの系列を出力します。
 * コメント行（#ではじまる）は、Stringオブジェクトとして出力します。
 * @author iwasaki
 */
@RuntimeBeanInfo(
		inputPorts = { @PortInfo(name = "inputPort", classes = {String.class}) },
		outputPorts = { @PortInfo(name = "outputPort", classes = {LabelLine.class, String.class}) }
)
public class LabelFileParser extends AbstractFilter {
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String row=(String)message;
			if (row.startsWith("#")) {
				outputMessage(row);
			}else if (row.isEmpty()) {
				// NOP
			}else{
				String[] columns=CSVUtil.parseCSVRecord(row);
				LabelLine ll=new LabelLine();
				ll.timeBegin=secondToTime(Double.parseDouble(columns[0]));
				if(columns[1].equals("")){
					ll.timeEnd=ll.timeBegin;
				}else{
					ll.timeEnd=secondToTime(Double.parseDouble(columns[1]));
				}
				ll.label=columns[2];
				outputMessage(ll);
			}
		}else if (message==EnumCommand.BEGIN) {
			outputMessage(message);
		}else{
			outputMessage(message);
		}
	}
	
	private double timeUnitSeconds_=1.0;
	
	public long secondToTime(double secs) {
		return SignalMessage.TIME_UNIT.convert((long)(secs*timeUnitSeconds_*1000000), TimeUnit.MICROSECONDS);
	}

	public double getTimeUnitSeconds() {
		return timeUnitSeconds_;
	}

	public void setTimeUnitSeconds(double timeUnitSeconds) {
		timeUnitSeconds_ = timeUnitSeconds;
	}
}
