package jp.hasc.hasctool.core.runtime.filter.file.message;

import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/**
 * 指定した文字をメッセ―ジの前or後に付け加えます
 * @author hiro
 */
public class MessageAdder extends AbstractFilter{

	private String addVal_;
	private boolean addEnd_ = true;

	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}

	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s =(String)message;
			if(addEnd_){
				outputMessage(s + addVal_);
			} else {
				outputMessage(addVal_ + s);
			}
		}else{
			//BEGIN,END message
			outputMessage(message);
		}
	}

	public void setAddValue(String add){
		addVal_ = add;
	}

	public void setAddEnd(boolean addend){
		addEnd_ = addend;
	}
}
