package jp.hasc.hasctool.core.runtime.filter.file.message;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;

/*
 * Begin メッセージから End メッセージまでのメッセージをカンマ　“，”　区切りでMergeします
 * input:filePath, val[0], val[1], ....
 * output:filePath, val[mIndex_], val[mIndx_], ....
 * マージ対象は、mIndex_におり決定します。
 * @author hiro
 */
public class MessageBEMerger extends AbstractFilter{

	private int mIndx_;
	private String filePath_;
	private String val_;
	boolean start_ = true;
	
	@Override
	public void setup(RuntimeContext context) {
		super.setup(context);
	}
	
	@Override
	public void processMessage(Object message) throws InterruptedException {
		if (message instanceof String) {
			String s =(String)message;
			String[] row = s.split(",");
			if(start_){
				filePath_ = row[0];
				val_ = row[0];
				start_ = false;
			}
			if(!(filePath_.equals(row[0]))){
				outputMessage(val_);
				filePath_ = row[0];
				val_ = row[0];
			}
			val_ += "," + row[mIndx_];

		} else if(message == EnumCommand.END){
			outputMessage(val_);
			outputMessage(message);
		}else{
			//BEGIN message
			outputMessage(message);
		}
	}
	
	public void setMergeIndex(int mIndex){
		mIndx_ = mIndex;
	}

}
